#coding: utf-8
from django import forms
from django.conf import settings as django_settings



from django.views.generic.edit import FormView
import operator
from diocese import models as modelsLoja
from django.shortcuts import redirect
from django.core.urlresolvers import reverse
from django.core.paginator import Paginator

from django import http
from django.contrib.auth.models import User
from django.http import HttpResponse
from django.template import RequestContext
from django.shortcuts import render_to_response
from datetime import datetime, date, timedelta
from  django.http import QueryDict
from agenda.models import Agenda
from django.views.generic import ListView, DetailView #, TemplateView
from django.db.models import Q
from conteudos.models import Noticia, Seccao, Multimedia, Fotogaleria, PDF, FotogaleriaImagem
from diocese.models import Arciprestado, Presbitero, DiaconoPermanente, Diacono, Paroquia, Bispo, NotaHistorica, CuriaDiocesana, Secretariado
from diocese.models import Seminario, InstitutoReligiosoMasculino, InstitutoReligiosoFeminino, InstitutoSecular, TribunalEclesiastico
from django.core.cache import cache
from django.template.defaultfilters import slugify
from django.utils import simplejson

from django.core.validators import email_re
from newsletter.models import User as UserNewsletter, Group, UserGroup
import hmac
import uuid
try:
    from hashlib import sha1
except ImportError:
    import sha
    sha1 = sha.sha
from peakitcms.funcionalidades.Mailer import Mailer

from django.views.decorators.csrf import csrf_exempt
from django.template.loader import render_to_string


from django.utils import simplejson as json
from django.utils.simplejson import dumps, loads, JSONEncoder


from .models import WebSite
from sitemenu.models import MenuTree


# TODO: fazer merge com o ficheiro views_ruben.py mais tarde
from website.views_ruben import *

def get_seccao_queryset_descendants(nodes, include_self=False):
    if not nodes:
        return Seccao.tree.none()
    filters = []
    for n in nodes:
        lft, rght = n.lft, n.rght
        if include_self:
            lft -=1
            rght += 1
        filters.append(Q(tree_id=n.tree_id, lft__gt=lft, rght__lt=rght))
    q = reduce(operator.or_, filters)
    return Seccao.tree.filter(q)



class NoticiaDetailView(DetailView):
    template_name = "website/base/detail.html"
    queryset = Noticia.publicado.filter(activo=True)
    def __init__(self, *args, **kwargs):
        super(NoticiaDetailView, self).__init__(*args, **kwargs)
        self.seccao = None
        self.seccao_pai = None
        self.seccao_pai_seccoes = None
        self.content_type = 1
        self.website = 1

    def get_context_data(self, **kwargs):
        context = super(NoticiaDetailView, self).get_context_data(**kwargs)
        context['content_type'] = self.content_type
        context['seccao'] = self.seccao
        context['seccao_pai'] = self.seccao_pai
        context['seccao_pai_seccoes'] = self.seccao_pai_seccoes
        return context
    def get_queryset(self):
        rs = []
        if self.content_type == 1:
            rs = Noticia.publicado.filter(activo=True)
        elif self.content_type == 2:
            rs = Fotogaleria.publicado.filter(activo=True)
        elif self.content_type == 3:
            rs = Multimedia.publicado.filter(activo=True)
        elif self.content_type == 5:
                rs = PDF.publicado.filter(activo=True)
        elif self.content_type == 10:
            return Arciprestado.objects.filter(pk__isnull=False)
        elif self.content_type == 11:
            return Presbitero.objects.filter(pk__isnull=False, faleceu=False)
        elif self.content_type == 12:
            return DiaconoPermanente.objects.filter(pk__isnull=False)
        elif self.content_type == 13:
            return NotaHistorica.objects.filter(pk__isnull=False)
        elif self.content_type == 14:
            return CuriaDiocesana.objects.filter(pk__isnull=False)
        elif self.content_type == 15:
            return TribunalEclesiastico.objects.filter(pk__isnull=False)
        elif self.content_type == 16:
            return Diacono.objects.filter(pk__isnull=False)



        if self.seccao:
            rs = rs.filter(
                seccoes__in=self.seccao
            )
        if self.seccao_pai_seccoes:
            rs = rs.filter(
                seccoes__in=self.seccao_pai_seccoes
            )
        rs = rs.filter(website=self.website)
        return rs.order_by('-publicada_inicio')

    def get(self, request, **kwargs):
        if 'website' in kwargs:
            self.website = kwargs['website']
        if 'seccao' in kwargs:
            self.seccao = kwargs['seccao'].split(',')
        if 'content_type' in kwargs:
            self.content_type = kwargs['content_type']
        if 'seccao_pai' in kwargs:
            self.seccao_pai = kwargs['seccao_pai'].split(',')
            self.seccao_pai_seccoes = get_seccao_queryset_descendants(
                    Seccao.objects.filter(
                        pk__in=self.seccao_pai
                    ).all(), True
                )

        return super(NoticiaDetailView, self).get(request, **kwargs)


class NoticiaListView(ListView):
    template_name = "website/base/listagem.html"
    paginate_by = 10
    def get_queryset(self):
        rs = []
        if self.content_type == 1:
            rs = Noticia.publicado.filter(activo=True)
        elif self.content_type == 2:
            rs = Fotogaleria.publicado.filter(activo=True)
        elif self.content_type == 3:
            rs = Multimedia.publicado.filter(activo=True)

        elif self.content_type == 10:
            return Arciprestado.objects.filter(pk__isnull=False).order_by('arciprestado')
        elif self.content_type == 12:
            return DiaconoPermanente.objects.filter(pk__isnull=False) #.order_by('arciprestado')
        elif self.content_type == 13:
            return Secretariado.objects.filter(pk__isnull=False)
        elif self.content_type == 14:
            try:
                rs = WebSite.objects.filter(websiteprofile__horarios_horario__isnull=False)
            except Exception, e:
                #print e
                pass
        elif self.content_type == 16:
            return Diacono.objects.filter(pk__isnull=False) #.order_by('arciprestado')

        if self.seccao:
            rs = rs.filter(
                seccoes__in=self.seccao
            )
        if self.seccao_pai_seccoes:
            rs = rs.filter(
                seccoes__in=self.seccao_pai_seccoes
            )
        if not self.content_type == 14:
            rs = rs.filter(website=self.website)
            return rs.order_by('-publicada_inicio')

        return rs

    def get_context_data(self, **kwargs):
        context = super(NoticiaListView, self).get_context_data(**kwargs)
        context['content_type'] = self.content_type
        context['seccao'] = self.seccao
        context['seccao_pai'] = self.seccao_pai
        context['seccao_pai_seccoes'] = self.seccao_pai_seccoes
        context['object'] = self.object
        context['pk'] = self.pk
        if self.content_type in [3,2] and self.pk:
            context['object'] = self.get_queryset().filter(pk=self.pk)[0]
            
        if self.seccao == 169:
            self.template_name='website/nomeacoes_list.html'

        return context

    def __init__(self,*args, **kwargs):
        super(NoticiaListView, self).__init__(*args, **kwargs)
        self.seccao = None
        self.seccao_pai = None
        self.seccao_pai_seccoes = None
        self.object = None
        self.pk = None
        self.website = 1
        self.content_type = 1


    def get(self, request, **kwargs):
        if 'pk' in kwargs:
            self.pk = kwargs['pk']
        if 'website' in kwargs:
            self.website = kwargs['website']
        if 'seccao' in kwargs:
            self.seccao = kwargs['seccao'].split(',')
        if 'content_type' in kwargs:
            self.content_type = kwargs['content_type']
        if 'seccao_pai' in kwargs:
            self.seccao_pai = kwargs['seccao_pai'].split(',')
            self.seccao_pai_seccoes = get_seccao_queryset_descendants(
                    Seccao.objects.filter(
                        pk__in=self.seccao_pai
                    ).all(), True
                )
        try:
            if self.content_type in [3,2] and self.pk is None:
                self.pk = int(self.get_queryset()[0].pk)
        except Exception:
            pass
        return super(NoticiaListView, self).get(request, **kwargs)


class SubsidiosPastoraisListView(ListView):
    template_name = "website/base/listagem.html"
    paginate_by = 10
    def get_queryset(self):
        rs = []
        if self.content_type == 1:
            rs = Noticia.publicado.filter(activo=True)
        elif self.content_type == 2:
            rs = Fotogaleria.publicado.filter(activo=True)
        elif self.content_type == 3:
            rs = Multimedia.publicado.filter(activo=True)

        elif self.content_type == 10:
            return Arciprestado.objects.filter(pk__isnull=False).order_by('arciprestado')
        elif self.content_type == 12:
            return DiaconoPermanente.objects.filter(pk__isnull=False) #.order_by('arciprestado')
        elif self.content_type == 13:
            return Secretariado.objects.filter(pk__isnull=False)
        elif self.content_type == 14:
            try:
                rs = WebSite.objects.filter(websiteprofile__horarios_horario__isnull=False)
            except Exception, e:
                #print e
                pass
        
        if self.seccao:
            rs = rs.filter(
                seccoes__in=self.seccao
            )
        if self.seccao_pai_seccoes:
            rs = rs.filter(
                seccoes__in=self.seccao_pai_seccoes
            )
        if not self.content_type == 14:
            rs = rs.filter(website=self.website)
            return rs.order_by('-publicada_inicio')

        return rs

    def get_context_data(self, **kwargs):
        context = super(NoticiaListView, self).get_context_data(**kwargs)
        context['seccao'] = self.seccao
        context['seccao_pai'] = self.seccao_pai
        context['seccao_pai_seccoes'] = self.seccao_pai_seccoes
        context['object'] = self.object
        context['pk'] = self.pk
        if self.content_type in [3,2] and self.pk:
            context['object'] = self.get_queryset().filter(pk=self.pk)[0]
        return context

    def __init__(self,*args, **kwargs):
        super(NoticiaListView, self).__init__(*args, **kwargs)
        self.seccao = None
        self.seccao_pai = None
        self.seccao_pai_seccoes = None
        self.object = None
        self.pk = None
        self.website = 1
        self.content_type = 1


    def get(self, request, **kwargs):
        if 'pk' in kwargs:
            self.pk = kwargs['pk']
        if 'website' in kwargs:
            self.website = kwargs['website']
        if 'seccao' in kwargs:
            self.seccao = kwargs['seccao'].split(',')
        if 'content_type' in kwargs:
            self.content_type = kwargs['content_type']
        if 'seccao_pai' in kwargs:
            self.seccao_pai = kwargs['seccao_pai'].split(',')
            self.seccao_pai_seccoes = get_seccao_queryset_descendants(
                    Seccao.objects.filter(
                        pk__in=self.seccao_pai
                    ).all(), True
                )
        try:
            if self.content_type in [3,2] and self.pk is None:
                self.pk = int(self.get_queryset()[0].pk)
        except Exception:
            pass
        return super(NoticiaListView, self).get(request, **kwargs)



class InstituicoesListView(ListView):

    def __init__(self, *args, **kwargs):
        super(InstituicoesListView, self).__init__(*args, **kwargs)
        self.search = None
        self.arciprestado = None
        self.search_letter = None
        self.page_title = None
        self.content_type = 20
        self.search_tipo_presbitero = None
        self.search_paroquia = None

    template_name = 'website/instituicoes/instituicoes.html'
    paginate_by = 10

    def get_context_data(self, **kwargs):
        context = super(InstituicoesListView, self).get_context_data(**kwargs)
        context['search_letter'] = self.search_letter
        context['arciprestado'] = self.arciprestado
        context['search'] = self.search
        context['page_title'] = self.page_title
        context['content_type'] = self.content_type
        context['search_tipo_presbitero'] = self.search_tipo_presbitero
        context['search_paroquia'] = self.search_paroquia
        context['arciprestados'] = Arciprestado.objects.all()
        if self.content_type == 12 and self.arciprestado:
            context['arciprestado_object'] = Arciprestado.objects.get(pk=self.arciprestado)

        return context

    def get_queryset(self):
        if self.content_type == 1:
            rs = Seminario.objects.filter(pk__isnull=False)
        elif self.content_type == 2:
            rs = InstitutoReligiosoMasculino.objects.filter(pk__isnull=False)
        elif self.content_type == 3:
            rs = InstitutoReligiosoFeminino.objects.filter(pk__isnull=False)
        elif self.content_type == 4:
            rs = InstitutoSecular.objects.filter(pk__isnull=False)
        elif self.content_type == 11:
            rs = Presbitero.objects.filter(pk__isnull=False, faleceu=False)
            if self.search_paroquia:
                paroquia = Paroquia.objects.get(pk=self.search_paroquia)
                rs = rs.filter(pk__in=[
                    paroquia.padre1_id,
                    paroquia.padre2_id,
                    paroquia.padre3_id,]
                )
            if self.search_tipo_presbitero:
                rs = rs.filter(clero_tipo=self.search_tipo_presbitero)
        elif self.content_type == 12:
            rs = Paroquia.objects.filter(pk__isnull=False)

        if self.search:
            rs = rs.filter(nome__icontains=self.search)
        if self.search_letter:
            rs = rs.filter(nome__istartswith=self.search_letter)
        if self.arciprestado:
            if not self.content_type == 11:
                rs = rs.filter(arciprestado__in=[self.arciprestado])
            else:
                rs = rs.filter(dioceses_presbiteroarciprestados_presbiteroarciprestados_presbitero__arciprestado__in=[self.arciprestado])
        return rs.order_by('nome')

    def process_filter(self, request):
        try:
            self.search = request.GET.get('search', None)
            if self.search == "":
                self.search = None
        except:
            self.search = None

        try:
            self.arciprestado = int(request.GET.get('arciprestado', None))
        except:
            self.arciprestado = None

        try:
            self.search_letter = request.GET.get('search_letter', None)
            if self.search_letter == "":
                self.search_letter = None
        except:
            self.search_letter = None

        try:
            self.search_tipo_presbitero = request.GET.get('search_tipo_presbitero', None)
            if self.search_tipo_presbitero == "":
                self.search_tipo_presbitero = None
        except:
            self.search_tipo_presbitero = None

        try:
            self.search_paroquia = request.GET.get('search_paroquia', None)
            if self.search_paroquia == "":
                self.search_paroquia = None
        except:
            self.search_paroquia = None


    def dispatch(self, *args, **kwargs):
        self.content_type = int(kwargs['content_type']) if 'content_type' in kwargs else ''
        self.page_title = kwargs['page_title'] if 'page_title' in kwargs else ''
        self.process_filter(args[0])
        return super(InstituicoesListView, self).dispatch(*args, **kwargs)


def detail(request, ):
    return render_to_response('website/base/detail.html', {},
        context_instance=RequestContext(request))

def listagem(request, ):
    return render_to_response('website/base/listagem.html', {},
        context_instance=RequestContext(request))


class AgendaListView(ListView):
    def __init__(self,*args, **kwargs):
        super(AgendaListView, self).__init__(*args, **kwargs)
        self.search = None
        self.date_start = None
        self.date_end = None
        self.is_searchable = False

    template_name = 'website/agenda_listagem.html'
    model = Agenda
    paginate_by = 10
    def get_context_data(self, **kwargs):
        context = super(AgendaListView, self).get_context_data(**kwargs)
        context['date_start'] = self.date_start
        context['date_end'] = self.date_end
        context['search'] = self.search
        context['is_searchable'] = self.is_searchable
        return context

    def get_queryset(self):
        if not self.is_searchable:
            return []
        rs = Agenda.publicado.filter(website=1)
        if self.date_start is not None:
            rs = rs.filter(
                Q(data_inicio__gte = self.date_start) |
                Q(data_inicio__lte = self.date_start, data_fim__gte = self.date_start)
            )
        if self.date_end is not None:
            rs = rs.filter(
                Q(data_fim__lte = self.date_end) |
                Q(data_fim__gte = self.date_end, data_inicio__lte = self.date_end)
            )

        if self.search is not None:
            rs = rs.filter(
                Q(titulo__contains=self.search) |
                Q(descricao__contains=self.search)
            )
        return rs

    def process_filter(self, request):
        try:
            self.search = request.GET.get('search',None)
            if self.search == "":
                self.search = None
        except:
            self.search = None

        try:
            self.date_start = datetime.strptime(request.GET.get('date_start',None), "%d-%m-%Y" )
        except:
            self.date_start = None

        try:
            self.date_end = datetime.strptime(request.GET.get('date_end',None), "%d-%m-%Y" )
        except:
            self.date_end = None
        if self.date_end is not None:
            self.date_end = self.date_end + timedelta(hours=23) + timedelta(minutes=59) + timedelta(seconds=59)

        if self.date_start is not None or self.date_end is not None or self.search is not None:
            self.is_searchable = True

    def dispatch(self, *args, **kwargs):
        self.process_filter(args[0])
        return super(AgendaListView, self).dispatch(*args, **kwargs)


def ajax_agenda(request, paroquia=None):
    agora = date.today()
    website = int(request.GET.get('website',1))
    year = int(request.GET.get('year',agora.year))
    month = int(request.GET.get('month',agora.month))
    calendar_start = date(year,month,1)
    date_begin = calendar_start

    cache_key = slugify('ajax_agenda' + '_' + str(year) + '_' + str(month) +'_'+ str(website))
    weeks = cache.get(cache_key)
    if weeks is None:
        year_end = year if month < 12 else year + 1
        month_end = month +1 if month < 12 else 1
        calendar_end = date(year_end,month_end,1) - timedelta(days=1)
        calendar_start -= timedelta(days=calendar_start.weekday() )
        calendar_end += timedelta(days=6-calendar_end.weekday() )
        ocupped_days = []
        for evento in Agenda.objects.filter(
                (
                    Q(data_inicio__year = year, data_inicio__month = month,) |
                    Q(data_fim__year = year, data_fim__month = month,)
                ), Q(website=website)
            ).order_by('data_inicio').all():
            data = evento.data_inicio
            data_i = date(data.year,data.month,data.day)
            data = evento.data_fim
            data_f = date(data.year,data.month,data.day)
            while data_i <= data_f:
                if data_i not in ocupped_days:
                    ocupped_days.append(data_i)
                data_i += timedelta(days=1)

        weeks = []
        dd = calendar_start - timedelta(days=1)
        while dd < calendar_end:
            week = []
            for d in "xxxxxxx":
                dd += timedelta(days=1)
                week.append({
                    'date': dd ,
                    'actual': dd == agora ,
                    'disabled': not (dd.month == month and dd.year == year),
                    'events': dd in ocupped_days,
                })
            weeks.append(week)
        cache.set(cache_key, weeks, 10*60)

    next_page = QueryDict('').copy()
    next_page.update({
        'month': month+1 if month < 12 else 1,
        'year': year if month < 12 else year + 1,
        'website':website
    })

    previous_page = QueryDict('').copy()
    previous_page.update({
        'month': month-1 if month > 1 else 12,
        'year': year if month > 1 else year - 1,
        'website':website
    })

    return render_to_response('website/base/agenda.html',
        {
            'website': website,
            'weeks': weeks,
            'next_page': next_page.urlencode(),
            'previous_page': previous_page.urlencode(),
            'calendar_date': date_begin,
        },
        context_instance=RequestContext(request))




@csrf_exempt
def ajax_newsletter(request, paroquia=None):
    to_return = {'msg':u'No POST data sent.' }
    if request.method == "POST":
        post = request.POST.copy()
        if post.has_key('email') and email_re.match(post['email']) and post.has_key('website'):
            registar = True
            user = None
            create = False

            try:
                website = WebSite.objects.get(pk=post['website'] )
                user, create  = UserNewsletter.objects.get_or_create(email=post['email'], website_id=post['website'])
                if not create and user.aproved:
                    registar = False

            except Exception, e:
                #print str(e)
                registar = False

            if registar:
                from django.conf import settings as django_settings
                new_uuid = uuid.uuid4()
                user.aprove_key = hmac.new(str(new_uuid), digestmod=sha1).hexdigest()

                mailer = Mailer(getattr(django_settings,
                    'NEWSLETTER_FROM_EMAIL'), user.email, "Registo da newsletter da Diocese de Braga",
                    render_to_string('website/emails/email_subscricao_newsletter.html', {'user': user, 'website':post['website'] }))
                mailer.send()
                user.save()
                if not create:
                    user.usergroup_user.all().delete()

                for g in Group.objects.filter(website_id=post['website']).all():
                    ug = UserGroup.objects.create(user=user, group=g)
                    ug.save()

                to_return['msg'] = u"Registado com sucesso na newsletter! Confirme o seu email para completar a activação."
            else:
                to_return['msg'] = u"Já se encontra registado na newsletter!"
        else:
            to_return['msg'] = u"Introduza um email válido!"

    serialized = simplejson.dumps(to_return)
    return HttpResponse(serialized, mimetype="application/json")

@csrf_exempt
def ajax_newsletter_desactivar(request, ):
    to_return = {'msg':u'No POST data sent.' }
    if request.method == "POST":
        post = request.POST.copy()
        
        if post.has_key('email') and email_re.match(post['email']) and post.has_key('website'):

            registar = True
            user = None

            try:

                website = WebSite.objects.get(pk=post['website'] )
                user = UserNewsletter.objects.get(email=post['email'], aproved = True, website_id=post['website'])
            except Exception, e:
                #print e
                registar = False

            if registar:
                from django.conf import settings as django_settings
                new_uuid = uuid.uuid4()
                user.aprove_key = hmac.new(str(new_uuid), digestmod=sha1).hexdigest()

                mailer = Mailer(getattr(django_settings,
                    'NEWSLETTER_FROM_EMAIL'), user.email, "Desactivação da newsletter da Diocese de Braga",
                    render_to_string('website/emails/email_desactivacao_newsletter.html', {'user': user, 'website':post['website'] }))
                mailer.send()
                user.save()
                to_return['msg'] = u"Cancelamento realizado com sucesso da newsletter! Confirme o seu email para completar a desactivação."
            else:
                to_return['msg'] = u"Não se encontra registado na newsletter!"
        else:
            to_return['msg'] = u"Introduza um email válido!"

    serialized = simplejson.dumps(to_return)
    return HttpResponse(serialized, mimetype="application/json")


def newsletter_confirm(request, confirmar=False, key = None, email = None, desactivar = False, website=1, paroquia=None):
    if paroquia:
        website = WebSite.objects.get(url__icontains='/'+paroquia+'/' )
        website = website.pk

    if confirmar:
        confirmar = False
        try:
            un = UserNewsletter.objects.get(aprove_key=key,aproved=False, website_id=website)
            un.aprove_key = None
            un.aproved = True
            email = un.email
            un.save()
            confirmar = True
        except:
            pass
    elif desactivar:
        desactivar = False
        try:
            un = UserNewsletter.objects.get(aprove_key=key,aproved=True, website_id=website)
            un.aprove_key = None
            un.aproved = False
            email = un.email
            un.save()
            desactivar = True
        except:
            pass

    if website == 1:
        return render_to_response('website/newsletter/confirm.html', {
                'confirmar': confirmar,
                'desactivar': desactivar,
                'email': email,
            },
            context_instance=RequestContext(request))
    else:
        #print {'confirmar': confirmar, 'desactivar': desactivar,'email': email,'paroquia':paroquia}

        return redirect('http://diocese-braga.pt/'+str(paroquia)+'/newsletter/sucesso/'+str(email)+str('/')+str(confirmar)+str('/')+str(desactivar)+str('/'))

        #from django.core.urlresolvers import reverse
        #from django.http import HttpResponseRedirect
        #url = reverse('paroquia_newsletter-sucesso-view', kwargs={'paroquia': paroquia,'email': email,'confirmar': confirmar,'desactivar': desactivar})
        #return HttpResponseRedirect(url)

        #from django.http import HttpResponseRedirect
        #return HttpResponseRedirect(reverse('paroquia_newsletter-confirmar-sucesso-view',args=[{
        #    'paroquia':paroquia, 
        #    'email':unicode(email), 
        #    'confirmar':unicode(confirmar), 
        #    'desactivar':unicode(desactivar),
        #    }]))
        #return HttpResponseRedirect(reverse('paroquia_newsletter-confirmar-sucesso-view',args=[paroquia, unicode(email), unicode(confirmar), unicode(desactivar)]))
        #sucesso=1 if confirmar else (2 if desactivar else (0))
        #return HttpResponseRedirect(reverse('paroquia_newsletter-confirmar-sucesso-view',args=[paroquia, sucesso]))
        




import os

def getFiles(dir,pdf):
    if not os.path.exists(dir):
        return None
    d = dir + "/"
    n = 1
    n_str = "001"
    files = []
    while os.path.exists(d+n_str+".swf"):
        files.append(n_str+".swf")
        n += 1
        n_str = str(n)
        while len(n_str)<3:
            n_str = "0" + n_str
    if len(files) == 0:
        return None
    return files

def gerarFiles(dir,pdf):
    if not os.path.exists(dir):
        os.mkdir(dir)
    import gfx
    gfx.setparameter("poly2bitmap", "1")
    doc = gfx.open("pdf", pdf)
    #gfx.setparameter("zoom", "100")
    for pagenr in range(1,doc.pages+1):
        swf = gfx.SWF()
        #img = gfx.ImageList()
        #img.setparameter("antialise", "1") # turn on antialising
        #img.setparameter("jpegquality", "80") # turn on antialising

        page = doc.getPage(pagenr)
        #img.startpage(page.width,page.height)
        #print page.width
        #print page.height
        swf.startpage(page.width, page.height)
        #page.render(img)
        page.render(swf)
        #img.endpage()
        swf.endpage()
        name = str(pagenr)
        while len(name)<3:
            name = "0"+ name
        swf.save(dir+"/"+name+".swf")
        #img.save(dir+"/"+name+".jpg")
    return getFiles(dir,pdf)

def get_book_pdf(request, pk):
    cache_key = slugify('get_book_pdf_' + '_' + str(pk) )
    images = cache.get(cache_key)

    if images is None:
        try:
            pdf_record = PDF.publicado.get(pk=pk)
            fs = pdf_record.fs.directory_set.filter(parent__isnull=True)[0]
            path = os.path.abspath(fs.getPathMEDIA())

            pdf = pdf_record.pdf
            pdf_add = os.path.dirname(pdf)+'/book_' + str(pdf_record.pk)

            book_path = path+ "/book_" + str(pdf_record.pk)
            path_pdf = os.path.abspath(path+'/../../'+pdf)
            if os.path.exists(path_pdf):
                images = getFiles(book_path,path_pdf)
                if images is None:
                    images = gerarFiles(book_path,path_pdf)

                if images is not None:
                    images = map(lambda x:pdf_add+"/"+x,images)

            else:
                images = None
            cache.set(cache_key, images, 60*60)
        except:
            pass

    return render_to_response('website/igreja_viva/igreja_viva_book_xml.html', {
        'images':images,
        },
        context_instance=RequestContext(request))


def mobile(self, request_type=0):
    #Requests para noticias
    if request_type in [0, 1, 2, 3]:
        try:
            pagina = int(request.GET.get('page', 1))
            pagina = 1 if pagina <= 1 else pagina
        except:
            pagina = 1

        objectos = {'update_on': str(datetime.now()), 'Noticias': {}}
        objectos['Noticias'] = []
        n = Noticia.publicado.filter(seccoes__in = [request_type]).order_by('-publicada_inicio')[:30]
        for s in n:
            objectos['Noticias'].append({
                'titulo': s.titulo,
                'data': str(s.publicada_inicio),
                'descricao': s.noticia
            })

    #Request para Agenda
    elif request_type == 4:
        n = Agenda.publicado.filter(website=1)
        n = n.filter(
            Q(data_inicio__gte=datetime.now()) |
            Q(data_inicio__lte=datetime.now(), data_fim__gte=datetime.now())
        ).order_by('data_inicio').select_related('entidade', 'local')[:30]
        objectos = {'update_on': str(datetime.now()), 'Agendas': {}}
        objectos['Agendas'] = []
        for s in n:
            objectos['Agendas'].append({
                'titulo': s.titulo,
                'data inicio': str(s.data_inicio),
                'data fim': str(s.data_fim),
                'descricao': s.descricao,
                'entidade': str(s.entidade),
                'local': str(s.local)
            })

    #Request para imagens
    elif request_type == 5:
        objectos = {'update_on': str(datetime.now()), 'Fotos': {}}
        objectos['Fotos'] = []
        n = Fotogaleria.objects.all()
        for s in n:
            k = s.conteudos_fotogaleriaimagem_fotogaleria_imagem.all()
            for x in k:
                objectos['Fotos'].append({
                    'titulo': x.titulo,
                    'imagem': x.imagem
                })

    #Request para Videos
    elif request_type == 6:
        objectos = {'update_on': str(datetime.now()), 'Videos': {}}
        objectos['Videos'] = []
        n = Multimedia.objects.all()
        for s in n:
            objectos['Videos'].append({
                'descricao': s.descricao,
                'video': s.video
            })

    #Request para Notas Historicas
    elif request_type == 7:
        objectos = {'update_on': str(datetime.now()), 'Historia': {}}
        objectos['Historia'] = []
        n = NotaHistorica.objects.all()
        for s in n:
            objectos['Historia'].append({
                'nome': s.nome,
                'sufraganea': s.nota_historica,
                'nota historica': s.sufraganea
            })

    # Request para Curia
    elif request_type == 8:
        objectos = {'update_on': str(datetime.now()), 'Curia': {}}
        objectos['Curia'] = []
        n = CuriaDiocesana.objects.all()
        for s in n:
            objectos['Curia'].append({
                'nome': s.nome,
                'morada': s.morada,
                'codigopostal': s.codigo_postal,
                'localidade': s.localidade,
                'telefone': s.telefone,
                'telemovel': s.telemovel,
                'fax': s.fax,
                'email': s.email,
                'paginaweb': s.paginaweb,
                'horarios': s.horarios,
                'conselhoepiscopal': s.conselho_episcopal,
                'moderador': s.moderador,
                'vigariosgerais': s.vigarios_gerais,
                'vigariosgeraisadjuntos': s.vigarios_gerais_ad,
                'provigariogeral': s.provigario_geral,
                'vigariosepiscopais': s.direvigarios_episcopais,
                'delegadosepiscopais': s.delegados_episcopais,
                'secretariaepiscopal': s.secretaria_episcopal,
                'chefedegabinete': s.chefe_gabinete,
                'secretarioparticular': s.secretario_particular,
                'gabineteinformacao': s.gabinete_informacao,
                'arciprestado': str(s.arciprestado),
                'director': s.director,
                'chanceler': s.chanceler,
                'secretariadogeral': s.secretariado_geral,
                'consultorjuridico': s.consultor_juridico,
                'servicodelegadospios': s.servico_legados_pios,
                'associacoesreligiosas': s.associacoes_religiosas,
                'arquivo secreto': s.arquivo_secreto,
                'arquivohistorico': s.arquivo_historico,
                'notario': s.notario,
                'feriadosdacuria': s.feriados,
                'administradordacasaarquiepiscopal': s.administradorcasaarquiepiscopal,
                'foto': s.foto
            })

    # Request para Arciprestados
    elif request_type == 9:
        objectos = {'update_on': str(datetime.now()), 'Arciprestados': {}}
        objectos['Arciprestados'] = []
        n = Arciprestado.objects.all()
        for s in n:
            objectos['Arciprestados'].append({
                'arciprestado': s.arciprestado,
                'arcipreste': s.arcipreste,
                'arcipresteadjunto': s.arcipreste_adjunto,
                'logo': s.logo
            })

    # Request para Seminarios
    elif request_type == 10:
        objectos = {
            'update_on': str(datetime.now()),
            'Seminarios': {}
        }
        objectos['Seminarios'] = []
        n = Seminario.objects.all()
        for s in n:
            #print dir(s)
            objectos['Seminarios'].append({
                'nome': s.nome,
                'morada': s.morada,
                'codigopostal': s.codigo_postal,
                'localidade': s.localidade,
                'telefone': s.telefone,
                'telemovel': s.telemovel,
                'fax': s.fax,
                'email': s.email,
                'paginaweb': s.paginaweb,
                'reitor': s.reitor,
                'vicereitor': s.vice_reitor,
                'prefeito': s.prefeito,
                'secretario': s.secretario,
                'confessor': s.confessor,
                'directorespiritual': s.director_espiritual,
                'tesoureiro': s.tesoureiro,
                'economo': s.economo,
                'equiparesponsavel': s.equipa_resp,
                'observacoes': s.obs,
                'arciprestado': str(s.arciprestado)
            })

    #Request para InstitutoReligiosoMasculino
    elif request_type == 11:
        objectos = {
            'update_on': str(datetime.now()),
            'InstitutoReligiosoMasculino': {}
        }
        objectos['InstitutoReligiosoMasculino'] = []
        n = InstitutoReligiosoMasculino.objects.all()
        for s in n:
            objectos['InstitutoReligiosoMasculino'].append({
                'nome': s.nome,
                'congregacao': str(s.congregacao_id),
                'comunidade': s.comunidade,
                'superior': s.superior,
                'membros': s.membros,
                'morada': s.morada,
                'codigopostal': s.codigo_postal,
                'localidade': s.localidade,
                'telefone': s.telefone,
                'telemovel': s.telemovel,
                'fax': s.fax,
                'email': s.email,
                'paginaweb': s.paginaweb,
                'arciprestado': str(s.arciprestado),
                'foto': s.foto
            })

    #Request para InstitutoReligiosoFeminino
    elif request_type == 12:
        objectos = {
            'update_on': str(datetime.now()),
            'InstitutoReligiosoFeminino': {}
        }
        objectos['InstitutoReligiosoFeminino'] = []
        n = InstitutoReligiosoFeminino.objects.all()
        for s in n:
            objectos['InstitutoReligiosoFeminino'].append({
                'nome': s.nome,
                'congregacao': str(s.congregacao_id),
                'comunidade': s.comunidade,
                'superiora': s.superiora,
                'membros': s.membros,
                'morada': s.morada,
                'codigopostal': s.codigo_postal,
                'localidade': s.localidade,
                'telefone': s.telefone,
                'telemovel': s.telemovel,
                'fax': s.fax,
                'email': s.email,
                'paginaweb': s.paginaweb,
                'arciprestado': str(s.arciprestado),
                'foto': s.foto
            })

    #Request para InstituoReligiosoSecular
    elif request_type == 13:
        objectos = {'update_on': str(datetime.now()), 'InstitutoSecular': {}}
        objectos['InstitutoSecular'] = []
        n = InstitutoSecular.objects.all()
        for s in n:
            objectos['InstitutoSecular'].append({
                'institutosecular': s.instituto_secular_n_id,
                'comunidade': s.comunidade,
                'director': s.director,
                'morada': s.morada,
                'codigopostal': s.codigo_postal,
                'localidade': s.localidade,
                'telefone': s.telefone,
                'telemovel': s.telemovel,
                'fax': s.fax,
                'email': s.email,
                'paginaweb': s.paginaweb,
                'arciprestado': str(s.arciprestado),
                'foto': s.foto
            })

    #Request para obter o Clero inteiro
    elif request_type == 14:
        objectos = {
            'update_on': str(datetime.now()),
            'Bispos': {},
            'Presbiteros': {},
            'Diaconos': {}
        }
        objectos['Bispos'] = []
        objectos['Presbiteros'] = []
        objectos['Diaconos'] = []
        b = Bispo.objects.all()
        p = Presbitero.objects.all()
        d = DiaconoPermanente.objects.all()
        for s in b:
            objectos['Bispos'].append({
                'nome': s.nome,
                'tipo': str(s.bispo_tipo),
                'datadeascimento': str(s.data_nascimento),
                'localdenascimento': s.local_nascimento,
                'dataordenacaopresbiteral': str(s.data_orden_presbiteral),
                'localordenacaopresbiteral': s.local_ordenacao_presb,
                'dataordenacaoepiscoal': str(s.data_orden_episc),
                'localordenacaoepiscoral': s.local_ordenacoa_episc,
                'curriculo': s.curriculo,
                'datadanomeacao': str(s.data_nomeacao),
                'datadatomadadeposse': str(s.data_tomada),
                'dataresignacao': str(s.data_resignacao),
                'morada': s.morada,
                'codigopostal': s.codigo_postal,
                'localidade': s.localidade,
                'telefone': s.telefone,
                'telemovel': s.telemovel,
                'fax': s.fax,
                'email': s.email,
                'paginaweb': s.paginaweb,
                'observacoes': s.observacoes,
                'foto': s.foto,
                'habilitacoesacademicas': s.habilitacoes_academicas,
                'nomeacoes': s.nomeacoes,
                'datafaleceu': str(s.data_faleceu),
                'noticia': s.noticia
            })
        for a in p:
            #objectos['Presbiteros'].append({'Nome': a.nome, u'Residência': str(a.clero_tipo), 'Data de Nascimento': str(s.data_nascimento), u'Data de Ordenação': str(a.data_ordenacoa), 'Morada': a.morada, 'Codigo Postal': a.codigo_postal, 'Localidade': a.localidade, 'Telefone': a.telefone, u'Telemóvel': a.telemovel, 'Fax': a.fax, 'Email': a.email, 'Pagina Web': a.paginaweb, u'Serviço Pastoral': a.serv_pastoral, u'Observações': a.obs, 'Foto': a.foto, 'Tipo': a.tipo_clero, 'Igreja': a.igreja, u'Habilitações Académicas': a.habilitacoes_academicas, 'Publicações': a.publicacoes, u'Formação Permanente': a.formacao_permanente, u'Nomeações': a.nomeacoes, 'Local de Nascimento': a.local_nascimento, u'Local de Ordenação': a.local_ordenacao, u'Nomeações Actuais': a.nomeacoes_actuais, 'Data Faleceu': str(a.data_faleceu)})
            objectos['Presbiteros'].append({
                'nome': a.nome,
                'datadenascimento': str(a.data_nascimento),
                'datadeordenacao': str(a.data_ordenacoa),
                'morada': a.morada,
                'codigopostal': a.codigo_postal,
                'localidade': a.localidade,
                'telefone': a.telefone,
                'telemovel': a.telemovel,
                'fax': a.fax,
                'email': a.email,
                'paginaweb': a.paginaweb,
                'foto': a.foto,
                'datafaleceu': str(a.data_faleceu)
            })
        for f in d:
            objectos['Diaconos'].append({
                'nome': f.nome,
                'morada': f.morada,
                'codigopostal': f.codigo_postal,
                'telefone': f.telefone,
                'datadenascimento': str(f.data_nascimento),
                'datadeordenacao': str(f.data_ordenacoa),
                'datafaleceu': str(f.data_faleceu),
                'foto': f.foto
            })

    #Request so para Bispos
    elif request_type == 15:
        objectos = {
            'update_on': str(datetime.now()),
            'Bispos': {},
        }
        objectos['Bispos'] = []
        b = Bispo.objects.all()
        for s in b:
            objectos['Bispos'].append({
                'nome': s.nome,
                'tipo': str(s.bispo_tipo),
                'datadeascimento': str(s.data_nascimento),
                'localdenascimento': s.local_nascimento,
                'dataordenacaopresbiteral': str(s.data_orden_presbiteral),
                'localordenacaopresbiteral': s.local_ordenacao_presb,
                'dataordenacaoepiscoal': str(s.data_orden_episc),
                'localordenacaoepiscoral': s.local_ordenacoa_episc,
                'curriculo': s.curriculo,
                'datadanomeacao': str(s.data_nomeacao),
                'datadatomadadeposse': str(s.data_tomada),
                'dataresignacao': str(s.data_resignacao),
                'morada': s.morada,
                'codigopostal': s.codigo_postal,
                'localidade': s.localidade,
                'telefone': s.telefone,
                'telemovel': s.telemovel,
                'fax': s.fax,
                'email': s.email,
                'paginaweb': s.paginaweb,
                'observacoes': s.observacoes,
                'foto': s.foto,
                'habilitacoesacademicas': s.habilitacoes_academicas,
                'nomeacoes': s.nomeacoes,
                'datafaleceu': str(s.data_faleceu),
                'noticia': s.noticia
            })

    #Request so para Presbiteros
    elif request_type == 16:
        objectos = {
            'update_on': str(datetime.now()),
            'Presbiteros': {}
        }
        objectos['Presbiteros'] = []
        p = Presbitero.objects.all()
        for a in p:
            objectos['Presbiteros'].append({
                'nome': a.nome,
                'datadenascimento': str(a.data_nascimento),
                'datadeordenacao': str(a.data_ordenacoa),
                'morada': a.morada,
                'codigopostal': a.codigo_postal,
                'localidade': a.localidade,
                'telefone': a.telefone,
                'telemovel': a.telemovel,
                'fax': a.fax,
                'email': a.email,
                'paginaweb': a.paginaweb,
                'foto': a.foto,
                'datafaleceu': str(a.data_faleceu)
            })

    #Request para obter so Diaconos
    elif request_type == 17:
        objectos = {'update_on': str(datetime.now()), 'Diaconos': {}}
        objectos['Diaconos'] = []
        d = DiaconoPermanente.objects.all()
        for f in d:
            objectos['Diaconos'].append({
                'nome': f.nome,
                'morada': f.morada,
                'codigopostal': f.codigo_postal,
                'telefone': f.telefone,
                'datadenascimento': str(f.data_nascimento),
                'datadeordenacao': str(f.data_ordenacoa),
                'datafaleceu': str(f.data_faleceu),
                'foto': f.foto
            })

    #Request para obter os PDFs
    elif request_type == 19:
        objectos = {'update_on': str(datetime.now()), 'PDF': {}}
        objectos['PDF'] = []
        n = PDF.objects.all()
        for s in n:
            objectos['PDF'].append({
                'titulo': s.titulo,
                'capa': s.capa,
                'pdf': s.pdf,
                'datainicio': str(s.publicada_inicio)
            })

    return HttpResponse(json.dumps(objectos))














"""
class ParoquiaTemplateView(TemplateView):
    template_name = "website/paroquia/index.html"
"""




class ParoquiaDetailView(DetailView):
    template_name = "website/paroquia/index.html"
    queryset = Noticia.publicado.filter(activo=True)
    def __init__(self, *args, **kwargs):
        super(ParoquiaDetailView, self).__init__(*args, **kwargs)
        """
        self.seccao = None
        self.seccao_pai = None
        self.seccao_pai_seccoes = None
        """
        self.website = 1
        self.content_type = 1

    def get_context_data(self, **kwargs):
        context = super(ParoquiaDetailView, self).get_context_data(**kwargs)

        try:
            paroquia_menu = MenuTree.objects.filter(menu=self.paroquia_website.websiteprofile.menu.pk)
        except Exception, e:
            #print e
            paroquia_menu = None
        context['paroquia']=self.paroquia_params
        context['paroquia_menu'] = paroquia_menu
        context['website']=self.paroquia_website

        """
        context['seccao'] = self.seccao
        context['seccao_pai'] = self.seccao_pai
        context['seccao_pai_seccoes'] = self.seccao_pai_seccoes
        """
        return context
    def get_queryset(self):
        rs = []
        """
        if self.content_type == 1:
            rs = Noticia.publicado.filter(activo=True)
        elif self.content_type == 2:
            rs = Fotogaleria.publicado.filter(activo=True)
        el
        """
        if self.content_type == 3:
            rs = Noticia.publicado.filter(activo=True)
        """
        elif self.content_type == 5:
                rs = PDF.publicado.filter(activo=True)
        elif self.content_type == 10:
            return Arciprestado.objects.filter(pk__isnull=False)
        elif self.content_type == 11:
            return Presbitero.objects.filter(pk__isnull=False, faleceu=False)
        elif self.content_type == 12:
            return DiaconoPermanente.objects.filter(pk__isnull=False)
        elif self.content_type == 13:
            return NotaHistorica.objects.filter(pk__isnull=False)
        elif self.content_type == 14:
            return CuriaDiocesana.objects.filter(pk__isnull=False)
        elif self.content_type == 15:
            return TribunalEclesiastico.objects.filter(pk__isnull=False)

        if self.seccao:
            rs = rs.filter(
                seccoes__in=self.seccao
            )
        if self.seccao_pai_seccoes:
            rs = rs.filter(
                seccoes__in=self.seccao_pai_seccoes
            )
        """
        if rs:
            rs = rs.filter(website=self.paroquia_website.pk).order_by('-publicada_inicio')
        return rs
        #return []

    def get(self, request, **kwargs):

        self.paroquia_params=kwargs['paroquia']
        try:
            self.paroquia_website = WebSite.objects.get(websiteprofile__url__icontains='/'+kwargs['paroquia']+'' )
        except Exception, e:
            return redirect('/')

        if 'content_type' in kwargs:
            self.content_type = kwargs['content_type']
        """
        if 'website' in kwargs:
            self.website = kwargs['website']
        if 'seccao' in kwargs:
            self.seccao = kwargs['seccao'].split(',')
        if 'seccao_pai' in kwargs:
            self.seccao_pai = kwargs['seccao_pai'].split(',')
            self.seccao_pai_seccoes = get_seccao_queryset_descendants(
                    Seccao.objects.filter(
                        pk__in=self.seccao_pai
                    ).all(), True
                )
        """

        return super(ParoquiaDetailView, self).get(request, **kwargs)








class ParoquiaListView(ListView):
    template_name = "website/paroquia/index.html"
    paginate_by = 10
    paroquia_website = None
    paroquia_menu = None
    paroquia_params = None
    pk=None

    """
    content_type_menu = (
                        (1,'/'),
                        (2,'/noticias/(?P<pk>\d+)/'),
                        (3,'/noticia/(?P<pk>\d+)/'),
                        (4,'/horario/'),
                        (5,'/sacerdotes/'),
                        (6,'/contactos/'),
                        (7,'/agenda/'),
                        (8,'/fotogaleria/'),
                        (9,'/videos/'),
                        (10,'/localizacao/'),
                        )
    """

    def get_queryset(self):
        
        rs = []
        """
        if self.content_type == 1:
            rs = Noticia.publicado.filter(activo=True)
        el
        """
        if self.content_type == 2 or self.content_type == 11:            
            rs = Noticia.publicado.filter(activo=True)
        elif self.content_type == 7:
            if not self.is_searchable:
                return []
            rs = Agenda.publicado.filter(website=self.paroquia_website.pk)
            if self.date_start is not None:
                rs = rs.filter(
                    Q(data_inicio__gte = self.date_start) |
                    Q(data_inicio__lte = self.date_start, data_fim__gte = self.date_start)
                )
            if self.date_end is not None:
                rs = rs.filter(
                    Q(data_fim__lte = self.date_end) |
                    Q(data_fim__gte = self.date_end, data_inicio__lte = self.date_end)
                )

            if self.search is not None:
                rs = rs.filter(
                    Q(titulo__icontains=self.search) |
                    Q(descricao__icontains=self.search)
                )

            if rs:
                rs= rs.order_by('-data_inicio')
            return rs
        elif self.content_type == 8:
            rs = Fotogaleria.publicado.filter(activo=True)
        elif self.content_type == 9:
            rs = Multimedia.publicado.filter(activo=True)

        """
        elif self.content_type == 3:
            rs = Multimedia.publicado.filter(activo=True)

        elif self.content_type == 10:
            return Arciprestado.objects.filter(pk__isnull=False).order_by('arciprestado')
        elif self.content_type == 12:
            return DiaconoPermanente.objects.filter(pk__isnull=False) #.order_by('arciprestado')
        elif self.content_type == 13:
            return Secretariado.objects.filter(pk__isnull=False)

        if not self.content_type == 0:
            if self.seccao:
                rs = rs.filter(
                    seccoes__in=self.seccao
                )
            if self.seccao_pai_seccoes:
                rs = rs.filter(
                    seccoes__in=self.seccao_pai_seccoes
                )
            rs = rs.filter(website=self.website)
            return rs.order_by('-publicada_inicio')
        """

        if rs:
            if not self.pk == None and self.content_type in [2,11]:
                rs= rs.filter(website=self.paroquia_website.pk, seccoes__in=[self.pk]).order_by('-publicada_inicio')
            elif self.content_type==8 or self.content_type==9:  
                rs= rs.filter(website=self.paroquia_website.pk, seccoes__in=[self.sec]).order_by('-publicada_inicio')

                """   
                cod_seccao=0
                if self.content_type==8 and self.paroquia_website.websiteprofile.fotogaleria_seccao:
                    cod_seccao=self.paroquia_website.websiteprofile.fotogaleria_seccao.pk
                elif self.content_type==9 and self.paroquia_website.websiteprofile.videos_seccao:
                    cod_seccao=self.paroquia_website.websiteprofile.videos_seccao.pk
                rs= rs.filter(website=self.paroquia_website.pk, seccoes__in=[cod_seccao]).order_by('-publicada_inicio')
                """               
                
        return rs

    def get_context_data(self, **kwargs):
        context = super(ParoquiaListView, self).get_context_data(**kwargs)
        #print self.paroquia_website.websiteprofile.menu.websites_websiteprofiles_menu.all
        #print dir(self.paroquia_website.websiteprofile.menu)
        #print '#################################################'
        try:
            paroquia_menu = MenuTree.objects.filter(menu=self.paroquia_website.websiteprofile.menu.pk)
        except Exception, e:
            #print e
            paroquia_menu = None
        context['paroquia'] = self.paroquia_params
        context['paroquia_menu'] = paroquia_menu
        context['website'] = self.paroquia_website
        if not self.pk == None:
            context['seccao']=Seccao.objects.get(pk=self.pk)

        if self.content_type==7:
            context['date_start'] = self.date_start
            context['date_end'] = self.date_end
            context['search'] = self.search
            context['is_searchable'] = self.is_searchable
        elif self.content_type in [8,9]:
            #context['object'] = self.object
            if self.pk:
                context['object'] = self.get_queryset().filter(pk=self.pk)[0]
            context['sec'] = self.sec
        if self.content_type==12:
            context['email'] = self.email
            context['confirmar'] = self.confirmar
            context['desactivar'] = self.desactivar


        """
        context['seccao'] = self.seccao

        context['ola']=self.paroquia_website.websiteprofile.menu

        context['seccao_pai'] = self.seccao_pai
        context['seccao_pai_seccoes'] = self.seccao_pai_seccoes
        context['object'] = self.object
        context['pk'] = self.pk
        if self.content_type in [3,2] and self.pk:
            context['object'] = self.get_queryset().filter(pk=self.pk)[0]
        """
        return context

    def __init__(self,*args, **kwargs):
        super(ParoquiaListView, self).__init__(*args, **kwargs)
        self.search = None
        self.date_start = None
        self.date_end = None
        self.is_searchable = False

        """
        self.seccao = None
        self.seccao_pai = None
        self.seccao_pai_seccoes = None
        self.object = None
        self.pk = None
        self.website = 1
        self.content_type = 1
        """


    def get(self, request, **kwargs):
        #print request
        #print request.path
        #paroquia_url = str('http')+str(('', 's')[request.is_secure()])+str('://')+request.META['HTTP_HOST']+ request.path
        self.paroquia_params=kwargs['paroquia']
        
        try:
            self.paroquia_website = WebSite.objects.get(websiteprofile__url__icontains='/'+kwargs['paroquia']+'' )
        except Exception, e:
            return redirect('/')

        if 'content_type' in kwargs:
            self.content_type = kwargs['content_type']
        if 'website' in kwargs:
            self.website = kwargs['website']
        if 'pk' in kwargs:
            self.pk = kwargs['pk']
        if 'sec' in kwargs:
            self.sec = kwargs['sec']

        if self.content_type==7:
            try:
                self.search = request.GET.get('search',None)
                if self.search == "":
                    self.search = None
            except:
                self.search = None

            try:
                self.date_start = datetime.strptime(request.GET.get('date_start',None), "%d-%m-%Y" )
            except:
                self.date_start = None

            try:
                self.date_end = datetime.strptime(request.GET.get('date_end',None), "%d-%m-%Y" )
            except:
                self.date_end = None
            if self.date_end is not None:
                self.date_end = self.date_end + timedelta(hours=23) + timedelta(minutes=59) + timedelta(seconds=59)

            if self.date_start is not None or self.date_end is not None or self.search is not None:
                self.is_searchable = True


        elif self.content_type in [8,9]:
            try:
                if self.pk is None:
                    self.pk = int(self.get_queryset()[0].pk)
            except Exception:
                pass
        elif self.content_type==12:
            
            if 'email' in kwargs:
                self.email = kwargs['email']
            if 'confirmar' in kwargs:
                self.confirmar = kwargs['confirmar']
            if 'desactivar' in kwargs:
                self.desactivar = kwargs['desactivar']

        """
        if 'seccao' in kwargs:
            self.seccao = kwargs['seccao'].split(',')
        if 'seccao_pai' in kwargs:
            self.seccao_pai = kwargs['seccao_pai'].split(',')
            self.seccao_pai_seccoes = get_seccao_queryset_descendants(
                    Seccao.objects.filter(
                        pk__in=self.seccao_pai
                    ).all(), True
                )
        try:
            if self.content_type in [3,2] and self.pk is None:
                self.pk = int(self.get_queryset()[0].pk)
        except Exception:
            pass
        """
        return super(ParoquiaListView, self).get(request, **kwargs)

    def content_type_menu_links():
        return content_type_menu_links[self.template]

    def process_filter(self, request):
        pass







from django.utils.translation import ugettext as _
from dbraga import settings
#getattr(django_settings,
#                    'NEWSLETTER_FROM_EMAIL')

class JSONResponseMixin(object):
    def render_to_response(self, context):
        "Returns a JSON response containing 'context' as payload"
        return self.get_json_response(self.convert_context_to_json(context))

    def get_json_response(self, content, **httpresponse_kwargs):
        "Construct an `HttpResponse` object."
        return http.HttpResponse(content, content_type='application/json', **httpresponse_kwargs)

    def convert_context_to_json(self, context):
        "Convert the context dictionary into a JSON object"
        return json.dumps(context)



class ContactoForm(forms.Form):
    nome = forms.CharField(label=_(u'Nome'), )
    email = forms.EmailField(label=_(u'Email'), )
    telefone = forms.CharField(label=_(u'Telefone'), )
    assunto = forms.CharField(label=_(u'Assunto'), )
    mensagem = forms.CharField(label=_(u'Mensagem'), )
    #captcha = ReCaptchaField()



def ajax_contacto(request, paroquia=None):
    json ={
           'ok':False,
           'msg':'',
        }
    website = int(request.POST.get('website',1))
    try:
        form = ContactoForm(request.POST)
        if form.is_valid():
            context = {
                'form': form,
                'request': request,
                'STATIC_URL':django_settings.STATIC_URL,
                'MEDIA_URL':django_settings.MEDIA_URL,
                'SITE_URL': settings.SITE_URL,
            }
            website = WebSite.objects.get(pk=website )
            #print form.data['assunto']
            body = render_to_string("website/emails/email_contacto.html", context)
            ###m = Mailer(settings.EMAIL_FROM, form.data['email'], _(u"Formulário de Contacto: ") + form.data['assunto'], body)
            m = Mailer(website.websiteprofile.email, form.data['email'], _(u"Formulário de Contacto: ") + form.data['assunto'], body)
            m.send()
            ###m = Mailer(form.data['email'], settings.EMAIL_FROM, u"[SITE] " + _(u"Formulário de Contacto: ") + form.data['assunto'], body)
            m = Mailer(form.data['email'], website.websiteprofile.email, u"[SITE] " + _(u"Formulário de Contacto: ") + form.data['assunto'], body)
            m.send()
            json['msg'] = _(u'Foi enviado um email com sucesso! Responderemos com a maior brevidade possivel.\n')
            json['ok'] = True
        else:
            json['msg'] = _(u'Os dados não são validos.\n')
            for x in form.errors:
                json['msg']+='\n'+form.fields[x].label.upper()+': '+form.errors[x][0]
                #json['msg']+='\n'+form.fields[x].label.upper().encode('utf-8')+': '+form.errors[x][0].encode('utf-8')
    except Exception,e:
        json['msg'] = _(u'Ocorreu um erro, tente novamente mais tarde.\n') + str(e)

    return JSONResponseMixin().render_to_response(json)
