# -*- coding: utf-8 *-*

from django.conf.urls.defaults import patterns, include, url
from django.conf import settings
from django.contrib import admin
from .views import detail, listagem, ajax_agenda, ajax_contacto
from .views import AgendaListView, NoticiaDetailView, NoticiaListView, SubsidiosPastoraisListView
from .views import InstituicoesListView, ParoquiaListView, ParoquiaDetailView #, ParoquiaTemplateView
from django.views.generic import TemplateView, DetailView
from conteudos.models import Noticia

from website.rss import DioceseFeed

from django.views.generic.simple import redirect_to

#from views import mobile


# TODO: fazer merge com o ficheiro urls_ruben.py mais tarde
from website.urls_ruben import urlpatterns as ruben_urlpatterns
urlpatterns = ruben_urlpatterns


urlpatterns += patterns('',
    url(r'^/?$',
        TemplateView.as_view(template_name="website/home/home.html"),
        name='home2-view'
    ),
    url(r'^home/?$',
        TemplateView.as_view(template_name="website/home/home.html"),
        name='home-view'
    ),
    url(r'^noticia/(?P<seccao>\d+)/(?P<pk>\d+)/?$',
        NoticiaDetailView.as_view(),
        name='noticia-view'
    ),
    url(r'^noticias/(?P<seccao>\d+)/?$',
        NoticiaListView.as_view(),
        name='noticias-view'
    ),

    url(r'^videos/(?P<pk>\d+)?$',
        NoticiaListView.as_view(
            template_name="website/videos.html",
            paginate_by=6,
        ),
        {
            'content_type':3,
            'seccao_pai':'5',
        },
        name='videos-view'
    ),
    url(r'^fotogalerias/(?P<pk>\d+)?$',
        NoticiaListView.as_view(
            template_name="website/fotogalerias.html",
            paginate_by=6,
        ),
        {
            'content_type':2,
            'seccao_pai':'4',
        },
        name='fotogalerias-view'
    ),
    url(r'^arciprestados/?$',
         NoticiaListView.as_view(
            template_name="website/arciprestados_list.html",
            paginate_by=10000,
        ),
        {
            'content_type': 10
        },
        name='arciprestados-list-view'
    ),
    url(r'^arciprestado/(?P<pk>\d+)/?$',
        NoticiaDetailView.as_view(
            template_name="website/arciprestado.html"
        ),
        {
            'content_type': 10
        },
        name='arciprestado-view'
    ),
    url(r'^clero/presbitero/(?P<pk>\d+)/?$',
        NoticiaDetailView.as_view(
            template_name="website/presbitero.html"
        ),
        {
            'content_type': 11
        },
        name='presbitero-view'
    ),
    url(r'^clero/diaconopermanente/(?P<pk>\d+)/?$',
        NoticiaDetailView.as_view(
            template_name="website/diacono.html"
        ),
        {
            'content_type': 12
        },
        name='diacono_permanente-view'
    ),
    url(r'^clero/diacono/(?P<pk>\d+)/?$',
        NoticiaDetailView.as_view(
            template_name="website/diacono.html"
        ),
        {
            'content_type': 16
        },
        name='diacono-view'
    ),
    url(r'^comunidade/seminarios/?$',
        InstituicoesListView.as_view(
            template_name="website/instituicoes/instituicoes.html"
        ),
        {
            'content_type': 1,
            'page_title':'Seminários Arquidiocesanos'
        },
        name='seminarios-view'
    ),
    url(r'^comunidade/irmasculinos/?$',
        InstituicoesListView.as_view(
            template_name="website/instituicoes/instituicoes.html"
        ),
        {
            'content_type': 2,
            'page_title':'Institutos Religiosos Masculinos'
        },
        name='irmasculinos-view'
    ),
    url(r'^comunidade/irfemininos/?$',
        InstituicoesListView.as_view(
            template_name="website/instituicoes/instituicoes.html"
        ),
        {
            'content_type': 3,
            'page_title':'Institutos Religiosos Femininos'
        },
        name='irfemininos-view'
    ),
    url(r'^comunidade/irseculares/?$',
        InstituicoesListView.as_view(
            template_name="website/instituicoes/instituicoes.html"
        ),
        {
            'content_type': 4,
            'page_title':'Institutos Religiosos Seculares'
        },
        name='irseculares-view'
    ),








    #url(r'^detail/?$', detail, name='detail-view'),
    #url(r'^listagem/?$', listagem, name='listagem-view'),
    url(r'^ajax/agenda/?$', ajax_agenda, name='agenda-view'),
    url(r'^agenda/?$', AgendaListView.as_view(),  name='agenda-listview'),



    url(r'^localizacao/?$',
        TemplateView.as_view(template_name="website/localizacao.html"),
        name='localizacao-view'
    ),
    url(r'^contactos/?$',
        #TemplateView.as_view(template_name="website/contactos.html"),
        NoticiaDetailView.as_view(
        template_name="website/contactos.html"
        ),
        {
            'content_type': 1,
            'pk':4443
        },
        name='contactos-view'
    ),

    url(r'^horarios/?$',
        NoticiaListView.as_view(
            template_name="website/horarios.html"
        ),
        {
            'content_type': 14,
        },
        #NoticiaDetailView.as_view(
        #    template_name="website/horarios.html"
        #),
        #{
        #    'content_type': 1,
        #    'pk':4440
        #},
        name='horarios-view'
    ),

    url(r'^historia/?$',
        NoticiaDetailView.as_view(
            template_name="website/historia.html"
        ),
        {
            'content_type': 13,
            'pk':1,
        },
        name='historia-view'
    ),

    url(r'^personalidades/?$',
        NoticiaListView.as_view(
            template_name="website/personalidades.html"
        ),
        {
            'content_type': 1,
            'seccao': "20",
        },
        name='personalidades-view'
    ),

    url(r'^personalidade/(?P<pk>\d+)/?$',
        NoticiaDetailView.as_view(
            template_name="website/personalidade.html"
        ),
        {
            'content_type': 1,
        },
        name='personalidade-view'
    ),

    url(r'^curia_administracao/?$',
        NoticiaDetailView.as_view(
            template_name="website/curia_administracao.html"
        ),
        {
            'content_type': 14,
            'pk':748,
        },
        name='curia_administracao-view'
    ),

    url(r'^curia_justica/?$',
        NoticiaDetailView.as_view(
            template_name="website/curia_justica.html"
        ),
        {
            'content_type': 15,
            'pk':727,
        },
        name='curia_justica-view'
    ),

    url(r'^curia_evangelizacao/?$',
        NoticiaListView.as_view(
            template_name="website/curia_evangelizacao.html"
        ),
        {
            'content_type': 13,
        },
        name='curia_evangelizacao-view'
    ),

    url(r'^clero_bispos/?$',
        TemplateView.as_view(template_name="website/clero_bispos.html"),
        name='clero_bispos-view'
    ),
    url(r'^clero_bispos/(?P<pk>\d+)/?$',
        TemplateView.as_view(template_name="website/clero_bispos_detalhes.html"),
        name='clero_bispos_detalhe-view'
    ),
    url(r'^clero_bispos/(?P<pk>\d+)/(?P<cod>\d+)/?$',
        TemplateView.as_view(template_name="website/clero_bispos_detalhes.html"),
        name='clero_bispos_detalhe-view'
    ),

    url(r'^igreja_viva/(?P<pk>\d+)/?$',
        NoticiaDetailView.as_view(
            template_name="website/igreja_viva/igreja_viva.html"
        ),
        {
            'content_type': 5,
        },
        name='igreja_viva-view'
    ),
    url(r'^igreja_viva_livro/xml/(?P<pk>\d+).xml$',
        'website.views.get_book_pdf',
        name='igreja_viva_livro-xml-view'
    ),

    url(r'^igreja_viva_livro/(?P<pk>\d+)/?$',
        NoticiaDetailView.as_view(
            template_name="website/igreja_viva/igreja_viva_livro.html"
        ),
        {
            'content_type': 5,
        },
        name='igreja_viva_livro-view'
    ),
    url(r'^diacono_permanente/?$',
         NoticiaListView.as_view(
            template_name="website/diacono_list.html",
            paginate_by=10000,
        ),
        {
            'content_type': 12
        },
        name='diacono_permanente-list-view'
    ),
    url(r'^diaconos/?$',
         NoticiaListView.as_view(
            template_name="website/diacono_list.html",
            paginate_by=10000,
        ),
        {
            'content_type': 16
        },
        name='diacono-list-view'
    ),
    url(r'^presbiteros/?$',
        InstituicoesListView.as_view(
            template_name="website/presbitero_list.html"
        ),
        {
            'content_type': 11,
        },
        name='presbitero-list-view'
    ),
    url(r'^paroquias/?$',
        InstituicoesListView.as_view(
            template_name="website/paroquia_list.html"
        ),
        {
            'content_type': 12,
        },
        name='paroquia-list-view'
    ),
    url(r'^visitas_pastorais/?$',
        TemplateView.as_view(template_name="website/visitas_pastorais_list.html"),
        name='visitas_pastorais-list-view'
    ),    

    url(r'^jubileussacerdotais/?$',        
        TemplateView.as_view(template_name="website/jubileussacerdotais_list.html"),
        name='jubileussacerdotais-list-view'
    ),


    url(r'^newsletter/registar/?$',
        'website.views.ajax_newsletter',
        name='newsletter-ajax-registar-view',
    ),
    url(r'^newsletter/desactivar/?$',
        'website.views.ajax_newsletter_desactivar',
        name='newsletter-ajax-desactivar-view',
    ),
    url(r'^newsletter/confirmar/(?P<key>[\w|\W]+)/?$',
        'website.views.newsletter_confirm',
        {'confirmar':True,},
        name='newsletter-confirmar-view',
    ),
    url(r'^newsletter/confirmar_desactivar/(?P<key>[\w|\W]+)/?$',
        'website.views.newsletter_confirm',
        {'desactivar':True,},
        name='newsletter-desactivar-view',
    ),
    url(r'^newsletter/?$',
        'website.views.newsletter_confirm',
        {'confirmar':False,},
        name='newsletter-view',
    ),
    url(r'^newsletter/desactivar/(?P<email>[\w|\W]+)/?$',
        'website.views.newsletter_confirm',
        {'confirmar':False,},
        name='newsletter-desactivar-email-view',
    ),
    url(r'^rss/?$',
        TemplateView.as_view(template_name="website/rss.html"),
        name='rss-view'
    ),
    url(r'^rss.php$',
        DioceseFeed(content_type = 1),
        name='rss-php-view',
    ),
    url(r'^rss/noticias/?$',
        DioceseFeed(content_type = 1),
        name='rss-noticias-view',
    ),
    url(r'^rss/igreja_primaz/?$',
        DioceseFeed(content_type = 2),
        name='rss-igreja_primaz-view',
    ),
    url(r'^rss/voz_arcebispo/?$',
        DioceseFeed(content_type = 3),
        name='rss-voz_arcebispo-view',
    ),
    url(r'^rss/agenda/?$',
        DioceseFeed(content_type = 4),
        name='rss-agenda-view',
    ),
    url(r'^ws/?$',
        'website.views.mobile',
        {'request_type': 0},
        name='mobile-view'
        ),
    url(r'^ws/noticias/?$', #Request do mobile para receber todas as noticias
        'website.views.mobile',
        {'request_type': 1},
        name='mobile-noticias-view'
    ),
    url(r'^ws/igreja-primaz/?$', #Request do mobile para receber as noticias do canal IGreja Primaz
        'website.views.mobile',
        {'request_type': 2},
        name='mobile-igreja_primaz-view'
    ),
    url(r'^ws/a-voz-do-arcebispo/?$', #Request do mobile para receber do canal A Voz do Arcebispo
        'website.views.mobile',
        {'request_type': 3},
        name='mobile-voz_do_arcebispo-view'
    ),
    url(r'^ws/agenda/?$', #Request do mobile para receber a Agenda
        'website.views.mobile',
        {'request_type': 4},
        name='mobile-agenda-view'
    ),
    url(r'^ws/fotogaleria/?$', #Request do mobile para receber Fotogaleria
        'website.views.mobile',
        {'request_type': 5},
        name='mobile-fotogaleria-view'
    ),
    url(r'^ws/videos/?$', #Request do mobile para receber os videos
        'website.views.mobile',
        {'request_type': 6},
        name='mobile-video-view'
    ),
    url(r'^ws/historia/?$', #Request do mobile para receber as Notas Historicas
        'website.views.mobile',
        {'request_type': 7},
        name='mobile-historia-view'
    ),
    url(r'^ws/curia/?$', #Request do Mobile para receber a Cúria
        'website.views.mobile',
        {'request_type': 8},
        name='mobile-curia-view'
    ),
    url(r'^ws/arciprestados/?$', #Request do Mobile para receber os Arciprestados
        'website.views.mobile',
        {'request_type': 9},
        name='mobile-arciprestados-view'
    ),
    url(r'^ws/seminarios/?$', #Request do Mobile para receber os Seminarios
        'website.views.mobile',
        {'request_type': 10},
        name='mobile-arciprestados-view'
    ),
    url(r'^ws/instituto_religioso_masculino/?$', #Request do Mobile para Instituto Relogioso Masculino
        'website.views.mobile',
        {'request_type': 11},
        name='mobile-institutoreligiosomasculino-view'
    ),
    url(r'^ws/instituto_religioso_feminino/?$', #Request do Mobile para Instituto Relogioso Feminino
        'website.views.mobile',
        {'request_type': 12},
        name="mobile-institutoreligiosofeminino-view"
    ),
    url(r'^ws/instituto_secular/?$', #Request do Mobile para Instituto Relogioso Secular
        'website.views.mobile',
        {'request_type': 13},
        name='mobile-institutoreligiososecular-view'
    ),
    url(r'^ws/clero/?$', #Request do Mobile para receber todos os dados do Clero
        'website.views.mobile',
        {'request_type': 14},
        name='mobile-clero-view'
    ),
    url(r'ws/bispos/?$',
        'website.views.mobile',
        {'request_type': 15},
        name='mobile-bispos-views'
    ),
    url(r'ws/presbiteros/?$',
        'website.views.mobile',
        {'request_type': 16},
        name='mobile-presbiteros-view'
    ),
    url(r'ws/diaconos/?$',
        'website.views.mobile',
        {'request_type': 17},
        name='mobile-diaconos-view'
    ),
    url(r'^ws/pdf/?$',
        'website.views.mobile',
        {'request_type': 18},
        name='mobile-pdf-view'
    ),



    url(r'^transmissaoeucaristia/?$',
        TemplateView.as_view(template_name="website/base/transmissaoeucaristia.html"),
        name='transmissaoeucaristia-view'
    ),



    url(r'^subsidiospastorais/?$',
        NoticiaListView.as_view(),
        {'seccao':'87'},
        name='subsidiospastorais-view'
    ),
    url(r'^nomeacoes/?$',
        NoticiaListView.as_view(template_name="website/nomeacoes_list.html"),
        {'seccao':'169'},
        name='nomeacoes-view'
    ),



    url(r'^ajax/contacto/?$', ajax_contacto, name='contacto-view'),



    (r'txt/Lang.txt$', redirect_to, {'url': settings.STATIC_URL + 'txt/Lang.txt'}),
    (r'swf/Pages.swf$', redirect_to, {'url': settings.STATIC_URL + 'swf/Pages.swf'}),







    url(r'^(?P<paroquia>[a-zA-Z0-9_.-]+)/$',
        #TemplateView.as_view(template_name="website/paroquia/index.html"),
        ParoquiaListView.as_view(
            template_name="website/paroquia/index.html",
            #paginate_by=6,
        ),
        {
            'content_type': 1,
        },
        name='paroquia_home-view'
    ),
    url(r'^(?P<paroquia>[a-zA-Z0-9_.-]+)/noticias/(?P<pk>\d+)/$',
        #TemplateView.as_view(template_name="website/paroquia/listagem.html"),
        ParoquiaListView.as_view(
            template_name="website/paroquia/listagem.html",
            paginate_by=10,
        ),
        {
            'content_type': 2,
        },
        name='paroquia_noticias-view'
    ),
    url(r'^(?P<paroquia>[a-zA-Z0-9_.-]+)/noticia/(?P<pk>\d+)/$',
        #TemplateView.as_view(template_name="website/paroquia/conteudo.html"),
        ParoquiaDetailView.as_view(
            template_name="website/paroquia/conteudo.html",
        ),
        {
            'content_type': 3,
        },
        name='paroquia_noticia-view'
    ),
    url(r'^(?P<paroquia>[a-zA-Z0-9_.-]+)/horario/$',
        #TemplateView.as_view(template_name="website/paroquia/horarios.html"),
        ParoquiaListView.as_view(
            template_name="website/paroquia/horarios.html",
            paginate_by=20000,
        ),
        {
            'content_type': 4,
        },
        name='paroquia_horario-view'
    ),
    url(r'^(?P<paroquia>[a-zA-Z0-9_.-]+)/sacerdotes/$',
        #TemplateView.as_view(template_name="website/paroquia/sacerdotes.html"),
        ParoquiaListView.as_view(
            template_name="website/paroquia/sacerdotes.html",
            #paginate_by=6,
        ),
        {
            'content_type': 5,
        },
        name='paroquia_sacerdotes-view'
    ),
    url(r'^(?P<paroquia>[a-zA-Z0-9_.-]+)/contactos/$',
        #TemplateView.as_view(template_name="website/paroquia/contactos.html"),
        ParoquiaListView.as_view(
            template_name="website/paroquia/contactos.html",
            #paginate_by=6,
        ),
        {
            'content_type': 6,
        },
        name='paroquia_contactos-view'
    ),
    url(r'^(?P<paroquia>[a-zA-Z0-9_.-]+)/agenda/$',
        #TemplateView.as_view(template_name="website/paroquia/agenda.html"),
        ParoquiaListView.as_view(
            template_name="website/paroquia/agenda.html",
            #paginate_by=6,
        ),
        {
            'content_type': 7,
        },
        name='paroquia_agenda-view'
    ),
    url(r'^(?P<paroquia>[a-zA-Z0-9_.-]+)/fotogaleria/(?P<sec>\d+)/(?P<pk>\d+)?$',
        ParoquiaListView.as_view(
            template_name="website/paroquia/fotogaleria.html",
            paginate_by=6,
        ),
        {
            'content_type':8,
        },
        #TemplateView.as_view(template_name="website/paroquia/fotogaleria.html"),
        #ParoquiaListView.as_view(
        #    template_name="website/paroquia/fotogaleria.html",
        #    #paginate_by=6,
        #),
        #{
        #    'content_type': 8,
        #},
        name='paroquia_fotogaleria-view'
    ),
    url(r'^(?P<paroquia>[a-zA-Z0-9_.-]+)/videos/(?P<sec>\d+)/(?P<pk>\d+)?$',
        ParoquiaListView.as_view(
            template_name="website/paroquia/videos.html",
            paginate_by=6,
        ),
        {
            'content_type':9,
        },
        #TemplateView.as_view(template_name="website/paroquia/videos.html"),
        #ParoquiaListView.as_view(
        #    template_name="website/paroquia/videos.html",
        #    #paginate_by=6,
        #),
        #{
        #    'content_type': 9,
        #},
        name='paroquia_videos-view'
    ),
    url(r'^(?P<paroquia>[a-zA-Z0-9_.-]+)/localizacao/$',
        #TemplateView.as_view(template_name="website/paroquia/fotogaleria.html"),
        ParoquiaListView.as_view(
            template_name="website/paroquia/localizacao.html",
            #paginate_by=6,
        ),
        {
            'content_type': 10,
        },
        name='paroquia_localizacao-view'
    ),
    url(r'^(?P<paroquia>[a-zA-Z0-9_.-]+)/downloads/(?P<pk>\d+)/$',
        #TemplateView.as_view(template_name="website/paroquia/fotogaleria.html"),
        ParoquiaListView.as_view(
            template_name="website/paroquia/downloads.html",
            #paginate_by=6,
        ),
        {
            'content_type': 11,
        },
        name='paroquia_downloads-view'
    ),

    #url(r'^(?P<paroquia>[a-z-]+)/agenda/?$', AgendaListView.as_view(),  name='paroquia_agenda-listview'),
    #url(r'^(?P<paroquia>[a-z-]+)/ajax/agenda/?$', ajax_agenda, name='paroquia_agenda-ajax'),


    #url(r'^(?P<paroquia>[a-z-]+)/newsletter/sucesso/(?P<sucesso>\d+)?$', #(?P<email>[\w|\W]+)/
    url(r'^(?P<paroquia>[a-zA-Z0-9_.-]+)/newsletter/sucesso/(?P<email>[\w|\W]+)/(?P<confirmar>(True|False))/(?P<desactivar>(True|False))/?$', 
        ParoquiaListView.as_view(
            template_name="website/newsletter/confirm_paroquia.html",
            #paginate_by=6,
        ),
        {
            'content_type': 12,
        },
        name='paroquia_newsletter-sucesso-view',
    ),

    url(r'^(?P<paroquia>[a-zA-Z0-9_.-]+)/newsletter/confirmar/(?P<key>[\w|\W]+)/?$',
        'website.views.newsletter_confirm',
        {'confirmar':True,},
        name='paroquia_newsletter-confirmar-view',
    ),
    url(r'^(?P<paroquia>[a-zA-Z0-9_.-]+)/newsletter/confirmar_desactivar/(?P<key>[\w|\W]+)/?$',
        'website.views.newsletter_confirm',
        {'desactivar':True,},
        name='paroquia_newsletter-desactivar-view',
    ),
    url(r'^(?P<paroquia>[a-zA-Z0-9_.-]+)/newsletter/?$',
        'website.views.newsletter_confirm',
        {'confirmar':False,},
        name='paroquia_newsletter-view',
    ),
    url(r'^(?P<paroquia>[a-zA-Z0-9_.-]+)/newsletter/desactivar/(?P<email>[\w|\W]+)/?$',
        'website.views.newsletter_confirm',
        {'confirmar':False,},
        name='paroquia_newsletter-desactivar-email-view',
    ),



)


"""
    url(r'^subsidiospastorais/?$',
        SubsidiosPastoraisListView.as_view(),
        name='subsidiospastorais-view'
    ),
"""












"""
    url(r'^fotogalerias/(?P<pk>\d+)?$',
        NoticiaListView.as_view(
            template_name="website/fotogalerias.html",
            paginate_by=6,
        ),
        {
            'content_type':2,
            'seccao_pai':'4',
        },
        name='fotogalerias-view'
    ),
"""

"""
    url(r'^(?P<paroquia>[a-z-]+)/newsletter/registar/?$',
        'website.views.ajax_newsletter',
        name='paroquia_newsletter-ajax-registar-view',
    ),
    url(r'^(?P<paroquia>[a-z-]+)/newsletter/desactivar/?$',
        'website.views.ajax_newsletter_desactivar',
        name='paroquia_newsletter-ajax-desactivar-view',
    ),
"""
