# -*- coding: utf-8 *-*

from django import template
from datetime import datetime, timedelta
from django.core.cache import cache
from django.template.defaultfilters import slugify
from django.db.models import Q
from conteudos.models import Noticia, Fotogaleria, Seccao, Multimedia, Link
from conteudos.models import PDF
from agenda.models import Agenda
from diocese.models import GestaoRecursos, AssociacaoObraPresbitero, Paroquia, Presbitero
from horario.models import Horario, HorarioTipo

import operator
import diocese
import random

from website.models import WebSite


def get_seccao_queryset_descendants(nodes, include_self=False):
    if not nodes:
        return Seccao.tree.none()
    filters = []
    for n in nodes:
        lft, rght = n.lft, n.rght
        if include_self:
            lft -=1
            rght += 1
        filters.append(Q(tree_id=n.tree_id, lft__gt=lft, rght__lt=rght))
    q = reduce(operator.or_, filters)
    return Seccao.tree.filter(q)

register = template.Library()

"""
Get last 'elements' order by published DESC in url e cache_timeout para o tempo de cache dos items
"""


def get_seccao(context=None,seccao=None, cod=None):
    #print seccao
    #print Seccao.objects.filter(pk__in=seccao).all()
    if cod is not None:
        return Seccao.objects.filter(pk=cod).all()
    return Seccao.objects.filter(pk__in=seccao).all()

register.assignment_tag(takes_context=True)(get_seccao)


def get_latest_contents(context, website=1, content_type=1, sections=None, cod=None,
    sections_parent=None, elements=5, cache_time=5 * 60):#cache_time=10 * 60

    cache_key = slugify('get_latest_contents'
        + '_' + str(website) + '_' + str(content_type)
        + '_' + str(sections) + '_' + str(cod) + '_' + str(elements)
        + '_' + str(sections_parent)
    )
    #cache.set(cache_key, None, cache_time)
    rs = cache.get(cache_key)
    if rs is None:
        try:
            rs = []
            if content_type == 1:
                rs = Noticia.publicado
            elif content_type == 2:
                rs = Fotogaleria.publicado
            elif content_type == 3:
                rs = Multimedia.publicado
            elif content_type == 4:
                rs = Link.publicado
            elif content_type == 5:
                rs = PDF.publicado
            elif content_type == 6:
                rs = Horario.publicado.order_by('titulo')
            elif content_type == 7:
                rs = HorarioTipo.publicado

            rs = rs.filter(website=website)

            if cod is not None:
                rs = rs.filter(pk=cod)


            if sections is not None:
                try:
                    sections = sections.split(',')
                except Exception, e:
                    sections = [sections]
                rs = rs.filter(seccoes__in=sections)
            elif sections_parent is not None:
                sections_parent = sections_parent.split(',')
                seccoes = get_seccao_queryset_descendants(
                    Seccao.objects.filter(pk__in=sections_parent).all(), True
                )
                rs = rs.filter(seccoes__in=seccoes)

            if content_type >0 and content_type<6:
                rs = rs.order_by('-publicada_inicio')
            if elements is not None:
                rs = rs[:elements]
            else:
                rs = rs.all()

            cache.set(cache_key, rs, cache_time)
        except Exception,e:
            #print str(e)
            cache.set(cache_key, None, cache_time)
            return None
    return rs

register.assignment_tag(takes_context=True)(get_latest_contents)


@register.filter
def split(str,splitter):
    return str.split(splitter)


def get_tipos_presbiteros(context):
    return diocese.models.PRESBITERO_TIPOS_CHOICES

register.assignment_tag(takes_context=True)(get_tipos_presbiteros)

def get_paroquias(context):
    return diocese.models.Paroquia.objects.order_by('nome').all()

register.assignment_tag(takes_context=True)(get_paroquias)


def get_departamentos(context):
    return diocese.models.Secretariado.objects.filter(paginaweb__isnull=False).order_by('nome').all()

register.assignment_tag(takes_context=True)(get_departamentos)





def get_latest_diocese(context, content_type=1, codigo=None, elements=5, cache_time=10 * 60):

    cache_key = slugify('get_latest_diocese'
        + '_' + str(content_type)
        + '_' + str(codigo) + '_' + str(elements)
    )
    #cache.set(cache_key, None, cache_time)
    rs = cache.get(cache_key)
    if rs is None:
        try:
            rs = []
            if content_type == 1:
                rs = GestaoRecursos.objects.all()
            if content_type == 2:
                rs = AssociacaoObraPresbitero.objects.all()
            if content_type == 3:
                rs = Paroquia.objects.all()

            if codigo is not None:
                rs = rs.filter(pk=codigo)

            if elements is not None:
                rs = rs[:elements]
            else:
                rs = rs.all()

            cache.set(cache_key, rs, cache_time)
        except Exception,e:
            #print str(e)
            cache.set(cache_key, None, cache_time)
            return None
    return rs

register.assignment_tag(takes_context=True)(get_latest_diocese)




def get_latest_secctions(context, cod=None, sections=None,
    sections_parent=None,sections_parent_self=True, elements=5, cache_time=5 * 60, level=None):#cache_time=10 * 60

    cache_key = slugify('get_latest_secctions'
        + '_' + str(cod) + '_' + str(sections) + '_' + str(elements)
        + '_' + str(sections_parent) + '_' + str(sections_parent_self)
         + '_' + str(level)
    )
    #cache.set(cache_key, None, cache_time)
    rs = cache.get(cache_key)
    if rs is None:
        try:
            #rs = Seccao.publicado.filter(pk__isnull=False)
            rs = Seccao.objects.filter(pk__isnull=False)

            if cod is not None:
                rs = rs.filter(pk=cod)

            if sections is not None:
                try:
                    sections = sections.split(',')
                except Exception, e:
                    sections = [sections]
                rs = rs.filter(pk__in=sections)
            elif sections_parent is not None:
                try:
                    sections_parent = sections_parent.split(',')
                except Exception, e:
                    sections_parent = [sections_parent]
                seccoes = get_seccao_queryset_descendants(
                    Seccao.objects.filter(pk__in=sections_parent).all(), False
                )
                rs = rs.filter(pk__in=seccoes)

            if level:
                rs = rs.filter(level=level)

            rs = rs.order_by('tree_id', 'lft')
            if elements is not None:
                rs = rs[:elements]
            else:
                rs = rs.all()
            cache.set(cache_key, rs, cache_time)
        except Exception,e:
            #print str(e)
            cache.set(cache_key, None, cache_time)
            return None
    return rs

register.assignment_tag(takes_context=True)(get_latest_secctions)



def get_paroquia(context, website=None):
    paroquia = None
    if not website==1 and website:
        try:
            website = WebSite.objects.get(pk=website)
            for item in website.url.split("/"):
                if item:
                    paroquia=item
        except Exception, e:
            #print e
            pass
    return paroquia

register.assignment_tag(takes_context=True)(get_paroquia)

def get_website(context, website=None):
    paroquia = None
    if website:
        try:
            paroquia = WebSite.objects.get(pk=website)
        except Exception, e:
            #print e
            pass
    else:
        try:
            paroquia = WebSite.objects.all()
        except Exception, e:
            #print e
            pass
    return paroquia

register.assignment_tag(takes_context=True)(get_website)


def cut(value, arg):
    """Removes all values of arg from the given string"""
    return value.replace(arg, '')
register.filter('cut', cut)


def get_hora(value):
    return str(value/60).rjust(2,'0')+':' + str(value%60).rjust(2,'0')

register.filter('get_hora', get_hora)

def mysort(value):
    return sorted(value)
register.filter('mysort', mysort)



def get_mydate(context):
    from datetime import datetime
    diasemana = datetime.now().strftime('%w')
    hora = int(datetime.now().strftime('%H'))
        
    transmitir = False

    if diasemana == 0 and hora >= 11 and hora <= 13:
        transmitir = True
    elif diasemana > 0 and hora >= 17 and hora <= 19:
        transmitir = True

    return transmitir

register.assignment_tag(takes_context=True)(get_mydate)





def get_igrejasembraga(context):
    paroquias = diocese.models.Paroquia.objects.exclude(foto='')
    number_of_records = paroquias.count()
    if number_of_records>0:
        random_index = int(random.random()*number_of_records)
        return paroquias[random_index]
    return None

register.assignment_tag(takes_context=True)(get_igrejasembraga)








def get_visitas_by_bispo(context, cache_time=5 * 60):#cache_time=10 * 60
    from datetime import date
    from django.db.models import Q

    cache_key = slugify('get_visitas_by_bispo')
    #cache.set(cache_key, None, cache_time)
    rs = cache.get(cache_key)
    if rs is None:
        try:
            rs = []
            
            object_list = Agenda.objects.filter(local__isnull=False, visitas_pastorais=True, data_inicio__year=date.today().year).filter(Q(entidade=1) | Q(entidade=7) | Q(entidade=8)).order_by('entidade__titulo', '-data_inicio')
            visitas_object_list = {}
            for visita in object_list:
                if visita.entidade.pk not in visitas_object_list:
                    visitas_object_list[visita.entidade.pk] = {'entidade':visita.entidade.nome, 'object_list':[]}
                visitas_object_list[visita.entidade.pk]['object_list'].append(visita)

            rs = visitas_object_list
        
            cache.set(cache_key, rs, cache_time)
        except Exception,e:
            #print str(e)
            cache.set(cache_key, None, cache_time)
            return None
    return rs

register.assignment_tag(takes_context=True)(get_visitas_by_bispo)



def get_jubileussacerdotais(context, cache_time=5 * 60):#cache_time=10 * 60
    from datetime import date

    cache_key = slugify('get_jubileussacerdotais')
    #cache.set(cache_key, None, cache_time)
    rs = cache.get(cache_key)
    if rs is None:
        try:
            rs = []
            
            datahoje=date.today()
            dataouro=date(year=datahoje.year-50, month=datahoje.month, day=datahoje.day)
            dataprata=date(year=datahoje.year-25, month=datahoje.month, day=datahoje.day)

            object_list_ouro = Presbitero.objects.filter(faleceu=False, data_ordenacoa__lte=dataouro).order_by('nome')
            object_list_prata = Presbitero.objects.filter(faleceu=False, data_ordenacoa__lte=dataprata, data_ordenacoa__gte=dataouro).order_by('nome')

            rs = {'ouro':object_list_ouro, 'prata':object_list_prata}
        
            cache.set(cache_key, rs, cache_time)
        except Exception,e:
            #print str(e)
            cache.set(cache_key, None, cache_time)
            return None
    return rs

register.assignment_tag(takes_context=True)(get_jubileussacerdotais)

