# -*- coding: utf-8 *-*
from django import template
from datetime import datetime,timedelta
from django.core.cache import cache
from django.template.defaultfilters import slugify
from agenda.models import Agenda
from django.db.models import Q

register = template.Library()

"""
Get last 'elements' order by published DESC in url e cache_timeout para o tempo de cache dos items
"""
def get_proximos_eventos(context, website=1, elements=5, cache_time = 10*60, ):
    cache_key = slugify('proximos_eventos_' + str(website) + '_' + str(elements) )
    rs = cache.get(cache_key)
    if rs is None:
        try:
            data_pesquisa = datetime.today()
            rs = Agenda.objects.filter(website=website)
            rs = rs.filter(
                Q(data_inicio__gte = data_pesquisa) |
                Q(data_inicio__lte = data_pesquisa, data_fim__gte = data_pesquisa)
            ).order_by('data_inicio')
            rs = rs[:elements]
            cache.set(cache_key, rs, cache_time)
        except Exception, e:
            cache.set(cache_key, None, cache_time)
            return None
    return rs

register.assignment_tag(takes_context=True)(get_proximos_eventos)
