# -*- coding: utf-8 *-*
from django import template
import feedparser
from time import mktime
from datetime import date
from django.core.cache import cache

register = template.Library()


def get_passo_rezar_aux(items):
    link = None
    hoje = date.today()
    for item in items:
        xdate = date.fromtimestamp(mktime(item['published_parsed']))
        if  xdate >= hoje:
            link = item['link']
    return link

def get_passo_rezar(context,):
    items = cache.get('passo_a_rezar')
    link = None
    if items is not None:
        link = get_passo_rezar_aux(items)

    if link is None:
        try:
            url = 'http://www.passo-a-rezar.net/podcast.php'
            items = feedparser.parse( url )['items']
            items = sorted(items,
                key=lambda entry: entry["published_parsed"] )
            items.reverse()
            cache.set('passo_a_rezar', items, 2*24*3600)
        except:
            cache.set('passo_a_rezar', None, 2*24*3600)
            return None
        link = get_passo_rezar_aux(items)
    return link

register.assignment_tag(takes_context=True)(get_passo_rezar)



