# -*- coding: utf-8 *-*
from django import template
import feedparser
from time import mktime
from datetime import date
from django.core.cache import cache
from django.template.defaultfilters import slugify

register = template.Library()

"""
Get last 'elements' order by published DESC in url e cache_timeout para o tempo de cache dos items
"""
def get_feed(context, url, elements=5, cache_time = 3600):
    cache_key = slugify(url + '_' + str(elements) )
    items = cache.get(cache_key)
    if items is None:
        try:
            items = feedparser.parse( url )['items']
            items = sorted(items,
                key=lambda entry: entry["published_parsed"] )
            items.reverse()
            items = items[:elements]
            cache.set(cache_key, items, cache_time)
        except:
            cache.set(cache_key, None, cache_time)
            return None

    return items

register.assignment_tag(takes_context=True)(get_feed)
