# -*- coding: utf-8 *-*

from django.utils.safestring import SafeString
from django.contrib.syndication.views import Feed
from django.utils import feedgenerator
from datetime import datetime
from django.db.models import Q
from conteudos.models import Noticia
from agenda.models import Agenda
from django.core.urlresolvers import reverse
#from django.utils.feedgenerator import Rss201rev2Feed
from django.core.cache import cache

from xml.dom.minidom import parseString

from sorl.thumbnail import get_thumbnail


class DioceseFeed(Feed):
    my_links = [
        'rss-noticias-view',
        'rss-igreja_primaz-view',
        'rss-voz_arcebispo-view',
        'rss-agenda-view',
    ]

    def __init__(self, *args, **kwargs):
        super(DioceseFeed, self).__init__()
        self.content_type = int(kwargs.get('content_type',1))
        self.cache_key = 'rss_cache_' + str(self.content_type)

    def __call__(self, request, *args, **kwargs):
        content=super(DioceseFeed,self).__call__(request, *args, **kwargs)
        content._headers['content-type']=('Content-Type', 'text/xml; charset=utf-8')
        content.content=self.indent_xml(content.content)
        return content

    def indent_xml(self, xml, indent=' '*4):
        """Indent and return XML."""
        return parseString(xml).toprettyxml(indent)

    feed_type = feedgenerator.Rss201rev2Feed

    ttl = 600
    feed_copyright = 'Copyright (c) 2012, Diocese de Braga'
    item_copyright = 'Copyright (c) 2012, Diocese de Braga'
    def link(self):
        return self.feed_url()

    def feed_url(self):
        return reverse(self.my_links[self.content_type - 1])

    def title(self):
        return [
            u'Notícias', u'Igreja Primaz',
            u'A Voz do Arcebispo', u'Agenda'
        ][self.content_type-1]
    def description(self):
        return u'Rss de %s' % self.title()

    def categories(self):
         return (self.title(), )

    def items(self, obj):
        cache.set(self.cache_key, None, 10*60)
        rs = cache.get(self.cache_key)
        if rs == None:
            if self.content_type in [1,2,3]:
                rs = Noticia.publicado.filter(
                    website = 1,
                    seccoes__in = [self.content_type]
                ).order_by('-criado')[:30]
            elif self.content_type == 4:
                rs = Agenda.publicado.filter(website=1)
                rs = rs.filter(
                    Q(data_inicio__gte = datetime.now()) |
                    Q(data_inicio__lte = datetime.now(), data_fim__gte = datetime.now())
                ).order_by('data_inicio').select_related('entidade', 'local')[:30]
            cache.set(self.cache_key, rs, 10*60)

        return [] if rs == None else rs

    def item_title(self, item):
        return item.titulo

    def my_item_noticia(self, item):
        if self.content_type == 4:
            return item.descricao + '<br/>' + \
                (item.entidade.titulo if item.entidade else '') + ' - ' + \
                (item.local.titulo if item.local else '') + '<br/>' + \
                item.data_inicio.strftime("%d-%m-%Y %H:%M") + \
                u' até ' + item.data_fim.strftime("%d-%m-%Y %H:%M")

        if item.capa!=None:
            try:
                #im = get_thumbnail(item.cover, '230x230', crop='center', quality=99)
                im = get_thumbnail(item.capa, '234', crop='center', quality=99)
                return str('<img src="http://www.diocese-braga.pt')+im.url+str('" align="left" width="230px" hspace="10" />')+item.resumo
            except Exception, e:
                #print e
                pass

        return item.resumo
        #return item.noticia

    def item_description(self, item):
        return self.my_item_noticia(item)


    def item_link(self, item):
        if self.content_type == 4:
            return "http://www.diocese-braga.pt"
        return  reverse('noticia-view',
            kwargs = {'seccao':self.content_type, 'pk': int(item.pk) },
        )

    def item_guid(self, obj):
        return str(obj.pk)

    def item_author_name(self, item):
        if self.content_type == 4:
            return ''
        return item.autor

    def item_pubdate(self, item):
        return item.publicada_inicio

    def item_categories(self, item):
        if self.content_type == 4:
            return ('Agenda', )

        return map(lambda seccao: seccao.title, item.seccoes.all())


