# -*- coding: utf-8 *-*
from django.conf import settings
#from celery.decorators import task
from celery.decorators import periodic_task
from celery.task.schedules import crontab
from django.conf import settings as django_settings
from peakitcms.funcionalidades.Mailer import Mailer
from sms_email.models import SmsEmail, SmsQueue, SmsQueueNumbers
from newsletter.models import Quee
from datetime import datetime
from .sms import SendSms

@periodic_task(run_every=crontab(
    minute="*/" + getattr(settings, 'SMSEMAIL_QUEUE_EVERY', '1')))
def add_queue():
    smsemails_enviar = SmsEmail.objects.filter(active=True, send_date__isnull=True)[:10]

    for sms_email in smsemails_enviar:
        if sms_email.ntype in (1,3):
            for email in sms_email.get_emails():
                mailer = Mailer(getattr(django_settings,
                    'NEWSLETTER_FROM_EMAIL'), email, sms_email.subject, sms_email.noticia)
                mailer.queue = Quee
                mailer.send()

        if sms_email.ntype in (2,3):
            
            numbers = sms_email.get_numbers()
            if len(numbers) > 0:
                sms_q = SmsQueue.objects.create(body=sms_email.sms_body)
                sms_q.save()
                for number in numbers:
                    SmsQueueNumbers.objects.create(to_number=number, sms=sms_q).save()
                    
        sms_email.send_date = datetime.now()
        sms_email.save()




@periodic_task(run_every=crontab(
    minute="*/" + getattr(settings, 'SMSEMAIL_DISPATCH_EVERY', '1')))
def dispatch_queue():
    for sms_q in SmsQueue.objects.order_by('-trys')[:10]:
        numbers = map(lambda x: x.to_number, sms_q.smsqueue_number.all())
        ok=True
        error_message = ''
        if len(numbers)>0:
            try:
                result = SendSms().send(sms_q.body, numbers)
                ok=result['ok']
                error_message = result['message']
            except Exception,e:
                ok=False
                error_message = str(e)
        
        handle1=open(settings.PATH+'static/smslogs.txt','a+')
        handle1.write(str(datetime.today())+' - '+error_message+"\r\n")
        handle1.close();

        if ok:
            sms_q.delete()
        else:
            sms_q.last_error_message = error_message
            sms_q.trys += 1
            sms_q.save()

