#coding: utf-8
from sms_email import models as MODsms_email
from django.contrib import admin
from django.forms.models import BaseInlineFormSet
from django.utils.translation import ugettext_lazy as _
from inline_ordering.admin import OrderableStackedInline

from newsletter.forms import NewForm


class MyInlineFormSet(BaseInlineFormSet):
    def _construct_form(self, i, **kwargs):
        form = super(MyInlineFormSet, self)._construct_form(i, **kwargs)
        form.empty_permitted = True
        return form


class BaseInline(admin.TabularInline):
    extra = 0
    formset = MyInlineFormSet


# User
class UserGroupInline(BaseInline):
    """"""
    model = MODsms_email.UserGroup
    raw_id_fields = ('group',)
# ---------------------


# NewsletterGroup
class SmsEmailGroupInline(BaseInline):
    """"""
    model = MODsms_email.SmsEmailGroup
    raw_id_fields = ('group',)
# ---------------------

#Users
class SmsEmailUserInline(BaseInline):
    """"""
    model = MODsms_email.SmsEmailUser
    raw_id_fields = ('user',)

# ---------------------


#numbers
class SmsQueueNumberInline(BaseInline):
    """"""
    model = MODsms_email.SmsQueueNumbers
    #raw_id_fields = ('user',)

# ---------------------
"""
# Section
class SectionsInline(BaseInline):
    """"""
    model = MODsms_email.NewsletterSection
    raw_id_fields = ('section',)

# ---------------------


#Users
class NewsInline(OrderableStackedInline):
    """"""
    form = NewForm
    extra = 0
    model = MODsms_email.NewsletterNew
    raw_id_fields = ('news',)

    class Media:
        js = ('admin/js/jquery-ui.min.js', 'inline_ordering.js')
# ---------------------


#TemplateTag
class NewsletterTemplateTagInline(BaseInline):
    """"""
    model = MODsms_email.NewsletterTemplateTag
# ---------------------
"""