#coding: utf-8
from sitemenu.models import Menu, MenuTree
from django.contrib import admin
from django.utils.translation import ugettext_lazy as _
#from my_utils.BaseTreeEditor import BaseTreeEditorAdmin
#from my_utils.BaseAdmin import BaseAdmin

from django.contrib import admin

"""
Estendi a class ModelAdmin para suportar accoes nas linhas
"""
class BaseAdmin(admin.ModelAdmin):
    change_list_template = 'actionslistview.html'
    row_actions = []


from django.conf import settings as django_settings
from django.utils.translation import ugettext_lazy as _
from feincms.admin import tree_editor



from myadmin.admin import MyBaseAdmin



# Admin
# ---------------------
class BaseTreeEditorAdmin(tree_editor.TreeEditor):
    raw_id_fields = ['parent',]
    list_display = ('title','active_toggle',)
    active_toggle = tree_editor.ajax_editable_boolean('active', _('is active'))

    is_popup = False
    request = dict()

    def queryset(self, request):
        self.is_popup = False
        if  'pop' in request.GET:
            self.is_popup = True
        self.request = request
        return super(BaseTreeEditorAdmin, self).queryset(request)

    def _actions_column(self, page):
        editable = getattr(page, 'feincms_editable', True)
        actions = super(BaseTreeEditorAdmin, self)._actions_column(page)

        link = u'add/?'

        if self.is_popup:
            link += u'_popup=%s&' % self.request.GET['pop']

        if editable:
            actions.insert(0, u'<a href="%sparent=%s" title="%s"><img src="%sadmin/img/icon_addlink.gif" alt="%s"></a>' % (link, page.pk, _('Add child page'),django_settings.ADMIN_MEDIA_PREFIX , _('Add child page')))
        #actions.insert(0, u'<a href="%s" title="%s"><img src="%simg/admin/selector-search.gif" alt="%s" /></a>' % (page.pk, _('View on site'), django_settings.ADMIN_MEDIA_PREFIX, _('View on site')))

        return actions
# ---------------------









# Layouts
# ---------------------
class MenuAdmin(MyBaseAdmin, BaseAdmin):
    save_on_top = True #adiciona os botoes de salvar no topo tambem
    list_display = ('title','id',)
    search_fields = ('id', 'title', )

    exclude = ('website',)

    row_actions = ['tree',]

    def tree(self):
        return {
            'href': '/admin/sitemenu/menutree/?menu=',
            'name': self.tree.short_description
        }

    tree.short_description = _("Tree")

admin.site.register(Menu, MenuAdmin)

from mptt.admin import MPTTModelAdmin
class MenuTreeAdmin(MyBaseAdmin, MPTTModelAdmin, BaseTreeEditorAdmin):#BaseTreeEditorAdmin
    save_on_top = True #adiciona os botoes de salvar no topo tambem
    unknown_fields = ['parent',]
    #list_display = ('title', 'active_toggle','id',)
    #list_display = ('title','id',)
    list_display = ('title', 'id', 'actions_column',)
    #list_filter = ('active', )
    #search_fields = ('id', 'ref', 'title', 'section__title', )
    search_fields = ('id', 'ref', 'title', )
    #raw_id_fields = ('section',)
    raw_id_fields = ('menu','noticias_noticias', 'noticia_noticia', ) # , 'home_noticia', 'home_noticias', 'fotogaleria_seccao', 'horario_horario', 'sacerdotes_paroquia', 'contactos_noticia',
    exclude = ('link',)

    fieldsets = (
        (None, {
            #'fields': ('menu', ('active', 'ref'), 'title', 'link','section'),
            'fields': (
                        'menu',
                        'title',
                        #'link',
                        'template',
                        'parent',
                ),
            }),
        #("Home", {
        #    'classes': ['collapse',],
        #    'fields': (
        #                'home_noticia',
        #                'home_noticias',
        #                'fotogaleria_seccao',
        #        ),
        #    }),
        ("Listagem de Notícias", {
            'classes': ['collapse',],
            'fields': (
                        'noticias_noticias',
                ),
            }),
        ("Detalhes de Notícia", {
            'classes': ['collapse',],
            'fields': (
                        'noticia_noticia',
                ),
            }),
        #("Detalhes de Horário", {
        #    'classes': ['collapse',],
        #    'fields': (
        #                'horario_horario',
        #        ),
        #    }),
        #("Listagem de Sacerdotes", {
        #    'classes': ['collapse',],
        #    'fields': (
        #                'sacerdotes_paroquia',
        #        ),
        #    }),
        #("Formulário de Contactos", {
        #    'classes': ['collapse',],
        #    'fields': (
        #                'contactos_noticia',
        #        ),
        #    }),

        #(_('Other options'), {
        #    'classes': ['collapse',],
        #    'fields': unknown_fields,
        #}),
        )


    def queryset(self, request):
        qs = super(MenuTreeAdmin, self).queryset(request)

        if 'menu' in request.GET:
            qs = qs.filter(menu=request.GET['menu'])

        ordering = self.ordering or () # otherwise we might try to *None, which is bad ;)
        if ordering:
            qs = qs.order_by(*ordering)
        return qs

    def _actions_column(self, page):
        try:
            actions = []
            actions.append(u'<a href="add/?parent=%s" title="%s"><img src="%sadmin/img/icon_addlink.gif" alt="%s"></a>' % ( page.pk, _('Add child page'), django_settings.STATIC_URL, ('Add child page')))
            actions.append(u'<div class="drag_handle"></div>')
            #actions.append(u'<div class="drag_handle" title="%s"></div>' % (_('Move child page')))
            #actions.append(u'<a href="add/?parent=%s" title="%s"><img src="%simg/admin/icon_addlink.gif" alt="%s"></a>' % ( page.pk, _('Add child'), django_settings.ADMIN_MEDIA_PREFIX ,_('Add child')))
            #actions.append(u'<a href="#" onclick="return cut_item(\'%s\', this)" title="%s">&#x2702;</a>' % (page.pk, _('Cut')))
            #actions.append(u'<a class="paste_target" href="#" onclick="return paste_item(\'%s\', \'last-child\')" title="%s">&#x21b3;</a>' % (page.pk, _('Insert as child')))
            #actions.append(u'<a class="paste_target" href="#" onclick="return paste_item(\'%s\', \'left\')" title="%s">&#x21b1;</a>' % (page.pk, _('Insert before')))
            return actions
        except Exception, e:
            print e
            return None

admin.site.register(MenuTree, MenuTreeAdmin)
# ---------------------

"""
 {% for genre, structure in genres|tree_info %}
      {% if tree.new_level %}<ul><li>{% else %}</li><li>{% endif %}
         {{ genre.name }}
      {% for level in tree.closed_levels %}</li></ul>{% endfor %}
   {% endfor %}
"""
