#coding: utf-8
from django.contrib import admin
from django.db import models
from django.utils.translation import ugettext_lazy as _
from django import forms

from peakitcms.models import Base, getBaseAdmin, DEFAULT_FIELDSETS, BaseForm

from inline_ordering.admin import OrderableStackedInline, OrderableTabularInline
from inline_ordering.models import Orderable
from elfinder.hooks.ElfinderImageField import ElfinderImageWidget

from tinymce import widgets as tinymce_widgets
from redactor.widgets import JQueryEditor as RedactorEditor

DIA_SEMANA_CHOICES=(
    (1, _(u'Diária')),
    (2, _(u'Semanal')),
    (3, _(u'Mensal')),
    (4, _(u'Livre')),
)


# Models
def getBaseNewsletter():
    class BaseNewsletter(Base):
        titulo = models.CharField(_(u'Título'), max_length=255)
        noticia = models.TextField(_(u'Nóticia'), null=True, blank=True)
        periodicidade = models.PositiveIntegerField(_(u'Periocidade'), max_length=1, choices=DIA_SEMANA_CHOICES, default=1)
        data_envio = models.DateTimeField(_(u'Data Envio'), null=True, blank=True)
        subtitulo = models.CharField(_(u'Subtitulo'), max_length=255, null=True, blank=True)
        #activa =  models.BooleanField(_(u'Activa'), default=True)

        class Meta:
            abstract = True
            verbose_name = u'newsletter'
            verbose_name_plural = u'newsletters'

        def __unicode__(self):
            return self.titulo

    return BaseNewsletter

def getBaseNewsletterGrupos(basenewsletter, basenewslettergrupo):
    class BaseNewsletterGrupos(models.Model):
        newsletter = models.ForeignKey(basenewsletter, verbose_name=_(u'Newsletter'), related_name='%(app_label)s_%(class)s_newsletter')
        grupo = models.ForeignKey(basenewslettergrupo, verbose_name=_(u'Grupo'), related_name='%(app_label)s_%(class)s_grupo')

        class Meta(Base.Meta):
            abstract = True
            verbose_name = _(u'newsletter grupo')
            verbose_name_plural = _(u'newsletter grupos')
            unique_together = ('newsletter', 'grupo',)

    return BaseNewsletterGrupos

# Fim Models

# Admin
def getBaseNewsletterGrupoInline(mymodel):
    class BaseNewsletterGrupoInline(admin.TabularInline):
        model = mymodel
        extra=0
        raw_id_fields = ('newsletter',)

    return BaseNewsletterGrupoInline

def getBaseNewsletterForm(mymodel):
    class BaseNewsletterForm(BaseForm):
        #noticia = forms.CharField(widget=tinymce_widgets.AdminTinyMCE)
        noticia = forms.CharField(widget=RedactorEditor())
        class Meta:
            model = mymodel

    return BaseNewsletterForm

def getBaseNewsletterAdmin(mymodel):
    class BaseNewsletterAdmin(getBaseAdmin(mymodel)):
        form =  getBaseNewsletterForm(mymodel)
        fieldsets = (
                     DEFAULT_FIELDSETS['informacao'],
                     DEFAULT_FIELDSETS['publicacao'],
                     (None, {
                             'fields':(
                                       #'activo',
                                       'titulo',
                                       'noticia',
                                       'periodicidade',
                                       'data_envio',
                                       'subtitulo',
                                       )
                             }),
                     )
        list_display = ('titulo', 'activo', 'aprovado_por', 'alterado', 'id',)
        list_filter = ('activo', )
        search_fields = ('titulo', 'noticia', 'id', )

    return BaseNewsletterAdmin
# Fim Admin
