#coding: utf-8
from django.contrib import admin
from django.db import models
from django.utils.translation import ugettext_lazy as _
from django import forms

from peakitcms.models import Base, getBaseAdmin, DEFAULT_FIELDSETS, BaseForm

from inline_ordering.admin import OrderableStackedInline, OrderableTabularInline
from inline_ordering.models import Orderable
from elfinder.hooks.ElfinderImageField import ElfinderImageWidget


# Models
def getBaseNewsletterAssinante():
    class BaseNewsletterAssinante(Base):
        email = models.CharField(_(u'Email'), max_length=255)
        #activo =  models.BooleanField(_(u'Activa'), default=True)
        str_aleatorio = models.CharField(_(u'STR Aleatório'), max_length=255, null=True, blank=True)

        class Meta:
            abstract = True
            verbose_name = u'newsletter assinante'
            verbose_name_plural = u'newsletter assinantes'

        def __unicode__(self):
            return self.email

    return BaseNewsletterAssinante

def getBaseNewsletterAssinanteGrupo(basenewsletter, basenewslettergrupo):
    class BaseNewsletterAssinanteGrupo(models.Model):
        assinante = models.ForeignKey(basenewsletter, verbose_name=_(u'Assinante'), related_name='%(app_label)s_%(class)s_assinante')
        grupo = models.ForeignKey(basenewslettergrupo, verbose_name=_(u'Grupo'), related_name='%(app_label)s_%(class)s_grupo')

        class Meta(Base.Meta):
            abstract = True
            verbose_name = _(u'assinante grupo')
            verbose_name_plural = _(u'assinante grupos')
            unique_together = ('assinante', 'grupo',)

    return BaseNewsletterAssinanteGrupo

# Fim Models

# Admin
def getBaseNewsletterAssinanteGrupoInline(mymodel):
    class BaseNewsletterAssinanteGrupoInline(admin.TabularInline):
        model = mymodel
        extra=0
        raw_id_fields = ('assinante',)

    return BaseNewsletterAssinanteGrupoInline

def getBaseNewsletterAssinanteForm(mymodel):
    class BaseNewsletterAssinanteForm(BaseForm):
        class Meta:
            model = mymodel

    return BaseNewsletterAssinanteForm

def getBaseNewsletterAssinanteAdmin(mymodel):
    class BaseNewsletterAssinanteAdmin(getBaseAdmin(mymodel)):
        form =  getBaseNewsletterAssinanteForm(mymodel)
        fieldsets = (
                     DEFAULT_FIELDSETS['informacao'],
                     DEFAULT_FIELDSETS['publicacao'],
                     (None, {
                             'fields':(
                                       #'activo',
                                       'email',
                                       )
                             }),
                     )
        list_display = ('email', 'activo', 'aprovado_por', 'alterado', 'id',)
        list_filter = ('activo', )
        search_fields = ('email', 'id', )

    return BaseNewsletterAssinanteAdmin
# Fim Admin
