#coding: utf-8
from django.contrib import admin
from django.db import models
from django.utils.translation import ugettext_lazy as _
from django import forms

from peakitcms.models import Base, getBaseAdmin, DEFAULT_FIELDSETS, BaseForm

from feincms.content.video import models as MODELSfeincms
from elfinder.hooks.ElfinderImageField import ElfinderImageWidget

# Models
def getBaseVideo():
    class BaseVideo(Base, MODELSfeincms.VideoContent):
        titulo = models.CharField(max_length=255)
        capa = models.CharField(max_length=255, null=True, blank=True)

        class Meta(Base.Meta):
            abstract = True
            verbose_name = u'video'
            verbose_name_plural = u'videos'

        def __unicode__(self):
            return self.titulo
    return BaseVideo
# Fim Models

# Admin
def getBaseVideoForm(mymodel):
    class BaseVideoForm(BaseForm):
        class Meta:
            model = mymodel
            widgets = {
                'fs': forms.widgets.HiddenInput,
                'capa': ElfinderImageWidget(attrs={'a':'a'}),
            }
    return BaseVideoForm

def getBaseVideoAdmin(mymodel):
    class BaseVideoAdmin(getBaseAdmin(mymodel)):
        form = getBaseVideoForm(mymodel)
        fieldsets = (
                     DEFAULT_FIELDSETS['informacao'],
                     DEFAULT_FIELDSETS['publicacao'],
                     (None, {
                             'fields':(
                                       ('capa', 'fs'),
                                       'titulo',
                                       'video'
                                       )
                             }),
                     )
        list_display = ('titulo', 'activo', 'aprovado_por', 'alterado', 'id',)
        list_filter = ('activo', )
        search_fields = ('titulo', 'id', )

    return BaseVideoAdmin
# Fim Amdin
