#coding: utf-8
from django.contrib import admin
from peakitcms.conteudos.models import BaseMPTT
from datetime import datetime
from django.db import models
from feincms.models import create_base_model
from django.utils.translation import ugettext_lazy as _

from peakitcms.models import Base, getBaseAdmin, getBaseMPTTAdmin, DEFAULT_FIELDSETS, BaseForm, MPTTAdminForm

from elfinder.hooks.ElfinderImageField import ElfinderImageWidget
from django import forms

from feincms.admin import editor
from django.conf import settings as django_settings


def getBaseSeccao():
    #class BaseSeccao(create_base_model(BaseMPTT)):
    class BaseSeccao(BaseMPTT):
        descricao = models.CharField(_(u'descrição'), max_length=255,null=True,blank=True)
        #referencia = models.CharField(_(u'referência'), max_length=10, blank=True, null=True, db_index=True)
        #foto = models.CharField(_(u'imagem'), max_length=255,null=True,blank=True)
        #cor = models.CharField(_(u'cor'), max_length=7, null=True, blank=True)
        #template = models.ForeignKey('Template', related_name='template_field', null=True, blank=True)

        class Meta(BaseMPTT.Meta):
            verbose_name = _(u'secção')
            verbose_name_plural = _(u'secções')
            abstract = True

        def __unicode__(self):
            return self.title
    return BaseSeccao

# Admin
def getBaseSeccaoForm(mymodel):
    class BaseSeccaoForm(MPTTAdminForm):
        class Meta:
            model = mymodel
        #    widgets = {
        #        'fs': forms.widgets.HiddenInput,
        #        'foto': ElfinderImageWidget(attrs={'a':'a'}),
        #    }
    return BaseSeccaoForm



def getBaseSeccaoAdmin(mymodel):
    class BaseSeccaoAdmin(getBaseMPTTAdmin(mymodel)):
        form = getBaseSeccaoForm(mymodel)
        fieldsets = (
                     #DEFAULT_FIELDSETS['informacao'],
                     #DEFAULT_FIELDSETS['publicacao'],
                     (None, {
                             'fields':(
                                       'title',
                                       'descricao',
                                       'parent'
                                       )
                             }),
                     )

        #list_display = ('title', 'activo', 'aprovado_por', 'alterado', 'id', 'actions_column',)
        list_display = ('title', 'id', 'actions_column',)

        def _actions_column(self, page):
            try:
                actions = []
                actions.append(u'<a href="add/?parent=%s" title="%s"><img src="%sadmin/img/icon_addlink.gif" alt="%s"></a>' % ( page.pk, _('Add child page'), django_settings.STATIC_URL, ('Add child page')))
                actions.append(u'<div class="drag_handle"></div>')
                #actions.append(u'<div class="drag_handle" title="%s"></div>' % (_('Move child page')))
                #actions.append(u'<a href="add/?parent=%s" title="%s"><img src="%sadmin/img/icon_addlink.gif" alt="%s"></a>' % ( page.pk, _('Add child'), django_settings.ADMIN_MEDIA_PREFIX ,_('Add child')))
                #actions.append(u'<a href="#" onclick="return cut_item(\'%s\', this)" title="%s">&#x2702;</a>' % (page.pk, _('Cut')))
                #actions.append(u'<a class="paste_target" href="#" onclick="return paste_item(\'%s\', \'last-child\')" title="%s">&#x21b3;</a>' % (page.pk, _('Insert as child')))
                #actions.append(u'<a class="paste_target" href="#" onclick="return paste_item(\'%s\', \'left\')" title="%s">&#x21b1;</a>' % (page.pk, _('Insert before')))
                return actions
            except Exception, e:
                print e
                return None
    return BaseSeccaoAdmin
# Fim Admin
