#coding: utf-8
from django.contrib import admin
from django.db import models
from django.utils.translation import ugettext_lazy as _
from django import forms

from peakitcms.models import Base, getBaseAdmin, DEFAULT_FIELDSETS, BaseForm

from feincms.content.video import models as MODELSfeincms
from elfinder.hooks.ElfinderImageField import ElfinderImageWidget

TIPOS_CHOICES=(
    (0, _(u'Video')),
    (1, _(u'Audio')),
)

# Models
def getBaseMultimedia(baseseccao, noticia_seccao, basemultimedia, noticia_noticia):
    class BaseMultimedia(Base, MODELSfeincms.VideoContent):
        titulo = models.CharField(max_length=255)
        foto = models.CharField(_(u'Foto'), max_length=255, null=True, blank=True)
        ficheiro = models.CharField(max_length=255, null=True, blank=True)
        descricao = models.TextField('Descrição', null=True, blank=True)
        tipo = models.PositiveIntegerField(_(u'Tipo'), max_length=1, choices=TIPOS_CHOICES, default=0)
        assinatura = models.CharField(_(u'Assinatura'), max_length=255, null=True, blank=True)
        #url = models.URLField(_('URL'), help_text=_('This should be a link to a youtube or vimeo video, i.e.: http://www.youtube.com/watch?v=zmj1rpzDRZ0'), null=True, blank=True)

        seccoes = models.ManyToManyField(baseseccao, through=noticia_seccao, related_name='%(app_label)s_%(class)s_multimedia_seccao', null=True, blank=True)
        seccoes.arvore_filter = True
        relacoes = models.ManyToManyField(basemultimedia, through=noticia_noticia, related_name='%(app_label)s_%(class)s_multimedia_relacao', null=True, blank=True)

        class Meta(Base.Meta):
            abstract = True
            verbose_name = u'Multimédia'
            verbose_name_plural = u'Multimédias'

        def __unicode__(self):
            return self.titulo
    return BaseMultimedia

def getBaseMultimediaSeccao(basemultimedia, baseseccao):
    class BaseMultimediaSeccao(models.Model):
        noticia = models.ForeignKey(basemultimedia, verbose_name=_(u'múltimedia'), related_name='%(app_label)s_%(class)s_multimedia')
        seccao = models.ForeignKey(baseseccao, verbose_name=_(u'secção'), related_name='%(app_label)s_%(class)s_seccao')
        seccao_publicacao = models.IntegerField(_(u'secção de publicação'), choices=((1,u'Destaque Principal'),(2,u'Destaque Secundário')), null=True, blank=True)

        class Meta(Base.Meta):
            abstract = True
            verbose_name = _(u'secção')
            verbose_name_plural = _(u'secções')
            unique_together = (("noticia", "seccao"),)

        def __unicode__(self):
            return self.seccao.title
    return BaseMultimediaSeccao

def getBaseMultimediaRelacao(basefotogaleria1, basefotogaleria2):
    class BaseMultimediaRelacao(models.Model):
        multimedia = models.ForeignKey(basefotogaleria1, verbose_name=_(u'notícia'), related_name='%(app_label)s_%(class)s_noticia_ori', db_index=True)
        multimedia_rel = models.ForeignKey(basefotogaleria2, verbose_name=_(u'notícia'), related_name='%(app_label)s_%(class)s_noticia_rel', db_index=True)

        def save(self, *args, **kwargs):
            super(BaseMultimediaRelacao, self).save(*args, **kwargs)
            self.multimedia_rel.relations.through.objects.get_or_create(
                                                              fotogaleria_id = self.multimedia_rel.id,
                                                              fotogaleria_rel_id = self.multimedia.id
                                                              )

        def delete(self):
            myid = self.multimedia_rel.id
            super(BaseMultimediaRelacao, self).delete()
            try:
                d = self.multimedia_rel.relations.through.objects.get(multimedia__id=myid)
                d.delete()
            except:
                pass

        #def __unicode__(self):
        #    return self.multimedia_rel.titulo

        class Meta:
            abstract = True
            verbose_name = _(u'relacionado')
            verbose_name_plural = _(u'relacionados')
            unique_together = (("multimedia", "multimedia_rel"),)
    return BaseMultimediaRelacao

# Fim Models

# Admin

def getBaseMultimediaSeccaoInline(mymodel, seccao='seccao'):
    class BaseMultimediaSeccaoInline(admin.TabularInline):
        extra = 0
        model = mymodel
        raw_id_fields = ('seccao',)
    return BaseMultimediaSeccaoInline

def getBaseMultimediaForm(mymodel):
    class BaseMultimediaForm(BaseForm):
        video = forms.URLField(label=_('URL'), help_text=_('This should be a link to a youtube or vimeo video, i.e.: http://www.youtube.com/watch?v=zmj1rpzDRZ0'), max_length=200, required=False, widget=forms.widgets.TextInput(attrs={'class':'vURLField'}))

        class Meta:
            model = mymodel
            widgets = {
                'fs': forms.widgets.HiddenInput,
                'ficheiro': ElfinderImageWidget(attrs={'a':'a'}),
                'foto': ElfinderImageWidget(attrs={'a':'a'}),
            }
    return BaseMultimediaForm

def getBaseMultimediaAdmin(mymodel):
    class BaseMultimediaAdmin(getBaseAdmin(mymodel)):
        form = getBaseMultimediaForm(mymodel)
        fieldsets = (
                     DEFAULT_FIELDSETS['informacao'],
                     DEFAULT_FIELDSETS['publicacao'],
                     (None, {
                             'fields':(
                                       ('titulo', 'fs'),
                                       'foto',
                                       'ficheiro',
                                       'descricao',
                                       'tipo',
                                       'assinatura',
                                       #'url'
                                       'video'
                                       )
                             }),
                     )
        list_display = ('titulo', 'activo', 'aprovado_por', 'alterado', 'id',)
        list_filter = ('activo', )
        search_fields = ('titulo', 'id', )

    return BaseMultimediaAdmin

# Fim Amdin


