#coding: utf-8
from django.contrib import admin
from django.db import models
from django.utils.translation import ugettext_lazy as _
from django import forms

from peakitcms.models import Base, getBaseAdmin, DEFAULT_FIELDSETS, BaseForm

from elfinder.hooks.ElfinderImageField import ElfinderImageWidget

CATEGORIA_CHOICES=(
    (2, _(u'Outros endereços')),
    (3, _(u'Paróquias')),
)

# Models
def getBaseLink():
    class BaseLink(Base):
        titulo = models.CharField(max_length=255)
        descricao = models.TextField('Descrição', null=True, blank=True)
        url = models.URLField(_('URL'), null=True, blank=True)
        categoria = models.PositiveIntegerField(_(u'Tipo'), max_length=1, choices=CATEGORIA_CHOICES, default=0)

        class Meta(Base.Meta):
            abstract = True
            verbose_name = u'Links'
            verbose_name_plural = u'Links'

        def __unicode__(self):
            return self.titulo
    return BaseLink

# Fim Models

# Admin
def getBaseLinkForm(mymodel):
    class BaseLinkForm(BaseForm):
        class Meta:
            model = mymodel

    return BaseLinkForm

def getBaseLinkAdmin(mymodel):
    class BaseLinkAdmin(getBaseAdmin(mymodel)):
        form = getBaseLinkForm(mymodel)
        fieldsets = (
                     DEFAULT_FIELDSETS['informacao'],
                     DEFAULT_FIELDSETS['publicacao'],
                     (None, {
                             'fields':(
                                       'titulo',
                                       'descricao',
                                       'url',
                                       'categoria'
                                       )
                             }),
                     )
        list_display = ('titulo', 'activo', 'aprovado_por', 'alterado', 'id',)
        list_filter = ('activo', )
        search_fields = ('titulo', 'id', )

    return BaseLinkAdmin

# Fim Amdin


