#coding: utf-8
from django.contrib import admin
from django.db import models
from django.utils.translation import ugettext_lazy as _
from django import forms

from peakitcms.models import Base, getBaseAdmin, DEFAULT_FIELDSETS, BaseForm

from inline_ordering.admin import OrderableStackedInline
from inline_ordering.models import Orderable
from elfinder.hooks.ElfinderImageField import ElfinderImageWidget

# Models
def getBaseFotogaleria(baseseccao, noticia_seccao, basemultimedia, noticia_noticia):
    class BaseFotogaleria(Base):
        titulo = models.CharField(max_length=255)
        resumo = models.TextField(null=True, blank=True)
        aceitar_comentarios = models.IntegerField(choices=((1,u'Não'),(2,u'Sim'),(3,u'Sim Automáticos')), default=1)

        seccoes = models.ManyToManyField(baseseccao, through=noticia_seccao, related_name='%(app_label)s_%(class)s_fotogaleria_seccao', null=True, blank=True)
        seccoes.arvore_filter = True
        relacoes = models.ManyToManyField(basemultimedia, through=noticia_noticia, related_name='%(app_label)s_%(class)s_fotogaleria_relacao', null=True, blank=True)

        class Meta:
            abstract = True
            verbose_name = u'fotogaleria'
            verbose_name_plural = u'fotogalerias'

        def __unicode__(self):
            return self.titulo

        def getList(self):
            return self.__class__.objects.only('titulo', 'aprovado_por', 'alterado' ,'id').extra(select={'tipo_conteudo':'\'fotogaleria\''})
    return BaseFotogaleria

def getBaseFotogaleriaImagem(basefotogaleria):
    class BaseImagem(Orderable):
        fotogaleria = models.ForeignKey(basefotogaleria, verbose_name=_(u'conteúdo'), related_name='%(app_label)s_%(class)s_fotogaleria_imagem')
        imagem = models.CharField(_(u'nome'), max_length=255,)
        titulo = models.CharField(_(u'titulo'), max_length=255, blank=True, null=True)

        class Meta(Orderable.Meta):
            abstract = True
            verbose_name = _(u'imagem')
            verbose_name_plural = _(u'imagens')

        def __unicode__(self):
            return self.imagem
    return BaseImagem

def getBaseFotogaleriaNoticia(basefotogaleria, basenoticia):
    class BaseFotogaleriaNoticia(models.Model):
        fotogaleria = models.ForeignKey(basefotogaleria)
        noticia = models.ForeignKey(basenoticia)

        class Meta(Base.Meta):
            abstract = True
            verbose_name = _(u'notícia relacionadas')
            verbose_name_plural = _(u'notícias relacionadas')

        def save(self, *args, **kwargs):
            super(BaseFotogaleriaNoticia, self).save(*args, **kwargs)
            """
            self.noticia_rel.relations.through.objects.get_or_create(
                                                              noticia_id = self.noticia_rel.id,
                                                              noticia_rel_id = self.noticia.id
                                                              )
            """

        def delete(self):
            myid = self.noticia.id
            super(BaseFotogaleriaNoticia, self).delete()
            """
            try:
                d = self.noticia_rel.relations.through.objects.get(noticia__id=myid)
                d.delete()
            except:
                pass
            """

        def __unicode__(self):
            return self.noticia.titulo
    return BaseFotogaleriaNoticia

def getBaseFotogaleriaSeccao(basemultimedia, baseseccao):
    class BaseFotogaleriaSeccao(models.Model):
        noticia = models.ForeignKey(basemultimedia, verbose_name=_(u'múltimedia'), related_name='%(app_label)s_%(class)s_multimedia')
        seccao = models.ForeignKey(baseseccao, verbose_name=_(u'secção'), related_name='%(app_label)s_%(class)s_seccao')
        seccao_publicacao = models.IntegerField(_(u'secção de publicação'), choices=((1,u'Destaque Principal'),(2,u'Destaque Secundário')), null=True, blank=True)

        class Meta(Base.Meta):
            abstract = True
            verbose_name = _(u'secção')
            verbose_name_plural = _(u'secções')
            unique_together = (("noticia", "seccao"),)

        def __unicode__(self):
            return self.seccao.title
    return BaseFotogaleriaSeccao

def getBaseFotogaleriaRelacao(basefotogaleria1, basefotogaleria2):
    class BaseFotogaleriaRelacao(models.Model):
        fotogaleria = models.ForeignKey(basefotogaleria1, verbose_name=_(u'notícia'), related_name='%(app_label)s_%(class)s_noticia_ori', db_index=True)
        fotogaleria_rel = models.ForeignKey(basefotogaleria2, verbose_name=_(u'notícia'), related_name='%(app_label)s_%(class)s_noticia_rel', db_index=True)

        def save(self, *args, **kwargs):
            super(BaseFotogaleriaRelacao, self).save(*args, **kwargs)
            self.fotogaleria_rel.relations.through.objects.get_or_create(
                                                              fotogaleria_id = self.fotogaleria_rel.id,
                                                              fotogaleria_rel_id = self.fotogaleria.id
                                                              )

        def delete(self):
            myid = self.fotogaleria_rel.id
            super(BaseFotogaleriaRelacao, self).delete()
            try:
                d = self.fotogaleria_rel.relations.through.objects.get(fotogaleria__id=myid)
                d.delete()
            except:
                pass

        #def __unicode__(self):
        #    return self.fotogaleria_rel.titulo

        class Meta:
            abstract = True
            verbose_name = _(u'relacionado')
            verbose_name_plural = _(u'relacionados')
            unique_together = (("fotogaleria", "fotogaleria_rel"),)
    return BaseFotogaleriaRelacao

# Fim Models

# Admin

def getBaseFotogaleriaSeccaoInline(mymodel, seccao='seccao'):
    class BaseFotogaleriaSeccaoInline(admin.TabularInline):
        extra = 0
        model = mymodel
        raw_id_fields = ('seccao',)
    return BaseFotogaleriaSeccaoInline


def getBaseNoticiaInline(mymodel):
    class BaseNoticiaInline(admin.TabularInline):
        extra = 0
        model = mymodel
        raw_id_fields = ('noticia',)
    return BaseNoticiaInline

def getBaseImagemInline(mymodel):
    class BaseImagemInline(OrderableStackedInline):
        model = mymodel
        extra=0

        def formfield_for_dbfield(self, db_field, **kwargs):
            x = super(BaseImagemInline,self).formfield_for_dbfield(db_field,**kwargs)
            if x is not None and db_field.name == 'imagem':
                x.widget = ElfinderImageWidget()
            return x

        class Media:
            js = ('admin/js/jquery-ui.min.js', 'inline_ordering.js', 'js/elfinder_inlines.js')
    return BaseImagemInline

def getBaseFotogaleriaForm(mymodel):
    class BaseFotogaleriaForm(BaseForm):
        class Meta:
            model = mymodel
            widgets = {
                'fs': forms.widgets.HiddenInput,
                'imagem': ElfinderImageWidget(),
            }
    return BaseFotogaleriaForm

def getBaseFotogaleriaAdmin(mymodel):
    class BaseFotogaleriaAdmin(getBaseAdmin(mymodel)):
        form =  getBaseFotogaleriaForm(mymodel)
        fieldsets = (
                     DEFAULT_FIELDSETS['informacao'],
                     DEFAULT_FIELDSETS['publicacao'],
                     (None, {
                                         'fields':(
                                                   ('aceitar_comentarios', 'fs'),
                                                   )
                                         }),
                     (None, {
                             'fields':(
                                       'titulo',
                                       'resumo',
                                       )
                             }),
                     )
        list_display = ('titulo', 'activo', 'aprovado_por', 'alterado', 'id',)
        list_filter = ('activo', )
        search_fields = ('titulo', 'resumo', 'id', )

    return BaseFotogaleriaAdmin
# Fim Admin
