#coding: utf-8
from django.contrib import admin
from django.db import models
from django.utils.translation import ugettext_lazy as _
from django import forms

from peakitcms.models import Base, getBaseAdmin, DEFAULT_FIELDSETS, BaseForm

from elfinder.hooks.ElfinderImageField import ElfinderImageWidget
from datetime import datetime

# Models
def getBaseComentario(fkmodel):
    #class BaseComentario(Base):
    class BaseComentario(models.Model):
        activo = models.BooleanField(_(u'publicado'), default=False)
        fk = models.ForeignKey(fkmodel, verbose_name='conteúdo', related_name='%(app_label)s_%(class)s_comentario')
        nome = models.CharField(u'nome', max_length=255)
        email = models.CharField(u'email', max_length=255)
        mensagem = models.TextField(u'mensagem')
        criado = models.DateTimeField(default=datetime.now,null=True,blank=True)
        
        #class Meta(Base.Meta):
        class Meta:
            abstract = True
            verbose_name = u'comentário'
            verbose_name_plural = u'comentários'
        
        def __unicode__(self):
            return ''
            #return str(self.fk) +str(' - ')+ str(self.nome)
        
    return BaseComentario
# Fim Models

# Admin
def getBaseComentarioForm(mymodel):
    #class BaseComentarioForm(BaseForm):
    class BaseComentarioForm(forms.ModelForm):
        class Meta:
            model = mymodel
            
    return BaseComentarioForm

def getBaseComentarioAdmin(mymodel):
    #class BaseComentarioAdmin(getBaseAdmin(mymodel)):
    class BaseComentarioAdmin(admin.ModelAdmin):
        form = getBaseComentarioForm(mymodel)
        fieldsets = (
                     (None, {
                             'fields':(
                                       ('activo'),
                                       ('fk'),
                                       ('nome'),
                                       ('email'),
                                       ('mensagem'),
                                       #('criado'),
                                       )
                             }),
                     )
        
        list_display = ('fk', 'nome', 'activo', 'criado',)
        list_filter = ('activo', )
        search_fields = ('nome', )
        
    return BaseComentarioAdmin
# Fim Amdin


