#coding: utf-8
from django.contrib import admin
from django.db import models
from django.utils.translation import ugettext_lazy as _
from django import forms

from peakitcms.models import Base, getBaseAdmin, DEFAULT_FIELDSETS, BaseForm

from elfinder.hooks.ElfinderImageField import ElfinderImageWidget

# Models
def getBaseAudio():
    class BaseAudio(Base):
        titulo = models.CharField(max_length=255)
        ficheiro = models.CharField(max_length=255)

        class Meta(Base.Meta):
            abstract = True
            verbose_name = u'audio'
            verbose_name_plural = u'audios'

        def __unicode__(self):
            return self.titulo
    return BaseAudio
# Fim Models

# Admin
def getBaseAudioForm(mymodel):
    class BaseAudioForm(BaseForm):
        class Meta:
            model = mymodel
            widgets = {
                'fs': forms.widgets.HiddenInput,
                'ficheiro': ElfinderImageWidget(attrs={'a':'a'}),
            }
    return BaseAudioForm

def getBaseAudioAdmin(mymodel):
    class BaseAudioAdmin(getBaseAdmin(mymodel)):
        form = getBaseAudioForm(mymodel)
        fieldsets = (
                     DEFAULT_FIELDSETS['informacao'],
                     DEFAULT_FIELDSETS['publicacao'],
                     (None, {
                             'fields':(
                                       'titulo',
                                       ('ficheiro', 'fs'),
                                       )
                             }),
                     )
        list_display = ('titulo', 'activo', 'aprovado_por', 'alterado', 'id',)
        list_filter = ('activo', )
        search_fields = ('titulo', 'id', )

    return BaseAudioAdmin
# Fim Amdin
