#coding: utf-8
from django.contrib import admin
from django.db import models
from django.utils.translation import ugettext_lazy as _
from django import forms

# Models
def getBaseAtributo(**kw):
    scope = ( (1, u'Website'), (2, u'Global'))
    
    if 'scope' in kw:
        scope = kw['scope']
    
    class BaseAtributo(models.Model):
        codigo = models.SlugField(_(u'Código'), max_length=30, unique=True, help_text=_(u'Para uso interno. Tem de ser unico sem espaços. Tem um tamanho máximo de 30 caracteres.'))
        titulo = models.CharField(_(u'Título'), max_length=255)
        scope = models.IntegerField(_(u'Scope'), choices=( (1, u'Loja'), (2, u'Website'), (3, u'Global')))
        tipo_atributo = models.IntegerField(_(u'Tipo'), choices=(
                                                     (1, u'TextField'),
                                                     (2, u'TextArea'),
                                                     (3, u'Data'),
                                                     (4, u'Sim/Não'),
                                                     (5, u'Select Multiplo'),
                                                     (6, u'Select'),
                                                     (7, u'Preço'),
                                                     (8, u'Imagem'),
                                                     (9, u'Taxa fixa de produto'),
                                                     (10, u'Email'),
                                                     ))
        valor_defeito = models.CharField(_(u'Valor por defeito'), max_length=255, null=True, blank=True)
        valor_unico = models.BooleanField(_(u'Valor unico'), default=False, help_text=_(u'Não partilhado com outros produtos.'))
        valores_obrigatorios = models.BooleanField(_(u'Valores obrigatórios'), default=False)
        aplica_se_a = models.IntegerField(_(u'Aplica-se a'), choices=(
                                                   (1, u'Todos os tipos'),
                                                   (2, u'Apenas a tipos seleccionados'),
                                                   ), default=1, null=True, blank=True)
        
        pesquisa_rapida = models.BooleanField(_(u'Pesquisa rápida'), default=False)
        pesquisa_avancada = models.BooleanField(_(u'Pesquisa avançada'), default=False)
        comparavel_frontend = models.BooleanField(_(u'Comparável no frontend'), default=False)
        navegacao_camadas = models.IntegerField(_(u'Usado na navegação em camadas'), choices=(
                                                             (1, u'Não'),
                                                             (2, u'Filtrar (com resultados)'),
                                                             (3, u'Filtrar (sem resultados)'),
                                                             ), default=1, null=True, blank=True, help_text=_(u'Apenas pode ser usado com os tipos: Select, Select Multiplo e Preço.'))
        resultados_navegacao_camadas = models.BooleanField(_(u'Usado nos resultados da navegação em camadas'), help_text=_(u'Apenas pode ser usado com os tipos: Select, Select Multiplo e Preço.'), default=False)
        condicoes_promocao = models.BooleanField(_(u'Usar para regras de promoções'), default=False)
        posicao = models.IntegerField(_(u'Posição'), null=True, blank=True)
        activo_wysiwyg = models.BooleanField(_(u'Activo WYSIWYG'), default=False)
        permite_html_frontend = models.BooleanField(_(u'Permite tags HTML no frontend'), default=True)
        visivel_pagina_frontend = models.BooleanField(_(u'Visível na página de detalhes no frontend'), default=False)
        usado_listagem = models.BooleanField(_(u'Usado na listagem'), default=False)
        usado_para_ordenacao_frontend = models.BooleanField(_(u'Usado para ordenação na listagem'), default=False)
        
        sistema = models.BooleanField(default=False)
        
        def __unicode__(self):
            return self.titulo
        
        class Meta:
            abstract = True
    return BaseAtributo

def getBaseAtributoSetAtributo(**kw):
    if 'atributo_set' in kw:
        atributo_set = kw['atributo_set']
    else:
        raise Exception(u'atributo_set é obrigatório')
    
    if 'atributo' in kw:
        atributo = kw['atributo']
    else:
        raise Exception(u'atributo é obrigatório')
    
    class BaseAtributoSetAtributo(models.Model):
        atributo_set = models.ForeignKey(atributo_set)
        atributo = models.ForeignKey(atributo)
        
        class Meta:
            unique_together = ('atributo_set', 'atributo')
            abstract = True
    return BaseAtributoSetAtributo

def getBaseAtributoSet(**kw):
    atributos, through = None, None
    print kw
    if 'atributos' in kw:
        cls_atributos = kw['atributos']
    else:
        raise Exception(u'atributos é obrigatório')
    
    if 'through' in kw:
        through = kw['through']
    else:
        raise Exception(u'through é obrigatório')
    
    class BaseAtributoSet(models.Model):
        titulo = models.CharField(_(u'Título'), max_length=255)
        atributos = models.ManyToManyField(cls_atributos, through=through)
        class Meta:
            abstract = True
    return BaseAtributoSet
# Fim Models

# Admin
def getBaseAtributoForm(mymodel):
    class BaseAtributoForm(forms.ModelForm):
        class Meta:
            model = mymodel
    return BaseAtributoForm

def getBaseAtributoAdmin(mymodel):
    class BaseAtributoAdmin(admin.ModelAdmin):
        form = getBaseAtributoForm(mymodel)
        fieldsets = (
                     (_(u'Propriedades'), {
                                           'fields': (
                                                      'codigo',
                                                      'titulo',
                                                      'scope',
                                                      'tipo_atributo',
                                                      'valor_defeito',
                                                      'valor_unico',
                                                      'valores_obrigatorios',
                                                      'aplica_se_a',
                                                      )
                                           }),
                     (_(u'Frontend'), {
                                           'fields': (
                                                      'pesquisa_rapida',
                                                      'pesquisa_avancada',
                                                      'comparavel_frontend',
                                                      'navegacao_camadas',
                                                      'resultados_navegacao_camadas',
                                                      'condicoes_promocao',
                                                      'posicao',
                                                      'activo_wysiwyg',
                                                      'permite_html_frontend',
                                                      'visivel_pagina_frontend',
                                                      'usado_listagem',
                                                      'usado_para_ordenacao_frontend',
                                                      )
                                           }),
                     )
    return BaseAtributoAdmin
# Fim Admin