#coding: utf-8
from django.contrib import admin
from django.db import models
from django.utils.translation import ugettext_lazy as _
from django import forms

from peakitcms.models import Base, getBaseAdmin, DEFAULT_FIELDSETS, BaseForm

from inline_ordering.admin import OrderableStackedInline
from inline_ordering.models import Orderable
from elfinder.hooks.ElfinderImageField import ElfinderImageWidget

# Models
def getBaseAgendaEntidade():
    class BaseAgendaEntidade(Base):
        titulo = models.CharField(max_length=255)

        class Meta:
            abstract = True
            verbose_name = u'agenda entidade'
            verbose_name_plural = u'agenda entidades'

        def __unicode__(self):
            return self.titulo

    return BaseAgendaEntidade
# Fim Models

# Admin
def getBaseAgendaEntidadeForm(mymodel):
    class BaseAgendaEntidadeForm(BaseForm):
        class Meta:
            model = mymodel

    return BaseAgendaEntidadeForm

def getBaseAgendaEntidadeAdmin(mymodel):
    class BaseAgendaEntidadeAdmin(getBaseAdmin(mymodel)):
        form =  getBaseAgendaEntidadeForm(mymodel)
        fieldsets = (
                     DEFAULT_FIELDSETS['informacao'],
                     DEFAULT_FIELDSETS['publicacao'],
                     (None, {
                             'fields':(
                                       'titulo',
                                       )
                             }),
                     )
        list_display = ('titulo', 'activo', 'aprovado_por', 'alterado', 'id',)
        list_filter = ('activo', )
        search_fields = ('titulo', 'resumo', 'id', )

    return BaseAgendaEntidadeAdmin
# Fim Admin
