# -*- coding: utf-8 *-*
from django.conf import settings
#from celery.decorators import task
from celery.decorators import periodic_task
from celery.task.schedules import crontab


from newsletter.models import Newsletter


@periodic_task(run_every=crontab(
    minute="*/" + getattr(settings, 'NEWSLETTER_QUEUE_EVERY', '1')))
def add_queue():
    n = Newsletter()
    n.handler('add_queue')
    pass


@periodic_task(run_every=crontab(
    minute="*/" + getattr(settings, 'NEWSLETTER_DISPATCH_EVERY', '1')))
def dispatch_queue():
    n = Newsletter()
    n.handler('dispatch_queue')
    pass
