# -*- coding: utf-8 -*-
import datetime
from south.db import db
from south.v2 import SchemaMigration
from django.db import models


class Migration(SchemaMigration):

    def forwards(self, orm):
        # Adding field 'Group.website'
        db.add_column('newsletter_group', 'website',
                      self.gf('django.db.models.fields.related.ForeignKey')(default=1, to=orm['website.WebSite']),
                      keep_default=False)

        # Deleting field 'UserGroup.ref'
        db.delete_column('newsletter_usergroup', 'ref')

        # Adding field 'Newsletter.website'
        db.add_column('newsletter_newsletter', 'website',
                      self.gf('django.db.models.fields.related.ForeignKey')(default=1, to=orm['website.WebSite']),
                      keep_default=False)


    def backwards(self, orm):
        # Deleting field 'Group.website'
        db.delete_column('newsletter_group', 'website_id')

        # Adding field 'UserGroup.ref'
        db.add_column('newsletter_usergroup', 'ref',
                      self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True),
                      keep_default=False)

        # Deleting field 'Newsletter.website'
        db.delete_column('newsletter_newsletter', 'website_id')


    models = {
        'auth.group': {
            'Meta': {'object_name': 'Group'},
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'unique': 'True', 'max_length': '80'}),
            'permissions': ('django.db.models.fields.related.ManyToManyField', [], {'to': "orm['auth.Permission']", 'symmetrical': 'False', 'blank': 'True'})
        },
        'auth.permission': {
            'Meta': {'ordering': "('content_type__app_label', 'content_type__model', 'codename')", 'unique_together': "(('content_type', 'codename'),)", 'object_name': 'Permission'},
            'codename': ('django.db.models.fields.CharField', [], {'max_length': '100'}),
            'content_type': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['contenttypes.ContentType']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '50'})
        },
        'auth.user': {
            'Meta': {'object_name': 'User'},
            'date_joined': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now'}),
            'email': ('django.db.models.fields.EmailField', [], {'max_length': '75', 'blank': 'True'}),
            'first_name': ('django.db.models.fields.CharField', [], {'max_length': '30', 'blank': 'True'}),
            'groups': ('django.db.models.fields.related.ManyToManyField', [], {'to': "orm['auth.Group']", 'symmetrical': 'False', 'blank': 'True'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'is_active': ('django.db.models.fields.BooleanField', [], {'default': 'True'}),
            'is_staff': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'is_superuser': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'last_login': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now'}),
            'last_name': ('django.db.models.fields.CharField', [], {'max_length': '30', 'blank': 'True'}),
            'password': ('django.db.models.fields.CharField', [], {'max_length': '128'}),
            'user_permissions': ('django.db.models.fields.related.ManyToManyField', [], {'to': "orm['auth.Permission']", 'symmetrical': 'False', 'blank': 'True'}),
            'username': ('django.db.models.fields.CharField', [], {'unique': 'True', 'max_length': '30'})
        },
        'contenttypes.contenttype': {
            'Meta': {'ordering': "('name',)", 'unique_together': "(('app_label', 'model'),)", 'object_name': 'ContentType', 'db_table': "'django_content_type'"},
            'app_label': ('django.db.models.fields.CharField', [], {'max_length': '100'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'model': ('django.db.models.fields.CharField', [], {'max_length': '100'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '100'})
        },
        'conteudos.noticia': {
            'Meta': {'object_name': 'Noticia'},
            'aceitar_comentarios': ('django.db.models.fields.IntegerField', [], {'default': '1'}),
            'activo': ('django.db.models.fields.BooleanField', [], {'default': 'True'}),
            'alterado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'alterado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'conteudos_noticia_alterado_por'", 'to': "orm['auth.User']"}),
            'ante_titulo': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'aprovado': ('django.db.models.fields.DateTimeField', [], {'null': 'True', 'blank': 'True'}),
            'aprovado_por': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'conteudos_noticia_aprovado_por'", 'null': 'True', 'to': "orm['auth.User']"}),
            'autor': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'autor_capa': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'autor_capa_local': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'capa': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'criado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'criado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'conteudos_noticia_criado_por'", 'to': "orm['auth.User']"}),
            'equipa': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'conteudos_noticia_equipa'", 'null': 'True', 'to': "orm['auth.User']"}),
            'foto1': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'foto2': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'fs': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'conteudos_noticia_file_collection'", 'null': 'True', 'to': "orm['elfinder.FileCollection']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'local': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'noticia': ('django.db.models.fields.TextField', [], {}),
            'pos_titulo': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'publicada_fim': ('django.db.models.fields.DateTimeField', [], {'db_index': 'True', 'null': 'True', 'blank': 'True'}),
            'publicada_inicio': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'db_index': 'True', 'blank': 'True'}),
            'relacoes': ('django.db.models.fields.related.ManyToManyField', [], {'related_name': "'conteudos_noticia_noticia_relacao'", 'to': "orm['conteudos.Noticia']", 'through': "orm['conteudos.NoticiaRelacao']", 'blank': 'True', 'symmetrical': 'False', 'null': 'True'}),
            'restrito': ('django.db.models.fields.BooleanField', [], {'default': 'True'}),
            'resumo': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'seccoes': ('django.db.models.fields.related.ManyToManyField', [], {'related_name': "'conteudos_noticia_noticia_seccao'", 'to': "orm['conteudos.Seccao']", 'through': "orm['conteudos.NoticiaSeccao']", 'blank': 'True', 'symmetrical': 'False', 'null': 'True'}),
            'titulo': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'website': ('django.db.models.fields.related.ForeignKey', [], {'default': '1', 'related_name': "'conteudos_noticia_website'", 'to': "orm['website.WebSite']"})
        },
        'conteudos.noticiarelacao': {
            'Meta': {'unique_together': "(('noticia', 'noticia_rel'),)", 'object_name': 'NoticiaRelacao'},
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'noticia': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'conteudos_noticiarelacao_noticia_ori'", 'to': "orm['conteudos.Noticia']"}),
            'noticia_rel': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'conteudos_noticiarelacao_noticia_rel'", 'to': "orm['conteudos.Noticia']"})
        },
        'conteudos.noticiaseccao': {
            'Meta': {'unique_together': "(('noticia', 'seccao'),)", 'object_name': 'NoticiaSeccao'},
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'noticia': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'conteudos_noticiaseccao_noticia'", 'to': "orm['conteudos.Noticia']"}),
            'seccao': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'conteudos_noticiaseccao_seccao'", 'to': "orm['conteudos.Seccao']"}),
            'seccao_publicacao': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'})
        },
        'conteudos.seccao': {
            'Meta': {'object_name': 'Seccao'},
            'activo': ('django.db.models.fields.BooleanField', [], {'default': 'True'}),
            'alterado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'alterado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'conteudos_seccao_alterado_por'", 'to': "orm['auth.User']"}),
            'criado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'criado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'conteudos_seccao_criado_por'", 'to': "orm['auth.User']"}),
            'descricao': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'fs': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'conteudos_seccao_file_collection'", 'null': 'True', 'to': "orm['elfinder.FileCollection']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'level': ('django.db.models.fields.PositiveIntegerField', [], {'db_index': 'True'}),
            'lft': ('django.db.models.fields.PositiveIntegerField', [], {'db_index': 'True'}),
            'parent': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'conteudos_seccao_parent'", 'null': 'True', 'to': "orm['conteudos.Seccao']"}),
            'rght': ('django.db.models.fields.PositiveIntegerField', [], {'db_index': 'True'}),
            'title': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'tree_id': ('django.db.models.fields.PositiveIntegerField', [], {'db_index': 'True'}),
            'website': ('django.db.models.fields.related.ForeignKey', [], {'default': '1', 'related_name': "'conteudos_seccao_website'", 'to': "orm['website.WebSite']"})
        },
        'diocese.arciprestado': {
            'Meta': {'ordering': "['arciprestado']", 'object_name': 'Arciprestado'},
            'activo': ('django.db.models.fields.BooleanField', [], {'default': 'True'}),
            'alterado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'alterado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_arciprestado_alterado_por'", 'to': "orm['auth.User']"}),
            'arciprestado': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'arcipreste': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'arcipreste_adjunto': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'codigo_ecclesia': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'criado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'criado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_arciprestado_criado_por'", 'to': "orm['auth.User']"}),
            'fs': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'diocese_arciprestado_file_collection'", 'null': 'True', 'to': "orm['elfinder.FileCollection']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'logo': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'presbitero_arcipreste': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'diocese_arciprestado_presbitero_arcipreste'", 'null': 'True', 'to': "orm['diocese.Presbitero']"}),
            'presbitero_arcipreste_adjunto': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'diocese_arciprestado_presbitero_arcipreste_adjunto'", 'null': 'True', 'to': "orm['diocese.Presbitero']"})
        },
        'diocese.presbitero': {
            'Meta': {'ordering': "['nome']", 'object_name': 'Presbitero'},
            'activo': ('django.db.models.fields.BooleanField', [], {'default': 'True'}),
            'alterado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'alterado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_presbitero_alterado_por'", 'to': "orm['auth.User']"}),
            'arcipreste': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'capelao': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'cartao_sacerdotal': ('django.db.models.fields.IntegerField', [], {'max_length': '2', 'null': 'True', 'blank': 'True'}),
            'clero_tipo': ('django.db.models.fields.PositiveIntegerField', [], {'default': '1', 'max_length': '1'}),
            'codigo_ecclesia': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'codigo_postal': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'criado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'criado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_presbitero_criado_por'", 'to': "orm['auth.User']"}),
            'data_faleceu': ('django.db.models.fields.DateField', [], {'null': 'True', 'blank': 'True'}),
            'data_nascimento': ('django.db.models.fields.DateField', [], {'null': 'True', 'blank': 'True'}),
            'data_ordenacoa': ('django.db.models.fields.DateField', [], {'null': 'True', 'blank': 'True'}),
            'email': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'faleceu': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'fax': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'formacao_permanente': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'foto': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'fraternidade_sacerdotal': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'fs': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'diocese_presbitero_file_collection'", 'null': 'True', 'to': "orm['elfinder.FileCollection']"}),
            'habilitacoes_academicas': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'igreja': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'local_nascimento': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'local_ordenacao': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'localidade': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'morada': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'nome': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'nomeacoes': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'nomeacoes_actuais': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'obs': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'paginaweb': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'paroco': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'publicacoes': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'reitor': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'serv_pastoral': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'telefone': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'telemovel': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'telemovel_privado': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'tipo_clero': ('django.db.models.fields.PositiveIntegerField', [], {'max_length': '1', 'null': 'True', 'blank': 'True'}),
            'vice_arcipreste': ('django.db.models.fields.BooleanField', [], {'default': 'False'})
        },
        'elfinder.filecollection': {
            'Meta': {'object_name': 'FileCollection'},
            'dir': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'url': ('django.db.models.fields.CharField', [], {'max_length': '255'})
        },
        'newsletter.group': {
            'Meta': {'object_name': 'Group'},
            'active': ('django.db.models.fields.BooleanField', [], {'default': 'True'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'ref': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'title': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'website': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['website.WebSite']"})
        },
        'newsletter.newsletter': {
            'Meta': {'object_name': 'Newsletter'},
            'active': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'body': ('django.db.models.fields.TextField', [], {}),
            'groups': ('django.db.models.fields.related.ManyToManyField', [], {'related_name': "'newsletter_groups'", 'to': "orm['newsletter.Group']", 'through': "orm['newsletter.NewsletterGroup']", 'blank': 'True', 'symmetrical': 'False', 'null': 'True'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'last_sended': ('django.db.models.fields.DateTimeField', [], {'db_index': 'True', 'null': 'True', 'blank': 'True'}),
            'ntype': ('django.db.models.fields.IntegerField', [], {'default': '1'}),
            'ref': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'sections': ('django.db.models.fields.related.ManyToManyField', [], {'related_name': "'newsletter_sections'", 'to': "orm['conteudos.Seccao']", 'through': "orm['newsletter.NewsletterSection']", 'blank': 'True', 'symmetrical': 'False', 'null': 'True'}),
            'send_news': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'send_news_number': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'send_pdf_destaque': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'start_date': ('django.db.models.fields.DateTimeField', [], {'db_index': 'True', 'null': 'True', 'blank': 'True'}),
            'subject': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'title': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'website': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['website.WebSite']"})
        },
        'newsletter.newslettergroup': {
            'Meta': {'unique_together': "(('newsletter', 'group'),)", 'object_name': 'NewsletterGroup'},
            'group': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'newslettergroup_group'", 'to': "orm['newsletter.Group']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'newsletter': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'newslettergroup_newsletter'", 'to': "orm['newsletter.Newsletter']"})
        },
        'newsletter.newsletternew': {
            'Meta': {'ordering': "('inline_ordering_position',)", 'object_name': 'NewsletterNew'},
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'inline_ordering_position': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'news': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'newsletternew_news'", 'to': "orm['conteudos.Noticia']"}),
            'newsletter': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'newsletternew_newsletter'", 'to': "orm['newsletter.Newsletter']"}),
            'tag': ('django.db.models.fields.CharField', [], {'max_length': '255'})
        },
        'newsletter.newslettersection': {
            'Meta': {'unique_together': "(('newsletter', 'section'),)", 'object_name': 'NewsletterSection'},
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'newsletter': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'newslettersection_newsletter'", 'to': "orm['newsletter.Newsletter']"}),
            'section': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'newslettersection_section'", 'to': "orm['conteudos.Seccao']"})
        },
        'newsletter.newslettertemplate': {
            'Meta': {'object_name': 'NewsletterTemplate'},
            'activo': ('django.db.models.fields.BooleanField', [], {'default': 'True'}),
            'alterado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'alterado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'newsletter_newslettertemplate_alterado_por'", 'to': "orm['auth.User']"}),
            'aprovado': ('django.db.models.fields.DateTimeField', [], {'null': 'True', 'blank': 'True'}),
            'aprovado_por': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'newsletter_newslettertemplate_aprovado_por'", 'null': 'True', 'to': "orm['auth.User']"}),
            'criado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'criado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'newsletter_newslettertemplate_criado_por'", 'to': "orm['auth.User']"}),
            'fs': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'newsletter_newslettertemplate_file_collection'", 'null': 'True', 'to': "orm['elfinder.FileCollection']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'publicada_fim': ('django.db.models.fields.DateTimeField', [], {'db_index': 'True', 'null': 'True', 'blank': 'True'}),
            'publicada_inicio': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'db_index': 'True', 'blank': 'True'}),
            'ref': ('django.db.models.fields.CharField', [], {'db_index': 'True', 'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'template': ('django.db.models.fields.TextField', [], {}),
            'titulo': ('django.db.models.fields.CharField', [], {'max_length': '80'})
        },
        'newsletter.newslettertemplatetag': {
            'Meta': {'unique_together': "(('template', 'tag'),)", 'object_name': 'NewsletterTemplateTag'},
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'tag': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'template': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['newsletter.NewsletterTemplate']"})
        },
        'newsletter.newsletteruser': {
            'Meta': {'unique_together': "(('newsletter', 'user'),)", 'object_name': 'NewsletterUser'},
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'newsletter': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'newsletteruser_newsletter'", 'to': "orm['newsletter.Newsletter']"}),
            'user': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'newslettergroup_user'", 'to': "orm['newsletter.User']"})
        },
        'newsletter.quee': {
            'Meta': {'object_name': 'Quee'},
            'body': ('django.db.models.fields.TextField', [], {}),
            'data': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime(2012, 10, 16, 0, 0)'}),
            'from_mail': ('django.db.models.fields.EmailField', [], {'max_length': '75'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'subject': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'to_mail': ('django.db.models.fields.EmailField', [], {'max_length': '75'}),
            'trys': ('django.db.models.fields.IntegerField', [], {'default': '0'})
        },
        'newsletter.user': {
            'Meta': {'unique_together': "(('website', 'email'),)", 'object_name': 'User'},
            'aprove_key': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'aproved': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'email': ('django.db.models.fields.EmailField', [], {'unique': 'True', 'max_length': '75'}),
            'groups': ('django.db.models.fields.related.ManyToManyField', [], {'related_name': "'user_groups'", 'to': "orm['newsletter.Group']", 'through': "orm['newsletter.UserGroup']", 'blank': 'True', 'symmetrical': 'False', 'null': 'True'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'website': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['website.WebSite']"})
        },
        'newsletter.usergroup': {
            'Meta': {'unique_together': "(('user', 'group'),)", 'object_name': 'UserGroup'},
            'group': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'usergroup_group'", 'to': "orm['newsletter.Group']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'user': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'usergroup_user'", 'to': "orm['newsletter.User']"})
        },
        'website.website': {
            'Meta': {'object_name': 'WebSite'},
            'activo': ('django.db.models.fields.BooleanField', [], {'default': 'True'}),
            'arciprestado': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'websites_websites_arciprestado'", 'null': 'True', 'to': "orm['diocese.Arciprestado']"}),
            'email': ('django.db.models.fields.EmailField', [], {'max_length': '75'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'titulo': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'url': ('django.db.models.fields.URLField', [], {'max_length': '200'}),
            'users': ('django.db.models.fields.related.ManyToManyField', [], {'blank': 'True', 'related_name': "'websites_websites_users'", 'null': 'True', 'symmetrical': 'False', 'to': "orm['auth.User']"})
        }
    }

    complete_apps = ['newsletter']