# -*- coding: utf-8 *-*
from django.conf import settings
from newsletter.models import Newsletter
import os
import sys
from datetime import datetime, timedelta


class PIDControler(object):
	pid = str(os.getpid())

	def __init__(self, f):
		self.pidfile = '%(PID_PATH)s/%(MY_APP)s_newsletter_%(pidfile)s.pid' % {
									'PID_PATH': getattr(settings, 'PATH', '/') + 'tmp/',
									'pidfile': f,
									'MY_APP': getattr(settings, 'MY_APP', 'peakit')
								}

	def is_runing(self):
		if os.path.isfile(self.pidfile): #O pid existe?
			agora = datetime.now()
			then = datetime.fromtimestamp(os.path.getmtime(self.pidfile))
			if (agora - then) > timedelta (minutes = getattr(settings, 'PID_LIFETIME', 1)): #O pid existe a x tempo?
				with file(self.pidfile, 'a'):
					os.utime(self.pidfile, None)
				return False
			return True
		else:
			file(self.pidfile, 'w').write(self.pid)
		return False

	def clear(self):
		try:
			os.unlink(self.pidfile)
		except:
			pass

def add_queue():
	pid = PIDControler('add_queue')
	if not pid.is_runing():
	    n = Newsletter()
	    n.handler('add_queue')
    	pid.clear()


def dispatch_queue():
	pid = PIDControler('dispatch_queue')
	if not pid.is_runing():
		n = Newsletter()
		n.handler('dispatch_queue')
		pid.clear()
