#coding: utf-8
from django.conf import settings as django_settings

if not hasattr(django_settings, 'SIM4_CONN'):
    raise Exception('SIM4_CONN não existe no ficheiro de settings.py\nExemplo:\n\tSIM4_CONN = "dbname=\'db_name\' user=\'db_user\' host=\'db_host\' password=\'db_password\'"')
    pass
else:

    from website import models as websiteModels

    from django.contrib.auth.models import User

    class ImporWebsite(object):

        def __init__(self, conn, cur):
            self.conn = conn
            self.cur = cur
            #self.User = User.objects.get(pk=101)

        def importar(self):
            self.cur.execute('SELECT * FROM grupos')
            for row in self.cur:
                linha = self.getLinha(row)

                try:
                    obj = websiteModels.WebSite.objects.create(
                                                        id = linha['id'],
                                                        activo =  linha['activo'],
                                                        titulo =  linha['titulo'],
                                                        )
                    ImportUserWebsite(obj, self.conn, self.conn.cursor()).importar()
                except Exception, e:
                    print e
                    pass

        def getLinha(self, row):
            #print row
            return {
                    'id': row[0],
                    'activo': 1,
                    'titulo': row[1],
                    }


    class ImportUserWebsite(object):

        def __init__(self, obj, conn, cur):
            self.obj = obj
            self.conn = conn
            self.cur = cur
            #self.User = User.objects.get(pk=101)

        def importar(self):
            self.cur.execute('SELECT * FROM grupos_utilizadores WHERE cod_grupo=%s' % self.obj.id)
            mylist=[]
            for row in self.cur:
                linha = self.getLinha(row)

                try:
                    mylist.append(linha['cod_utilizador'],);
                except Exception, e:
                    print e
                    pass

            self.obj.users=User.objects.filter(pk__in=mylist)
            self.obj.save()

        def getLinha(self, row):
            #print row
            return {
                    'cod_utilizador': row[0],
                    'cod_grupo': row[1],
                    'defeito': row[2],
                    'timestamp': row[3],
                    }


    print 'BEGIN'

    import MySQLdb as mdb
    import sys

    con = None

    try:

        con = mdb.connect(django_settings.SIM4_CONN[0],django_settings.SIM4_CONN[1],django_settings.SIM4_CONN[2],django_settings.SIM4_CONN[3],charset="utf8");

        #con.set_character_set('utf8')

        cur = con.cursor()
        """
        cur.execute('SET NAMES utf8;')
        cur.execute('SET CHARACTER SET utf8;')
        cur.execute('SET character_set_connection=utf8;')
        """
        """
        cur.execute("SELECT VERSION()")

        data = cur.fetchone()

        print "Database version : %s " % data
        """
        ImporWebsite(con, cur).importar()


    except mdb.Error, e:

        print "Error %d: %s" % (e.args[0],e.args[1])
        sys.exit(1)

    finally:

        if con:
            con.close()

    print 'END'









