#coding: utf-8
from django.conf import settings as django_settings

if not hasattr(django_settings, 'SIM4_CONN'):
    raise Exception('SIM4_CONN não existe no ficheiro de settings.py\nExemplo:\n\tSIM4_CONN = "dbname=\'db_name\' user=\'db_user\' host=\'db_host\' password=\'db_password\'"')
    pass
else:

    from newsletter import models as conteudoModels
    from django.contrib.auth.models import User
    from datetime import datetime

    from website import models as modelsWebsite

    def get_fromtimestamp(val):
        if val is None:
            return None
        try:
            return datetime.fromtimestamp(val)
        except Exception, e:
            print e
            return None

    def get_strpdate(val):
        if val is None:
            return None
        try:
            return val
        except Exception, e:
            print e
            return None






    class ImportGrupo(object):

        def __init__(self, conn, cur):
            self.conn = conn
            self.cur = cur
            #self.User = User.objects.get(pk=101)

        def importar(self):
            #self.cur.execute('SELECT DISTINCT * FROM grupos_newsletter WHERE codigo in (SELECT cod_registo FROM grupos_registos WHERE cod_grupo=1 and tabela="grupos_newsletter")')
            self.cur.execute('SELECT DISTINCT * FROM grupos_newsletter')
            for row in self.cur:
                linha = self.getLinha(row)

                try:
                    conteudoModels.Group.objects.create(
                                                        id = linha['id'],
                                                        title = linha['title'],
                                                        website = modelsWebsite.WebSite.objects.get(pk=linha['website']),
                                                        )
                except Exception, e:
                    print e
                    pass

        def getLinha(self, row):
            #print row
            return {
                    'id': row[0],
                    'title': row[1],
                    'website': row[4],
                    }





    class ImportAssinanteGrupo(object):

        def __init__(self, obj, conn, cur):
            self.obj = obj
            self.conn = conn
            self.cur = cur
            #self.User = User.objects.get(pk=101)

        def importar(self):

            self.cur.execute('SELECT * FROM grupos_registos WHERE cod_grupo in (1, 2, 3, 34) AND tabela = "utilizadores_newsletter" AND cod_registo="'+str(self.obj.id)+'"')
            website = modelsWebsite.WebSite.objects.get(pk=1)
            for row in self.cur:
                linha = self.getLinha(row)
                try:

                    grupo = conteudoModels.Group.objects.get(pk=linha['group'], website=website)

                    self.obj.usergroup_user.create(
                                                        user = self.obj,
                                                        group = grupo,
                                                        )
                except Exception, e:
                    print e
                    pass

        def getLinha(self, row):
            #print row
            return {
                    'user': row[0],
                    'group': row[1],
                    }


    class ImportAssinanteWebsite(object):

        def __init__(self, obj, conn, cur):
            self.obj = obj
            self.conn = conn
            self.cur = cur
            #self.User = User.objects.get(pk=101)

        def importar(self):
            self.cur.execute('SELECT DISTINCT * FROM  grupos_registos WHERE tabela="utilizadores_newsletter" AND cod_registo=%s' % self.obj.id)
            mylist=[]
            for row in self.cur:
                linha = self.getLinha(row)

                try:
                    mylist.append(linha['cod_grupo'],);
                except Exception, e:
                    print e
                    pass

            if 1 in mylist:
                self.obj.website=modelsWebsite.WebSite.objects.get(pk=1)
            else:
                self.obj.website=modelsWebsite.WebSite.objects.get(pk=mylist[0])
            self.obj.save()

        def getLinha(self, row):
            #print row
            return {
                    'cod_registo': row[0],
                    'cod_grupo': row[1],
                    'tabela': row[2],
                    'timestamp': row[3],
                    }




    class ImportAssinante(object):

        def __init__(self, conn, cur):
            self.conn = conn
            self.cur = cur
            #self.User = User.objects.get(pk=101)

        def importar(self):
            self.cur.execute('SELECT DISTINCT * FROM utilizadores_newsletter WHERE codigo in (SELECT cod_registo FROM grupos_registos WHERE cod_grupo in (1, 2, 3, 34) and tabela="utilizadores_newsletter")' )
            for row in self.cur:
                linha = self.getLinha(row)
                try:
                    obj = conteudoModels.User.objects.create(
                                                        id = linha['id'],
                                                        email = linha['email'],
                                                        aproved = linha['aproved'],
                                                        aprove_key = linha['aprove_key'],
                                                        website = modelsWebsite.WebSite.objects.get(pk=linha['website']),
                                                        )
                    #ImportAssinanteWebsite(obj, self.conn, self.conn.cursor()).importar()
                    ImportAssinanteGrupo(obj, self.conn, self.conn.cursor()).importar()
                except Exception, e:
                    print e
                    pass

        def getLinha(self, row):
            #print row
            return {
                    'id': row[0],
                    'email': row[1],
                    'aproved': row[2],
                    'aprove_key': row[5],
                    'website': 1,
                    }



    print 'BEGIN'

    import MySQLdb as mdb
    import sys

    con = None

    try:

        con = mdb.connect(django_settings.SIM4_CONN[0],django_settings.SIM4_CONN[1],django_settings.SIM4_CONN[2],django_settings.SIM4_CONN[3],charset="utf8");

        #con.set_character_set('utf8')

        cur = con.cursor()
        """
        cur.execute('SET NAMES utf8;')
        cur.execute('SET CHARACTER SET utf8;')
        cur.execute('SET character_set_connection=utf8;')
        """
        """
        cur.execute("SELECT VERSION()")

        data = cur.fetchone()

        print "Database version : %s " % data
        """

        ImportGrupo(con, cur).importar()
        ImportAssinante(con, cur).importar()



    except mdb.Error, e:
        print "Error %d: %s" % (e.args[0], e.args[1])
        sys.exit(1)
    finally:
        if con:
            con.close()

    print 'END'


