#coding: utf-8
from django.conf import settings as django_settings

if not hasattr(django_settings, 'SIM4_CONN'):
    raise Exception('SIM4_CONN não existe no ficheiro de settings.py\nExemplo:\n\tSIM4_CONN = "dbname=\'db_name\' user=\'db_user\' host=\'db_host\' password=\'db_password\'"')
    pass
else:

    from horario import models as horarioModels
    from django.contrib.auth.models import User
    from datetime import datetime

    from website import models as modelsWebsite

    def get_fromtimestamp(val):
        if val is None:
            return None
        try:
            return datetime.fromtimestamp(val)
        except Exception, e:
            print e
            return None

    def get_strpdate(val):
        if val is None:
            return None
        try:
            return val
        except Exception, e:
            print e
            return None

    def get_datetimestamo(val):
        if val is None:
            return None
        try:
            return datetime.fromtimestamp(val)
        except Exception, e:
            print e
            return None

    def get_tipo(val):
        if val is None:
            return None
        try:
            return horarioModels.HorarioTipo.objects.get(pk=val)
        except Exception, e:
            print e
            return None


    def  get_local(val):
        if val is None:
            return None
        try:
            return horarioModels.HorarioLocal.objects.get(pk=val)
        except Exception, e:
            print e
            return None






    class ImportHorario(object):

        def __init__(self, conn, cur):
            self.conn = conn
            self.cur = cur
            self.User = User.objects.get(pk=101)

        def importar(self):
            #self.cur.execute('SELECT DISTINCT * FROM horarios WHERE codigo in (SELECT cod_registo FROM grupos_registos WHERE cod_grupo!=1 and tabela="horarios")')
            self.cur.execute('SELECT DISTINCT horarios.*, grupos_registos.cod_grupo FROM horarios LEFT JOIN grupos_registos ON horarios.codigo=grupos_registos.cod_registo AND grupos_registos.cod_grupo!=1 and grupos_registos.tabela="horarios" WHERE grupos_registos.cod_grupo!=1 and grupos_registos.tabela="horarios"')
            
            for row in self.cur:
                try:
                    linha = self.getLinha(row)

                    horario = horarioModels.Horario.objects.filter(pk=linha['id'])
                    website = modelsWebsite.WebSite.objects.get(pk=linha['cod_grupo'])

                    if len(horario)==0:
                        obj = horarioModels.Horario.objects.create(
                                                            id = linha['id'],
                                                            titulo = linha['titulo'],
                                                            criado = linha['criado'],
                                                            activo = linha['activo'],
                                                            criado_por = linha['criado_por'],
                                                            alterado_por = linha['alterado_por'],
                                                            website = website,
                                                            )
                    else:
                        obj=horario[0]
                    
                    self.cur.execute('SELECT DISTINCT * FROM horarios_horarios_actividades WHERE cod_horario="'+str(obj.id)+'"')
                    for row1 in self.cur:
                        try:
                            linha1 = self.getLinha1(row1)

                            if linha1['tipo']:
                                self.cur.execute('SELECT DISTINCT * FROM horarios_tipos WHERE codigo="'+str(linha1['tipo'])+'"')
                                row2 = self.cur.fetchone()
                                linha2 = self.getLinha2(row2)

                                tipo = horarioModels.HorarioTipo.objects.filter(titulo=linha2['titulo'], website=website)
                                #tipo = horarioModels.HorarioTipo.objects.filter(pk=linha1['tipo'])
                                if len(tipo)==0:

                                    tipo=horarioModels.HorarioTipo.objects.create(
                                                                        #id = linha['id'],
                                                                        titulo = linha2['titulo'],
                                                                        abreviatura = linha2['abreviatura'],
                                                                        criado = linha2['criado'],
                                                                        criado_por = linha2['criado_por'],
                                                                        alterado_por = linha2['alterado_por'],
                                                                        website = website,
                                                                        )
                                else:
                                    tipo=tipo[0]
                            else:
                                tipo=None
                            


                            if linha1['local']:
                                #local = horarioModels.HorarioLocal.objects.filter(pk=linha1['local'])
                                self.cur.execute('SELECT DISTINCT * FROM horarios_locais WHERE codigo="'+str(linha1['local'])+'"')
                                row3 = self.cur.fetchone()
                                linha3 = self.getLinha3(row3)

                                local = horarioModels.HorarioLocal.objects.filter(titulo=linha3['titulo'], website=website)
                                if len(local)==0:
                                    local=horarioModels.HorarioTipo.objects.create(
                                                                        #id = linha['id'],
                                                                        titulo = linha3['titulo'],
                                                                        abreviatura = linha3['abreviatura'],
                                                                        criado = linha3['criado'],
                                                                        criado_por = linha3['criado_por'],
                                                                        alterado_por = linha3['alterado_por'],
                                                                        website = website,
                                                                        )
                                else:
                                    local=local[0]
                            else:
                                local=None

                            
                            horarioModels.HorarioActividades.objects.create(
                                                                id = linha1['id'],
                                                                horario = obj,
                                                                tipo = tipo,#linha1['tipo'],
                                                                hora_entrada = linha1['hora_entrada'],
                                                                hora_saida = linha1['hora_saida'],
                                                                local = local,#linha1['local'],
                                                                dia_semana = linha1['dia_semana'],
                                                                )
                        except Exception, e:
                            print e
                            pass
                except Exception, e:
                    print e
                    pass

        def getLinha(self, row):
            #print row
            return {
                    'id': row[0],
                    'titulo': row[1],
                    'criado': datetime.fromtimestamp(row[2]),
                    'activo': row[3],
                    'criado_por': self.User,
                    'alterado_por': self.User,
                    'cod_grupo': row[4],
                    }

        def getLinha1(self, row):
            #print row
            return {
                    'id': row[0],
                    #'tipo': get_tipo(row[2]),
                    'tipo': row[2],
                    'hora_entrada': get_datetimestamo(row[3]),
                    'hora_saida': get_datetimestamo(row[4]),
                    #'local': get_local(row[6]),
                    'local': row[6],
                    'dia_semana': row[8],
                    }
        def getLinha2(self, row):
            #print row
            return {
                    'id': row[0],
                    'titulo': row[1],
                    'abreviatura': row[2],
                    'criado': datetime.fromtimestamp(row[3]),
                    'criado_por': self.User,
                    'alterado_por': self.User,
                    }
        def getLinha3(self, row):
            #print row
            return {
                    'id': row[0],
                    'titulo': row[1],
                    'criado': datetime.fromtimestamp(row[2]),
                    'criado_por': self.User,
                    'alterado_por': self.User,
                    }


    print 'BEGIN'

    import MySQLdb as mdb
    import sys

    con = None

    try:

        con = mdb.connect(django_settings.SIM4_CONN[0],django_settings.SIM4_CONN[1],django_settings.SIM4_CONN[2],django_settings.SIM4_CONN[3],charset="utf8");

        #con.set_character_set('utf8')

        cur = con.cursor()
        """
        cur.execute('SET NAMES utf8;')
        cur.execute('SET CHARACTER SET utf8;')
        cur.execute('SET character_set_connection=utf8;')
        """
        """
        cur.execute("SELECT VERSION()")

        data = cur.fetchone()

        print "Database version : %s " % data
        """

        ImportHorario(con, cur).importar()

    except mdb.Error, e:
        print "Error %d: %s" % (e.args[0], e.args[1])
        sys.exit(1)
    finally:
        if con:
            con.close()

    print 'END'


