#coding: utf-8
from django.conf import settings as django_settings

if not hasattr(django_settings, 'SIM4_CONN'):
    raise Exception('SIM4_CONN não existe no ficheiro de settings.py\nExemplo:\n\tSIM4_CONN = "dbname=\'db_name\' user=\'db_user\' host=\'db_host\' password=\'db_password\'"')
    pass
else:

    from horario import models as horarioModels
    from django.contrib.auth.models import User
    from datetime import datetime

    from website import models as modelsWebsite

    def get_fromtimestamp(val):
        if val is None:
            return None
        try:
            return datetime.fromtimestamp(val)
        except Exception, e:
            print e
            return None

    def get_strpdate(val):
        if val is None:
            return None
        try:
            return val
        except Exception, e:
            print e
            return None

    def get_datetimestamo(val):
        if val is None:
            return None
        try:
            return datetime.fromtimestamp(val)
        except Exception, e:
            print e
            return None

    def get_tipo(val):
        if val is None:
            return None
        try:
            return horarioModels.HorarioTipo.objects.get(pk=val)
        except Exception, e:
            print e
            return None


    def  get_local(val):
        if val is None:
            return None
        try:
            return horarioModels.HorarioLocal.objects.get(pk=val)
        except Exception, e:
            print e
            return None

    class ImportHorarioTipo(object):

        def __init__(self, conn, cur):
            self.conn = conn
            self.cur = cur
            self.User = User.objects.get(pk=101)

        def importar(self):
            self.cur.execute('SELECT DISTINCT * FROM horarios_tipos')
            for row in self.cur:
                linha = self.getLinha(row)
                try:
                    horarioModels.HorarioTipo.objects.create(
                                                        id = linha['id'],
                                                        titulo = linha['titulo'],
                                                        abreviatura = linha['abreviatura'],
                                                        criado = linha['criado'],
                                                        criado_por = linha['criado_por'],
                                                        alterado_por = linha['alterado_por'],
                                                        )
                except Exception, e:
                    print e
                    pass

        def getLinha(self, row):
            #print row
            return {
                    'id': row[0],
                    'titulo': row[1],
                    'abreviatura': row[2],
                    'criado': datetime.fromtimestamp(row[3]),
                    'criado_por': self.User,
                    'alterado_por': self.User,
                    }




    class ImportHorarioLocal(object):

        def __init__(self, conn, cur):
            self.conn = conn
            self.cur = cur
            self.User = User.objects.get(pk=101)

        def importar(self):
            self.cur.execute('SELECT DISTINCT * FROM horarios_locais')
            for row in self.cur:
                linha = self.getLinha(row)
                try:
                    horarioModels.HorarioLocal.objects.create(
                                                        id = linha['id'],
                                                        titulo = linha['titulo'],
                                                        criado = linha['criado'],
                                                        criado_por = linha['criado_por'],
                                                        alterado_por = linha['alterado_por'],
                                                        )
                except Exception, e:
                    print e
                    pass

        def getLinha(self, row):
            #print row
            return {
                    'id': row[0],
                    'titulo': row[1],
                    'criado': datetime.fromtimestamp(row[2]),
                    'criado_por': self.User,
                    'alterado_por': self.User,
                    }


    class ImportHorarioActividades(object):

        def __init__(self, obj, conn, cur):
            self.obj = obj
            self.conn = conn
            self.cur = cur
            #self.User = User.objects.get(pk=101)

        def importar(self):
            self.cur.execute('SELECT DISTINCT * FROM horarios_horarios_actividades WHERE cod_horario="'+str(self.obj.id)+'"')
            for row in self.cur:
                try:
                    linha = self.getLinha(row)
                    horarioModels.HorarioActividades.objects.create(
                                                        id = linha['id'],
                                                        horario = linha['horario'],
                                                        tipo = linha['tipo'],
                                                        hora_entrada = linha['hora_entrada'],
                                                        hora_saida = linha['hora_saida'],
                                                        local = linha['local'],
                                                        dia_semana = linha['dia_semana'],
                                                        )
                except Exception, e:
                    print e
                    pass

        def getLinha(self, row):
            #print row
            return {
                    'id': row[0],
                    'horario': self.obj,
                    'tipo': get_tipo(row[2]),
                    'hora_entrada': get_datetimestamo(row[3]),
                    'hora_saida': get_datetimestamo(row[4]),
                    'local': get_local(row[6]),
                    'dia_semana': row[8],
                    }







    class ImportHorarioWebsite(object):

        def __init__(self, obj, conn, cur):
            self.obj = obj
            self.conn = conn
            self.cur = cur
            #self.User = User.objects.get(pk=101)

        def importar(self):
            self.cur.execute('SELECT DISTINCT * FROM  grupos_registos WHERE tabela="horarios" AND cod_registo=%s' % self.obj.id)
            mylist=[]
            for row in self.cur:
                linha = self.getLinha(row)

                try:
                    mylist.append(linha['cod_grupo'],);
                except Exception, e:
                    print e
                    pass

            if 1 in mylist:
                self.obj.website=modelsWebsite.WebSite.objects.get(pk=1)
            else:
                self.obj.website=modelsWebsite.WebSite.objects.get(pk=mylist[0])
            self.obj.save()

        def getLinha(self, row):
            #print row
            return {
                    'cod_registo': row[0],
                    'cod_grupo': row[1],
                    'tabela': row[2],
                    'timestamp': row[3],
                    }


    class ImportHorario(object):

        def __init__(self, conn, cur):
            self.conn = conn
            self.cur = cur
            self.User = User.objects.get(pk=101)

        def importar(self):
            self.cur.execute('SELECT DISTINCT * FROM horarios WHERE codigo in (SELECT cod_registo FROM grupos_registos WHERE cod_grupo=1 and tabela="horarios")')
            for row in self.cur:
                try:
                    linha = self.getLinha(row)
                    obj = horarioModels.Horario.objects.create(
                                                        id = linha['id'],
                                                        titulo = linha['titulo'],
                                                        criado = linha['criado'],
                                                        activo = linha['activo'],
                                                        criado_por = linha['criado_por'],
                                                        alterado_por = linha['alterado_por'],
                                                        )
                    ImportHorarioWebsite(obj, self.conn, self.conn.cursor()).importar()
                    ImportHorarioActividades(obj, self.conn, self.conn.cursor()).importar()
                except Exception, e:
                    print e
                    pass

        def getLinha(self, row):
            #print row
            return {
                    'id': row[0],
                    'titulo': row[1],
                    'criado': datetime.fromtimestamp(row[2]),
                    'activo': row[3],
                    'criado_por': self.User,
                    'alterado_por': self.User,
                    }


    print 'BEGIN'

    import MySQLdb as mdb
    import sys

    con = None

    try:

        con = mdb.connect(django_settings.SIM4_CONN[0],django_settings.SIM4_CONN[1],django_settings.SIM4_CONN[2],django_settings.SIM4_CONN[3],charset="utf8");

        #con.set_character_set('utf8')

        cur = con.cursor()
        """
        cur.execute('SET NAMES utf8;')
        cur.execute('SET CHARACTER SET utf8;')
        cur.execute('SET character_set_connection=utf8;')
        """
        """
        cur.execute("SELECT VERSION()")

        data = cur.fetchone()

        print "Database version : %s " % data
        """

        ImportHorarioTipo(con, cur).importar()
        ImportHorarioLocal(con, cur).importar()
        ImportHorario(con, cur).importar()

    except mdb.Error, e:
        print "Error %d: %s" % (e.args[0], e.args[1])
        sys.exit(1)
    finally:
        if con:
            con.close()

    print 'END'


