#coding: utf-8
from django.conf import settings as django_settings

if not hasattr(django_settings, 'SIM4_CONN'):
    raise Exception('SIM4_CONN não existe no ficheiro de settings.py\nExemplo:\n\tSIM4_CONN = "dbname=\'db_name\' user=\'db_user\' host=\'db_host\' password=\'db_password\'"')
    pass
else:

    from diocese import models as dioceseModels
    from django.contrib.auth.models import User
    from datetime import datetime

    from django.conf import settings
    from elfinder.models import FileCollection,Directory
    import os.path
    import os
    import shutil
    from exceptions import IOError



    def get_arciprestado(val):
        if val is None:
            return None
        try:
            return dioceseModels.Arciprestado.objects.get(pk=val)
        except Exception, e:
            print e
            return None

    def get_codigo_postal(val):
        if val is None:
            return None
        try:
            return val.split(' ')[:1][0]
        except Exception, e:
            print e
            return None

    def get_localidade(val):
        if val is None:
            return None
        try:
            return ' '.join(val.split(' ')[1:])
        except Exception, e:
            print e
            return None

    def get_fromtimestamp(val):
        if val is None:
            return None
        try:
            return datetime.fromtimestamp(val)
        except Exception, e:
            print e
            return None

    def get_strpdate(val):
        if val is None:
            return None
        try:
            return val
        except Exception, e:
            print e
            return None



    class ImportPresbitero(object):

        def __init__(self, conn, cur):
            self.conn = conn
            self.cur = cur
            #self.User = User.objects.get(pk=101)

        def importar(self):
            self.cur.execute('SELECT * FROM clero WHERE (cod_tipo_clero=1 or cod_tipo_clero=3 or  cod_tipo_clero=4 or  cod_tipo_clero=5) AND codigo in (645, 759, 760, 786, 936, 937, 944)')
            for row in self.cur:
                linha = self.getLinha(row)
                try:
                    dioceseModels.Presbitero.objects.create(
                                                        id = linha['id'],
                                                        tipo_clero = linha['tipo_clero'],
                                                        nome = linha['nome'],
                                                        morada = linha['morada'],
                                                        codigo_postal = linha['codigo_postal'],
                                                        localidade = linha['localidade'],
                                                        telefone = linha['telefone'],
                                                        fax = linha['fax'],
                                                        email = linha['email'],
                                                        igreja = linha['igreja'],
                                                        paginaweb = linha['paginaweb'],
                                                        data_nascimento = linha['data_nascimento'],
                                                        data_ordenacoa = linha['data_ordenacoa'],
                                                        clero_tipo = linha['clero_tipo'],
                                                        arcipreste = linha['arcipreste'],
                                                        vice_arcipreste = linha['vice_arcipreste'],
                                                        telemovel_privado = linha['telemovel_privado'],
                                                        paroco = linha['paroco'],
                                                        capelao = linha['capelao'],
                                                        reitor = linha['reitor'],
                                                        habilitacoes_academicas = linha['habilitacoes_academicas'],
                                                        publicacoes = linha['publicacoes'],
                                                        formacao_permanente = linha['formacao_permanente'],
                                                        fraternidade_sacerdotal = linha['fraternidade_sacerdotal'],
                                                        cartao_sacerdotal = linha['cartao_sacerdotal'],
                                                        foto = linha['foto'],
                                                        nomeacoes = linha['nomeacoes'],
                                                        local_nascimento = linha['local_nascimento'],
                                                        local_ordenacao = linha['local_ordenacao'],
                                                        faleceu = linha['faleceu'],
                                                        data_faleceu = linha['data_faleceu'],
                                                        criado = linha['criado'],
                                                        criado_por = linha['criado_por'],
                                                        codigo_ecclesia = linha['codigo_ecclesia'],
                                                        nomeacoes_actuais  = linha['nomeacoes_actuais'],
                                                        alterado_por = linha['alterado_por'],
                                                        )

                except Exception, e:
                    print e
                    pass

        def getLinha(self, row):
            #print row
            return {
                    'id': row[0],
                    'tipo_clero': self.get_tipo_clero(row[1]),
                    'nome': row[2],
                    'morada': row[3],
                    'codigo_postal': self.get_codigo_postal(row[4]),
                    'localidade': self.get_localidade(row[4]),
                    'telefone': row[5],
                    'fax': row[6],
                    'email': row[7],
                    'igreja': row[8],
                    'paginaweb': row[9],
                    'data_nascimento': get_strpdate(row[10]),
                    'data_ordenacoa': get_strpdate(row[11]),
                    'clero_tipo': self.get_clero_tipo(row[12]),
                    'arcipreste': row[13],
                    'vice_arcipreste': row[14],
                    'telemovel_privado': row[15],
                    'paroco': row[16],
                    'capelao': row[18],
                    'reitor': row[19],
                    'habilitacoes_academicas': row[20],
                    'publicacoes': row[21],
                    'formacao_permanente': row[22],
                    'fraternidade_sacerdotal': row[23],
                    'cartao_sacerdotal': row[24],
                    'foto': row[25],
                    'nomeacoes': row[26],
                    'local_nascimento': row[27],
                    'local_ordenacao': row[28],
                    'faleceu': row[29],
                    'data_faleceu': get_strpdate(row[30]),
                    'criado_por': User.objects.get(pk=row[32]),
                    'criado': datetime.strptime(str(row[33]) + str(' ') + str(row[34]), "%Y-%m-%d %H:%M:%S"),
                    'nomeacoes_actuais': row[48],
                    'codigo_ecclesia': row[35],
                    #'alterado_por': self.User,
                    'alterado_por':  User.objects.get(pk=row[32]),
                    }

        def get_codigo_postal(self, val):
            if val is None:
                return None
            if val=='CANADÁ' or val=='D-90480 Nürnberg ALEMANHA' or val=='Díli 88010, Timor Leste' or val=='H2W 1G3' or val=='Providence, R.I. 02906-1799 USA':
                return val
            try:
                return val.split(' ')[:1][0]
            except Exception, e:
                print e
                return None

        def get_localidade(self, val):
            if val is None:
                return None
            if val=='CANADÁ' or val=='D-90480 Nürnberg ALEMANHA' or val=='Díli 88010, Timor Leste' or val=='H2W 1G3' or val=='Providence, R.I. 02906-1799 USA':
                return None
            try:
                return ' '.join(val.split(' ')[1:])
            except Exception, e:
                print e
                return None

        def get_clero_tipo(self, val):
            try:
                if val=='arquidiocesano':
                    return 2
                elif val=='arquidiocesano_residir_fora':
                    return 3
                elif val=='de_fora_a_residir_na_arquidiocese':
                    return 4
                elif val=='religioso':
                    return 1
            except Exception, e:
                print e
                return None

        def get_tipo_clero(self, val):
            try:
                if val==1:
                    return 1
                elif val==3:
                    return 2
                elif val==4:
                    return 3
                elif val==5:
                    return 4
            except Exception, e:
                print e
                return None



    """
    class ImportDiaconoRetiros(object):

        def __init__(self, obj, conn, cur):
            self.obj = obj
            self.conn = conn
            self.cur = cur
            #self.User = User.objects.get(pk=101)

        def importar(self):
            self.cur.execute('SELECT * FROM clero_retiros WHERE cod_clero="'+str(self.obj.id)+'"')
            for row in self.cur:
                linha = self.getLinha(row)
                try:
                    self.obj.diocese_diaconoretiros_diaconoretiros.create(
                                                        id = linha['id'],
                                                        ano = linha['ano'],
                                                        observacoes = linha['observacoes'],
                                                        )
                except Exception, e:
                    print e
                    pass

        def getLinha(self, row):
            #print row
            return {
                    'id': row[0],
                    'ano': row[2],
                    'observacoes': row[3],
                    }
    """

    class ImportParoquiaDiacono(object):

        def __init__(self, obj, conn, cur):
            self.obj = obj
            self.conn = conn
            self.cur = cur
            #self.User = User.objects.get(pk=101)

        def importar(self):
            self.cur.execute('SELECT * FROM paroquias_clero WHERE cod_clero="'+str(self.obj.id)+'"')
            for row in self.cur:
                linha = self.getLinha(row)
                try:

                    if linha['padre1']==1 or linha['padre2']==1 or linha['padre3']==1:
                        if linha['padre1']==1:
                            obj = dioceseModels.Paroquia.objects.get(pk=linha['padre1'])
                            self.obj.diocese_diaconoparoquias_diaconoparoquias_diacono.create(
                                                                diacono = self.obj,
                                                                paroquia = obj,
                                                                )
                        elif linha['padre2']==1:
                            obj = dioceseModels.Paroquia.objects.get(pk=linha['padre2'])
                            self.obj.diocese_diaconoparoquias_diaconoparoquias_diacono.create(
                                                                diacono = self.obj,
                                                                paroquia = obj,
                                                                )
                        elif linha['padre3']==1:
                            obj = dioceseModels.Paroquia.objects.get(pk=linha['padre3'])
                            self.obj.diocese_diaconoparoquias_diaconoparoquias_diacono.create(
                                                                diacono = self.obj,
                                                                paroquia = obj,
                                                                )

                except Exception, e:
                    print e
                    pass

        def getLinha(self, row):
            #print row
            return {
                    'cod_paroquia': row[1],
                    'cod_clero': row[2],
                    'padre1': row[8],
                    'padre2': row[9],
                    'padre3': row[9],
                    }

    class ImportDiacono(object):

        def __init__(self, conn, cur):
            self.conn = conn
            self.cur = cur
            #self.User = User.objects.get(pk=101)

        def importar(self):
            self.cur.execute('SELECT * FROM clero WHERE cod_tipo_clero=9')
            for row in self.cur:
                linha = self.getLinha(row)
                try:
                    obj = dioceseModels.Diacono.objects.create(
                                                        id = linha['id'],
                                                        nome = linha['nome'],
                                                        morada = linha['morada'],
                                                        codigo_postal = linha['codigo_postal'],
                                                        localidade = linha['localidade'],
                                                        telefone = linha['telefone'],
                                                        fax = linha['fax'],
                                                        email = linha['email'],
                                                        paginaweb = linha['paginaweb'],
                                                        data_nascimento = linha['data_nascimento'],
                                                        data_ordenacoa = linha['data_ordenacoa'],
                                                        telemovel_privado = linha['telemovel_privado'],
                                                        nomeacoes = linha['nomeacoes'],
                                                        local_nascimento = linha['local_nascimento'],
                                                        local_ordenacao = linha['local_ordenacao'],
                                                        faleceu = linha['faleceu'],
                                                        data_faleceu = linha['data_faleceu'],
                                                        nomeacoes_actuais = linha['nomeacoes_actuais'],
                                                        criado = linha['criado'],
                                                        criado_por = linha['criado_por'],
                                                        codigo_ecclesia = linha['codigo_ecclesia'],
                                                        alterado_por = linha['alterado_por'],
                                                        )

                    ImportParoquiaDiacono(obj, self.conn, self.conn.cursor()).importar()
                except Exception, e:
                    print e
                    pass

        def getLinha(self, row):
            #print row
            return {
                    'id': row[0],
                    'nome': row[2],
                    'morada': row[3],
                    'codigo_postal': self.get_codigo_postal(row[4]),
                    'localidade': self.get_localidade(row[4]),
                    'telefone': row[5],
                    'fax': row[6],
                    'email': row[7],
                    'paginaweb': row[9],
                    'data_nascimento': get_strpdate(row[10]),
                    'data_ordenacoa': get_strpdate(row[11]),
                    'telemovel_privado': row[15],
                    'nomeacoes': row[26],
                    'local_nascimento': row[27],
                    'local_ordenacao': row[28],
                    'faleceu': row[29],
                    'data_faleceu': get_strpdate(row[30]),
                    'criado_por': User.objects.get(pk=row[32]),
                    'criado': datetime.strptime(str(row[33]) + str(' ') + str(row[34]), "%Y-%m-%d %H:%M:%S"),
                    'nomeacoes_actuais': row[48],
                    'codigo_ecclesia': row[35],
                    #'alterado_por': self.User,
                    'alterado_por':  User.objects.get(pk=row[32]),
                    }

        def get_codigo_postal(self, val):
            if val == None:
                return None
            if val=='CANADÁ' or val=='D-90480 Nürnberg ALEMANHA' or val=='Díli 88010, Timor Leste' or val=='H2W 1G3' or val=='Providence, R.I. 02906-1799 USA':
                return val
            try:
                return val.split(' ')[:1][0]
            except Exception, e:
                print e
                return None

        def get_localidade(self, val):
            if val == None:
                return None
            if val=='CANADÁ' or val=='D-90480 Nürnberg ALEMANHA' or val=='Díli 88010, Timor Leste' or val=='H2W 1G3' or val=='Providence, R.I. 02906-1799 USA':
                return None
            try:
                return ' '.join(val.split(' ')[1:])
            except Exception, e:
                print e
                return None




    class ImportPresbiteroFiles(object):

        def __init__(self):
            self.origem = os.path.abspath(os.path.dirname(os.path.realpath(__file__))+'/../../../biblioteca/diocese/clero/')

        def importar(self):
            lista = dioceseModels.Presbitero.objects.filter(pk__in=[645, 759, 760, 786, 936, 937, 944])

            for obj in lista:
                if obj.fs == None:
                    fs = create_fs()
                else:
                    fs = obj.fs
                obj.fs = fs

                if obj.foto != None:
                    try:
                        filename = fs.url + '/' + os.path.basename(obj.foto)
                        shutil.copy('%s%s' % (self.origem+ '/', obj.foto), fs.dir + '/')
                        obj.foto = filename
                    except IOError:
                        print IOError
                        obj.foto = None

                obj.save()



    def create_fs():
        import datetime
        import tempfile
        mydir= os.path.abspath(os.path.realpath(settings.MEDIA_ROOT +'/contents/')) #os.path.abspath(os.path.dirname(os.path.realpath(__file__))+'/../../media/contents/')
        dirpath = tempfile.mkdtemp(prefix = 'contents_',dir = mydir)
        fc = FileCollection(dir = dirpath,name = 'Filesystem',url='contents/'+os.path.basename(dirpath))
        fc.save();
        (mode, ino, dev, nlink, uid, gid, size, atime, mtime, ctime) = os.stat(dirpath)
        mtime = datetime.datetime.fromtimestamp(mtime)
        d = Directory(name = '/', collection=fc, last_modification=mtime)
        d.save()
        return fc






    class ImportOutraInstituicao(object):

        def __init__(self, conn, cur):
            self.conn = conn
            self.cur = cur
            #self.User = User.objects.get(pk=101)

        def importar(self):
            self.cur.execute('SELECT * FROM instituicoes WHERE cod_tipo_instituicao=12')
            for row in self.cur:
                linha = self.getLinha(row)
                try:
                    dioceseModels.OutraInstituicao.objects.create(
                                                        id = linha['id'],
                                                        nome = linha['nome'],
                                                        morada = linha['morada'],
                                                        codigo_postal = linha['codigo_postal'],
                                                        localidade = linha['localidade'],
                                                        telefone = linha['telefone'],
                                                        fax = linha['fax'],
                                                        email = linha['email'],
                                                        paginaweb = linha['paginaweb'],
                                                        arciprestado = linha['arciprestado'],
                                                        criado_por = linha['criado_por'],
                                                        criado = linha['criado'],
                                                        director = linha['director'],
                                                        codigo_ecclesia = linha['codigo_ecclesia'],
                                                        telemovel = linha['telemovel'],
                                                        alterado_por = linha['alterado_por'],
                                                        )
                except Exception, e:
                    print e
                    pass

        def getLinha(self, row):
            #print row
            return {
                    'id': row[0],
                    'nome': row[1],
                    'morada': row[3],
                    'codigo_postal': get_codigo_postal(row[4]),
                    'localidade': get_localidade(row[4]),
                    'telefone': row[5],
                    'fax': row[6],
                    'email': row[7],
                    'paginaweb': row[8],
                    'arciprestado': get_arciprestado(row[9]),
                    'criado_por': User.objects.get(pk=row[10]),
                    'criado': datetime.strptime(str(row[11]) + str(' ') + str(row[12]), "%Y-%m-%d %H:%M:%S"),
                    'director': row[13],
                    'codigo_ecclesia': row[70],
                    'telemovel': (row[78] if row[78] is not None else str('')) + (str('/') if row[78] is not None and row[79] is not None else str('')) + (row[79] if row[79] is not None else str('')),
                    #'alterado_por': self.User,
                    'alterado_por': User.objects.get(pk=row[10]),
                    }


    print 'BEGIN'

    import MySQLdb as mdb
    import sys

    con = None

    try:

        con = mdb.connect(django_settings.SIM4_CONN[0],django_settings.SIM4_CONN[1],django_settings.SIM4_CONN[2],django_settings.SIM4_CONN[3],charset="utf8");

        #con.set_character_set('utf8')

        cur = con.cursor()
        """
        cur.execute('SET NAMES utf8;')
        cur.execute('SET CHARACTER SET utf8;')
        cur.execute('SET character_set_connection=utf8;')
        """
        """
        cur.execute("SELECT VERSION()")

        data = cur.fetchone()

        print "Database version : %s " % data
        """

        ImportPresbitero(con, cur).importar()
        ImportPresbiteroFiles().importar()
        ImportDiacono(con, cur).importar()
        ImportOutraInstituicao(con, cur).importar()

    except mdb.Error, e:
        print "Error %d: %s" % (e.args[0], e.args[1])
        sys.exit(1)
    finally:
        if con:
            con.close()

    print 'END'


