#coding: utf-8
from django.conf import settings as django_settings

if not hasattr(django_settings, 'SIM4_CONN'):
    raise Exception('SIM4_CONN não existe no ficheiro de settings.py\nExemplo:\n\tSIM4_CONN = "dbname=\'db_name\' user=\'db_user\' host=\'db_host\' password=\'db_password\'"')
    pass
else:

    from diocese import models as dioceseModels
    from django.contrib.auth.models import User
    from datetime import datetime

    def get_arciprestado(val):
        if val is None:
            return None
        try:
            return dioceseModels.Arciprestado.objects.get(pk=val)
        except Exception, e:
            print e
            return None

    def get_codigo_postal(val):
        if val is None:
            return None
        try:
            return val.split(' ')[:1][0]
        except Exception, e:
            print e
            return None

    def get_localidade(val):
        if val is None:
            return None
        try:
            return ' '.join(val.split(' ')[1:])
        except Exception, e:
            print e
            return None

    def get_fromtimestamp(val):
        if val is None:
            return None
        try:
            return datetime.fromtimestamp(val)
        except Exception, e:
            print e
            return None

    def get_strpdate(val):
        if val is None:
            return None
        try:
            return val
        except Exception, e:
            print e
            return None


    class ImportParoquiaCleros(object):

        def __init__(self, obj, conn, cur):
            self.obj = obj
            self.conn = conn
            self.cur = cur
            #self.User = User.objects.get(pk=101)

        def importar(self):
            self.cur.execute('SELECT * FROM paroquias_clero WHERE cod_clero="'+str(self.obj.id)+'"')
            for row in self.cur:
                linha = self.getLinha(row)
                try:
                    if linha['padre1']==1 or linha['padre2']==1 or linha['padre3']==1:
                        obj = dioceseModels.Paroquia.objects.get(pk=linha['cod_paroquia'])
                        if linha['padre1']==1:
                            obj.padre1=self.obj
                            obj.save()
                        elif linha['padre2']==1:
                            obj.padre2=self.obj
                            obj.save()
                        elif linha['padre3']==1:
                            obj.padre3=self.obj
                            obj.save()

                except Exception, e:
                    print e
                    pass

        def getLinha(self, row):
            #print row
            return {
                    'cod_paroquia': row[1],
                    'cod_clero': row[2],
                    'padre1': row[8],
                    'padre2': row[9],
                    'padre3': row[9],
                    }


    class ImportPresbitero2(object):

        def __init__(self, conn, cur):
            self.conn = conn
            self.cur = cur
            #self.User = User.objects.get(pk=101)

        def importar(self):
            self.cur.execute('SELECT * FROM clero WHERE cod_tipo_clero=1 or cod_tipo_clero=3 or  cod_tipo_clero=4 or  cod_tipo_clero=5')
            for row in self.cur:
                linha = self.getLinha(row)
                try:
                    obj = dioceseModels.Presbitero.objects.get(
                                                        pk = linha['id']
                                                        )

                    ImportParoquiaCleros(obj, self.conn, self.conn.cursor()).importar()
                except Exception, e:
                    print e
                    pass

        def getLinha(self, row):
            #print row
            return {
                    'id': row[0],
                    'tipo_clero': self.get_tipo_clero(row[1]),
                    'nome': row[2],
                    'morada': row[3],
                    'codigo_postal': self.get_codigo_postal(row[4]),
                    'localidade': self.get_localidade(row[4]),
                    'telefone': row[5],
                    'fax': row[6],
                    'email': row[7],
                    'igreja': row[8],
                    'paginaweb': row[9],
                    'data_nascimento': get_strpdate(row[10]),
                    'data_ordenacoa': get_strpdate(row[11]),
                    'clero_tipo': self.get_clero_tipo(row[12]),
                    'arcipreste': row[13],
                    'vice_arcipreste': row[14],
                    'telemovel_privado': row[15],
                    'paroco': row[16],
                    'capelao': row[18],
                    'reitor': row[19],
                    'habilitacoes_academicas': row[20],
                    'publicacoes': row[21],
                    'formacao_permanente': row[22],
                    'fraternidade_sacerdotal': row[23],
                    'cartao_sacerdotal': row[24],
                    'foto': row[25],
                    'nomeacoes': row[26],
                    'local_nascimento': row[27],
                    'local_ordenacao': row[28],
                    'faleceu': row[29],
                    'data_faleceu': get_strpdate(row[30]),
                    'criado_por': User.objects.get(pk=row[32]),
                    'criado': datetime.strptime(str(row[33]) + str(' ') + str(row[34]), "%Y-%m-%d %H:%M:%S"),
                    'nomeacoes_actuais': row[48],
                    'codigo_ecclesia': row[35],
                    #'alterado_por': self.User,
                    'alterado_por':  User.objects.get(pk=row[32]),
                    }

        def get_codigo_postal(self, val):
            if val is None:
                return None
            if val=='CANADÁ' or val=='D-90480 Nürnberg ALEMANHA' or val=='Díli 88010, Timor Leste' or val=='H2W 1G3' or val=='Providence, R.I. 02906-1799 USA':
                return val
            try:
                return val.split(' ')[:1][0]
            except Exception, e:
                print e
                return None

        def get_localidade(self, val):
            if val is None:
                return None
            if val=='CANADÁ' or val=='D-90480 Nürnberg ALEMANHA' or val=='Díli 88010, Timor Leste' or val=='H2W 1G3' or val=='Providence, R.I. 02906-1799 USA':
                return None
            try:
                return ' '.join(val.split(' ')[1:])
            except Exception, e:
                print e
                return None

        def get_clero_tipo(self, val):
            try:
                if val=='arquidiocesano':
                    return 2
                elif val=='arquidiocesano_residir_fora':
                    return 3
                elif val=='de_fora_a_residir_na_arquidiocese':
                    return 4
                elif val=='religioso':
                    return 1
            except Exception, e:
                print e
                return None

        def get_tipo_clero(self, val):
            try:
                if val==1:
                    return 1
                elif val==3:
                    return 2
                elif val==4:
                    return 3
                elif val==5:
                    return 4
            except Exception, e:
                print e
                return None



    print 'BEGIN'

    import MySQLdb as mdb
    import sys

    con = None

    try:

        con = mdb.connect(django_settings.SIM4_CONN[0],django_settings.SIM4_CONN[1],django_settings.SIM4_CONN[2],django_settings.SIM4_CONN[3],charset="utf8");

        #con.set_character_set('utf8')

        cur = con.cursor()
        """
        cur.execute('SET NAMES utf8;')
        cur.execute('SET CHARACTER SET utf8;')
        cur.execute('SET character_set_connection=utf8;')
        """
        """
        cur.execute("SELECT VERSION()")

        data = cur.fetchone()

        print "Database version : %s " % data
        """

        ImportPresbitero2(con, cur).importar()
    except mdb.Error, e:
        print "Error %d: %s" % (e.args[0], e.args[1])
        sys.exit(1)
    finally:
        if con:
            con.close()

    print 'END'


