#coding: utf-8
from django.conf import settings as django_settings

if not hasattr(django_settings, 'SIM4_CONN'):
    #raise Exception('SIM4_CONN não existe no ficheiro de settings.py\nExemplo:\n\tSIM4_CONN = "dbname=\'db_name\' user=\'db_user\' host=\'db_host\' password=\'db_password\'"')
    pass
else:
    from diocese import models as contentModels
    from django.conf import settings
    from elfinder.models import FileCollection,Directory
    import os.path
    import os
    import shutil
    from exceptions import IOError

    def importar():
        print 'BEGIN'
        ImportBispo().importar()
        ImportDiaconoPermanente().importar()
        ImportPresbitero().importar()
        print 'END'
        pass

    class ImportBispo(object):

        def __init__(self):
            self.origem = os.path.abspath(os.path.dirname(os.path.realpath(__file__))+'/../../../biblioteca/diocese/clero/')

        def importar(self):
            lista = contentModels.Bispo.objects.order_by('id').all()

            for obj in lista:
                if obj.fs == None:
                    fs = create_fs()
                else:
                    fs = obj.fs
                obj.fs = fs

                if obj.foto != None:
                    try:
                        filename = fs.url + '/' + os.path.basename(obj.foto)
                        shutil.copy('%s%s' % (self.origem+ '/', obj.foto), fs.dir + '/')
                        obj.foto = filename
                    except IOError:
                        print IOError
                        obj.foto = None

                obj.save()

    class ImportPresbitero(object):

        def __init__(self):
            self.origem = os.path.abspath(os.path.dirname(os.path.realpath(__file__))+'/../../../biblioteca/diocese/clero/')

        def importar(self):
            lista = contentModels.Presbitero.objects.order_by('id').all()

            for obj in lista:
                if obj.fs == None:
                    fs = create_fs()
                else:
                    fs = obj.fs
                obj.fs = fs

                if obj.foto != None:
                    try:
                        filename = fs.url + '/' + os.path.basename(obj.foto)
                        shutil.copy('%s%s' % (self.origem+ '/', obj.foto), fs.dir + '/')
                        obj.foto = filename
                    except IOError:
                        print IOError
                        obj.foto = None

                obj.save()

    class ImportDiaconoPermanente(object):

        def __init__(self):
            self.origem = os.path.abspath(os.path.dirname(os.path.realpath(__file__))+'/../../../biblioteca/diocese/clero/')

        def importar(self):
            lista = contentModels.DiaconoPermanente.objects.order_by('id').all()

            for obj in lista:
                if obj.fs == None:
                    fs = create_fs()
                else:
                    fs = obj.fs
                obj.fs = fs

                if obj.foto != None:
                    try:
                        filename = fs.url + '/' + os.path.basename(obj.foto)
                        shutil.copy('%s%s' % (self.origem+ '/', obj.foto), fs.dir + '/')
                        obj.foto = filename
                    except IOError:
                        print IOError
                        obj.foto = None

                obj.save()


    def create_fs():
        import datetime
        import tempfile
        mydir= os.path.abspath(os.path.realpath(settings.MEDIA_ROOT +'/contents/')) #os.path.abspath(os.path.dirname(os.path.realpath(__file__))+'/../../media/contents/')
        dirpath = tempfile.mkdtemp(prefix = 'contents_',dir = mydir)
        fc = FileCollection(dir = dirpath,name = 'Filesystem',url='contents/'+os.path.basename(dirpath))
        fc.save();
        (mode, ino, dev, nlink, uid, gid, size, atime, mtime, ctime) = os.stat(dirpath)
        mtime = datetime.datetime.fromtimestamp(mtime)
        d = Directory(name = '/', collection=fc, last_modification=mtime)
        d.save()
        return fc


importar()
