#coding: utf-8
from django.conf import settings as django_settings

if not hasattr(django_settings, 'SIM4_CONN'):
    raise Exception('SIM4_CONN não existe no ficheiro de settings.py\nExemplo:\n\tSIM4_CONN = "dbname=\'db_name\' user=\'db_user\' host=\'db_host\' password=\'db_password\'"')
    pass
else:

    from diocese import models as dioceseModels
    from django.contrib.auth.models import User
    from datetime import datetime

    def get_arciprestado(val):
        if val is None:
            return None
        try:
            return dioceseModels.Arciprestado.objects.get(pk=val)
        except Exception, e:
            print e
            return None

    def get_codigo_postal(val):
        if val is None:
            return None
        try:
            return val.split(' ')[:1][0]
        except Exception, e:
            print e
            return None

    def get_localidade(val):
        if val is None:
            return None
        try:
            return ' '.join(val.split(' ')[1:])
        except Exception, e:
            print e
            return None

    def get_fromtimestamp(val):
        if val is None:
            return None
        try:
            return datetime.fromtimestamp(val)
        except Exception, e:
            print e
            return None

    def get_strpdate(val):
        if val is None:
            return None
        try:
            return val
        except Exception, e:
            print e
            return None


    """
    dioceseModels.NotaHistorica.objects.create(
                                        for e in linha.keys():
                                            print "%8s = %8s" % (e, linha[e])
                                            "%8s = %8s, " % (e, linha[e])
                                        )

            for e in linha.keys():
                print "%8s = %8s" % (e, linha[e])
                "%8s = %8s, " % (e, linha[e])
    #[ "%8s = %8s, " % (e, linha[e]) for e in linha.keys() ]

    """

    class ImportNotaHistorica(object):

        def __init__(self, conn, cur):
            self.conn = conn
            self.cur = cur
            #self.User = User.objects.get(pk=101)

        def importar(self):
            self.cur.execute('SELECT * FROM nota_historica')
            for row in self.cur:
                linha = self.getLinha(row)
                try:
                    dioceseModels.NotaHistorica.objects.create(
                                                        id = linha['id'],
                                                        nome =  linha['nome'],
                                                        sufraganea = linha['sufraganea'],
                                                        nota_historica = linha['nota_historica'],
                                                        criado = linha['criado'],
                                                        criado_por = linha['criado_por'],
                                                        codigo_ecclesia = linha['codigo_ecclesia'],
                                                        alterado_por = linha['alterado_por'],
                                                        )
                except Exception, e:
                    print e
                    pass

        def getLinha(self, row):
            #print row
            return {
                    'id': row[0],
                    'nome': row[1],
                    'sufraganea': row[2],
                    'nota_historica': row[3],
                    'criado': datetime.fromtimestamp(row[4]),
                    'criado_por': User.objects.get(pk=row[5]),
                    'codigo_ecclesia': row[6],
                    #'alterado_por': self.User,
                    'alterado_por': User.objects.get(pk=row[5]),
                    }

    class ImportDadosEstatisticos(object):

        def __init__(self, conn, cur):
            self.conn = conn
            self.cur = cur
            #self.User = User.objects.get(pk=101)

        def importar(self):
            self.cur.execute('SELECT * FROM estatisticas')
            for row in self.cur:
                linha = self.getLinha(row)

                try:
                    dioceseModels.DadosEstatisticos.objects.create(
                                                        id = linha['id'],
                                                        ano = linha['ano'],
                                                        superficie = linha['superficie'],
                                                        populacao = linha['populacao'],
                                                        catolicos = linha['catolicos'],
                                                        arciprestados = linha['arciprestados'],
                                                        paroquias = linha['paroquias'],
                                                        pclerodiocesano = linha['pclerodiocesano'],
                                                        pcleroreligioso = linha['pcleroreligioso'],
                                                        poutrosacerdote = linha['poutrosacerdote'],
                                                        pdiaconosper = linha['pdiaconosper'],
                                                        preligiosas = linha['preligiosas'],
                                                        pleigos = linha['pleigos'],
                                                        totalmentevacantes = linha['totalmentevacantes'],
                                                        capelanias = linha['capelanias'],
                                                        sacerdotesdiocesanos = linha['sacerdotesdiocesanos'],
                                                        spdiocesepropria = linha['spdiocesepropria'],
                                                        spnoutradiocese = linha['spnoutradiocese'],
                                                        foraservicopastoral = linha['foraservicopastoral'],
                                                        srrdiocese = linha['srrdiocese'],
                                                        srrtotalpartesdiocese = linha['srrtotalpartesdiocese'],
                                                        srrservicoinstituto = linha['srrservicoinstituto'],
                                                        srrforaservicopastoral = linha['srrforaservicopastoral'],
                                                        religiososprofessosnsacerdotes = linha['religiososprofessosnsacerdotes'],
                                                        religiosasprofessasrd = linha['religiosasprofessasrd'],
                                                        diaconospermanentes = linha['diaconospermanentes'],
                                                        candidatossacerdocio = linha['candidatossacerdocio'],
                                                        cscelrodiocesano = linha['cscelrodiocesano'],
                                                        cscleroreligioso = linha['cscleroreligioso'],
                                                        cficlerodiocesano = linha['cficlerodiocesano'],
                                                        cficleroreligioso = linha['cficleroreligioso'],
                                                        cieescolasmaternoinfantis = linha['cieescolasmaternoinfantis'],
                                                        cieescolasprimarias = linha['cieescolasprimarias'],
                                                        cieescolassecundarias = linha['cieescolassecundarias'],
                                                        cieinstitutossuperiores = linha['cieinstitutossuperiores'],
                                                        cieuniversidadecatolica = linha['cieuniversidadecatolica'],
                                                        cashospitais = linha['cashospitais'],
                                                        casambulatorios = linha['casambulatorios'],
                                                        cascasasdeidosos = linha['cascasasdeidosos'],
                                                        casorfanatos = linha['casorfanatos'],
                                                        cascreches = linha['cascreches'],
                                                        casconsultoriosfamiliares = linha['casconsultoriosfamiliares'],
                                                        cascentrosespeciais = linha['cascentrosespeciais'],
                                                        cascentrossociais = linha['cascentrossociais'],
                                                        casconfrarias = linha['casconfrarias'],
                                                        casmisericordias = linha['casmisericordias'],
                                                        vsbaptizados = linha['vsbaptizados'],
                                                        vsate1ano = linha['vsate1ano'],
                                                        vsde1a7anos = linha['vsde1a7anos'],
                                                        vsapos7anos = linha['vsapos7anos'],
                                                        vsconfirmacoes = linha['vsconfirmacoes'],
                                                        vsprimeirascomunhoes = linha['vsprimeirascomunhoes'],
                                                        vsmatrimonioscanonicos = linha['vsmatrimonioscanonicos'],
                                                        vsmcentrecatolicos = linha['vsmcentrecatolicos'],
                                                        vsmcentrecatolicoencatolico = linha['vsmcentrecatolicoencatolico'],
                                                        ecseditorascatolicas = linha['ecseditorascatolicas'],
                                                        ecslivrarias = linha['ecslivrarias'],
                                                        ecsjornaisdiarios = linha['ecsjornaisdiarios'],
                                                        ecsjornaissemanarios = linha['ecsjornaissemanarios'],
                                                        ecsjornaisquinzenarios = linha['ecsjornaisquinzenarios'],
                                                        ecsjornaismensarios = linha['ecsjornaismensarios'],
                                                        ecsboletinsparoquiais = linha['ecsboletinsparoquiais'],
                                                        ecsradiosregionais = linha['ecsradiosregionais'],
                                                        ecsradioslocais = linha['ecsradioslocais'],
                                                        obs = linha['obs'],
                                                        criado_por = linha['criado_por'],
                                                        criado = linha['criado'],
                                                        codigo_ecclesia = linha['codigo_ecclesia'],
                                                        alterado_por = linha['alterado_por'],
                                                        )
                except Exception, e:
                    print e
                    pass

        def getLinha(self, row):
            #print row
            return {
                    'id': row[0],
                    'ano': row[1],
                    'superficie': row[2],
                    'populacao': row[3],
                    'catolicos': row[4],
                    'arciprestados': row[5],
                    'paroquias': row[6],
                    'pclerodiocesano': row[7],
                    'pcleroreligioso': row[8],
                    'poutrosacerdote': row[9],
                    'pdiaconosper': row[10],
                    'preligiosas': row[11],
                    'pleigos': row[12],
                    'totalmentevacantes': row[13],
                    'capelanias': row[14],
                    'sacerdotesdiocesanos': row[15],
                    'spdiocesepropria': row[16],
                    'spnoutradiocese': row[17],
                    'foraservicopastoral': row[18],
                    'srrdiocese': row[19],
                    'srrtotalpartesdiocese': row[20],
                    'srrservicoinstituto': row[21],
                    'srrforaservicopastoral': row[22],
                    'religiososprofessosnsacerdotes': row[23],
                    'religiosasprofessasrd': row[24],
                    'diaconospermanentes': row[25],
                    'candidatossacerdocio': row[26],
                    'cscelrodiocesano': row[27],
                    'cscleroreligioso': row[28],
                    'cficlerodiocesano': row[29],
                    'cficleroreligioso': row[30],
                    'cieescolasmaternoinfantis': row[31],
                    'cieescolasprimarias': row[32],
                    'cieescolassecundarias': row[33],
                    'cieinstitutossuperiores': row[34],
                    'cieuniversidadecatolica': row[35],
                    'cashospitais': row[36],
                    'casambulatorios': row[37],
                    'cascasasdeidosos': row[38],
                    'casorfanatos': row[39],
                    'cascreches': row[40],
                    'casconsultoriosfamiliares': row[41],
                    'cascentrosespeciais': row[42],
                    'cascentrossociais': row[43],
                    'casconfrarias': row[44],
                    'casmisericordias': row[45],
                    'vsbaptizados': row[46],
                    'vsate1ano': row[47],
                    'vsde1a7anos': row[48],
                    'vsapos7anos': row[49],
                    'vsconfirmacoes': row[50],
                    'vsprimeirascomunhoes': row[51],
                    'vsmatrimonioscanonicos': row[52],
                    'vsmcentrecatolicos': row[53],
                    'vsmcentrecatolicoencatolico': row[54],
                    'ecseditorascatolicas': row[55],
                    'ecslivrarias': row[56],
                    'ecsjornaisdiarios': row[57],
                    'ecsjornaissemanarios': row[58],
                    'ecsjornaisquinzenarios': row[59],
                    'ecsjornaismensarios': row[60],
                    'ecsboletinsparoquiais': row[61],
                    'ecsradiosregionais': row[62],
                    'ecsradioslocais': row[63],
                    'obs': row[64],
                    'criado_por': User.objects.get(pk=row[65]),
                    'criado': datetime.fromtimestamp(row[66]),
                    'codigo_ecclesia': row[67],
                    #'alterado_por': self.User,
                    'alterado_por': User.objects.get(pk=row[65]),
                    }

    class ImportCabido(object):

        def __init__(self, conn, cur):
            self.conn = conn
            self.cur = cur
            #self.User = User.objects.get(pk=101)

        def importar(self):
            self.cur.execute('SELECT * FROM cabido')
            for row in self.cur:
                linha = self.getLinha(row)
                try:
                    dioceseModels.Cabido.objects.create(
                                                        id = linha['id'],
                                                        nome =  linha['nome'],
                                                        presidente =  linha['presidente'],
                                                        vice_presidente =  linha['vice_presidente'],
                                                        secretario =  linha['secretario'],
                                                        dignidades =  linha['dignidades'],
                                                        deao =  linha['deao'],
                                                        chantre =  linha['chantre'],
                                                        mestre_escola =  linha['mestre_escola'],
                                                        arcediago =  linha['arcediago'],
                                                        tesoureiro =  linha['tesoureiro'],
                                                        capitulares =  linha['capitulares'],
                                                        honorarios =  linha['honorarios'],
                                                        jubilados =  linha['jubilados'],
                                                        beneficiados =  linha['beneficiados'],
                                                        criado = linha['criado'],
                                                        criado_por = linha['criado_por'],
                                                        codigo_ecclesia =  linha['codigo_ecclesia'],
                                                        morada =  linha['morada'],
                                                        telefone =  linha['telefone'],
                                                        email =  linha['email'],
                                                        arcipreste =  linha['arcipreste'],
                                                        penitenciario =  linha['penitenciario'],
                                                        fax =  linha['fax'],
                                                        alterado_por = linha['alterado_por'],
                                                        )
                except Exception, e:
                    print e
                    pass

        def getLinha(self, row):
            #print row
            return {
                    'id': row[0],
                    'nome': row[1],
                    'presidente': row[2],
                    'vice_presidente': row[3],
                    'secretario': row[4],
                    'dignidades': row[5],
                    'deao': row[6],
                    'chantre': row[7],
                    'mestre_escola': row[8],
                    'arcediago': row[9],
                    'tesoureiro': row[10],
                    'capitulares': row[11],
                    'honorarios': row[12],
                    'jubilados': row[13],
                    'beneficiados': row[14],
                    'criado': datetime.fromtimestamp(row[15]),
                    'criado_por': User.objects.get(pk=row[16]),
                    'codigo_ecclesia': row[17],
                    'morada': row[18],
                    'telefone': row[19],
                    'email': row[20],
                    'arcipreste': row[21],
                    'penitenciario': row[22],
                    'fax': row[23],
                    #'alterado_por': self.User,
                    'alterado_por': User.objects.get(pk=row[16]),
                    }

    class ImportArciprestado(object):

        def __init__(self, conn, cur):
            self.conn = conn
            self.cur = cur
            #self.User = User.objects.get(pk=101)

        def importar(self):
            self.cur.execute('SELECT * FROM arciprestados')
            for row in self.cur:
                linha = self.getLinha(row)
                try:
                    dioceseModels.Arciprestado.objects.create(
                                                        id = linha['id'],
                                                        arciprestado =  linha['arciprestado'],
                                                        criado_por = linha['criado_por'],
                                                        criado = linha['criado'],
                                                        codigo_ecclesia =  linha['codigo_ecclesia'],
                                                        presbitero_arcipreste =  linha['presbitero_arcipreste'],
                                                        presbitero_arcipreste_adjunto =  linha['presbitero_arcipreste_adjunto'],
                                                        arcipreste =  linha['arcipreste'],
                                                        arcipreste_adjunto =  linha['arcipreste_adjunto'],
                                                        alterado_por =  linha['alterado_por'],
                                                        )
                except Exception, e:
                    print e
                    pass

        def getLinha(self, row):
            return {
                    'id': row[0],
                    'arciprestado': row[1],
                    'criado_por': User.objects.get(pk=row[2]),
                    'criado': datetime.strptime(str(row[3]) + str(' ') + str(row[4]), "%Y-%m-%d %H:%M:%S"),
                    'codigo_ecclesia': row[5],
                    'presbitero_arcipreste': dioceseModels.Presbitero.objects.get(pk=row[8]),
                    'presbitero_arcipreste_adjunto': dioceseModels.Presbitero.objects.get(pk=row[10]),
                    'arcipreste': row[6],
                    'arcipreste_adjunto': row[7],
                    #'alterado_por': self.User,
                    'alterado_por':  User.objects.get(pk=row[2]),
                    }

    class ImportParoquiaCleros(object):

        def __init__(self, obj, conn, cur):
            self.obj = obj
            self.conn = conn
            self.cur = cur
            #self.User = User.objects.get(pk=101)

        def importar(self):
            self.cur.execute('SELECT * FROM paroquias_clero WHERE cod_clero="'+str(self.obj.id)+'"')
            for row in self.cur:
                linha = self.getLinha(row)
                try:
                    if linha['padre1']==1 or linha['padre2']==1 or linha['padre3']==1:
                        obj = dioceseModels.Paroquia.objects.get(pk=linha['cod_paroquia'])
                        if linha['padre1']==1:
                            obj.padre1=self.obj
                            obj.save()
                        elif linha['padre2']==1:
                            obj.padre2=self.obj
                            obj.save()
                        elif linha['padre3']==1:
                            obj.padre3=self.obj
                            obj.save()

                except Exception, e:
                    print e
                    pass

        def getLinha(self, row):
            #print row
            return {
                    'cod_paroquia': row[1],
                    'cod_clero': row[2],
                    'padre1': row[8],
                    'padre2': row[9],
                    'padre3': row[9],
                    }

    class ImportParoquia(object):

        def __init__(self, conn, cur):
            self.conn = conn
            self.cur = cur
            #self.User = User.objects.get(pk=101)

        def importar(self):
            self.cur.execute('SELECT * FROM paroquias')
            for row in self.cur:
                linha = self.getLinha(row)
                try:
                    dioceseModels.Paroquia.objects.create(
                                                        id = linha['id'],
                                                        orago =  linha['orago'],
                                                        arciprestado = linha['arciprestado'],
                                                        nome =  linha['nome'],
                                                        paginaweb =  linha['paginaweb'],
                                                        email =  linha['email'],
                                                        morada =  linha['morada'],
                                                        codigo_postal =  linha['codigo_postal'],
                                                        localidade =  linha['localidade'],
                                                        telefone =  linha['telefone'],
                                                        fax =  linha['fax'],
                                                        criado_por = linha['criado_por'],
                                                        criado = linha['criado'],
                                                        codigo_ecclesia =  linha['codigo_ecclesia'],
                                                        alterado_por = linha['alterado_por'],
                                                        )

                except Exception, e:
                    print e
                    pass

        def getLinha(self, row):
            return {
                    'id': row[0],
                    'orago': row[1],
                    'arciprestado': get_arciprestado(row[2]),
                    'nome': row[3],
                    'paginaweb': row[4],
                    'email': row[5],
                    'morada': row[6],
                    'codigo_postal': get_codigo_postal(row[7]),
                    'localidade': get_localidade(row[7]),
                    'telefone': row[8],
                    'fax': row[9],
                    'criado_por': User.objects.get(pk=row[14]),
                    'criado': datetime.strptime(str(row[15]) + str(' ') + str(row[16]), "%Y-%m-%d %H:%M:%S"),
                    'codigo_ecclesia': row[17],
                    #'alterado_por': self.User,
                    'alterado_por': User.objects.get(pk=row[14]),
                    }

    class ImportBispo(object):

        def __init__(self, conn, cur):
            self.conn = conn
            self.cur = cur
            #self.User = User.objects.get(pk=101)

        def importar(self):
            self.cur.execute('SELECT * FROM clero WHERE cod_tipo_clero=8')
            for row in self.cur:
                linha = self.getLinha(row)
                try:
                    dioceseModels.Bispo.objects.create(
                                                        id = linha['id'],
                                                        nome = linha['nome'],
                                                        morada = linha['morada'],
                                                        codigo_postal = linha['codigo_postal'],
                                                        localidade = linha['localidade'],
                                                        telefone = linha['telefone'],
                                                        fax = linha['fax'],
                                                        email = linha['email'],
                                                        paginaweb = linha['paginaweb'],
                                                        data_nascimento = linha['data_nascimento'],
                                                        data_orden_presbiteral = linha['data_orden_presbiteral'],
                                                        telemovel_privado = linha['telemovel_privado'],
                                                        habilitacoes_academicas = linha['habilitacoes_academicas'],
                                                        fraternidade_sacerdotal = linha['fraternidade_sacerdotal'],
                                                        foto = linha['foto'],
                                                        nomeacoes = linha['nomeacoes'],
                                                        local_nascimento = linha['local_nascimento'],
                                                        local_ordenacao_presb = linha['local_ordenacao_presb'],
                                                        faleceu = linha['faleceu'],
                                                        data_faleceu = linha['data_faleceu'],
                                                        criado = linha['criado'],
                                                        criado_por = linha['criado_por'],
                                                        codigo_ecclesia = linha['codigo_ecclesia'],
                                                        data_orden_episc = linha['data_orden_episc'],
                                                        local_ordenacoa_episc = linha['local_ordenacoa_episc'],
                                                        data_tomada = linha['data_tomada'],
                                                        data_resignacao = linha['data_resignacao'],
                                                        bispo_tipo = linha['bispo_tipo'],
                                                        data_nomeacao = linha['data_nomeacao'],
                                                        alterado_por = linha['alterado_por'],
                                                        )
                except Exception, e:
                    print e
                    pass

        def getLinha(self, row):
            #print row
            return {
                    'id': row[0],
                    'nome': row[2],
                    'morada': row[3],
                    'codigo_postal': get_codigo_postal(row[4]),
                    'localidade': get_localidade(row[4]),
                    'telefone': row[5],
                    'fax': row[6],
                    'email': row[7],
                    'paginaweb': row[9],
                    'data_nascimento': get_strpdate(row[10]),
                    'data_orden_presbiteral': get_strpdate(row[11]),
                    'telemovel_privado': get_strpdate(row[15]),
                    'habilitacoes_academicas': row[20],
                    'fraternidade_sacerdotal': row[23],
                    'foto': row[25],
                    'nomeacoes': row[26],
                    'local_nascimento': row[27],
                    'local_ordenacao_presb': row[28],
                    'faleceu': row[29],
                    'data_faleceu': get_strpdate(row[30]),
                    'criado_por': User.objects.get(pk=row[32]),
                    'criado': datetime.strptime(str(row[33]) + str(' ') + str(row[34]), "%Y-%m-%d %H:%M:%S"),
                    'codigo_ecclesia': row[35],
                    'data_orden_episc': get_fromtimestamp(row[36]),
                    'local_ordenacoa_episc': row[37],
                    'data_tomada': get_fromtimestamp(row[38]),
                    'data_resignacao': get_fromtimestamp(row[39]),
                    'bispo_tipo': row[46],
                    'data_nomeacao': get_strpdate(row[47]),
                    #'alterado_por': self.User,
                    'alterado_por':  User.objects.get(pk=row[32]),
                    }

    class ImportPresbiteroRetiros(object):

        def __init__(self, obj, conn, cur):
            self.obj = obj
            self.conn = conn
            self.cur = cur
            #self.User = User.objects.get(pk=101)

        def importar(self):
            self.cur.execute('SELECT * FROM clero_retiros WHERE cod_clero="'+str(self.obj.id)+'"')
            for row in self.cur:
                linha = self.getLinha(row)
                try:
                    self.obj.diocese_presbiteroretiros_presbiteroretiros.create(
                                                        id = linha['id'],
                                                        ano = linha['ano'],
                                                        observacoes = linha['observacoes'],
                                                        )
                except Exception, e:
                    print e
                    pass

        def getLinha(self, row):
            #print row
            return {
                    'id': row[0],
                    'ano': row[2],
                    'observacoes': row[3],
                    }

    class ImportPresbitero(object):

        def __init__(self, conn, cur):
            self.conn = conn
            self.cur = cur
            #self.User = User.objects.get(pk=101)

        def importar(self):
            self.cur.execute('SELECT * FROM clero WHERE cod_tipo_clero=1 or cod_tipo_clero=3 or  cod_tipo_clero=4 or  cod_tipo_clero=5')
            for row in self.cur:
                linha = self.getLinha(row)
                try:
                    obj = dioceseModels.Presbitero.objects.create(
                                                        id = linha['id'],
                                                        tipo_clero = linha['tipo_clero'],
                                                        nome = linha['nome'],
                                                        morada = linha['morada'],
                                                        codigo_postal = linha['codigo_postal'],
                                                        localidade = linha['localidade'],
                                                        telefone = linha['telefone'],
                                                        fax = linha['fax'],
                                                        email = linha['email'],
                                                        igreja = linha['igreja'],
                                                        paginaweb = linha['paginaweb'],
                                                        data_nascimento = linha['data_nascimento'],
                                                        data_ordenacoa = linha['data_ordenacoa'],
                                                        clero_tipo = linha['clero_tipo'],
                                                        arcipreste = linha['arcipreste'],
                                                        vice_arcipreste = linha['vice_arcipreste'],
                                                        telemovel_privado = linha['telemovel_privado'],
                                                        paroco = linha['paroco'],
                                                        capelao = linha['capelao'],
                                                        reitor = linha['reitor'],
                                                        habilitacoes_academicas = linha['habilitacoes_academicas'],
                                                        publicacoes = linha['publicacoes'],
                                                        formacao_permanente = linha['formacao_permanente'],
                                                        fraternidade_sacerdotal = linha['fraternidade_sacerdotal'],
                                                        cartao_sacerdotal = linha['cartao_sacerdotal'],
                                                        foto = linha['foto'],
                                                        nomeacoes = linha['nomeacoes'],
                                                        local_nascimento = linha['local_nascimento'],
                                                        local_ordenacao = linha['local_ordenacao'],
                                                        faleceu = linha['faleceu'],
                                                        data_faleceu = linha['data_faleceu'],
                                                        criado = linha['criado'],
                                                        criado_por = linha['criado_por'],
                                                        codigo_ecclesia = linha['codigo_ecclesia'],
                                                        nomeacoes_actuais  = linha['nomeacoes_actuais'],
                                                        alterado_por = linha['alterado_por'],
                                                        )

                    ImportPresbiteroRetiros(obj, self.conn, self.conn.cursor()).importar()
                    #ImportParoquiaCleros(obj, self.conn, self.conn.cursor()).importar()
                except Exception, e:
                    print e
                    pass

        def getLinha(self, row):
            #print row
            return {
                    'id': row[0],
                    'tipo_clero': self.get_tipo_clero(row[1]),
                    'nome': row[2],
                    'morada': row[3],
                    'codigo_postal': self.get_codigo_postal(row[4]),
                    'localidade': self.get_localidade(row[4]),
                    'telefone': row[5],
                    'fax': row[6],
                    'email': row[7],
                    'igreja': row[8],
                    'paginaweb': row[9],
                    'data_nascimento': get_strpdate(row[10]),
                    'data_ordenacoa': get_strpdate(row[11]),
                    'clero_tipo': self.get_clero_tipo(row[12]),
                    'arcipreste': row[13],
                    'vice_arcipreste': row[14],
                    'telemovel_privado': row[15],
                    'paroco': row[16],
                    'capelao': row[18],
                    'reitor': row[19],
                    'habilitacoes_academicas': row[20],
                    'publicacoes': row[21],
                    'formacao_permanente': row[22],
                    'fraternidade_sacerdotal': row[23],
                    'cartao_sacerdotal': row[24],
                    'foto': row[25],
                    'nomeacoes': row[26],
                    'local_nascimento': row[27],
                    'local_ordenacao': row[28],
                    'faleceu': row[29],
                    'data_faleceu': get_strpdate(row[30]),
                    'criado_por': User.objects.get(pk=row[32]),
                    'criado': datetime.strptime(str(row[33]) + str(' ') + str(row[34]), "%Y-%m-%d %H:%M:%S"),
                    'nomeacoes_actuais': row[48],
                    'codigo_ecclesia': row[35],
                    #'alterado_por': self.User,
                    'alterado_por':  User.objects.get(pk=row[32]),
                    }

        def get_codigo_postal(self, val):
            if val is None:
                return None
            if val=='CANADÁ' or val=='D-90480 Nürnberg ALEMANHA' or val=='Díli 88010, Timor Leste' or val=='H2W 1G3' or val=='Providence, R.I. 02906-1799 USA':
                return val
            try:
                return val.split(' ')[:1][0]
            except Exception, e:
                print e
                return None

        def get_localidade(self, val):
            if val is None:
                return None
            if val=='CANADÁ' or val=='D-90480 Nürnberg ALEMANHA' or val=='Díli 88010, Timor Leste' or val=='H2W 1G3' or val=='Providence, R.I. 02906-1799 USA':
                return None
            try:
                return ' '.join(val.split(' ')[1:])
            except Exception, e:
                print e
                return None

        def get_clero_tipo(self, val):
            try:
                if val=='arquidiocesano':
                    return 2
                elif val=='arquidiocesano_residir_fora':
                    return 3
                elif val=='de_fora_a_residir_na_arquidiocese':
                    return 4
                elif val=='religioso':
                    return 1
            except Exception, e:
                print e
                return None

        def get_tipo_clero(self, val):
            try:
                if val==1:
                    return 1
                elif val==3:
                    return 2
                elif val==4:
                    return 3
                elif val==5:
                    return 4
            except Exception, e:
                print e
                return None

    class ImportPresbitero2(object):

        def __init__(self, conn, cur):
            self.conn = conn
            self.cur = cur
            #self.User = User.objects.get(pk=101)

        def importar(self):
            self.cur.execute('SELECT * FROM clero WHERE cod_tipo_clero=1 or cod_tipo_clero=3 or  cod_tipo_clero=4 or  cod_tipo_clero=5')
            for row in self.cur:
                linha = self.getLinha(row)
                try:
                    obj = dioceseModels.Presbitero.objects.get(
                                                        pk = linha['id']
                                                        )

                    ImportParoquiaCleros(obj, self.conn, self.conn.cursor()).importar()
                except Exception, e:
                    print e
                    pass

        def getLinha(self, row):
            #print row
            return {
                    'id': row[0],
                    'tipo_clero': self.get_tipo_clero(row[1]),
                    'nome': row[2],
                    'morada': row[3],
                    'codigo_postal': self.get_codigo_postal(row[4]),
                    'localidade': self.get_localidade(row[4]),
                    'telefone': row[5],
                    'fax': row[6],
                    'email': row[7],
                    'igreja': row[8],
                    'paginaweb': row[9],
                    'data_nascimento': get_strpdate(row[10]),
                    'data_ordenacoa': get_strpdate(row[11]),
                    'clero_tipo': self.get_clero_tipo(row[12]),
                    'arcipreste': row[13],
                    'vice_arcipreste': row[14],
                    'telemovel_privado': row[15],
                    'paroco': row[16],
                    'capelao': row[18],
                    'reitor': row[19],
                    'habilitacoes_academicas': row[20],
                    'publicacoes': row[21],
                    'formacao_permanente': row[22],
                    'fraternidade_sacerdotal': row[23],
                    'cartao_sacerdotal': row[24],
                    'foto': row[25],
                    'nomeacoes': row[26],
                    'local_nascimento': row[27],
                    'local_ordenacao': row[28],
                    'faleceu': row[29],
                    'data_faleceu': get_strpdate(row[30]),
                    'criado_por': User.objects.get(pk=row[32]),
                    'criado': datetime.strptime(str(row[33]) + str(' ') + str(row[34]), "%Y-%m-%d %H:%M:%S"),
                    'nomeacoes_actuais': row[48],
                    'codigo_ecclesia': row[35],
                    #'alterado_por': self.User,
                    'alterado_por':  User.objects.get(pk=row[32]),
                    }

        def get_codigo_postal(self, val):
            if val is None:
                return None
            if val=='CANADÁ' or val=='D-90480 Nürnberg ALEMANHA' or val=='Díli 88010, Timor Leste' or val=='H2W 1G3' or val=='Providence, R.I. 02906-1799 USA':
                return val
            try:
                return val.split(' ')[:1][0]
            except Exception, e:
                print e
                return None

        def get_localidade(self, val):
            if val is None:
                return None
            if val=='CANADÁ' or val=='D-90480 Nürnberg ALEMANHA' or val=='Díli 88010, Timor Leste' or val=='H2W 1G3' or val=='Providence, R.I. 02906-1799 USA':
                return None
            try:
                return ' '.join(val.split(' ')[1:])
            except Exception, e:
                print e
                return None

        def get_clero_tipo(self, val):
            try:
                if val=='arquidiocesano':
                    return 2
                elif val=='arquidiocesano_residir_fora':
                    return 3
                elif val=='de_fora_a_residir_na_arquidiocese':
                    return 4
                elif val=='religioso':
                    return 1
            except Exception, e:
                print e
                return None

        def get_tipo_clero(self, val):
            try:
                if val==1:
                    return 1
                elif val==3:
                    return 2
                elif val==4:
                    return 3
                elif val==5:
                    return 4
            except Exception, e:
                print e
                return None

    class ImportDiaconoPermanenteRetiros(object):

        def __init__(self, obj, conn, cur):
            self.obj = obj
            self.conn = conn
            self.cur = cur
            #self.User = User.objects.get(pk=101)

        def importar(self):
            self.cur.execute('SELECT * FROM clero_retiros WHERE cod_clero="'+str(self.obj.id)+'"')
            for row in self.cur:
                linha = self.getLinha(row)
                try:
                    self.obj.diocese_diaconopermanenteretiros_diaconopermanenteretiros.create(
                                                        id = linha['id'],
                                                        ano = linha['ano'],
                                                        observacoes = linha['observacoes'],
                                                        )
                except Exception, e:
                    print e
                    pass

        def getLinha(self, row):
            #print row
            return {
                    'id': row[0],
                    'ano': row[2],
                    'observacoes': row[3],
                    }

    class ImportDiaconoPermanente(object):

        def __init__(self, conn, cur):
            self.conn = conn
            self.cur = cur
            #self.User = User.objects.get(pk=101)

        def importar(self):
            self.cur.execute('SELECT * FROM clero WHERE cod_tipo_clero=7')
            for row in self.cur:
                linha = self.getLinha(row)
                try:
                    obj = dioceseModels.DiaconoPermanente.objects.create(
                                                        id = linha['id'],
                                                        nome = linha['nome'],
                                                        morada = linha['morada'],
                                                        codigo_postal = linha['codigo_postal'],
                                                        localidade = linha['localidade'],
                                                        telefone = linha['telefone'],
                                                        fax = linha['fax'],
                                                        email = linha['email'],
                                                        paginaweb = linha['paginaweb'],
                                                        data_nascimento = linha['data_nascimento'],
                                                        data_ordenacoa = linha['data_ordenacoa'],
                                                        telemovel_privado = linha['telemovel_privado'],
                                                        cartao_sacerdotal = linha['cartao_sacerdotal'],
                                                        foto = linha['foto'],
                                                        nomeacoes = linha['nomeacoes'],
                                                        local_nascimento = linha['local_nascimento'],
                                                        local_ordenacao = linha['local_ordenacao'],
                                                        faleceu = linha['faleceu'],
                                                        data_faleceu = linha['data_faleceu'],
                                                        delegado_coordenador = linha['delegado_coordenador'],
                                                        criado = linha['criado'],
                                                        criado_por = linha['criado_por'],
                                                        codigo_ecclesia = linha['codigo_ecclesia'],
                                                        alterado_por = linha['alterado_por'],
                                                        )

                    ImportDiaconoPermanenteRetiros(obj, self.conn, self.conn.cursor()).importar()
                except Exception, e:
                    print e
                    pass

        def getLinha(self, row):
            #print row
            return {
                    'id': row[0],
                    'nome': row[2],
                    'morada': row[3],
                    'codigo_postal': self.get_codigo_postal(row[4]),
                    'localidade': self.get_localidade(row[4]),
                    'telefone': row[5],
                    'fax': row[6],
                    'email': row[7],
                    'paginaweb': row[9],
                    'data_nascimento': get_strpdate(row[10]),
                    'data_ordenacoa': get_strpdate(row[11]),
                    'telemovel_privado': row[15],
                    'cartao_sacerdotal': row[24],
                    'foto': row[25],
                    'nomeacoes': row[26],
                    'local_nascimento': row[27],
                    'local_ordenacao': row[28],
                    'faleceu': row[29],
                    'data_faleceu': get_strpdate(row[30]),
                    'criado_por': User.objects.get(pk=row[32]),
                    'criado': datetime.strptime(str(row[33]) + str(' ') + str(row[34]), "%Y-%m-%d %H:%M:%S"),
                    'codigo_ecclesia': row[35],
                    'delegado_coordenador': row[40],
                    #'alterado_por': self.User,
                    'alterado_por':  User.objects.get(pk=row[32]),
                    }

        def get_codigo_postal(self, val):
            if val == None:
                return None
            if val=='CANADÁ' or val=='D-90480 Nürnberg ALEMANHA' or val=='Díli 88010, Timor Leste' or val=='H2W 1G3' or val=='Providence, R.I. 02906-1799 USA':
                return val
            try:
                return val.split(' ')[:1][0]
            except Exception, e:
                print e
                return None

        def get_localidade(self, val):
            if val == None:
                return None
            if val=='CANADÁ' or val=='D-90480 Nürnberg ALEMANHA' or val=='Díli 88010, Timor Leste' or val=='H2W 1G3' or val=='Providence, R.I. 02906-1799 USA':
                return None
            try:
                return ' '.join(val.split(' ')[1:])
            except Exception, e:
                print e
                return None

    class ImportCuriaDiocesana(object):

        def __init__(self, conn, cur):
            self.conn = conn
            self.cur = cur
            #self.User = User.objects.get(pk=101)

        def importar(self):
            self.cur.execute('SELECT * FROM instituicoes WHERE cod_tipo_instituicao=33')
            for row in self.cur:
                linha = self.getLinha(row)
                try:
                    dioceseModels.CuriaDiocesana.objects.create(
                                                        id = linha['id'],
                                                        nome = linha['nome'],
                                                        morada = linha['morada'],
                                                        codigo_postal = linha['codigo_postal'],
                                                        localidade = linha['localidade'],
                                                        telefone = linha['telefone'],
                                                        fax = linha['fax'],
                                                        email = linha['email'],
                                                        paginaweb = linha['paginaweb'],
                                                        arciprestado = linha['arciprestado'],
                                                        criado_por = linha['criado_por'],
                                                        criado = linha['criado'],
                                                        director = linha['director'],
                                                        horarios = linha['horarios'],
                                                        conselho_episcopal = linha['conselho_episcopal'],
                                                        moderador = linha['moderador'],
                                                        vigarios_gerais = linha['vigarios_gerais'],
                                                        vigarios_gerais_ad = linha['vigarios_gerais_ad'],
                                                        provigario_geral = linha['provigario_geral'],
                                                        direvigarios_episcopais = linha['direvigarios_episcopais'],
                                                        delegados_episcopais = linha['delegados_episcopais'],
                                                        secretaria_episcopal = linha['secretaria_episcopal'],
                                                        chefe_gabinete = linha['chefe_gabinete'],
                                                        gabinete_informacao = linha['gabinete_informacao'],
                                                        chanceler = linha['chanceler'],
                                                        secretariado_geral = linha['secretariado_geral'],
                                                        consultor_juridico = linha['consultor_juridico'],
                                                        servico_legados_pios = linha['servico_legados_pios'],
                                                        associacoes_religiosas = linha['associacoes_religiosas'],
                                                        arquivo_secreto = linha['arquivo_secreto'],
                                                        arquivo_historico = linha['arquivo_historico'],
                                                        codigo_ecclesia = linha['codigo_ecclesia'],
                                                        notario = linha['notario'],
                                                        telemovel = linha['telemovel'],
                                                        feriados = linha['feriados'],
                                                        administradorcasaarquiepiscopal = linha['administradorcasaarquiepiscopal'],
                                                        alterado_por = linha['alterado_por'],
                                                        )
                except Exception, e:
                    print e
                    pass

        def getLinha(self, row):
            #print row
            return {
                    'id': row[0],
                    'nome': row[1],
                    'morada': row[3],
                    'codigo_postal': get_codigo_postal(row[4]),
                    'localidade': get_localidade(row[4]),
                    'telefone': row[5],
                    'fax': row[6],
                    'email': row[7],
                    'paginaweb': row[8],
                    'arciprestado': get_arciprestado(row[9]),
                    'criado_por': User.objects.get(pk=row[10]),
                    'criado': datetime.strptime(str(row[11]) + str(' ') + str(row[12]), "%Y-%m-%d %H:%M:%S"),
                    'director': row[13],
                    'horarios': row[44],
                    'conselho_episcopal': row[45],
                    'moderador': row[46],
                    'vigarios_gerais': row[47],
                    'vigarios_gerais_ad': row[48],
                    'provigario_geral': row[49],
                    'direvigarios_episcopais': row[50],
                    'delegados_episcopais': row[51],
                    'secretaria_episcopal': row[52],
                    'chefe_gabinete': row[53],
                    'gabinete_informacao': row[54],
                    'chanceler': row[56],
                    'secretariado_geral': row[58],
                    'consultor_juridico': row[59],
                    'servico_legados_pios': row[60],
                    'associacoes_religiosas': row[61],
                    'arquivo_secreto': row[62],
                    'arquivo_historico': row[63],
                    'codigo_ecclesia': row[70],
                    'notario': row[75],
                    'telemovel': (row[78] if row[78] is not None else str('')) + (str('/') if row[78] is not None and row[79] is not None else str('')) + (row[79] if row[79] is not None else str('')),
                    'feriados': row[80],
                    'administradorcasaarquiepiscopal': row[82],
                    #'alterado_por': self.User,
                    'alterado_por': User.objects.get(pk=row[10]),
                    }

    class ImportChancelaria(object):

        def __init__(self, conn, cur):
            self.conn = conn
            self.cur = cur
            #self.User = User.objects.get(pk=101)

        def importar(self):
            self.cur.execute('SELECT * FROM instituicoes WHERE cod_tipo_instituicao=35')
            for row in self.cur:
                linha = self.getLinha(row)
                try:
                    dioceseModels.Chancelaria.objects.create(
                                                        id = linha['id'],
                                                        nome = linha['nome'],
                                                        morada = linha['morada'],
                                                        codigo_postal = linha['codigo_postal'],
                                                        localidade = linha['localidade'],
                                                        telefone = linha['telefone'],
                                                        fax = linha['fax'],
                                                        email = linha['email'],
                                                        paginaweb = linha['paginaweb'],
                                                        arciprestado = linha['arciprestado'],
                                                        criado_por = linha['criado_por'],
                                                        criado = linha['criado'],
                                                        chanceler = linha['chanceler'],
                                                        vice_chanceler = linha['vice_chanceler'],
                                                        secretariado_deral = linha['secretariado_deral'],
                                                        consultor_juridico = linha['consultor_juridico'],
                                                        servico_del_pios = linha['servico_del_pios'],
                                                        associacoes_religiosas = linha['associacoes_religiosas'],
                                                        arquivo_secreto = linha['arquivo_secreto'],
                                                        arquivo_historico = linha['arquivo_historico'],
                                                        codigo_ecclesia = linha['codigo_ecclesia'],
                                                        notario = linha['notario'],
                                                        telemovel = linha['telemovel'],
                                                        alterado_por = linha['alterado_por'],
                                                        )
                except Exception, e:
                    print e
                    pass

        def getLinha(self, row):
            #print row
            return {
                    'id': row[0],
                    'nome': row[1],
                    'morada': row[3],
                    'codigo_postal': get_codigo_postal(row[4]),
                    'localidade': get_localidade(row[4]),
                    'telefone': row[5],
                    'fax': row[6],
                    'email': row[7],
                    'paginaweb': row[8],
                    'arciprestado': get_arciprestado(row[9]),
                    'criado_por': User.objects.get(pk=row[10]),
                    'criado': datetime.strptime(str(row[11]) + str(' ') + str(row[12]), "%Y-%m-%d %H:%M:%S"),
                    'chanceler': row[56],
                    'vice_chanceler': row[57],
                    'secretariado_deral': row[58],
                    'consultor_juridico': row[59],
                    'servico_del_pios': row[60],
                    'associacoes_religiosas': row[61],
                    'arquivo_secreto': row[62],
                    'arquivo_historico': row[63],
                    'codigo_ecclesia': row[70],
                    'notario': row[75],
                    'telemovel': (row[78] if row[78] is not None else str('')) + (str('/') if row[78] is not None and row[79] is not None else str('')) + (row[79] if row[79] is not None else str('')),
                    #'alterado_por': self.User,
                    'alterado_por': User.objects.get(pk=row[10]),
                    }

    class ImportGestaoRecursos(object):

        def __init__(self, conn, cur):
            self.conn = conn
            self.cur = cur
            #self.User = User.objects.get(pk=101)

        def importar(self):
            self.cur.execute('SELECT * FROM instituicoes WHERE cod_tipo_instituicao=28')
            for row in self.cur:
                linha = self.getLinha(row)
                try:
                    dioceseModels.GestaoRecursos.objects.create(
                                                        id = linha['id'],
                                                        nome = linha['nome'],
                                                        morada = linha['morada'],
                                                        codigo_postal = linha['codigo_postal'],
                                                        localidade = linha['localidade'],
                                                        telefone = linha['telefone'],
                                                        fax = linha['fax'],
                                                        email = linha['email'],
                                                        paginaweb = linha['paginaweb'],
                                                        arciprestado = linha['arciprestado'],
                                                        criado_por = linha['criado_por'],
                                                        criado = linha['criado'],
                                                        membros_natos = linha['membros_natos'],
                                                        membros_eleitos = linha['membros_eleitos'],
                                                        economo = linha['economo'],
                                                        assuntos_economicos = linha['assuntos_economicos'],
                                                        tesouraria = linha['tesouraria'],
                                                        codigo_ecclesia = linha['codigo_ecclesia'],
                                                        telemovel = linha['telemovel'],
                                                        alterado_por = linha['alterado_por'],
                                                        )
                except Exception, e:
                    print e
                    pass

        def getLinha(self, row):
            #print row
            return {
                    'id': row[0],
                    'nome': row[1],
                    'morada': row[3],
                    'codigo_postal': get_codigo_postal(row[4]),
                    'localidade': get_localidade(row[4]),
                    'telefone': row[5],
                    'fax': row[6],
                    'email': row[7],
                    'paginaweb': row[8],
                    'arciprestado': get_arciprestado(row[9]),
                    'criado_por': User.objects.get(pk=row[10]),
                    'criado': datetime.strptime(str(row[11]) + str(' ') + str(row[12]), "%Y-%m-%d %H:%M:%S"),
                    'membros_natos': row[15],
                    'membros_eleitos': row[17],
                    'economo': row[20],
                    'assuntos_economicos': row[27],
                    'tesouraria': row[64],
                    'codigo_ecclesia': row[70],
                    'telemovel': (row[78] if row[78] is not None else str('')) + (str('/') if row[78] is not None and row[79] is not None else str('')) + (row[79] if row[79] is not None else str('')),
                    #'alterado_por': self.User,
                    'alterado_por': User.objects.get(pk=row[10]),
                    }

    class ImportConselhoPresbiteral(object):

        def __init__(self, conn, cur):
            self.conn = conn
            self.cur = cur
            #self.User = User.objects.get(pk=101)

        def importar(self):
            self.cur.execute('SELECT * FROM instituicoes WHERE cod_tipo_instituicao=26')
            for row in self.cur:
                linha = self.getLinha(row)
                try:
                    dioceseModels.ConselhoPresbiteral.objects.create(
                                                        id = linha['id'],
                                                        nome = linha['nome'],
                                                        morada = linha['morada'],
                                                        codigo_postal = linha['codigo_postal'],
                                                        localidade = linha['localidade'],
                                                        telefone = linha['telefone'],
                                                        fax = linha['fax'],
                                                        email = linha['email'],
                                                        paginaweb = linha['paginaweb'],
                                                        arciprestado = linha['arciprestado'],
                                                        criado_por = linha['criado_por'],
                                                        criado = linha['criado'],
                                                        membros_natos = linha['membros_natos'],
                                                        designados_bispo = linha['designados_bispo'],
                                                        por_eleicao = linha['por_eleicao'],
                                                        associados_presidencia = linha['associados_presidencia'],
                                                        codigo_ecclesia = linha['codigo_ecclesia'],
                                                        conselho_permanente = linha['conselho_permanente'],
                                                        alterado_por = linha['alterado_por'],
                                                        )
                except Exception, e:
                    print e
                    pass

        def getLinha(self, row):
            #print row
            return {
                    'id': row[0],
                    'nome': row[1],
                    'morada': row[3],
                    'codigo_postal': get_codigo_postal(row[4]),
                    'localidade': get_localidade(row[4]),
                    'telefone': row[5],
                    'fax': row[6],
                    'email': row[7],
                    'paginaweb': row[8],
                    'arciprestado': get_arciprestado(row[9]),
                    'criado_por': User.objects.get(pk=row[10]),
                    'criado': datetime.strptime(str(row[11]) + str(' ') + str(row[12]), "%Y-%m-%d %H:%M:%S"),
                    'membros_natos': row[15],
                    'designados_bispo': row[16],
                    'por_eleicao': row[17],
                    'associados_presidencia': row[25],
                    'codigo_ecclesia': row[70],
                    'conselho_permanente': row[15]+str(', ')+row[17]+str(', ')+row[16],
                    #'alterado_por': self.User,
                    'alterado_por': User.objects.get(pk=row[10]),
                    }

    class ImportColegioConsultores(object):

        def __init__(self, conn, cur):
            self.conn = conn
            self.cur = cur
            #self.User = User.objects.get(pk=101)

        def importar(self):
            self.cur.execute('SELECT * FROM instituicoes WHERE cod_tipo_instituicao=31')
            for row in self.cur:
                linha = self.getLinha(row)
                try:
                    dioceseModels.ColegioConsultores.objects.create(
                                                        id = linha['id'],
                                                        nome = linha['nome'],
                                                        criado_por = linha['criado_por'],
                                                        criado = linha['criado'],
                                                        colegio_consultores = linha['colegio_consultores'],
                                                        codigo_ecclesia = linha['codigo_ecclesia'],
                                                        alterado_por = linha['alterado_por'],
                                                        )
                except Exception, e:
                    print e
                    pass

        def getLinha(self, row):
            #print row
            return {
                    'id': row[0],
                    'nome': row[1],
                    'morada': row[3],
                    'codigo_postal': get_codigo_postal(row[4]),
                    'localidade': get_localidade(row[4]),
                    'telefone': row[5],
                    'fax': row[6],
                    'email': row[7],
                    'paginaweb': row[8],
                    'arciprestado': get_arciprestado(row[9]),
                    'criado_por': User.objects.get(pk=row[10]),
                    'criado': datetime.strptime(str(row[11]) + str(' ') + str(row[12]), "%Y-%m-%d %H:%M:%S"),
                    'colegio_consultores': row[37],
                    'codigo_ecclesia': row[70],
                    #'alterado_por': self.User,
                    'alterado_por': User.objects.get(pk=row[10]),
                    }

    class ImportConselhoPastoral(object):

        def __init__(self, conn, cur):
            self.conn = conn
            self.cur = cur
            #self.User = User.objects.get(pk=101)

        def importar(self):
            self.cur.execute('SELECT * FROM instituicoes WHERE cod_tipo_instituicao=25')
            for row in self.cur:
                linha = self.getLinha(row)
                try:
                    dioceseModels.ConselhoPastoral.objects.create(
                                                        id = linha['id'],
                                                        nome = linha['nome'],
                                                        morada = linha['morada'],
                                                        codigo_postal = linha['codigo_postal'],
                                                        localidade = linha['localidade'],
                                                        telefone = linha['telefone'],
                                                        fax = linha['fax'],
                                                        email = linha['email'],
                                                        paginaweb = linha['paginaweb'],
                                                        arciprestado = linha['arciprestado'],
                                                        criado_por = linha['criado_por'],
                                                        criado = linha['criado'],
                                                        membros_natos = linha['membros_natos'],
                                                        membros_designados = linha['membros_designados'],
                                                        membros_eleitos = linha['membros_eleitos'],
                                                        mandato = linha['mandato'],
                                                        codigo_ecclesia = linha['codigo_ecclesia'],
                                                        comissao_permanente = linha['comissao_permanente'],
                                                        alterado_por = linha['alterado_por'],
                                                        )
                except Exception, e:
                    print e
                    pass

        def getLinha(self, row):
            #print row
            return {
                    'id': row[0],
                    'nome': row[1],
                    'morada': row[3],
                    'codigo_postal': get_codigo_postal(row[4]),
                    'localidade': get_localidade(row[4]),
                    'telefone': row[5],
                    'fax': row[6],
                    'email': row[7],
                    'paginaweb': row[8],
                    'arciprestado': get_arciprestado(row[9]),
                    'criado_por': User.objects.get(pk=row[10]),
                    'criado': datetime.strptime(str(row[11]) + str(' ') + str(row[12]), "%Y-%m-%d %H:%M:%S"),
                    'membros_natos': row[15],
                    'membros_designados': row[16],
                    'membros_eleitos': row[17],
                    'mandato': row[23],
                    'codigo_ecclesia': row[70],
                    'comissao_permanente': row[72],
                    #'alterado_por': self.User,
                    'alterado_por': User.objects.get(pk=row[10]),
                    }

    class ImportColegioArciprestes(object):

        def __init__(self, conn, cur):
            self.conn = conn
            self.cur = cur
            #self.User = User.objects.get(pk=101)

        def importar(self):
            self.cur.execute('SELECT * FROM instituicoes WHERE cod_tipo_instituicao=40')
            for row in self.cur:
                linha = self.getLinha(row)
                try:
                    dioceseModels.ColegioArciprestes.objects.create(
                                                        id = linha['id'],
                                                        nome = linha['nome'],
                                                        morada = linha['morada'],
                                                        codigo_postal = linha['codigo_postal'],
                                                        localidade = linha['localidade'],
                                                        telefone = linha['telefone'],
                                                        fax = linha['fax'],
                                                        email = linha['email'],
                                                        paginaweb = linha['paginaweb'],
                                                        arciprestado = linha['arciprestado'],
                                                        criado_por = linha['criado_por'],
                                                        criado = linha['criado'],
                                                        codigo_ecclesia = linha['codigo_ecclesia'],
                                                        colegio_arciprestes = linha['colegio_arciprestes'],
                                                        alterado_por = linha['alterado_por'],
                                                        )
                except Exception, e:
                    print e
                    pass

        def getLinha(self, row):
            #print row
            return {
                    'id': row[0],
                    'nome': row[1],
                    'morada': row[3],
                    'codigo_postal': get_codigo_postal(row[4]),
                    'localidade': get_localidade(row[4]),
                    'telefone': row[5],
                    'fax': row[6],
                    'email': row[7],
                    'paginaweb': row[8],
                    'arciprestado': get_arciprestado(row[9]),
                    'criado_por': User.objects.get(pk=row[10]),
                    'criado': datetime.strptime(str(row[11]) + str(' ') + str(row[12]), "%Y-%m-%d %H:%M:%S"),
                    'codigo_ecclesia': row[70],
                    'colegio_arciprestes': row[76],
                    #'alterado_por': self.User,
                    'alterado_por': User.objects.get(pk=row[10]),
                    }

    class ImportSecretariado(object):

        def __init__(self, conn, cur):
            self.conn = conn
            self.cur = cur
            #self.User = User.objects.get(pk=101)

        def importar(self):
            self.cur.execute('SELECT * FROM instituicoes WHERE cod_tipo_instituicao=29')
            for row in self.cur:
                linha = self.getLinha(row)
                try:
                    dioceseModels.Secretariado.objects.create(
                                                        id = linha['id'],
                                                        nome = linha['nome'],
                                                        morada = linha['morada'],
                                                        codigo_postal = linha['codigo_postal'],
                                                        localidade = linha['localidade'],
                                                        telefone = linha['telefone'],
                                                        fax = linha['fax'],
                                                        email = linha['email'],
                                                        paginaweb = linha['paginaweb'],
                                                        arciprestado = linha['arciprestado'],
                                                        criado_por = linha['criado_por'],
                                                        criado = linha['criado'],
                                                        director =  linha['director'],
                                                        assistente =  linha['assistente'],
                                                        coordenador =  linha['coordenador'],
                                                        codigo_ecclesia = linha['codigo_ecclesia'],
                                                        sector_departamento = linha['sector_departamento'],
                                                        telemovel =  linha['telemovel'],
                                                        alterado_por = linha['alterado_por'],
                                                        )
                except Exception, e:
                    print e
                    pass

        def getLinha(self, row):
            #print row
            return {
                    'id': row[0],
                    'nome': row[1],
                    'morada': row[3],
                    'codigo_postal': get_codigo_postal(row[4]),
                    'localidade': get_localidade(row[4]),
                    'telefone': row[5],
                    'fax': row[6],
                    'email': row[7],
                    'paginaweb': row[8],
                    'arciprestado': get_arciprestado(row[9]),
                    'criado_por': User.objects.get(pk=row[10]),
                    'criado': datetime.strptime(str(row[11]) + str(' ') + str(row[12]), "%Y-%m-%d %H:%M:%S"),
                    'director': row[13],
                    'assistente': row[18],
                    'coordenador': row[55],
                    'codigo_ecclesia': row[70],
                    'sector_departamento': row[74],
                    'telemovel': (row[78] if row[78] is not None else str('')) + (str('/') if row[78] is not None and row[79] is not None else str('')) + (row[79] if row[79] is not None else str('')),
                    #'alterado_por': self.User,
                    'alterado_por': User.objects.get(pk=row[10]),
                    }

    class ImportComissao(object):

        def __init__(self, conn, cur):
            self.conn = conn
            self.cur = cur
            #self.User = User.objects.get(pk=101)

        def importar(self):
            self.cur.execute('SELECT * FROM instituicoes WHERE cod_tipo_instituicao=19')
            for row in self.cur:
                linha = self.getLinha(row)
                try:
                    dioceseModels.Comissao.objects.create(
                                                        id = linha['id'],
                                                        nome = linha['nome'],
                                                        morada = linha['morada'],
                                                        codigo_postal = linha['codigo_postal'],
                                                        localidade = linha['localidade'],
                                                        telefone = linha['telefone'],
                                                        fax = linha['fax'],
                                                        email = linha['email'],
                                                        paginaweb = linha['paginaweb'],
                                                        arciprestado = linha['arciprestado'],
                                                        criado_por = linha['criado_por'],
                                                        criado = linha['criado'],
                                                        presidente =  linha['presidente'],
                                                        assistente =  linha['assistente'],
                                                        membros =  linha['membros'],
                                                        codigo_ecclesia = linha['codigo_ecclesia'],
                                                        sector_departamento = linha['sector_departamento'],
                                                        telemovel =  linha['telemovel'],
                                                        alterado_por = linha['alterado_por'],
                                                        )
                except Exception, e:
                    print e
                    pass

        def getLinha(self, row):
            #print row
            return {
                    'id': row[0],
                    'nome': row[1],
                    'morada': row[3],
                    'codigo_postal': get_codigo_postal(row[4]),
                    'localidade': get_localidade(row[4]),
                    'telefone': row[5],
                    'fax': row[6],
                    'email': row[7],
                    'paginaweb': row[8],
                    'arciprestado': get_arciprestado(row[9]),
                    'criado_por': User.objects.get(pk=row[10]),
                    'criado': datetime.strptime(str(row[11]) + str(' ') + str(row[12]), "%Y-%m-%d %H:%M:%S"),
                    'presidente': row[13],
                    'assistente': row[18],
                    'membros': row[19],
                    'codigo_ecclesia': row[70],
                    'sector_departamento': row[74],
                    'telemovel': (row[78] if row[78] is not None else str('')) + (str('/') if row[78] is not None and row[79] is not None else str('')) + (row[79] if row[79] is not None else str('')),
                    #'alterado_por': self.User,
                    'alterado_por': User.objects.get(pk=row[10]),
                    }

    class ImportTribunalEclesiastico(object):

        def __init__(self, conn, cur):
            self.conn = conn
            self.cur = cur
            #self.User = User.objects.get(pk=101)

        def importar(self):
            self.cur.execute('SELECT * FROM instituicoes WHERE cod_tipo_instituicao=30')
            for row in self.cur:
                linha = self.getLinha(row)
                try:
                    dioceseModels.TribunalEclesiastico.objects.create(
                                                        id = linha['id'],
                                                        nome = linha['nome'],
                                                        morada = linha['morada'],
                                                        codigo_postal = linha['codigo_postal'],
                                                        localidade = linha['localidade'],
                                                        telefone = linha['telefone'],
                                                        fax = linha['fax'],
                                                        email = linha['email'],
                                                        paginaweb = linha['paginaweb'],
                                                        arciprestado = linha['arciprestado'],
                                                        criado_por = linha['criado_por'],
                                                        criado = linha['criado'],
                                                        vigario_judicial = linha['vigario_judicial'],
                                                        vigariojudicialad = linha['vigariojudicialad'],
                                                        juizes_diocesanos = linha['juizes_diocesanos'],
                                                        auditores = linha['auditores'],
                                                        promotor_justica = linha['promotor_justica'],
                                                        defensor_vinculo = linha['defensor_vinculo'],
                                                        notario_actuario = linha['notario_actuario'],
                                                        advogados_oficio = linha['advogados_oficio'],
                                                        meirinho = linha['meirinho'],
                                                        codigo_ecclesia = linha['codigo_ecclesia'],
                                                        telemovel =  linha['telemovel'],
                                                        alterado_por = linha['alterado_por'],
                                                        )
                except Exception, e:
                    print e
                    pass

        def getLinha(self, row):
            #print row
            return {
                    'id': row[0],
                    'nome': row[1],
                    'morada': row[3],
                    'codigo_postal': get_codigo_postal(row[4]),
                    'localidade': get_localidade(row[4]),
                    'telefone': row[5],
                    'fax': row[6],
                    'email': row[7],
                    'paginaweb': row[8],
                    'arciprestado': get_arciprestado(row[9]),
                    'criado_por': User.objects.get(pk=row[10]),
                    'criado': datetime.strptime(str(row[11]) + str(' ') + str(row[12]), "%Y-%m-%d %H:%M:%S"),
                    'vigario_judicial': row[28],
                    'vigariojudicialad': row[29],
                    'juizes_diocesanos': row[30],
                    'auditores': row[31],
                    'promotor_justica': row[32],
                    'defensor_vinculo': row[33],
                    'notario_actuario': row[34],
                    'advogados_oficio': row[35],
                    'meirinho': row[36],
                    'codigo_ecclesia': row[70],
                    'telemovel': (row[78] if row[78] is not None else str('')) + (str('/') if row[78] is not None and row[79] is not None else str('')) + (row[79] if row[79] is not None else str('')),
                    #'alterado_por': self.User,
                    'alterado_por': User.objects.get(pk=row[10]),
                    }

    class ImportSeminario(object):

        def __init__(self, conn, cur):
            self.conn = conn
            self.cur = cur
            #self.User = User.objects.get(pk=101)

        def importar(self):
            self.cur.execute('SELECT * FROM instituicoes WHERE cod_tipo_instituicao=1')
            for row in self.cur:
                linha = self.getLinha(row)
                try:
                    dioceseModels.Seminario.objects.create(
                                                        id = linha['id'],
                                                        nome = linha['nome'],
                                                        morada = linha['morada'],
                                                        codigo_postal = linha['codigo_postal'],
                                                        localidade = linha['localidade'],
                                                        telefone = linha['telefone'],
                                                        fax = linha['fax'],
                                                        email = linha['email'],
                                                        paginaweb = linha['paginaweb'],
                                                        arciprestado = linha['arciprestado'],
                                                        criado_por = linha['criado_por'],
                                                        criado = linha['criado'],
                                                        economo = linha['economo'],
                                                        reitor = linha['reitor'],
                                                        vice_reitor = linha['vice_reitor'],
                                                        prefeito = linha['prefeito'],
                                                        confessor = linha['confessor'],
                                                        director_espiritual = linha['director_espiritual'],
                                                        equipa_resp = linha['equipa_resp'],
                                                        tesoureiro = linha['tesoureiro'],
                                                        codigo_ecclesia = linha['codigo_ecclesia'],
                                                        secretario =  linha['secretario'],
                                                        telemovel =  linha['telemovel'],
                                                        alterado_por = linha['alterado_por'],
                                                        )
                except Exception, e:
                    print e
                    pass

        def getLinha(self, row):
            #print row
            return {
                    'id': row[0],
                    'nome': row[1],
                    'morada': row[3],
                    'codigo_postal': get_codigo_postal(row[4]),
                    'localidade': get_localidade(row[4]),
                    'telefone': row[5],
                    'fax': row[6],
                    'email': row[7],
                    'paginaweb': row[8],
                    'arciprestado': get_arciprestado(row[9]),
                    'criado_por': User.objects.get(pk=row[10]),
                    'criado': datetime.strptime(str(row[11]) + str(' ') + str(row[12]), "%Y-%m-%d %H:%M:%S"),
                    'economo': row[20],
                    'reitor': row[38],
                    'vice_reitor': row[39],
                    'prefeito': row[40],
                    'confessor': row[41],
                    'director_espiritual': row[42],
                    'equipa_resp': row[43],
                    'tesoureiro': row[65],
                    'codigo_ecclesia': row[70],
                    'secretario': row[71],
                    'telemovel': (row[78] if row[78] is not None else str('')) + (str('/') if row[78] is not None and row[79] is not None else str('')) + (row[79] if row[79] is not None else str('')),
                    #'alterado_por': self.User,
                    'alterado_por': User.objects.get(pk=row[10]),
                    }

    class ImportDiaconadoPermanente(object):

        def __init__(self, conn, cur):
            self.conn = conn
            self.cur = cur
            #self.User = User.objects.get(pk=101)

        def importar(self):
            self.cur.execute('SELECT * FROM instituicoes WHERE cod_tipo_instituicao=42')
            for row in self.cur:
                linha = self.getLinha(row)
                try:
                    dioceseModels.DiaconadoPermanente.objects.create(
                                                                id = linha['id'],
                                                                nome = linha['nome'],
                                                                morada = linha['morada'],
                                                                codigo_postal = linha['codigo_postal'],
                                                                localidade = linha['localidade'],
                                                                telefone = linha['telefone'],
                                                                fax = linha['fax'],
                                                                email = linha['email'],
                                                                paginaweb = linha['paginaweb'],
                                                                arciprestado = linha['arciprestado'],
                                                                criado_por = linha['criado_por'],
                                                                criado = linha['criado'],
                                                                delegado = linha['delegado'],
                                                                codigo_ecclesia = linha['codigo_ecclesia'],
                                                                seleccao_formacao = linha['seleccao_formacao'],
                                                                telemovel = linha['telemovel'],
                                                                alterado_por = linha['alterado_por'],
                                                        )
                except Exception, e:
                    print e
                    pass

        def getLinha(self, row):
            #print row
            return {
                    'id': row[0],
                    'nome': row[1],
                    'morada': row[3],
                    'codigo_postal': get_codigo_postal(row[4]),
                    'localidade': get_localidade(row[4]),
                    'telefone': row[5],
                    'fax': row[6],
                    'email': row[7],
                    'paginaweb': row[8],
                    'arciprestado': get_arciprestado(row[9]),
                    'criado_por': User.objects.get(pk=row[10]),
                    'criado': datetime.strptime(str(row[11]) + str(' ') + str(row[12]), "%Y-%m-%d %H:%M:%S"),
                    'delegado': row[13],
                    'codigo_ecclesia': row[70],
                    'seleccao_formacao': row[77],
                    'telemovel': (row[78] if row[78] is not None else str('')) + (str('/') if row[78] is not None and row[79] is not None else str('')) + (row[79] if row[79] is not None else str('')),
                    #'alterado_por': self.User,
                    'alterado_por': User.objects.get(pk=row[10]),
                    }

    class ImportFormacaoAgentePastoral(object):

        def __init__(self, conn, cur):
            self.conn = conn
            self.cur = cur
            #self.User = User.objects.get(pk=101)

        def importar(self):
            self.cur.execute('SELECT * FROM instituicoes WHERE cod_tipo_instituicao=24')
            for row in self.cur:
                linha = self.getLinha(row)
                try:
                    dioceseModels.FormacaoAgentePastoral.objects.create(
                                                                id = linha['id'],
                                                                nome = linha['nome'],
                                                                morada = linha['morada'],
                                                                codigo_postal = linha['codigo_postal'],
                                                                localidade = linha['localidade'],
                                                                telefone = linha['telefone'],
                                                                fax = linha['fax'],
                                                                email = linha['email'],
                                                                paginaweb = linha['paginaweb'],
                                                                arciprestado = linha['arciprestado'],
                                                                criado_por = linha['criado_por'],
                                                                criado = linha['criado'],
                                                                director = linha['director'],
                                                                propriedade = linha['propriedade'],
                                                                codigo_ecclesia = linha['codigo_ecclesia'],
                                                                telemovel = linha['telemovel'],
                                                                alterado_por = linha['alterado_por'],
                                                        )
                except Exception, e:
                    print e
                    pass

        def getLinha(self, row):
            #print row
            return {
                    'id': row[0],
                    'nome': row[1],
                    'morada': row[3],
                    'codigo_postal': get_codigo_postal(row[4]),
                    'localidade': get_localidade(row[4]),
                    'telefone': row[5],
                    'fax': row[6],
                    'email': row[7],
                    'paginaweb': row[8],
                    'arciprestado': get_arciprestado(row[9]),
                    'criado_por': User.objects.get(pk=row[10]),
                    'criado': datetime.strptime(str(row[11]) + str(' ') + str(row[12]), "%Y-%m-%d %H:%M:%S"),
                    'director': row[13],
                    'propriedade': row[14],
                    'codigo_ecclesia': row[70],
                    'telemovel': (row[78] if row[78] is not None else str('')) + (str('/') if row[78] is not None and row[79] is not None else str('')) + (row[79] if row[79] is not None else str('')),
                    #'alterado_por': self.User,
                    'alterado_por': User.objects.get(pk=row[10]),
                    }

    class ImportCentroVidaCrista(object):

        def __init__(self, conn, cur):
            self.conn = conn
            self.cur = cur
            #self.User = User.objects.get(pk=101)

        def importar(self):
            self.cur.execute('SELECT * FROM instituicoes WHERE cod_tipo_instituicao=15')
            for row in self.cur:
                linha = self.getLinha(row)
                try:
                    dioceseModels.CentroVidaCrista.objects.create(
                                                                id = linha['id'],
                                                                nome = linha['nome'],
                                                                morada = linha['morada'],
                                                                codigo_postal = linha['codigo_postal'],
                                                                localidade = linha['localidade'],
                                                                telefone = linha['telefone'],
                                                                fax = linha['fax'],
                                                                email = linha['email'],
                                                                paginaweb = linha['paginaweb'],
                                                                arciprestado = linha['arciprestado'],
                                                                criado_por = linha['criado_por'],
                                                                criado = linha['criado'],
                                                                director = linha['director'],
                                                                propriedade = linha['propriedade'],
                                                                tipo = linha['tipo'],
                                                                codigo_ecclesia = linha['codigo_ecclesia'],
                                                                telemovel = linha['telemovel'],
                                                                alterado_por = linha['alterado_por'],
                                                        )
                except Exception, e:
                    print e
                    pass

        def getLinha(self, row):
            #print row
            return {
                    'id': row[0],
                    'nome': row[1],
                    'morada': row[3],
                    'codigo_postal': get_codigo_postal(row[4]),
                    'localidade': get_localidade(row[4]),
                    'telefone': row[5],
                    'fax': row[6],
                    'email': row[7],
                    'paginaweb': row[8],
                    'arciprestado': get_arciprestado(row[9]),
                    'criado_por': User.objects.get(pk=row[10]),
                    'criado': datetime.strptime(str(row[11]) + str(' ') + str(row[12]), "%Y-%m-%d %H:%M:%S"),
                    'director': row[13],
                    'propriedade': row[14],
                    'tipo': row[69],
                    'codigo_ecclesia': row[70],
                    'telemovel': (row[78] if row[78] is not None else str('')) + (str('/') if row[78] is not None and row[79] is not None else str('')) + (row[79] if row[79] is not None else str('')),
                    #'alterado_por': self.User,
                    'alterado_por': User.objects.get(pk=row[10]),
                    }

    class ImportAssociacaoObraPresbitero(object):

        def __init__(self, conn, cur):
            self.conn = conn
            self.cur = cur
            #self.User = User.objects.get(pk=101)

        def importar(self):
            self.cur.execute('SELECT * FROM instituicoes WHERE cod_tipo_instituicao=32')
            for row in self.cur:
                linha = self.getLinha(row)
                try:
                    dioceseModels.AssociacaoObraPresbitero.objects.create(
                                                                id = linha['id'],
                                                                nome = linha['nome'],
                                                                morada = linha['morada'],
                                                                codigo_postal = linha['codigo_postal'],
                                                                localidade = linha['localidade'],
                                                                telefone = linha['telefone'],
                                                                fax = linha['fax'],
                                                                email = linha['email'],
                                                                paginaweb = linha['paginaweb'],
                                                                arciprestado = linha['arciprestado'],
                                                                criado_por = linha['criado_por'],
                                                                criado = linha['criado'],
                                                                director = linha['director'],
                                                                membros_eleitos = linha['membros_eleitos'],
                                                                codigo_ecclesia = linha['codigo_ecclesia'],
                                                                telemovel = linha['telemovel'],
                                                                alterado_por = linha['alterado_por'],
                                                        )
                except Exception, e:
                    print e
                    pass

        def getLinha(self, row):
            #print row
            return {
                    'id': row[0],
                    'nome': row[1],
                    'morada': row[3],
                    'codigo_postal': get_codigo_postal(row[4]),
                    'localidade': get_localidade(row[4]),
                    'telefone': row[5],
                    'fax': row[6],
                    'email': row[7],
                    'paginaweb': row[8],
                    'arciprestado': get_arciprestado(row[9]),
                    'criado_por': User.objects.get(pk=row[10]),
                    'criado': datetime.strptime(str(row[11]) + str(' ') + str(row[12]), "%Y-%m-%d %H:%M:%S"),
                    'director': row[13],
                    'membros_eleitos': row[17],
                    'codigo_ecclesia': row[70],
                    'telemovel': (row[78] if row[78] is not None else str('')) + (str('/') if row[78] is not None and row[79] is not None else str('')) + (row[79] if row[79] is not None else str('')),
                    #'alterado_por': self.User,
                    'alterado_por': User.objects.get(pk=row[10]),
                    }

    class ImportPrelaturaPessoal(object):

        def __init__(self, conn, cur):
            self.conn = conn
            self.cur = cur
            #self.User = User.objects.get(pk=101)

        def importar(self):
            self.cur.execute('SELECT * FROM instituicoes WHERE cod_tipo_instituicao=22')
            for row in self.cur:
                linha = self.getLinha(row)
                try:
                    dioceseModels.PrelaturaPessoal.objects.create(
                                                                id = linha['id'],
                                                                nome = linha['nome'],
                                                                morada = linha['morada'],
                                                                codigo_postal = linha['codigo_postal'],
                                                                localidade = linha['localidade'],
                                                                telefone = linha['telefone'],
                                                                fax = linha['fax'],
                                                                email = linha['email'],
                                                                paginaweb = linha['paginaweb'],
                                                                arciprestado = linha['arciprestado'],
                                                                criado_por = linha['criado_por'],
                                                                criado = linha['criado'],
                                                                comunidade = linha['comunidade'],
                                                                superiora = linha['superiora'],
                                                                codigo_ecclesia = linha['codigo_ecclesia'],
                                                                telemovel = linha['telemovel'],
                                                                alterado_por = linha['alterado_por'],
                                                        )
                except Exception, e:
                    print e
                    pass

        def getLinha(self, row):
            #print row
            return {
                    'id': row[0],
                    'nome': row[1],
                    'morada': row[3],
                    'codigo_postal': get_codigo_postal(row[4]),
                    'localidade': get_localidade(row[4]),
                    'telefone': row[5],
                    'fax': row[6],
                    'email': row[7],
                    'paginaweb': row[8],
                    'arciprestado': get_arciprestado(row[9]),
                    'criado_por': User.objects.get(pk=row[10]),
                    'criado': datetime.strptime(str(row[11]) + str(' ') + str(row[12]), "%Y-%m-%d %H:%M:%S"),
                    'comunidade': row[21],
                    'superiora': row[22],
                    'codigo_ecclesia': row[70],
                    'telemovel': (row[78] if row[78] is not None else str('')) + (str('/') if row[78] is not None and row[79] is not None else str('')) + (row[79] if row[79] is not None else str('')),
                    #'alterado_por': self.User,
                    'alterado_por': User.objects.get(pk=row[10]),
                    }

    class ImportInstitutoReligiosoFeminino(object):

        def __init__(self, conn, cur):
            self.conn = conn
            self.cur = cur
            #self.User = User.objects.get(pk=101)

        def importar(self):
            self.cur.execute('SELECT * FROM instituicoes WHERE cod_tipo_instituicao=3')
            for row in self.cur:
                linha = self.getLinha(row)
                try:
                    dioceseModels.InstitutoReligiosoFeminino.objects.create(
                                                                id = linha['id'],
                                                                nome = linha['nome'],
                                                                morada = linha['morada'],
                                                                codigo_postal = linha['codigo_postal'],
                                                                localidade = linha['localidade'],
                                                                telefone = linha['telefone'],
                                                                fax = linha['fax'],
                                                                email = linha['email'],
                                                                paginaweb = linha['paginaweb'],
                                                                arciprestado = linha['arciprestado'],
                                                                criado_por = linha['criado_por'],
                                                                criado = linha['criado'],
                                                                comunidade = linha['comunidade'],
                                                                superiora = linha['superiora'],
                                                                codigo_ecclesia = linha['codigo_ecclesia'],
                                                                telemovel = linha['telemovel'],
                                                                alterado_por = linha['alterado_por'],
                                                        )
                except Exception, e:
                    print e
                    pass

        def getLinha(self, row):
            #print row
            return {
                    'id': row[0],
                    'nome': row[1],
                    'morada': row[3],
                    'codigo_postal': get_codigo_postal(row[4]),
                    'localidade': get_localidade(row[4]),
                    'telefone': row[5],
                    'fax': row[6],
                    'email': row[7],
                    'paginaweb': row[8],
                    'arciprestado': get_arciprestado(row[9]),
                    'criado_por': User.objects.get(pk=row[10]),
                    'criado': datetime.strptime(str(row[11]) + str(' ') + str(row[12]), "%Y-%m-%d %H:%M:%S"),
                    'comunidade': row[21],
                    'superiora': row[22],
                    'codigo_ecclesia': row[70],
                    'telemovel': (row[78] if row[78] is not None else str('')) + (str('/') if row[78] is not None and row[79] is not None else str('')) + (row[79] if row[79] is not None else str('')),
                    #'alterado_por': self.User,
                    'alterado_por': User.objects.get(pk=row[10]),
                    }

    class ImportInstitutoReligiosoMasculino(object):

        def __init__(self, conn, cur):
            self.conn = conn
            self.cur = cur
            #self.User = User.objects.get(pk=101)

        def importar(self):
            self.cur.execute('SELECT * FROM instituicoes WHERE cod_tipo_instituicao=4')
            for row in self.cur:
                linha = self.getLinha(row)
                try:
                    dioceseModels.InstitutoReligiosoMasculino.objects.create(
                                                                id = linha['id'],
                                                                nome = linha['nome'],
                                                                morada = linha['morada'],
                                                                codigo_postal = linha['codigo_postal'],
                                                                localidade = linha['localidade'],
                                                                telefone = linha['telefone'],
                                                                fax = linha['fax'],
                                                                email = linha['email'],
                                                                paginaweb = linha['paginaweb'],
                                                                arciprestado = linha['arciprestado'],
                                                                criado_por = linha['criado_por'],
                                                                criado = linha['criado'],
                                                                comunidade = linha['comunidade'],
                                                                superior = linha['superior'],
                                                                codigo_ecclesia = linha['codigo_ecclesia'],
                                                                telemovel = linha['telemovel'],
                                                                alterado_por = linha['alterado_por'],
                                                        )
                except Exception, e:
                    print e
                    pass

        def getLinha(self, row):
            #print row
            return {
                    'id': row[0],
                    'nome': row[1],
                    'morada': row[3],
                    'codigo_postal': get_codigo_postal(row[4]),
                    'localidade': get_localidade(row[4]),
                    'telefone': row[5],
                    'fax': row[6],
                    'email': row[7],
                    'paginaweb': row[8],
                    'arciprestado': get_arciprestado(row[9]),
                    'criado_por': User.objects.get(pk=row[10]),
                    'criado': datetime.strptime(str(row[11]) + str(' ') + str(row[12]), "%Y-%m-%d %H:%M:%S"),
                    'comunidade': row[21],
                    'superior': row[22],
                    'codigo_ecclesia': row[70],
                    'telemovel': (row[78] if row[78] is not None else str('')) + (str('/') if row[78] is not None and row[79] is not None else str('')) + (row[79] if row[79] is not None else str('')),
                    #'alterado_por': self.User,
                    'alterado_por': User.objects.get(pk=row[10]),
                    }

    class ImportInstitutoSecular(object):

        def __init__(self, conn, cur):
            self.conn = conn
            self.cur = cur
            #self.User = User.objects.get(pk=101)

        def importar(self):
            self.cur.execute('SELECT * FROM instituicoes WHERE cod_tipo_instituicao=5')
            for row in self.cur:
                linha = self.getLinha(row)
                try:
                    dioceseModels.InstitutoSecular.objects.create(
                                                                id = linha['id'],
                                                                nome = linha['nome'],
                                                                morada = linha['morada'],
                                                                codigo_postal = linha['codigo_postal'],
                                                                localidade = linha['localidade'],
                                                                telefone = linha['telefone'],
                                                                fax = linha['fax'],
                                                                email = linha['email'],
                                                                paginaweb = linha['paginaweb'],
                                                                arciprestado = linha['arciprestado'],
                                                                criado_por = linha['criado_por'],
                                                                criado = linha['criado'],
                                                                director = linha['director'],
                                                                assistente = linha['assistente'],
                                                                codigo_ecclesia = linha['codigo_ecclesia'],
                                                                telemovel = linha['telemovel'],
                                                                alterado_por = linha['alterado_por'],
                                                        )
                except Exception, e:
                    print e
                    pass

        def getLinha(self, row):
            #print row
            return {
                    'id': row[0],
                    'nome': row[1],
                    'morada': row[3],
                    'codigo_postal': get_codigo_postal(row[4]),
                    'localidade': get_localidade(row[4]),
                    'telefone': row[5],
                    'fax': row[6],
                    'email': row[7],
                    'paginaweb': row[8],
                    'arciprestado': get_arciprestado(row[9]),
                    'criado_por': User.objects.get(pk=row[10]),
                    'criado': datetime.strptime(str(row[11]) + str(' ') + str(row[12]), "%Y-%m-%d %H:%M:%S"),
                    'director': row[13],
                    'assistente': row[18],
                    'codigo_ecclesia': row[70],
                    'telemovel': (row[78] if row[78] is not None else str('')) + (str('/') if row[78] is not None and row[79] is not None else str('')) + (row[79] if row[79] is not None else str('')),
                    #'alterado_por': self.User,
                    'alterado_por': User.objects.get(pk=row[10]),
                    }

    """
    class ImportSociedadeVidaApostolica(object):

        def __init__(self, conn, cur):
            self.conn = conn
            self.cur = cur
            #self.User = User.objects.get(pk=101)

        def importar(self):
            self.cur.execute('SELECT * FROM instituicoes WHERE cod_tipo_instituicao=')
            for row in self.cur:
                linha = self.getLinha(row)
                try:
                    dioceseModels.SociedadeVidaApostolica.objects.create(
                                                                id = linha['id'],
                                                                nome = linha['nome'],
                                                                morada = linha['morada'],
                                                                codigo_postal = linha['codigo_postal'],
                                                                localidade = linha['localidade'],
                                                                telefone = linha['telefone'],
                                                                fax = linha['fax'],
                                                                email = linha['email'],
                                                                paginaweb = linha['paginaweb'],
                                                                arciprestado = linha['arciprestado'],
                                                                criado_por = linha['criado_por'],
                                                                criado = linha['criado'],
                                                                director = linha['director'],
                                                                codigo_ecclesia = linha['codigo_ecclesia'],
                                                                telemovel = linha['telemovel'],
                                                                alterado_por = linha['alterado_por'],
                                                        )
                except Exception, e:
                    print e
                    pass

        def getLinha(self, row):
            #print row
            return {
                    'id': row[0],
                    'nome': row[1],
                    'morada': row[3],
                    'codigo_postal': get_codigo_postal(row[4]),
                    'localidade': get_localidade(row[4]),
                    'telefone': row[5],
                    'fax': row[6],
                    'email': row[7],
                    'paginaweb': row[8],
                    'arciprestado': get_arciprestado(row[9]),
                    'criado_por': User.objects.get(pk=row[10]),
                    'criado': datetime.strptime(str(row[11]) + str(' ') + str(row[12]), "%Y-%m-%d %H:%M:%S"),
                    'director': row[13],
                    'codigo_ecclesia': row[70],
                    'telemovel': (row[78] if row[78] is not None else str('')) + (str('/') if row[78] is not None and row[79] is not None else str('')) + (row[79] if row[79] is not None else str('')),
                    #'alterado_por': self.User,
                    'alterado_por': User.objects.get(pk=row[10]),
                    }
    """

    class ImportAssociacaoMovimentoObra(object):

        def __init__(self, conn, cur):
            self.conn = conn
            self.cur = cur
            #self.User = User.objects.get(pk=101)

        def importar(self):
            self.cur.execute('SELECT * FROM instituicoes WHERE cod_tipo_instituicao=6')
            for row in self.cur:
                linha = self.getLinha(row)
                try:
                    dioceseModels.AssociacaoMovimentoObra.objects.create(
                                                                id = linha['id'],
                                                                nome = linha['nome'],
                                                                morada = linha['morada'],
                                                                codigo_postal = linha['codigo_postal'],
                                                                localidade = linha['localidade'],
                                                                telefone = linha['telefone'],
                                                                fax = linha['fax'],
                                                                email = linha['email'],
                                                                paginaweb = linha['paginaweb'],
                                                                arciprestado = linha['arciprestado'],
                                                                criado_por = linha['criado_por'],
                                                                criado = linha['criado'],
                                                                presidente = linha['presidente'],
                                                                assistente = linha['assistente'],
                                                                codigo_ecclesia = linha['codigo_ecclesia'],
                                                                telemovel = linha['telemovel'],
                                                                alterado_por = linha['alterado_por'],
                                                        )
                except Exception, e:
                    print e
                    pass

        def getLinha(self, row):
            #print row
            return {
                    'id': row[0],
                    'nome': row[1],
                    'morada': row[3],
                    'codigo_postal': get_codigo_postal(row[4]),
                    'localidade': get_localidade(row[4]),
                    'telefone': row[5],
                    'fax': row[6],
                    'email': row[7],
                    'paginaweb': row[8],
                    'arciprestado': get_arciprestado(row[9]),
                    'criado_por': User.objects.get(pk=row[10]),
                    'criado': datetime.strptime(str(row[11]) + str(' ') + str(row[12]), "%Y-%m-%d %H:%M:%S"),
                    'presidente': row[13],
                    'assistente': row[18],
                    'codigo_ecclesia': row[70],
                    'telemovel': (row[78] if row[78] is not None else str('')) + (str('/') if row[78] is not None and row[79] is not None else str('')) + (row[79] if row[79] is not None else str('')),
                    #'alterado_por': self.User,
                    'alterado_por': User.objects.get(pk=row[10]),
                    }

    class ImportCentroAnimacaoEspiritual(object):

        def __init__(self, conn, cur):
            self.conn = conn
            self.cur = cur
            #self.User = User.objects.get(pk=101)

        def importar(self):
            self.cur.execute('SELECT * FROM instituicoes WHERE cod_tipo_instituicao=41')
            for row in self.cur:
                linha = self.getLinha(row)
                try:
                    dioceseModels.CentroAnimacaoEspiritual.objects.create(
                                                                id = linha['id'],
                                                                nome = linha['nome'],
                                                                morada = linha['morada'],
                                                                codigo_postal = linha['codigo_postal'],
                                                                localidade = linha['localidade'],
                                                                telefone = linha['telefone'],
                                                                fax = linha['fax'],
                                                                email = linha['email'],
                                                                paginaweb = linha['paginaweb'],
                                                                arciprestado = linha['arciprestado'],
                                                                criado_por = linha['criado_por'],
                                                                criado = linha['criado'],
                                                                director = linha['director'],
                                                                propiedade = linha['propiedade'],
                                                                assistente = linha['assistente'],
                                                                codigo_ecclesia = linha['codigo_ecclesia'],
                                                                telemovel = linha['telemovel'],
                                                                alterado_por = linha['alterado_por'],
                                                        )
                except Exception, e:
                    print e
                    pass

        def getLinha(self, row):
            #print row
            return {
                    'id': row[0],
                    'nome': row[1],
                    'morada': row[3],
                    'codigo_postal': get_codigo_postal(row[4]),
                    'localidade': get_localidade(row[4]),
                    'telefone': row[5],
                    'fax': row[6],
                    'email': row[7],
                    'paginaweb': row[8],
                    'arciprestado': get_arciprestado(row[9]),
                    'criado_por': User.objects.get(pk=row[10]),
                    'criado': datetime.strptime(str(row[11]) + str(' ') + str(row[12]), "%Y-%m-%d %H:%M:%S"),
                    'director': row[13],
                    'propiedade': row[14],
                    'assistente': row[18],
                    'codigo_ecclesia': row[70],
                    'telemovel': (row[78] if row[78] is not None else str('')) + (str('/') if row[78] is not None and row[79] is not None else str('')) + (row[79] if row[79] is not None else str('')),
                    #'alterado_por': self.User,
                    'alterado_por': User.objects.get(pk=row[10]),
                    }

    class ImportObraAccaoSocioCaritativa(object):

        def __init__(self, conn, cur):
            self.conn = conn
            self.cur = cur
            #self.User = User.objects.get(pk=101)

        def importar(self):
            self.cur.execute('SELECT * FROM instituicoes WHERE cod_tipo_instituicao=10')
            for row in self.cur:
                linha = self.getLinha(row)
                try:
                    dioceseModels.ObraAccaoSocioCaritativa.objects.create(
                                                                id = linha['id'],
                                                                nome = linha['nome'],
                                                                morada = linha['morada'],
                                                                codigo_postal = linha['codigo_postal'],
                                                                localidade = linha['localidade'],
                                                                telefone = linha['telefone'],
                                                                fax = linha['fax'],
                                                                email = linha['email'],
                                                                paginaweb = linha['paginaweb'],
                                                                arciprestado = linha['arciprestado'],
                                                                criado_por = linha['criado_por'],
                                                                criado = linha['criado'],
                                                                responsavel = linha['responsavel'],
                                                                propriedade = linha['propriedade'],
                                                                assistente = linha['assistente'],
                                                                tipo = linha['tipo'],
                                                                codigo_ecclesia = linha['codigo_ecclesia'],
                                                                alterado_por = linha['alterado_por'],
                                                        )
                except Exception, e:
                    print e
                    pass

        def getLinha(self, row):
            #print row
            return {
                    'id': row[0],
                    'nome': row[1],
                    'morada': row[3],
                    'codigo_postal': get_codigo_postal(row[4]),
                    'localidade': get_localidade(row[4]),
                    'telefone': row[5],
                    'fax': row[6],
                    'email': row[7],
                    'paginaweb': row[8],
                    'arciprestado': get_arciprestado(row[9]),
                    'criado_por': User.objects.get(pk=row[10]),
                    'criado': datetime.strptime(str(row[11]) + str(' ') + str(row[12]), "%Y-%m-%d %H:%M:%S"),
                    'responsavel': row[13],
                    'propriedade': row[14],
                    'assistente': row[18],
                    'tipo': row[26],
                    'codigo_ecclesia': row[70],
                    #'alterado_por': self.User,
                    'alterado_por': User.objects.get(pk=row[10]),
                    }

    class ImportEscolaCatolica(object):

        def __init__(self, conn, cur):
            self.conn = conn
            self.cur = cur
            #self.User = User.objects.get(pk=101)

        def importar(self):
            self.cur.execute('SELECT * FROM instituicoes WHERE cod_tipo_instituicao=13')
            for row in self.cur:
                linha = self.getLinha(row)
                try:
                    dioceseModels.EscolaCatolica.objects.create(
                                                                id = linha['id'],
                                                                nome = linha['nome'],
                                                                morada = linha['morada'],
                                                                codigo_postal = linha['codigo_postal'],
                                                                localidade = linha['localidade'],
                                                                telefone = linha['telefone'],
                                                                fax = linha['fax'],
                                                                email = linha['email'],
                                                                paginaweb = linha['paginaweb'],
                                                                arciprestado = linha['arciprestado'],
                                                                criado_por = linha['criado_por'],
                                                                criado = linha['criado'],
                                                                director = linha['director'],
                                                                propriedade = linha['propriedade'],
                                                                escolaridade = linha['escolaridade'],
                                                                codigo_ecclesia = linha['codigo_ecclesia'],
                                                                telemovel =  linha['telemovel'],
                                                                alterado_por = linha['alterado_por'],
                                                        )
                except Exception, e:
                    print e
                    pass

        def getLinha(self, row):
            #print row
            return {
                    'id': row[0],
                    'nome': row[1],
                    'morada': row[3],
                    'codigo_postal': get_codigo_postal(row[4]),
                    'localidade': get_localidade(row[4]),
                    'telefone': row[5],
                    'fax': row[6],
                    'email': row[7],
                    'paginaweb': row[8],
                    'arciprestado': get_arciprestado(row[9]),
                    'criado_por': User.objects.get(pk=row[10]),
                    'criado': datetime.strptime(str(row[11]) + str(' ') + str(row[12]), "%Y-%m-%d %H:%M:%S"),
                    'director': row[13],
                    'propriedade': row[14],
                    'escolaridade': row[24],
                    'codigo_ecclesia': row[70],
                    'telemovel': (row[78] if row[78] is not None else str('')) + (str('/') if row[78] is not None and row[79] is not None else str('')) + (row[79] if row[79] is not None else str('')),
                    #'alterado_por': self.User,
                    'alterado_por': User.objects.get(pk=row[10]),
                    }

    class ImportInstituicaoCultural(object):

        def __init__(self, conn, cur):
            self.conn = conn
            self.cur = cur
            #self.User = User.objects.get(pk=101)

        def importar(self):
            self.cur.execute('SELECT * FROM instituicoes WHERE cod_tipo_instituicao=39')
            for row in self.cur:
                linha = self.getLinha(row)
                try:
                    dioceseModels.InstituicaoCultural.objects.create(
                                                                id = linha['id'],
                                                                nome = linha['nome'],
                                                                morada = linha['morada'],
                                                                codigo_postal = linha['codigo_postal'],
                                                                localidade = linha['localidade'],
                                                                telefone = linha['telefone'],
                                                                fax = linha['fax'],
                                                                email = linha['email'],
                                                                paginaweb = linha['paginaweb'],
                                                                arciprestado = linha['arciprestado'],
                                                                criado_por = linha['criado_por'],
                                                                criado = linha['criado'],
                                                                codigo_ecclesia = linha['codigo_ecclesia'],
                                                                telemovel = linha['telemovel'],
                                                                alterado_por = linha['alterado_por'],
                                                        )
                except Exception, e:
                    print e
                    pass

        def getLinha(self, row):
            #print row
            return {
                    'id': row[0],
                    'nome': row[1],
                    'morada': row[3],
                    'codigo_postal': get_codigo_postal(row[4]),
                    'localidade': get_localidade(row[4]),
                    'telefone': row[5],
                    'fax': row[6],
                    'email': row[7],
                    'paginaweb': row[8],
                    'arciprestado': get_arciprestado(row[9]),
                    'criado_por': User.objects.get(pk=row[10]),
                    'criado': datetime.strptime(str(row[11]) + str(' ') + str(row[12]), "%Y-%m-%d %H:%M:%S"),
                    'codigo_ecclesia': row[70],
                    'telemovel': (row[78] if row[78] is not None else str('')) + (str('/') if row[78] is not None and row[79] is not None else str('')) + (row[79] if row[79] is not None else str('')),
                    #'alterado_por': self.User,
                    'alterado_por': User.objects.get(pk=row[10]),
                    }

    class ImportComunicacaoSocial(object):

        def __init__(self, conn, cur):
            self.conn = conn
            self.cur = cur
            #self.User = User.objects.get(pk=101)

        def importar(self):
            self.cur.execute('SELECT * FROM instituicoes WHERE cod_tipo_instituicao=34')
            for row in self.cur:
                linha = self.getLinha(row)
                try:
                    dioceseModels.ComunicacaoSocial.objects.create(
                                                                id = linha['id'],
                                                                nome = linha['nome'],
                                                                morada = linha['morada'],
                                                                codigo_postal = linha['codigo_postal'],
                                                                localidade = linha['localidade'],
                                                                telefone = linha['telefone'],
                                                                fax = linha['fax'],
                                                                email = linha['email'],
                                                                paginaweb = linha['paginaweb'],
                                                                arciprestado = linha['arciprestado'],
                                                                criado_por = linha['criado_por'],
                                                                criado = linha['criado'],
                                                                director = linha['director'],
                                                                propriedade = linha['propriedade'],
                                                                tipo = linha['tipo'],
                                                                periocidade = linha['periocidade'],
                                                                codigo_ecclesia = linha['codigo_ecclesia'],
                                                                alterado_por = linha['alterado_por'],
                                                        )
                except Exception, e:
                    print e
                    pass

        def getLinha(self, row):
            #print row
            return {
                    'id': row[0],
                    'nome': row[1],
                    'morada': row[3],
                    'codigo_postal': get_codigo_postal(row[4]),
                    'localidade': get_localidade(row[4]),
                    'telefone': row[5],
                    'fax': row[6],
                    'email': row[7],
                    'paginaweb': row[8],
                    'arciprestado': get_arciprestado(row[9]),
                    'criado_por': User.objects.get(pk=row[10]),
                    'criado': datetime.strptime(str(row[11]) + str(' ') + str(row[12]), "%Y-%m-%d %H:%M:%S"),
                    'director': row[13],
                    'propriedade': row[14],
                    'tipo': row[66],
                    'periocidade': row[67],
                    'codigo_ecclesia': row[70],
                    #'alterado_por': self.User,
                    'alterado_por': User.objects.get(pk=row[10]),
                    }


    print 'BEGIN'

    import MySQLdb as mdb
    import sys

    con = None

    try:

        con = mdb.connect(django_settings.SIM4_CONN[0],django_settings.SIM4_CONN[1],django_settings.SIM4_CONN[2],django_settings.SIM4_CONN[3],charset="utf8");

        #con.set_character_set('utf8')

        cur = con.cursor()
        """
        cur.execute('SET NAMES utf8;')
        cur.execute('SET CHARACTER SET utf8;')
        cur.execute('SET character_set_connection=utf8;')
        """
        """
        cur.execute("SELECT VERSION()")

        data = cur.fetchone()

        print "Database version : %s " % data
        """

        ImportPresbitero(con, cur).importar()
        ImportNotaHistorica(con, cur).importar()
        ImportDadosEstatisticos(con, cur).importar()
        ImportCabido(con, cur).importar()
        ImportArciprestado(con, cur).importar()
        ImportParoquia(con, cur).importar()
        ImportBispo(con, cur).importar()
        ImportDiaconoPermanente(con, cur).importar()
        ImportCuriaDiocesana(con, cur).importar()
        ImportChancelaria(con, cur).importar()
        ImportGestaoRecursos(con, cur).importar()
        ImportConselhoPresbiteral(con, cur).importar()
        ImportColegioConsultores(con, cur).importar()
        ImportConselhoPastoral(con, cur).importar()
        ImportColegioArciprestes(con, cur).importar()
        ImportSecretariado(con, cur).importar()
        ImportComissao(con, cur).importar()
        ImportTribunalEclesiastico(con, cur).importar()
        ImportSeminario(con, cur).importar()
        ImportDiaconadoPermanente(con, cur).importar()
        ImportFormacaoAgentePastoral(con, cur).importar()
        ImportCentroVidaCrista(con, cur).importar()
        ImportAssociacaoObraPresbitero(con, cur).importar()
        ImportPrelaturaPessoal(con, cur).importar()
        ImportInstitutoReligiosoFeminino(con, cur).importar()
        ImportInstitutoReligiosoMasculino(con, cur).importar()
        ImportInstitutoSecular(con, cur).importar()
        #ImportSociedadeVidaApostolica(con, cur).importar()
        ImportAssociacaoMovimentoObra(con, cur).importar()
        ImportCentroAnimacaoEspiritual(con, cur).importar()
        ImportObraAccaoSocioCaritativa(con, cur).importar()
        ImportEscolaCatolica(con, cur).importar()
        ImportInstituicaoCultural(con, cur).importar()
        ImportComunicacaoSocial(con, cur).importar()
        ImportPresbitero2(con, cur).importar()
    except mdb.Error, e:
        print "Error %d: %s" % (e.args[0], e.args[1])
        sys.exit(1)
    finally:
        if con:
            con.close()

    print 'END'


