#coding: utf-8
from django.conf import settings as django_settings

if not hasattr(django_settings, 'SIM4_CONN'):
    #raise Exception('SIM4_CONN não existe no ficheiro de settings.py\nExemplo:\n\tSIM4_CONN = "dbname=\'db_name\' user=\'db_user\' host=\'db_host\' password=\'db_password\'"')
    pass
else:
    from conteudos import models as contentModels
    from django.conf import settings
    from elfinder.models import FileCollection,Directory
    import os.path
    import os
    import shutil
    from exceptions import IOError
    from datetime import datetime

    def importar():
        ImportNoticia().importar()
        pass

    class ImportNoticia(object):

        def __init__(self):
            self.origem = os.path.abspath(os.path.dirname(os.path.realpath(__file__))+'/../../../biblioteca/publicacoes_online/')

        def importar(self):
            lista = contentModels.Noticia.objects.exclude(website=1).filter(alterado__contains=str(datetime.today()).split(' ')[0]).order_by('id')
            print len(lista)
            
            for obj in lista:
                origem =self.origem +str('/')+ str(obj.id) +str('/')
                if obj.fs == None:
                    fs = create_fs()
                else:
                    fs = obj.fs
                obj.fs = fs

                if obj.foto1 != None:
                    try:
                        filename = fs.url + '/' + os.path.basename(obj.foto1)
                        shutil.copy('%s%s' % (origem+ '/', obj.foto1), fs.dir + '/')
                        obj.foto1 = filename
                    except IOError:
                        print IOError
                        obj.foto1 = None

                if obj.foto2 != None:
                    try:
                        filename = fs.url + '/' + os.path.basename(obj.foto2)
                        shutil.copy('%s%s' % (origem+ '/', obj.foto2), fs.dir + '/')
                        obj.foto2 = filename
                    except IOError:
                        print IOError
                        obj.foto2 = None

                if obj.capa != None:
                    try:
                        filename = fs.url + '/' + os.path.basename(obj.capa)
                        shutil.copy('%s%s' % (origem+ '/', obj.capa), fs.dir + '/')
                        obj.capa = filename
                    except IOError:
                        print IOError
                        obj.capa = None

                obj.save()


    def create_fs():
        import datetime
        import tempfile
        mydir= os.path.abspath(os.path.realpath(settings.MEDIA_ROOT +'/contents/')) #os.path.abspath(os.path.dirname(os.path.realpath(__file__))+'/../../media/contents/')
        dirpath = tempfile.mkdtemp(prefix = 'contents_',dir = mydir)
        fc = FileCollection(dir = dirpath,name = 'Filesystem',url='contents/'+os.path.basename(dirpath))
        fc.save();
        (mode, ino, dev, nlink, uid, gid, size, atime, mtime, ctime) = os.stat(dirpath)
        mtime = datetime.datetime.fromtimestamp(mtime)
        d = Directory(name = '/', collection=fc, last_modification=mtime)
        d.save()
        return fc


importar()
