#coding: utf-8
from django.conf import settings as django_settings

if not hasattr(django_settings, 'SIM4_CONN'):
    raise Exception('SIM4_CONN não existe no ficheiro de settings.py\nExemplo:\n\tSIM4_CONN = "dbname=\'db_name\' user=\'db_user\' host=\'db_host\' password=\'db_password\'"')
    pass
else:

    from conteudos import models as conteudoModels
    from django.contrib.auth.models import User
    from datetime import datetime

    from website import models as modelsWebsite

    def get_fromtimestamp(val):
        if val is None:
            return None
        try:
            return datetime.fromtimestamp(val)
        except Exception, e:
            print e
            return None

    def get_strpdate(val):
        if val is None:
            return None
        try:
            return val
        except Exception, e:
            print e
            return None


    class ImportLink(object):

        def __init__(self, conn, cur):
            self.conn = conn
            self.cur = cur
            #self.User = User.objects.get(pk=101)

        def importar(self):
            self.cur.execute('SELECT DISTINCT * FROM links')
            for row in self.cur:
                linha = self.getLinha(row)
                try:
                    conteudoModels.Link.objects.create(
                                                        id = linha['id'],
                                                        titulo = linha['titulo'],
                                                        descricao = linha['descricao'],
                                                        url = linha['url'],
                                                        categoria = linha['categoria'],
                                                        criado_por = linha['criado_por'],
                                                        criado = linha['criado'],
                                                        alterado_por = linha['alterado_por'],
                                                        )
                except Exception, e:
                    print e
                    pass

        def getLinha(self, row):
            #print row
            return {
                    'id': row[0],
                    'titulo': row[1],
                    'descricao': row[2],
                    'url': row[3],
                    'categoria': row[4],
                    'criado_por': User.objects.get(pk=row[5]),
                    'criado': datetime.strptime(str(row[6]) + str(' ') + str(row[7]), "%Y-%m-%d %H:%M:%S"),
                    #'alterado_por': self.User,
                    'alterado_por': User.objects.get(pk=row[5]),
                    }



    class ImportSeccao(object):

        def __init__(self, conn, cur):
            self.conn = conn
            self.cur = cur
            #self.User = User.objects.get(pk=101)

        def importar(self):
            self.cur.execute('SELECT DISTINCT * FROM seccoes')
            for row in self.cur:
                linha = self.getLinha(row)
                try:
                    conteudoModels.Seccao.objects.create(
                                                        id = linha['id'],
                                                        title = linha['title'],
                                                        descricao = linha['descricao'],
                                                        criado_por = linha['criado_por'],
                                                        criado = linha['criado'],
                                                        alterado_por = linha['alterado_por'],
                                                        )
                except Exception, e:
                    print e
                    pass

        def getLinha(self, row):
            #print row
            return {
                    'id': row[0],
                    'title': row[1],
                    'descricao': row[2],
                    'criado_por': User.objects.get(pk=row[3]),
                    'criado': datetime.strptime(str(row[4]) + str(' ') + str(row[5]), "%Y-%m-%d %H:%M:%S"),
                    #'alterado_por': self.User,
                    'alterado_por': User.objects.get(pk=row[3]),
                    }



    class ImportConteudoSeccao(object):

        def __init__(self, obj, conn, cur):
            self.obj = obj
            self.conn = conn
            self.cur = cur
            #self.User = User.objects.get(pk=101)

        def importar(self):
            self.cur.execute('SELECT DISTINCT * FROM publicacoes_online_seccoes WHERE cod_noticia="'+str(self.obj.id)+'"')
            for row in self.cur:
                linha = self.getLinha(row)
                try:
                    self.obj.conteudos_noticiaseccao_noticia.create(
                                                        id = linha['id'],
                                                        noticia = self.obj,
                                                        seccao = conteudoModels.Seccao.objects.get(pk=linha['seccao']),
                                                        seccao_publicacao = linha['seccao_publicacao'],
                                                        )
                except Exception, e:
                    print e
                    pass

        def getLinha(self, row):
            #print row
            return {
                    'id': row[0],
                    'noticia': row[1],
                    'seccao': row[2],
                    'seccao_publicacao': self.get_seccao_publicacao(row[6]),
                    }

        def get_seccao_publicacao(self,val):
            if val is None or val ==0:
                return None
            try:
                if val==1 or val==2 or val==3:
                    return 1
                else:
                    return None
            except Exception, e:
                print e
                return None


    class ImportConteudoSeccao2(object):

        def __init__(self, obj, conn, cur):
            self.obj = obj
            self.conn = conn
            self.cur = cur
            #self.User = User.objects.get(pk=101)
            self.seccao = []

        def importar(self):

            self.cur.execute('SELECT DISTINCT * FROM publicacoes_online_seccoes WHERE cod_noticia="'+str(self.obj.id)+'"')
            for row in self.cur:
                linha = self.getLinha(row)
                try:
                    if linha['seccao'] not in self.seccao:
                        self.obj.conteudos_noticiaseccao_noticia.create(
                                                            id = linha['id'],
                                                            noticia = self.obj,
                                                            seccao = conteudoModels.Seccao.objects.get(pk=linha['seccao']),
                                                            seccao_publicacao = linha['seccao_publicacao'],
                                                            )
                        self.seccao.append(linha['seccao'])
                except Exception, e:
                    print e
                    pass

        def getLinha(self, row):
            #print row
            return {
                    'id': row[0],
                    'noticia': row[1],
                    'seccao': (2 if row[2] == 13 else 1),
                    'seccao_publicacao': self.get_seccao_publicacao(row[6]),
                    }

        def get_seccao_publicacao(self,val):
            if val is None or val ==0:
                return None
            try:
                if val==1 or val==2 or val==3:
                    return 1
                else:
                    return None
            except Exception, e:
                print e
                return None


    class ImportConteudoWebsite(object):

        def __init__(self, obj, conn, cur):
            self.obj = obj
            self.conn = conn
            self.cur = cur
            #self.User = User.objects.get(pk=101)

        def importar(self):
            self.cur.execute('SELECT DISTINCT * FROM  grupos_registos WHERE tabela="noticias" AND cod_registo=%s' % self.obj.id)
            mylist=[]
            for row in self.cur:
                linha = self.getLinha(row)

                try:
                    mylist.append(linha['cod_grupo'],);
                except Exception, e:
                    print e
                    pass

            if 1 in mylist:
                self.obj.website=modelsWebsite.WebSite.objects.get(pk=1)
            else:
                self.obj.website=modelsWebsite.WebSite.objects.get(pk=mylist[0])
            self.obj.save()

        def getLinha(self, row):
            #print row
            return {
                    'cod_registo': row[0],
                    'cod_grupo': row[1],
                    'tabela': row[2],
                    'timestamp': row[3],
                    }


    class ImportConteudo(object):

        def __init__(self, conn, cur):
            self.conn = conn
            self.cur = cur
            #self.User = User.objects.get(pk=101)

        def importar(self):
            self.cur.execute('SELECT DISTINCT * FROM noticias WHERE codigo not in (2071, 2074, 2440, 2447, 2454, 2935, 4179, 4180, 4185,  2558, 2583, 2639, 2702, 2703, 2804, 2892, 3935, 4092) AND codigo in (SELECT cod_registo FROM grupos_registos WHERE cod_grupo=1 and tabela="noticias")')
            for row in self.cur:
                linha = self.getLinha(row)
                try:
                    obj = conteudoModels.Noticia.objects.create(
                                                        id = linha['id'],
                                                        publicada_inicio = linha['publicada_inicio'],
                                                        ante_titulo = linha['ante_titulo'],
                                                        titulo = linha['titulo'],
                                                        pos_titulo = linha['pos_titulo'],
                                                        resumo = linha['resumo'],
                                                        noticia = linha['noticia'],
                                                        autor = linha['autor'],
                                                        capa = linha['capa'],
                                                        autor_capa = linha['autor_capa'],
                                                        foto1 = linha['foto1'],
                                                        foto2 = linha['foto2'],
                                                        criado_por = linha['criado_por'],
                                                        criado = linha['criado'],
                                                        equipa = linha['equipa'],
                                                        publicada_fim = linha['publicada_fim'],
                                                        activo = linha['activo'],
                                                        alterado_por = linha['alterado_por'],
                                                        )

                    ImportConteudoWebsite(obj, self.conn, self.conn.cursor()).importar()
                    ImportConteudoSeccao2(obj, self.conn, self.conn.cursor()).importar()
                    #ImportConteudoSeccao(obj, self.conn, self.conn.cursor()).importar()
                except Exception, e:
                    print e
                    pass

        def getLinha(self, row):
            #print row
            return {
                    'id': row[0],
                    'publicada_inicio': datetime.strptime(str(row[1]) + str(' ') + str(row[24]), "%Y-%m-%d %H:%M:%S"),
                    'ante_titulo': row[2],
                    'titulo': row[3],
                    'pos_titulo': row[4],
                    'resumo': row[5],
                    'noticia': row[6],
                    'autor': row[7],
                    'capa': row[8],
                    'autor_capa': row[9],
                    'foto1': row[10],
                    'foto2': row[11],
                    'criado_por': User.objects.get(pk=row[14]),
                    'criado': datetime.strptime(str(row[15]) + str(' ') + str(row[16]), "%Y-%m-%d %H:%M:%S"),
                    'equipa': self.get_equipa(row[21]),
                    'publicada_fim': self.get_publicada_fim(row[22],row[25]),
                    'activo': row[23],
                    #'alterado_por': self.User,
                    'alterado_por': User.objects.get(pk=row[14]),
                    }

        def get_equipa(self,val):
            if val is None:
                return None
            try:
                return User.objects.get(pk=val)
            except Exception, e:
                print e
                return None

        def get_publicada_fim(self,val1,val2):
            if val1 is None:
                return None
            try:
                if val1 is not None and val2 is not None:
                    return datetime.strptime(str(val1) + str(' ') + str(val2), "%Y-%m-%d %H:%M:%S")
                else:
                    return None
            except Exception, e:
                print e
                return None





    print 'BEGIN'

    import MySQLdb as mdb
    import sys

    con = None

    try:

        con = mdb.connect(django_settings.SIM4_CONN[0],django_settings.SIM4_CONN[1],django_settings.SIM4_CONN[2],django_settings.SIM4_CONN[3],charset="utf8");

        #con.set_character_set('utf8')

        cur = con.cursor()
        """
        cur.execute('SET NAMES utf8;')
        cur.execute('SET CHARACTER SET utf8;')
        cur.execute('SET character_set_connection=utf8;')
        """
        """
        cur.execute("SELECT VERSION()")

        data = cur.fetchone()

        print "Database version : %s " % data
        """
        ##ImportSeccao(con, cur).importar()
        """
        conteudoModels.Seccao.objects.create(
                    id = 1,
                    title = str('Notícias'),
                    criado_por = User.objects.get(pk=101),
                    criado = datetime.today(),
                    alterado_por = User.objects.get(pk=101),
                    )
        conteudoModels.Seccao.objects.create(
                    id = 2,
                    title = str('Igreja Primaz'),
                    criado_por = User.objects.get(pk=101),
                    criado = datetime.today(),
                    alterado_por = User.objects.get(pk=101),
                    )
        conteudoModels.Seccao.objects.create(
                    id = 3,
                    title = str('A Voz do Arcebispo'),
                    criado_por = User.objects.get(pk=101),
                    criado = datetime.today(),
                    alterado_por = User.objects.get(pk=101),
                    )
        conteudoModels.Seccao.objects.create(
                    id = 4,
                    title = str('Fotografias'),
                    criado_por = User.objects.get(pk=101),
                    criado = datetime.today(),
                    alterado_por = User.objects.get(pk=101),
                    )
        conteudoModels.Seccao.objects.create(
                    id = 5,
                    title = str('Multimédia'),
                    criado_por = User.objects.get(pk=101),
                    criado = datetime.today(),
                    alterado_por = User.objects.get(pk=101),
                    )
        """
        ImportLink(con, cur).importar()
        ImportConteudo(con, cur).importar()
        #ImportMultimediaSeccao(con, cur).importar()
        #ImportFotografiaSeccao(con, cur).importar()
        #ImportFotografia(con, cur).importar()
        #ImportMultimedia(con, cur).importar()


    except mdb.Error, e:
        print "Error %d: %s" % (e.args[0], e.args[1])
        sys.exit(1)
    finally:
        if con:
            con.close()

    print 'END'


