#coding: utf-8
from django.conf import settings as django_settings

if not hasattr(django_settings, 'SIM4_CONN'):
    raise Exception('SIM4_CONN não existe no ficheiro de settings.py\nExemplo:\n\tSIM4_CONN = "dbname=\'db_name\' user=\'db_user\' host=\'db_host\' password=\'db_password\'"')
    pass
else:

    from agenda import models as agendaModels
    from django.contrib.auth.models import User
    from datetime import datetime
    import HTMLParser
    _htmlparser = HTMLParser.HTMLParser()
    unescape = _htmlparser.unescape

    from website import models as modelsWebsite

    def get_fromtimestamp(val):
        if val is None:
            return None
        try:
            return datetime.fromtimestamp(val)
        except Exception, e:
            print e
            return None

    def get_strpdate(val):
        if val is None:
            return None
        try:
            return val
        except Exception, e:
            print e
            return None


    def get_entidade(val):
        if val is None:
            return None
        try:
            return agendaModels.AgendaEntidade.objects.get(pk=val)
        except Exception, e:
            print e
            return None


    def  get_local(val):
        if val is None:
            return None
        try:
            return agendaModels.AgendaLocal.objects.get(pk=val)
        except Exception, e:
            print e
            return None







    class ImportAgenda(object):

        def __init__(self, conn, cur):
            self.conn = conn
            self.cur = cur
            self.User = User.objects.get(pk=101)

        def importar(self):
            #self.cur.execute('SELECT DISTINCT * FROM agenda WHERE codigo in (SELECT cod_registo FROM grupos_registos WHERE cod_grupo!=1 and tabela="agenda")')
            self.cur.execute('SELECT DISTINCT agenda.*, grupos_registos.cod_grupo FROM agenda LEFT JOIN grupos_registos ON agenda.codigo=grupos_registos.cod_registo AND grupos_registos.cod_grupo!=1 and grupos_registos.tabela="agenda" WHERE grupos_registos.cod_grupo!=1 and grupos_registos.tabela="agenda"')

            for row in self.cur:
                
                try:
                    linha = self.getLinha(row)

                    agenda = agendaModels.Agenda.objects.filter(pk=linha['id'])

                    if len(agenda)==0:
                        website = modelsWebsite.WebSite.objects.get(pk=linha['cod_grupo'])
                        
                        if linha['local']:
                            self.cur.execute('SELECT DISTINCT * FROM agenda_locais WHERE codigo="'+str(linha['local'])+'"')
                            row1 = self.cur.fetchone()
                            linha1 = self.getLinha1(row1)

                            local = agendaModels.AgendaLocal.objects.filter(titulo=linha1['titulo'], website=website)

                            if len(local)==0:

                                local=agendaModels.AgendaLocal.objects.create(
                                                                    #id = linha1['id'],
                                                                    titulo = linha1['titulo'],
                                                                    criado = linha1['criado'],
                                                                    criado_por = linha1['criado_por'],
                                                                    alterado_por = linha1['alterado_por'],
                                                                    website = website,
                                                                    )
                            else:
                                local=local[0]
                        else:
                            local=None

                        if linha['entidade']:
                            self.cur.execute('SELECT DISTINCT * FROM agenda_entidades WHERE codigo="'+str(linha['entidade'])+'"')
                            row2 = self.cur.fetchone()
                            linha2 = self.getLinha2(row2)

                            entidade = agendaModels.AgendaEntidade.objects.filter(titulo=linha2['titulo'], website=website)

                            if len(entidade)==0:

                                entidade=agendaModels.AgendaEntidade.objects.create(
                                                                    #id = linha2['id'],
                                                                    titulo = linha2['titulo'],
                                                                    criado_por = linha2['criado_por'],
                                                                    criado = linha2['criado'],
                                                                    alterado_por = linha2['alterado_por'],
                                                                    website = website,
                                                                    )
                            else:
                                entidade=entidade[0]
                        else:
                            entidade=None

                        agendaModels.Agenda.objects.create(
                                                            #id = linha['id'],
                                                            titulo = linha['titulo'],
                                                            descricao = linha['descricao'],
                                                            #entidade = linha['entidade'],
                                                            entidade = entidade,
                                                            criado_por = linha['criado_por'],
                                                            #local = linha['local'],
                                                            local = local,
                                                            data_inicio = linha['data_inicio'],
                                                            data_fim = linha['data_fim'],
                                                            criado = linha['criado'],
                                                            alterado_por = linha['alterado_por'],
                                                            website = website,
                                                            )


                    else:
                        obj=agenda[0]

                except Exception, e:
                    print e
                    pass

        def getLinha(self, row):
            #print row
            return {
                    'id': row[0],
                    'titulo': self.get_unescape(row[1]),
                    'descricao': self.get_unescape(row[2]),
                    #'entidade': get_entidade(row[3]),
                    'entidade': row[3],
                    'criado_por': User.objects.get(pk=row[4]),
                    #'local': get_local(row[5]),
                    'local': row[5],
                    'data_inicio': datetime.fromtimestamp(row[6]),
                    'data_fim': datetime.fromtimestamp(row[7]),
                    'criado': datetime.strptime(str(row[8]) + str(' ') + str(row[9]), "%Y-%m-%d %H:%M:%S"),
                    #'alterado_por': self.User,
                    'alterado_por': User.objects.get(pk=row[4]),
                    'cod_grupo': row[10],
                    }
        def getLinha1(self, row):
            #print row
            return {
                    'id': row[0],
                    'titulo': row[1],
                    'criado': datetime.fromtimestamp(row[2]),
                    'criado_por': User.objects.get(pk=row[3]),
                    #'alterado_por': self.User,
                    'alterado_por': User.objects.get(pk=row[3]),
                    }

        def getLinha2(self, row):
            #print row
            return {
                    'id': row[0],
                    'titulo': row[1],
                    'criado_por': User.objects.get(pk=row[2]),
                    'criado': datetime.strptime(str(row[3]) + str(' ') + str(row[4]), "%Y-%m-%d %H:%M:%S"),
                    #'alterado_por': self.User,
                    'alterado_por': User.objects.get(pk=row[2]),
                    }
        def get_unescape(self, val):
            if val is None:
                return None
            try:
                return unescape(val)
            except Exception, e:
                print e
                pass




    print 'BEGIN'

    import MySQLdb as mdb
    import sys

    con = None

    try:

        con = mdb.connect(django_settings.SIM4_CONN[0],django_settings.SIM4_CONN[1],django_settings.SIM4_CONN[2],django_settings.SIM4_CONN[3],charset="utf8");

        #con.set_character_set('utf8')

        cur = con.cursor()
        """
        cur.execute('SET NAMES utf8;')
        cur.execute('SET CHARACTER SET utf8;')
        cur.execute('SET character_set_connection=utf8;')
        """
        """
        cur.execute("SELECT VERSION()")

        data = cur.fetchone()

        print "Database version : %s " % data
        """

        ImportAgenda(con, cur).importar()

    except mdb.Error, e:
        print "Error %d: %s" % (e.args[0], e.args[1])
        sys.exit(1)
    finally:
        if con:
            con.close()

    print 'END'


