#coding: utf-8
"""
This file was generated with the custommenu management command, it contains
the classes for the admin menu, you can customize this class as you want.

To activate your custom menu add the following to your settings.py::
    ADMIN_TOOLS_MENU = 'photoimagem2.menu.CustomMenu'
"""

from django.core.urlresolvers import reverse
from django.utils.translation import ugettext_lazy as _

from admin_tools.menu import items, Menu



class CustomMenu(Menu):
    """
    Custom Menu for admin site.
    """
    def __init__(self, **kwargs):
        Menu.__init__(self, **kwargs)

    def init_with_context(self, context):
        """
        Use this method if you need to access the request context.
        """

        self.children += [
            items.MenuItem(_(u'Dashboard'), reverse('admin:index')),
            items.Bookmarks(_(u'Favoritos')),
            items.AppList(
                _(u'Módulos'),
                exclude=('django.contrib.*', 'elfinder.*', 'diocese.*', )
            ),
        ]

        if context['user'].has_module_perms('diocese'):
             self.children += [items.MenuItem('Diocese',
                children=[

                    items.MenuItem('Arciprestados',
                        children=[
                                items.MenuItem('Vigararias/Arciprestados', '/admin/diocese/arciprestado'),
                                items.MenuItem('Paróquias', '/admin/diocese/paroquia/'),
                        ]
                    ),
                    items.MenuItem('Clero',
                        children=[
                                items.MenuItem('Diáconos Permanentes', '/admin/diocese/diaconopermanente/'),
                                items.MenuItem('Bispos', '/admin/diocese/bispo/'),
                                items.MenuItem('Presbíteros', '/admin/diocese/presbitero/'),
                                items.MenuItem('Diáconos', '/admin/diocese/diacono/'),
                        ]
                    ),
                    items.MenuItem('Instituições',
                        children=[
                                items.MenuItem('Associações e Obras para Presbíteros', '/admin/diocese/associacaoobrapresbitero/'),
                                items.MenuItem('Associações Movimentos e Obras', '/admin/diocese/associacaomovimentoobra/'),
                                items.MenuItem('Centros de Animação Espiritual', '/admin/diocese/centroanimacaoespiritual/'),
                                items.MenuItem('Centros de Vida Cristã', '/admin/diocese/centrovidacrista/'),
                                items.MenuItem('Chancelaria/secretaria geral', '/admin/diocese/chancelaria/'),
                                items.MenuItem('Colégio de Arciprestes', '/admin/diocese/colegioarciprestes/'),
                                items.MenuItem('Colégio de Consultores', '/admin/diocese/colegioconsultores/'),
                                items.MenuItem('Comissões', '/admin/diocese/comissao/'),
                                items.MenuItem('Comunicações Sociais', '/admin/diocese/comunicacaosocial/'),
                                items.MenuItem('Conselho Pastoral', '/admin/diocese/conselhopastoral/'),
                                items.MenuItem('Conselho Presbiteral', '/admin/diocese/conselhopresbiteral/'),
                                items.MenuItem('Cúria Diocesana', '/admin/diocese/curiadiocesana/'),
                                items.MenuItem('Diaconado Permanente', '/admin/diocese/diaconadopermanente/'),
                                items.MenuItem('Escolas Católicas', '/admin/diocese/escolacatolica/'),
                                items.MenuItem('Formação de Agentes de Pastoral', '/admin/diocese/formacaoagentepastoral'),
                                items.MenuItem('Gestão de recursos pessoais, patrimoniais e financeiros', '/admin/diocese/gestaorecursos/'),
                                items.MenuItem('Instituições Culturais', '/admin/diocese/instituicaocultural/'),
                                items.MenuItem('Institutos Religiosos Femininos', '/admin/diocese/institutoreligiosofeminino/'),
                                items.MenuItem('Institutos Religiosos Masculinos', '/admin/diocese/institutoreligiosomasculino/'),
                                items.MenuItem('Institutos Seculares', '/admin/diocese/institutosecular/'),
                                items.MenuItem('Obras de Acção Sócio Caritativa', '/admin/diocese/obraaccaosociocaritativa/'),
                                items.MenuItem('Prelaturas pessoais', '/admin/diocese/prelaturapessoal/'),
                                items.MenuItem('Secretariados/serviços/departamentos', '/admin/diocese/secretariado/'),
                                items.MenuItem('Seminários', '/admin/diocese/seminario/'),
                                items.MenuItem('Tribunais Eclesiástico', '/admin/diocese/tribunaleclesiastico/'),
                                items.MenuItem('Outras Instituições', '/admin/diocese/outrainstituicao/'),
                                #items.MenuItem('Sociedades de Vida Apostólica', '/admin/diocese/sociedadevidaapostolica/'),
                        ]
                    ),
                    items.MenuItem('Cabidos', '/admin/diocese/cabido/'),
                    items.MenuItem('Estatísticas', '/admin/diocese/dadosestatisticos/'),
                    items.MenuItem('Notas Históricas', '/admin/diocese/notahistorica/'),
                ]
            )]

             self.children += [items.MenuItem('Formulários',
                children=[
                    items.MenuItem('Etiquetas Clero Envelope', '/admin/formularios/etiquetas_clero_envelope'),
                    items.MenuItem('Etiquetas Clero', '/admin/formularios/etiquetas_clero'),
                    items.MenuItem('Etiquetas Clero - Contactos', '/admin/formularios/etiquetas_clero_contactos'),
                    items.MenuItem('Etiquetas Clero - Nascimento', '/admin/formularios/etiquetas_clero_nascimento'),
                    items.MenuItem('Etiquetas Clero - Idade', '/admin/formularios/etiquetas_clero_idade'),
                    items.MenuItem('Etiquetas Clero - Ordenações', '/admin/formularios/etiquetas_clero_ordenacao'),
                    items.MenuItem('Etiquetas Locais Culto', '/admin/formularios/etiquetas_locais_culto'),
                    items.MenuItem('Etiquetas Instituições', '/admin/formularios/etiquetas_instituicoes'),
                    #items.MenuItem('Anuário', '/admin/formularios/anuario'),

                        ]
            )]






        self.children += [items.AppList(
            _(u'Administração'),
            models=('django.contrib.*',)
        )]
        return super(CustomMenu, self).init_with_context(context)
