#coding: utf-8
from django.db import models
from django.contrib import admin
from django import forms

from elfinder.hooks.ElfinderImageField import ElfinderImageWidget
from tinymce import widgets as tinymce_widgets
from django.utils.translation import ugettext_lazy as _
from datetime import datetime

from myadmin.admin import MyBaseAdmin, MyBaseForm

#from website import models as modelsDbraga

from peakitcms.manager import CmsDefaultManager

from django.db.models import get_model


# HorarioLocal
from peakitcms.horarios.local import models as modelsHorarioLocal

class HorarioLocal(modelsHorarioLocal.getBaseHorarioLocal()):
    website = models.ForeignKey(get_model('website','WebSite'), verbose_name=_(u'Website'), related_name='horarios_horariolocals_website', default=1)
    objects = models.Manager()
    publicado = CmsDefaultManager()
    #pass

class HorarioLocalForm(MyBaseForm, modelsHorarioLocal.getBaseHorarioLocalForm(HorarioLocal)):
    pass

horariolocal_fieldsets = modelsHorarioLocal.getBaseHorarioLocalAdmin(HorarioLocal).fieldsets

class HorarioLocalAdmin(MyBaseAdmin, modelsHorarioLocal.getBaseHorarioLocalAdmin(HorarioLocal)):
    form = HorarioLocalForm
    fieldsets = horariolocal_fieldsets

# Fim HorarioLocal

# HorarioTipo
from peakitcms.horarios.tipo import models as modelsHorarioTipo

class HorarioTipo(modelsHorarioTipo.getBaseHorarioTipo()):
    website = models.ForeignKey(get_model('website','WebSite'), verbose_name=_(u'Website'), related_name='horarios_horariotipos_website', default=1)
    objects = models.Manager()
    publicado = CmsDefaultManager()
    #pass

class HorarioTipoForm(MyBaseForm, modelsHorarioTipo.getBaseHorarioTipoForm(HorarioTipo)):
    pass

horariotipo_fieldsets = modelsHorarioTipo.getBaseHorarioTipoAdmin(HorarioTipo).fieldsets

class HorarioTipoAdmin(MyBaseAdmin, modelsHorarioTipo.getBaseHorarioTipoAdmin(HorarioTipo)):
    form = HorarioTipoForm
    fieldsets = horariotipo_fieldsets

# Fim HorarioTipo

# Horarios
from peakitcms.horarios.horario import models as modelsHorario

class Horario(modelsHorario.getBaseHorario()):
    website = models.ForeignKey(get_model('website','WebSite'), verbose_name=_(u'Website'), related_name='horarios_horarios_website', default=1)
    objects = models.Manager()
    publicado = CmsDefaultManager()
    #pass

horario_fildsets = modelsHorario.getBaseHorarioAdmin(Horario).fieldsets

class HorarioActividades(modelsHorario.getBaseHorarioActividades(Horario, HorarioTipo, HorarioLocal)): pass

class HorarioForm(MyBaseForm, modelsHorario.getBaseHorarioForm(Horario)):
    pass

class HorarioAdmin(MyBaseAdmin, modelsHorario.getBaseHorarioAdmin(Horario)):
    form = HorarioForm
    fieldsets = horario_fildsets
    inlines = [modelsHorario.getBaseHorarioActividadeInline(HorarioActividades),]
# Fim Horarios

