#coding: utf-8
import os.path
import os
from django.http import HttpResponse
from django.shortcuts import render_to_response
from django.utils import simplejson as json
from django.template import RequestContext
from elfinder.connector import ElFinderConnector
from elfinder.models import FileCollection,Directory,File
from elfinder.volume_drivers.fs_driver import FsVolumeDriver
import simplejson
from django.conf import settings
from django.contrib.auth.decorators import login_required


@login_required(login_url='/')
def index(request, coll_id):
    """ Displays the elFinder file browser template for the specified
        FileCollection.
    """
    collection = FileCollection.objects.get(pk=coll_id)
    return render_to_response("elfinder.html",
                              {'coll_id': collection.id},
                              RequestContext(request))


@login_required(login_url='/')
def connector_view(request, coll_id):
    """ Handles requests for the elFinder connector.
    """

    model_volume = FsVolumeDriver(coll_id)

    finder = ElFinderConnector([model_volume])
    finder.run(request)

    # Some commands (e.g. read file) will return a Django View - if it
    # is set, return it directly instead of building a response
    if finder.return_view:
        return finder.return_view

    response = HttpResponse(mimetype=finder.httpHeader['Content-type'])
    response.status_code = finder.httpStatusCode
    if finder.httpHeader['Content-type'] == 'application/json':
        response.content = json.dumps(finder.httpResponse)
    else:
        response.content = finder.httpResponse

    return response

@login_required(login_url='/')
def read_file(request, volume, file_hash, template="read_file.html"):
    """ Default view for responding to "open file" requests.

        coll: FileCollection this File belongs to
        file: The requested File object
    """
    return render_to_response(template,
                              {'file': file_hash},
                              RequestContext(request))

from django.core.serializers.json import DjangoJSONEncoder

def jsonEncode( obj ):
    return simplejson.dumps( obj, ensure_ascii=True,indent=4 )


@login_required(login_url='/')
def create_fs(request):
    import datetime
    import tempfile
    dir= os.path.abspath(os.path.realpath(settings.MEDIA_ROOT +'/contents/')) #os.path.abspath(os.path.dirname(os.path.realpath(__file__))+'/../../media/contents/')
    os.chmod(dir,0777) #Força a pasta a ter permissões 777
    dirpath = tempfile.mkdtemp(prefix = 'contents_',dir = dir)
    os.chmod(dirpath,0777) #Força a pasta a ter permissões 777
    fc = FileCollection(dir = dirpath,name = 'Filesystem',url='contents/'+os.path.basename(dirpath))
    fc.save();
    (mode, ino, dev, nlink, uid, gid, size, atime, mtime, ctime) = os.stat(dirpath)
    mtime = datetime.datetime.fromtimestamp(mtime)
    d = Directory(name = '/',collection=fc,last_modification=mtime)
    d.save()
    return HttpResponse(jsonEncode({'id':fc.id}), mimetype="application/json")

@login_required(login_url='/')
def getFsPath(request):
    try:
        if 'fs' not in request.POST:
            raise Exception("Não foi encontrado o fs")
        fs = FileCollection.objects.get(pk=request.POST['fs'])
        return HttpResponse(jsonEncode({'path':fs.url}), mimetype="application/json")
    except Exception, e:
        return HttpResponse(jsonEncode({'path':str(e)}), mimetype="application/json")

    #    return HttpResponse(jsonEncode({'path':request.POST['fs']}), mimetype="application/json")
    #else:
    #    return HttpResponse(jsonEncode({'path':''}), mimetype="application/json")
@login_required(login_url='/')
def getFsFilesRoot(request):
    try:
        if 'fs' not in request.POST:
            raise Exception("Não foi encontrado o fs")
        fs = FileCollection.objects.get(pk=request.POST['fs'])
        files = map(lambda x: x.getPathWithoutMEDIA(),File.objects.filter(collection__pk = fs.pk,mimetype__in=['image/jpeg','image/png','image/gif']).order_by('name') )
        
        return HttpResponse(jsonEncode({'files':files}), mimetype="application/json")
    except Exception, e:
        return HttpResponse(jsonEncode({'files2':str(e)}), mimetype="application/json")
