#coding: utf-8
from django.db import models
from django.dispatch import receiver
from django.db.models.signals import pre_delete
from mptt.models import MPTTModel, TreeForeignKey
import os
import time
import datetime
import mimetypes
from django.conf import settings

class FileCollectionChildMixin:
    def getTipo(self):
        return ''
    """ Provides common methods for Files/Directories.
    """
    def get_parent_hash(self):
        """ Returns the hash of this object's parent, or '' if this is the
            root of the tree.
        """
        if self.parent:
            return self.parent.get_hash()
        else:
            return ''
    
    def isReal(self):
        return True
    
    def getPathDirs(self):
        l = []
        if self.parent != None:
            elem = self.parent
            while elem.parent != None:
                l.append(elem.name)
                elem = elem.parent
        l.reverse()
        return "/".join(l) 
    
    def getDirBefore(self):
        return self.collection.dir + "/" + self.getPathDirs()
    
    def getUrl(self):
        return settings.MEDIA_URL+self.collection.url + self.getPathDirs() + "/" + self.name
    
    def getPathMEDIA(self):
        return settings.MEDIA_ROOT + self.collection.url + self.getPathDirs() + "/" + self.name
    
    def getPathWithoutMEDIA(self):
        return self.collection.url + self.getPathDirs() + "/" + self.name
    
    def getPath(self):
        return settings.MEDIA_ROOT + self.collection.url + self.getPathDirs() + "/" + self.name
        #return self.collection.dir + "/"+ self.getPathDirs() + "/" + self.name
    
        
class Directory(MPTTModel, FileCollectionChildMixin):
    """ A Directory in the file structure of a FileCollection. May contain
        child Directory and File objects.

        TODO prevent directories which are not auto-created root nodes from
             being saved with no parent.
    """
    name = models.CharField(max_length=255)
    parent = TreeForeignKey('self', null=True, blank=True, related_name='dirs')
    collection = models.ForeignKey('FileCollection')
    last_modification = models.DateTimeField()
    
    class Meta:
        verbose_name_plural = 'directories'
        unique_together = ('name', 'parent','collection')
    
    def getTipo(self):
        return 'd'
    
    def __unicode__(self):
        return self.name

    def get_hash(self):
        return '%s_d%s' % (self.collection.get_volume_id(), self.id)

    def get_info(self):
        """ Returns an object to represent this object in elFinder. Populates
            'cwd' in response to 'open' command.

            If the object is the root dir, 'volume_id' is included in the
            response.
        """
        obj = {'name': self.name,
               'hash': self.get_hash(),
               'phash': self.get_parent_hash(),
               'mime': 'directory',
               'read': 1,
               'write': 1,
               'size': 0,
               'dirs': 0 if (self.dirs.count() == 0) else 1,
               'path':self.getPath(),
               'is_real':self.isReal(),
               'date':str(self.last_modification),
               }

        if not self.parent:
            obj['volume_id'] = self.collection.get_volume_id()
            obj['locked'] = 1
            obj['name'] = self.collection.name

        return obj
    def updateFiles(self):
        if self.isReal():
            path = self.getPath()
            dirs = []
            files = []
            for f in os.listdir(path):
                caminho = path+"/"+f
                (mode, ino, dev, nlink, uid, gid, size, atime, mtime, ctime) = os.stat(caminho)
                mtime = datetime.datetime.fromtimestamp(mtime)
                if os.path.isdir(caminho):
                    dirs.append(f)
                    try:
                        obj = Directory.objects.get(parent = self, name = f,collection = self.collection)
                        if obj.last_modification !=  mtime:
                            obj.last_modification = mtime
                            obj.save()
                    except Exception,e:
                        obj = Directory(name = f,parent = self,collection = self.collection, last_modification = mtime )
                        obj.save()
                    
                else:
                    files.append(f)
                    mime = mimetypes.guess_type(caminho)
                    try:
                        obj = File.objects.get(parent = self, name = f,collection = self.collection )
                        if obj.last_modification !=  mtime:
                            obj.last_modification = mtime
                            obj.size = size
                            obj.mimetype = mime[0]
                            obj.save()
                    except Exception,e:
                        
                        obj = File(name = f,parent = self,collection = self.collection, last_modification = mtime, mimetype = mime[0] ,size = size )
                        obj.save()
                    #print f
                    pass
                
            Directory.objects.filter(parent = self,collection = self.collection).exclude(name__in = dirs).delete()
            File.objects.filter(parent = self,collection = self.collection).exclude(name__in = files).delete()
            

class FileCollection(models.Model):
    """ A collection of Directory and File objects.

        # TODO delete files/dirs when deleting file collection
    """
    #name = models.CharField(max_length=255, unique=True)
    name = models.CharField(max_length=255,)
    dir = models.CharField(max_length=255)
    url = models.CharField(max_length=255)
    #tree_id = models.CharField(
    #root_node = models.OneToOneField(Directory)

    def save(self, *args, **kwargs):
        """ Creates a Directory (root node) when the FileCollection is first
            created.
        """
        created = (self.id is None)
        super(FileCollection, self).save(*args, **kwargs)
        #if created:
            #root_dir = Directory(name='root_node_%s' % self.id, collection=self)
            #root_dir.save()

    def __unicode__(self):
        return self.name

    def get_volume_id(self):
        return 'fc%s' % self.id


class File(models.Model, FileCollectionChildMixin):
    """ A File in a FileCollection.
    """
    name = models.CharField(max_length=255)
    parent = TreeForeignKey(Directory, null=True, blank=True,
                            related_name='files')
    content = models.TextField(max_length=2048, blank=True)
    collection = models.ForeignKey('FileCollection')
    mimetype = models.CharField(max_length=255,null=True,blank=True)
    size = models.PositiveIntegerField()
    last_modification = models.DateTimeField()
    
    def getTipo(self):
        return 'f'
    
    
    class Meta:
        unique_together = ('name', 'parent')

    def __unicode__(self):
        return self.name
    
    def get_hash(self):
        return '%s_f%s' % (self.collection.get_volume_id(), self.id)

    def get_info(self):
        """ Returns an object to represent this object in elFinder. Populates
            'cwd' in response to 'open' command.
        """
        
        return {'name': self.name,
                'hash': self.get_hash(),
                'phash': self.get_parent_hash(),
                'mime': self.mimetype if self.mimetype != None else 'unknown',
                'size': self.size,
                'read': True,
                'write': True,
                'rm': True,
                'path':self.getPath(),
                'is_real':self.isReal(),
                'url':self.getUrl(),
                'resize':True,
                'date':str(self.last_modification),
               }
