import django.forms as forms
from django.forms.util import flatatt
from django.utils.safestring import mark_safe
import django.db.models.fields as fields
from django.conf import settings


class ElfinderImageWidget(forms.TextInput):

    CLIENT_CODE = "<input type=\"button\" value=\"upload\" class=\"elfinder_image\" %s /><input type=\"button\" value=\"X\" class=\"elfinder_image_remove\" field_name=\"%s\" /> %s"

    def __init__(self, attrs = None,fs_name = 'fs',helpText='',showImage=True):
        """"""
        attrs = {} if attrs is None else attrs
        attrs.update({'readonly':'readonly'})
        attrs = attrs #+ dict({'readonly':'readonly'})
        super(ElfinderImageWidget, self).__init__(attrs)
        self.fs_name = 'fs' if fs_name is None else fs_name
        self.helpText = 'fs' if helpText is None else helpText
        self.showImage = showImage

    def render(self, name, value, attrs = None):
        
        res = super(ElfinderImageWidget, self).render(name, value, attrs)
        attribs = {
            'fs_name':self.fs_name,
            'field_name':name,
        }
        attribs = flatatt(attribs)
        if value!='' and value is not None and self.showImage:
            image = "<div><img src='"+settings.MEDIA_URL+"/%s' class='elfinder_image_preview' %s /></div>" % (value,attribs)
        else:
            image = ""
        #print mark_safe(self.CLIENT_CODE % (attribs, name,self.helpText))
        return res + mark_safe(self.CLIENT_CODE % (attribs, name,self.helpText)) + mark_safe(image)
    class Media:
        #css = { 'all': ('pretty.css',) }
        js = ('js/django_fs.js',)

class ElfinderImageField(fields.Field):
    widget = ElfinderImageWidget

    def __init__(self, text = None, link_attrs = None, *args, **kwargs):
        """
        Have to pass a list of field types to the constructor, else we
        won't get any data to our compress method.
        """
        super(ElfinderImageField, self).__init__(*args, **kwargs)

        self.widget.link_attrs = link_attrs
        self.widget.text = text



        