#coding: utf-8
from django.db import models
from django.contrib.auth.models import User
from django.utils.translation import ugettext_lazy as _
from django.contrib import admin
from django import forms

from datetime import datetime
from mptt.models import MPTTModel
from elfinder.models import FileCollection

class SharedBase(models.Model):
    activo = models.BooleanField(_(u'publicada'), default=True)
    criado_por = models.ForeignKey(User, related_name='%(app_label)s_%(class)s_criado_por', editable=False)
    alterado_por = models.ForeignKey(User, related_name='%(app_label)s_%(class)s_alterado_por', editable=False)
    criado = models.DateTimeField(default=datetime.now,null=True,blank=True)
    alterado = models.DateTimeField(default=datetime.now,null=True,blank=True)
    fs = models.ForeignKey(FileCollection, related_name='%(app_label)s_%(class)s_file_collection', editable=True, null=True, blank=True)
    codigo_ecclesia = models.IntegerField(null=True,blank=True)
    
    class Meta:
        abstract = True
        
class Base(SharedBase):
    """
    O campo activo herdado da class SharedBase é aproveitado como campo aprovado
    """
    #publicada_inicio = models.DateTimeField(_(u'inicio'),default=datetime.now, blank=True, null=True, db_index=True, help_text=_('Will be set automatically once you tick the `published` checkbox above.'))
    #publicada_fim = models.DateTimeField(_(u'fim'),null=True,blank=True, db_index=True)
    #aprovado_por = models.ForeignKey(User, related_name='%(app_label)s_%(class)s_aprovado_por', editable=False, null=True, blank=True)
    #aprovado = models.DateTimeField(null=True,blank=True)
    
    class Meta(SharedBase.Meta):
        abstract = True

class BaseMPTT(MPTTModel, SharedBase):
    """
    Os campos title e parent são obrigatórios para o mptt, logo são usados por defeito na class BaseMPTT
    """
    title = models.CharField(_(u'título'), max_length=255)
    parent = models.ForeignKey('self', verbose_name=_(u'Pai'), blank=True, null=True, related_name='%(app_label)s_%(class)s_parent')
    
    class Meta(SharedBase.Meta):
        abstract = True

DEFAULT_FIELDSETS = {
                     'informacao':(_(u'Informação'), {
                                         'fields':(
                                                   ('criado', 'fake_criado_por'),
                                                   ('alterado', 'fake_alterado_por'),
                                                   ),
                                         'classes':('collapse',)
                                         }),
                     'publicacao':(_(u'Publicação'), {
                                         'fields':(
                                                   'activo',
                                                   ('publicada_inicio', 'publicada_fim'),
                                                   ),
                                         'classes':('collapse',)
                                         })
                     }

class BaseForm(forms.ModelForm):
    fake_criado_por = forms.CharField(label=_(u'Por'), widget=forms.widgets.TextInput(attrs={'readonly':'readonly'}), required=False)
    fake_alterado_por = forms.CharField(label=_(u'Por'), widget=forms.widgets.TextInput(attrs={'readonly':'readonly'}), required=False)
    criado = forms.DateTimeField(widget=forms.widgets.DateTimeInput(attrs={'readonly':'readonly', 'size':'22'}), initial=datetime.now(), required=False)
    alterado = forms.DateTimeField(widget=forms.widgets.DateTimeInput(attrs={'readonly':'readonly', 'size':'22'}), initial=datetime.now(), required=False)

    def __init__(self, *args, **kwargs):
        super(BaseForm, self).__init__(*args, **kwargs)
        if not self.instance.pk is None:
            self.fields['fake_criado_por'].initial=self.instance.criado_por
            self.fields['fake_alterado_por'].initial=self.instance.alterado_por

def getBaseAdmin(mymodel):
    class BaseAdmin(admin.ModelAdmin):
        save_on_top = True
        def save_model(self, request, obj, form, change):
            if change==True:
                tmp = mymodel.objects.get(pk=obj.id)
                if tmp.activo != obj.activo:
                    if obj.activo!= True:
                        obj.aprovado_por=None
                    else:
                        obj.aprovado_por=request.user
                obj.alterado_por=request.user
            else:
                if obj.activo:
                    obj.aprovado_por = request.user
                else:
                    obj.aprovado_por=None
                obj.criado_por=request.user
                obj.alterado_por=request.user
                obj.criado = datetime.now()
            obj.alterado = datetime.now()
            super(BaseAdmin, self).save_model(request, obj, form, change)
    return BaseAdmin    
    