#coding: utf-8
from django.db import models
from django.utils.translation import ugettext_lazy as _
from diocesesim.models import getBaseAdmin, SharedBase
from django import forms


# Models
def getBaseSociedadeVidaApostolica():
    class BaseSociedadeVidaApostolica(SharedBase):
        nome = models.CharField(_(u'Nome'), max_length=255)
        director = models.CharField(_(u'Responsável/ Director'), max_length=255, null=True, blank=True)
        morada = models.CharField(_(u'Morada'), max_length=255, null=True, blank=True)
        codigo_postal = models.CharField(_(u'Código postal'), max_length=255, null=True, blank=True)
        localidade = models.CharField(_(u'Localidade'), max_length=255, null=True, blank=True)
        telefone = models.CharField(_(u'Telefone'), max_length=255, null=True, blank=True)
        telemovel = models.CharField(_(u'Telemóvel'), max_length=255, null=True, blank=True)
        fax = models.CharField(_(u'Fax'), max_length=255, null=True, blank=True)
        email = models.CharField(_(u'Email'), max_length=255, null=True, blank=True)
        paginaweb = models.CharField(_(u'Página web'), max_length=255, null=True, blank=True)

        class Meta:
            verbose_name = _(u'Sociedade de Vida Apostólica')
            verbose_name_plural = _(u'Sociedades de Vida Apostólica')
            abstract = True
            ordering = ['nome']

        def __unicode__(self):
            return self.nome
    return BaseSociedadeVidaApostolica
# Fim Models

# Admin
def getBaseSociedadeVidaApostolicaForm(mymodel):
    class BaseSociedadeVidaApostolicaForm(forms.ModelForm):
        class Meta:
            model = mymodel

    return BaseSociedadeVidaApostolicaForm

def getBaseSociedadeVidaApostolicaAdmin(mymodel):
    class BaseSociedadeVidaApostolicaAdmin(getBaseAdmin(mymodel)):
        form = getBaseSociedadeVidaApostolicaForm(mymodel)
        fieldsets = (
                     (None, {
                             'fields':(
                                       ('nome',),
                                       ('director',),
                                       ('morada',),
                                       ('codigo_postal','localidade',),
                                       ('telefone','telemovel',),
                                       ('fax','email',),
                                       ('paginaweb',),
                                       )
                             }),
                     )
        list_display = ('nome', 'alterado', 'id',)
        search_fields = ('nome', 'id', )

    return BaseSociedadeVidaApostolicaAdmin
# Fim Admin
