#coding: utf-8
from django.db import models
from django.utils.translation import ugettext_lazy as _
from diocesesim.models import getBaseAdmin, SharedBase
from django import forms
from diocesesim.models import Base
from django.contrib import admin

# Models
def getBasePresbitero(TIPOS_CHOICES):
    if TIPOS_CHOICES == None:
        TIPOS_CHOICES=(
            (1, _(u'Religioso')),
            (2, _(u'Diocesano')),
            (3, _(u'Residente fora da Diocese')),
            (4, _(u'De outra Diocese')),
        )

    class BasePresbitero(SharedBase):
        nome = models.CharField(_(u'Nome'), max_length=255)
        clero_tipo = models.PositiveIntegerField(_(u'Tipo'), max_length=1, choices=TIPOS_CHOICES, default=1)
        data_nascimento = models.DateField(_(u'data nascimento'), help_text='(aaaa-mm-dd)', null=True, blank=True)
        data_ordenacoa = models.DateField(_(u'data ordenação'), help_text='(aaaa-mm-dd)', null=True, blank=True)
        morada = models.CharField(_(u'Morada'), max_length=255, null=True, blank=True)
        codigo_postal = models.CharField(_(u'Código postal'), max_length=255, null=True, blank=True)
        localidade = models.CharField(_(u'Localidade'), max_length=255, null=True, blank=True)
        telefone = models.CharField(_(u'Telefone'), max_length=255, null=True, blank=True)
        telemovel = models.CharField(_(u'Telemóvel'), max_length=255, null=True, blank=True)
        fax = models.CharField(_(u'Fax'), max_length=255, null=True, blank=True)
        email = models.CharField(_(u'Email'), max_length=255, null=True, blank=True)
        paginaweb = models.CharField(_(u'Página web'), max_length=255, null=True, blank=True)
        serv_pastoral = models.TextField(_(u'Serviço Pastoral'), null=True, blank=True)
        obs = models.TextField(_(u'Observações'), null=True, blank=True)

        class Meta:
            verbose_name = _(u'Presbítero')
            verbose_name_plural = _(u'Presbíteros')
            abstract = True
            ordering = ['nome']

        def __unicode__(self):
            return self.nome
    return BasePresbitero
# Fim Models

def getBasePresbiteroRetiros(basepresbitero):
    class BasePresbiteroRetiros(models.Model):
        presbitero = models.ForeignKey(basepresbitero, verbose_name=_(u'Presbitero'), related_name='%(app_label)s_%(class)s_presbiteroretiros')
        ano = models.IntegerField(_(u'Ano'), max_length=4, null=True, blank=True)
        observacoes = models.CharField(u'Observações', max_length=255, null=True, blank=True)

        class Meta(Base.Meta):
            abstract = True
            verbose_name = _(u'Retiro')
            verbose_name_plural = _(u'Retiros')
            unique_together = ('presbitero', 'ano',)

        def __unicode__(self):
            try:
                retiro = self.presbitero.nome+' - '+self.ano
            except Exception, e:
                retiro=''
            return retiro
    return BasePresbiteroRetiros
# Fim Models

# Admin
def getBasePresbiteroRetirosInline(mymodel):
    class BasePresbiteroRetirosInline(admin.TabularInline):
        extra = 0
        model = mymodel
    return BasePresbiteroRetirosInline

def getBasePresbiteroForm(mymodel):
    class BasePresbiteroForm(forms.ModelForm):
        class Meta:
            model = mymodel

    return BasePresbiteroForm

def getBasePresbiteroAdmin(mymodel):
    class BasePresbiteroAdmin(getBaseAdmin(mymodel)):
        form = getBasePresbiteroForm(mymodel)
        fieldsets = (
                     (None, {
                             'fields':(
                                       ('nome','clero_tipo',),
                                       ('data_nascimento','data_ordenacoa',),
                                       ('morada',),
                                       ('codigo_postal','localidade',),
                                       ('telefone','telemovel',),
                                       ('fax','email',),
                                       ('paginaweb',),
                                       ('serv_pastoral','obs',),
                                       )
                             }),
                     )
        list_display = ('nome', 'alterado', 'id',)
        search_fields = ('nome', 'id', )

    return BasePresbiteroAdmin
# Fim Admin
