#coding: utf-8
from django.db import models
from django.utils.translation import ugettext_lazy as _
from diocesesim.models import getBaseAdmin, SharedBase
from django import forms

# Models
def getBasePrelaturaPessoal(CONGREGACOES_CHOICES):
    if CONGREGACOES_CHOICES == None:
        CONGREGACOES_CHOICES = (
            (1, _(u'Adoradoras Escravas do Santíssimo Sacramento e da Caridade - AASC')),
            (2, _(u'Aliança de Santa Maria (ASM)')),
            (3, _(u'Auxiliadoras da Caridade')),
            (4, _(u'Beneditinas Missionárias de Tutzing – OSB')),
            (5, _(u'Carmelitas Missionárias – C.M.')),
            (6, _(u'Carmelitas Missionárias Teresinas')),
            (7, _(u'Congregação da Apresentação de Maria - PM')),
            (10, _(u'Congregação da Divina Providência e Sagrada Família – DPSF')),
            (13, _(u'Congregação das Irmãs do Santíssimo Salvador')),
            (11, _(u'Congregação das Irmãs Franciscanas Hospitaleiras da Imaculada Conceição - CONFHIC')),
            (14, _(u'Congregação das Irmãs Servas da Sagrada Família')),
            (8, _(u'Congregação das Monjas Beneditinas da Rainha dos Apóstolos')),
            (15, _(u'Congregação das Servas Franciscanas de Nossa Senhora das Graças')),
            (9, _(u'Congregação do Bom Pastor')),
            (16, _(u'Cooperadoras Paroquiais de Santa Maria – CPSM')),
            (17, _(u'Criaditas dos Pobres')),
            (96, _(u'Doroteias (ou Irmãs Doroteias) - Província do norte')),
            (95, _(u'Doroteias (ou Irmãs Doroteias) - Província do Sul')),
            (18, _(u'Escravas da Eucaristia – ESEMD')),
            (19, _(u'Escravas do Sagrado Coração de Jesus – ACI')),
            (12, _(u'Filhas da Caridade – Canossianas Missionárias')),
            (20, _(u'Filhas da Caridade de São Vicente de Paulo')),
            (22, _(u'Filhas de Maria Auxiliadora - (FMA) – Salesianas')),
            (23, _(u'Filhas de Maria Mãe da Igreja – FMMI')),
            (24, _(u'Filhas de Nossa Senhora das Dores')),
            (28, _(u'Filhas de S. Camilo')),
            (27, _(u'Filhas de Santa Maria de Guadalupe - F.S.M.G')),
            (21, _(u'Filhas do Coração de Maria – F.C.M.')),
            (32, _(u'Franciscanas de Nossa Senhora do Bom Conselho – FBC')),
            (29, _(u'Franciscanas Missionárias da Mãe do Divino Pastor – FMMDP')),
            (30, _(u'Franciscanas Missionárias de Maria – FMM')),
            (31, _(u'Franciscanas Missionárias de Nossa Senhora – F.M.N.S.')),
            (33, _(u'Fraternidade Franciscana da Divina Providência')),
            (34, _(u'Fraternidade Missionária Verbum Dei')),
            (25, _(u'Instituto das Irmãs da Misericórdia de Verona')),
            (42, _(u'Instituto das Pequenas Missionárias de Maria Imaculada – IPMMI')),
            (43, _(u'Instituto das Religiosas do Sagrado Coração de Maria - RSCM')),
            (35, _(u'Instituto Filhas de Santa Maria de Leuca')),
            (36, _(u'Instituto Irmãs Missionárias de Nossa Senhora de Fátima')),
            (37, _(u'Instituto Jesus Maria José')),
            (44, _(u'Irmãs Angélicas de São Paulo')),
            (45, _(u'Irmãs Carmelitas – CSCJ')),
            (46, _(u'Irmãs Concepcionistas ao Serviço dos Pobres – CSP')),
            (100, _(u'Irmãs da Caridade do Sagrado Coração de Jesus')),
            (77, _(u'Irmãs da Santa Cruz')),
            (72, _(u'Irmãs de Nossa Senhora da Glória')),
            (78, _(u'Irmãs de São João Baptista e de Maria Raínha')),
            (47, _(u'Irmãs Discípulas do Divino Mestre')),
            (49, _(u'Irmãs Dominicanas de Santa Catarina de Sena')),
            (48, _(u'Irmãs Dominicanas Irlandesas (do Bom Sucesso)')),
            (76, _(u'Irmãs dos Sagrados Corações – SS.CC')),
            (51, _(u'Irmãs Franciscanas da Imaculada')),
            (52, _(u'Irmãs Franciscanas da Imaculada Conceição')),
            (97, _(u'Irmãs Franciscanas de Nossa Senhora das Vitórias - Cúria Geral')),
            (98, _(u'Irmãs Franciscanas de Nossa Senhora das Vitórias - Província de Cristo Rei')),
            (99, _(u'Irmãs Franciscanas de Nossa Senhora das Vitórias - Província do Coração de Maria')),
            (50, _(u'Irmãs Franciscanas Evangelizadoras de Nossa Senhora da Esperança – FENSE')),
            (56, _(u'Irmãs Hospitaleiras do Sagrado Coração de Jesus')),
            (39, _(u'Irmãs Mercedárias da Caridade')),
            (57, _(u'Irmãs Missionárias Combonianas')),
            (58, _(u'Irmãs Missionárias da Consolata')),
            (70, _(u'Irmãs Missionárias de S. Pedro Claver')),
            (59, _(u'Irmãs Missionárias do Espírito Santo')),
            (71, _(u'Irmãs Missionárias Scalabrinianas')),
            (73, _(u'Irmãs Oblatas do Santíssimo Redentor')),
            (74, _(u'Irmãs Paulinas – FSP')),
            (75, _(u'Irmãs Reparadoras Missionárias da Santa Face')),
            (79, _(u'Irmãs S. José de Cluny – S.J.C.')),
            (60, _(u'Irmãs Servas de Maria Reparadoras – SMR')),
            (61, _(u'Irmãs Servidoras de Jesus do Cottolengo do Padre Alegre')),
            (63, _(u'Irmãzinhas da Assunção – I . A.')),
            (64, _(u'Irmãzinhas de Jesus')),
            (62, _(u'Irmãzinhas dos Anciãos desamparados')),
            (65, _(u'Irmãzinhas dos Pobres – I.P.')),
            (67, _(u'Missionárias Claretianas -  M.C.')),
            (40, _(u'Missionárias Cordimarianas – MC')),
            (68, _(u'Missionárias Cruzadas da Igreja – M.C.I.')),
            (66, _(u'Missionárias da Caridade (Da Madre Teresa de Calcutá) – M.C.')),
            (53, _(u'Missionárias de São Domingos')),
            (82, _(u'Missionárias do Precioso Sangue – C.P.S.')),
            (84, _(u'Missionárias do Santíssimo – M.S.S.')),
            (69, _(u'Missionárias Dominicanas do Rosário')),
            (81, _(u'Missionárias dos Pobres')),
            (80, _(u'Missionárias Eucarísticas de Nazaré – M.E.N.')),
            (83, _(u'Missionárias Reparadoras do Sagrado Coração de Jesus – M.R.')),
            (85, _(u'Missionárias Servas do Espírito Santo')),
            (86, _(u'Oblatas do Coração de Jesus')),
            (87, _(u'Oblatas do Divino Coração – O.D.C.')),
            (41, _(u'Religiosas da Instrução Cristã')),
            (89, _(u'Religiosas de Maria de Imaculada – R.M.I.')),
            (88, _(u'Religiosas do Amor de Deus – R.A.D.')),
            (90, _(u'Reparadoras de Nossa Senhora das Dores de Fátima')),
            (91, _(u'Servas da Divina Providência')),
            (55, _(u'Servas da Santa Igreja – S.S.I.')),
            (38, _(u'Servas de Jesus da Caridade – S. de J.')),
            (93, _(u'Servas de Maria (S de M)')),
            (94, _(u'Servas de Nossa Senhora de Fátima – SNSF')),
            (92, _(u'Servas Franciscanas  Reparadoras de Jesus Sacramentado – SFRJS')),
            (54, _(u'Teresianas – STJ')),
        )
    class BasePrelaturaPessoal(SharedBase):
        nome = models.CharField(_(u'Nome'), max_length=255)
        congregacao_id = models.PositiveIntegerField(_(u'Congregação'), max_length=3, choices=CONGREGACOES_CHOICES, null=True, blank=True)
        comunidade = models.CharField(_(u'Casa/comunidade'), max_length=255, null=True, blank=True)
        superiora = models.CharField(_(u'Superiora'), max_length=255, null=True, blank=True)
        membros = models.TextField(_(u'Membros da Comunidade'), null=True, blank=True)
        morada = models.CharField(_(u'Morada'), max_length=255, null=True, blank=True)
        codigo_postal = models.CharField(_(u'Código postal'), max_length=255, null=True, blank=True)
        localidade = models.CharField(_(u'Localidade'), max_length=255, null=True, blank=True)
        telefone = models.CharField(_(u'Telefone'), max_length=255, null=True, blank=True)
        telemovel = models.CharField(_(u'Telemóvel'), max_length=255, null=True, blank=True)
        fax = models.CharField(_(u'Fax'), max_length=255, null=True, blank=True)
        email = models.CharField(_(u'Email'), max_length=255, null=True, blank=True)
        paginaweb = models.CharField(_(u'Página web'), max_length=255, null=True, blank=True)

        class Meta:
            verbose_name = _(u'Prelatura pessoal')
            verbose_name_plural = _(u'Prelaturas pessoais')
            abstract = True
            ordering = ['nome']

        def __unicode__(self):
            return self.nome
    return BasePrelaturaPessoal
# Fim Models

# Admin
def getBasePrelaturaPessoalForm(mymodel):
    class BasePrelaturaPessoalForm(forms.ModelForm):
        class Meta:
            model = mymodel

    return BasePrelaturaPessoalForm

def getBasePrelaturaPessoalAdmin(mymodel):
    class BasePrelaturaPessoalAdmin(getBaseAdmin(mymodel)):
        form = getBasePrelaturaPessoalForm(mymodel)
        fieldsets = (
                     (None, {
                             'fields':(
                                       ('nome',),
                                       ('congregacao_id',),
                                       ('comunidade',),
                                       ('superiora',),
                                       ('membros',),
                                       ('morada',),
                                       ('codigo_postal','localidade',),
                                       ('telefone','telemovel',),
                                       ('fax','email',),
                                       ('paginaweb',),
                                       )
                             }),
                     )
        list_display = ('nome', 'alterado', 'id',)
        search_fields = ('nome', 'id', )

    return BasePrelaturaPessoalAdmin
# Fim Admin
