#coding: utf-8
from django.db import models
from django.utils.translation import ugettext_lazy as _
from diocesesim.models import getBaseAdmin, SharedBase
from django import forms

# Models
def getBaseParoquia(basearciprestado, basepresbitero, ORAGOS_CHOICES):
    if ORAGOS_CHOICES == None:
        ORAGOS_CHOICES = (
            (155, _(u'Apresentação de Nossa Senhora')),
            (116, _(u'Beato Nuno de Santa Maria')),
            (117, _(u'Beatos Nicolau Dinis e Bento de Castro')),
            (153, _(u'Bom Jesus')),
            (28, _(u'Bom Jesus Menino')),
            (417, _(u'Cadeira de São Pedro')),
            (157, _(u'Cadeira de São Pedro de Antioquia')),
            (341, _(u'Coração de Jesus')),
            (383, _(u'Coração de Maria')),
            (288, _(u'Coração Imaculado de Maria')),
            (143, _(u'Coração Imaculado de Maria e São João Baptista')),
            (358, _(u'Cristo-Rei')),
            (149, _(u'Degolação de São João Baptista')),
            (364, _(u'Divino Espírito Santo')),
            (405, _(u'Divino Salvador')),
            (271, _(u'Doze Apóstolos')),
            (108, _(u'Espírito Santo')),
            (195, _(u'Espírito Santo e Santo Antão')),
            (150, _(u'Exaltação de Santa Cruz')),
            (218, _(u'Imaculada Conceição')),
            (114, _(u'Imaculada Conceição e Santa Teresa de Ávila')),
            (245, _(u'Imaculado Coração de Maria')),
            (22, _(u'Jesus, Maria e José')),
            (148, _(u'Natividade de Nossa Senhora')),
            (348, _(u'Nossa Senhora')),
            (208, _(u'Nossa Senhora ao Pé da Cruz')),
            (161, _(u'Nossa Senhora Auxiliadora')),
            (219, _(u'Nossa Senhora Calçada')),
            (224, _(u'Nossa Senhora Conduzende')),
            (203, _(u'Nossa Senhora Coros')),
            (71, _(u'Nossa Senhora da Abela')),
            (19, _(u'Nossa Senhora da Ajuda')),
            (320, _(u'Nossa Senhora da Ajuda e São Lourenço')),
            (204, _(u'Nossa Senhora da Alagoa')),
            (133, _(u'Nossa Senhora da Alegria')),
            (419, _(u'Nossa Senhora da Anunciação')),
            (379, _(u'Nossa Senhora da Anunciada')),
            (13, _(u'Nossa Senhora da Apresentação')),
            (336, _(u'Nossa Senhora da Assunção')),
            (300, _(u'Nossa Senhora da Assunção e Ressurreição de Cristo')),
            (183, _(u'Nossa Senhora da Atalaia')),
            (142, _(u'Nossa Senhora da Atocha')),
            (401, _(u'Nossa Senhora da Azinheira')),
            (441, _(u'Nossa Senhora da Boa Água')),
            (162, _(u'Nossa Senhora da Boa Esperança')),
            (160, _(u'Nossa Senhora da Boa Fé')),
            (381, _(u'Nossa Senhora da Boa Hora')),
            (240, _(u'Nossa Senhora da Boa Memória')),
            (293, _(u'Nossa Senhora da Boa Nova')),
            (24, _(u'Nossa Senhora da Boa Viagem')),
            (47, _(u'Nossa Senhora da Boa-Hora')),
            (281, _(u'Nossa Senhora da Conceição')),
            (201, _(u'Nossa Senhora da Consolação')),
            (228, _(u'Nossa Senhora da Corredoura')),
            (53, _(u'Nossa Senhora da Encarnação')),
            (308, _(u'Nossa Senhora da Encarnação e São Domingos')),
            (92, _(u'Nossa Senhora da Esperança')),
            (63, _(u'Nossa Senhora da Estrela')),
            (407, _(u'Nossa Senhora da Expectação')),
            (292, _(u'Nossa Senhora da Fé')),
            (243, _(u'Nossa Senhora da Gaiola')),
            (362, _(u'Nossa Senhora da Glória')),
            (70, _(u'Nossa Senhora da Graça')),
            (66, _(u'Nossa Senhora da Guadalupe')),
            (390, _(u'Nossa Senhora da Guia')),
            (322, _(u'Nossa Senhora da Hora')),
            (440, _(u'Nossa Senhora da Incarnação')),
            (169, _(u'Nossa Senhora da Lagoa')),
            (290, _(u'Nossa Senhora da Lapa')),
            (399, _(u'Nossa Senhora da Livração')),
            (167, _(u'Nossa Senhora da Luz')),
            (286, _(u'Nossa Senhora da Misericórdia')),
            (353, _(u'Nossa Senhora da Natividade')),
            (43, _(u'Nossa Senhora da Nazaré')),
            (111, _(u'Nossa Senhora da Oliveira')),
            (171, _(u'Nossa Senhora da Orada')),
            (411, _(u'Nossa Senhora da Ouvida')),
            (151, _(u'Nossa Senhora da Paz')),
            (251, _(u'Nossa Senhora da Pena')),
            (212, _(u'Nossa Senhora da Penha')),
            (31, _(u'Nossa Senhora da Penha de França')),
            (4, _(u'Nossa Senhora da Piedade')),
            (277, _(u'Nossa Senhora da Porta do Céu')),
            (227, _(u'Nossa Senhora da Pureza')),
            (339, _(u'Nossa Senhora da Purificação')),
            (377, _(u'Nossa Senhora da Redenção')),
            (365, _(u'Nossa Senhora da Ribeira')),
            (282, _(u'Nossa Senhora da Salvação')),
            (18, _(u'Nossa Senhora da Saúde')),
            (305, _(u'Nossa Senhora da Saúde e São Sebastião')),
            (213, _(u'Nossa Senhora da Silva')),
            (72, _(u'Nossa Senhora da Soledade')),
            (175, _(u'Nossa Senhora da Vila')),
            (395, _(u'Nossa Senhora da Vinha')),
            (328, _(u'Nossa Senhora da Visitação')),
            (279, _(u'Nossa Senhora da Vitória')),
            (193, _(u'Nossa Senhora da Vitória e Santa Rita')),
            (6, _(u'Nossa Senhora das Angústias')),
            (280, _(u'Nossa Senhora das Areias')),
            (40, _(u'Nossa Senhora das Areias e São Jacinto')),
            (418, _(u'Nossa Senhora das Boas Novas')),
            (172, _(u'Nossa Senhora das Brotas')),
            (232, _(u'Nossa Senhora das Candeias')),
            (272, _(u'Nossa Senhora das Dores')),
            (158, _(u'Nossa Senhora das Graças')),
            (403, _(u'Nossa Senhora das Júnias')),
            (250, _(u'Nossa Senhora das Mercês')),
            (247, _(u'Nossa Senhora das Misericórdias')),
            (16, _(u'Nossa Senhora das Necessidades')),
            (57, _(u'Nossa Senhora das Neves')),
            (139, _(u'Nossa Senhora das Ondas')),
            (196, _(u'Nossa Senhora das Preces')),
            (67, _(u'Nossa Senhora das Relíquias')),
            (285, _(u'Nossa Senhora das Virtudes')),
            (296, _(u'Nossa Senhora de Aboboriz')),
            (2, _(u'Nossa Senhora de Alva')),
            (97, _(u'Nossa Senhora de Assunção')),
            (33, _(u'Nossa Senhora de Belém')),
            (156, _(u'Nossa Senhora de Espariz')),
            (360, _(u'Nossa Senhora de Fátima')),
            (164, _(u'Nossa Senhora de Guadalupe')),
            (34, _(u'Nossa Senhora de la Salette')),
            (128, _(u'Nossa Senhora de Lurdes')),
            (366, _(u'Nossa Senhora de Marvila')),
            (306, _(u'Nossa Senhora de Monserrate')),
            (199, _(u'Nossa Senhora do Açor')),
            (223, _(u'Nossa Senhora do Ameal')),
            (266, _(u'Nossa Senhora do Amparo')),
            (12, _(u'Nossa Senhora do Ar')),
            (174, _(u'Nossa Senhora do Bispo')),
            (194, _(u'Nossa Senhora do Bom Caminho')),
            (326, _(u'Nossa Senhora do Bom Despacho')),
            (188, _(u'Nossa Senhora do Bom Sucesso')),
            (45, _(u'Nossa Senhora do Bom Sucesso e São Paio')),
            (309, _(u'Nossa Senhora do Cabo')),
            (42, _(u'Nossa Senhora do Carmo')),
            (215, _(u'Nossa Senhora do Castelo')),
            (244, _(u'Nossa Senhora do Desterro')),
            (226, _(u'Nossa Senhora do Enxertado')),
            (432, _(u'Nossa Senhora do Espinheiro')),
            (29, _(u'Nossa Senhora do Guadalupe')),
            (197, _(u'Nossa Senhora do Livramento')),
            (187, _(u'Nossa Senhora do Loreto')),
            (229, _(u'Nossa Senhora do Loureiro')),
            (159, _(u'Nossa Senhora do Monte')),
            (380, _(u'Nossa Senhora do Monte Sião')),
            (36, _(u'Nossa Senhora do Ó')),
            (59, _(u'Nossa Senhora do Outeiro')),
            (238, _(u'Nossa Senhora do Patrocínio')),
            (294, _(u'Nossa Senhora do Perpétuo Socorro')),
            (30, _(u'Nossa Senhora do Pilar')),
            (297, _(u'Nossa Senhora do Pópulo')),
            (311, _(u'Nossa Senhora do Porto Salvo')),
            (408, _(u'Nossa Senhora do Pranto')),
            (370, _(u'Nossa Senhora do Reclamador')),
            (166, _(u'Nossa Senhora do Rosário')),
            (7, _(u'Nossa Senhora do Socorro')),
            (235, _(u'Nossa Senhora do Torrão')),
            (412, _(u'Nossa Senhora do Viso')),
            (433, _(u'Nossa Senhora dos Altos Céus')),
            (20, _(u'Nossa Senhora dos Anjos')),
            (299, _(u'Nossa Senhora dos Mártires')),
            (10, _(u'Nossa Senhora dos Milagres')),
            (258, _(u'Nossa Senhora dos Navegantes')),
            (25, _(u'Nossa Senhora dos Prazeres')),
            (106, _(u'Nossa Senhora dos Reis')),
            (8, _(u'Nossa Senhora dos Remédios')),
            (236, _(u'Nossa Senhora Entre Vinhas')),
            (50, _(u'Nossa Senhora Entre-as-Vinhas')),
            (136, _(u'Nossa Senhora Finisterra')),
            (23, _(u'Nossa Senhora Mãe de Deus')),
            (424, _(u'Nossa Senhora Mãe dos Homens')),
            (233, _(u'Nossa Senhora Piedade')),
            (124, _(u'Nossa Senhora Rainha')),
            (189, _(u'Nossa Senhora Rainha do Mundo')),
            (303, _(u'Nossa Senhora Rainha dos Apóstolos')),
            (205, _(u'Nossa Senhora Rocamador')),
            (95, _(u'Nosso Senhor dos Navegantes')),
            (434, _(u'O Salvador')),
            (186, _(u'Rei Salvador')),
            (270, _(u'Reis Magos')),
            (268, _(u'Sagrada Família')),
            (46, _(u'Sagrado Coração de Jesus')),
            (298, _(u'Sagrado Coração de Maria')),
            (284, _(u'Salvador do Mundo')),
            (406, _(u'Santa Águeda')),
            (54, _(u'Santa Ana')),
            (51, _(u'Santa Bárbara')),
            (259, _(u'Santa Beatriz')),
            (60, _(u'Santa Brígida')),
            (242, _(u'Santa Catarina')),
            (107, _(u'Santa Catarina de Alexandria')),
            (252, _(u'Santa Catarina do Monte Sinai')),
            (104, _(u'Santa Catarina Maior')),
            (146, _(u'Santa Cecília')),
            (333, _(u'Santa Clara')),
            (52, _(u'Santa Clara de Assis')),
            (421, _(u'Santa Columba')),
            (386, _(u'Santa Comba')),
            (359, _(u'Santa Cristina')),
            (394, _(u'Santa Cristina e São Silvestre')),
            (352, _(u'Santa Cruz')),
            (41, _(u'Santa Cruz e Nossa Senhora da Apresentação')),
            (126, _(u'Santa Engrácia')),
            (144, _(u'Santa Eufemia')),
            (105, _(u'Santa Eugénia')),
            (331, _(u'Santa Eulália')),
            (313, _(u'Santa Iria')),
            (91, _(u'Santa Isabel')),
            (439, _(u'Santa Isabel de Portugal')),
            (273, _(u'Santa Joana')),
            (38, _(u'Santa Joana Princesa')),
            (173, _(u'Santa Justa')),
            (323, _(u'Santa Leocádia')),
            (75, _(u'Santa Lucrécia')),
            (181, _(u'Santa Luzia')),
            (324, _(u'Santa Margarida')),
            (182, _(u'Santa Maria')),
            (425, _(u'Santa Maria da Devesa')),
            (404, _(u'Santa Maria da Feira')),
            (384, _(u'Santa Maria da Graça')),
            (168, _(u'Santa Maria da Lagoa')),
            (44, _(u'Santa Maria da Natividade')),
            (388, _(u'Santa Maria da Porta')),
            (372, _(u'Santa Maria da Serra e São João Baptista')),
            (385, _(u'Santa Maria das Neves')),
            (179, _(u'Santa Maria de Alcáçova')),
            (5, _(u'Santa Maria do Castelo')),
            (392, _(u'Santa Maria dos Anjos')),
            (371, _(u'Santa Maria dos Olivais')),
            (315, _(u'Santa Maria e São Miguel')),
            (376, _(u'Santa Maria e São Pedro')),
            (115, _(u'Santa Maria e São Vicente')),
            (137, _(u'Santa Maria Madalena')),
            (147, _(u'Santa Maria Maior')),
            (3, _(u'Santa Maria Nossa Senhora da Assunção')),
            (349, _(u'Santa Maria Nossa Senhora da Expectação')),
            (154, _(u'Santa Marinha')),
            (98, _(u'Santa Marta')),
            (198, _(u'Santa Quitéria')),
            (32, _(u'Santa Rita')),
            (81, _(u'Santa Senhorinha')),
            (176, _(u'Santa Sofia')),
            (319, _(u'Santa Susana')),
            (82, _(u'Santa Tecla')),
            (287, _(u'Santa Teresa do Menino Jesus')),
            (184, _(u'Santa Vitória')),
            (253, _(u'Santas Justa e Rufina')),
            (378, _(u'Santiago')),
            (423, _(u'Santiago Maior')),
            (11, _(u'Santíssima Trindade')),
            (248, _(u'Santíssimo Coração de Jesus')),
            (302, _(u'Santíssimo Nome de Jesus')),
            (289, _(u'Santíssimo Redentor')),
            (278, _(u'Santíssimo Sacramento')),
            (48, _(u'Santíssimo Salvador')),
            (327, _(u'Santo Adrião')),
            (129, _(u'Santo Agostinho')),
            (64, _(u'Santo Aleixo')),
            (65, _(u'Santo Amador')),
            (110, _(u'Santo Amaro')),
            (332, _(u'Santo André')),
            (249, _(u'Santo André e Santa Marinha')),
            (77, _(u'Santo André, Apóstolo')),
            (274, _(u'Santo Anjo de Portugal')),
            (387, _(u'Santo Antão')),
            (382, _(u'Santo António')),
            (191, _(u'Santo António de Lisboa')),
            (109, _(u'Santo Apolinário')),
            (262, _(u'Santo Condestável')),
            (9, _(u'Santo Cristo')),
            (347, _(u'Santo Cruz')),
            (237, _(u'Santo Elias')),
            (78, _(u'Santo Emilião')),
            (123, _(u'Santo Estevão')),
            (260, _(u'Santo Eugénio')),
            (415, _(u'Santo Eusébio')),
            (361, _(u'Santo Eustáquio')),
            (113, _(u'Santo Ildefonso')),
            (414, _(u'Santo Isidoro')),
            (37, _(u'Santo Isidoro de Sevilha')),
            (375, _(u'Santo Isidro')),
            (214, _(u'Santo Nome de Jesus')),
            (356, _(u'Santo Ovídio')),
            (85, _(u'Santo Tirso')),
            (15, _(u'Santos Reis Magos')),
            (263, _(u'Santos Veríssimo, Máxima e Júlia')),
            (337, _(u'São Barnabé')),
            (241, _(u'São Bartolomeu')),
            (291, _(u'São Bento')),
            (118, _(u'São Bento e São Francisco')),
            (39, _(u'São Bernardo')),
            (127, _(u'São Brás')),
            (367, _(u'São Braz')),
            (61, _(u'São Brissos')),
            (141, _(u'São Caetano')),
            (410, _(u'São Carlos Borromeu')),
            (88, _(u'São Cipriano')),
            (100, _(u'São Ciríaco')),
            (83, _(u'São Cláudio')),
            (87, _(u'São Clemente')),
            (211, _(u'São Cosme')),
            (351, _(u'São Cosme e São Damião')),
            (125, _(u'São Cristóvão')),
            (255, _(u'São Cristóvão e São Lourenço')),
            (62, _(u'São Cucufate')),
            (427, _(u'São Dâmaso ')),
            (73, _(u'São Domingos')),
            (230, _(u'São Domingos de Gusmão')),
            (178, _(u'São Domingos Sávio')),
            (222, _(u'São Facundo')),
            (330, _(u'São Faustino')),
            (225, _(u'São Faustino e São Jovita')),
            (393, _(u'São Felix')),
            (334, _(u'São Félix de Gerona')),
            (94, _(u'São Félix e Santa Marinha')),
            (112, _(u'São Filipe')),
            (400, _(u'São Francisco')),
            (239, _(u'São Francisco de Assis')),
            (442, _(u'São Francisco de Borja')),
            (264, _(u'São Francisco de Paula')),
            (265, _(u'São Francisco Xavier')),
            (120, _(u'São Frutuoso')),
            (135, _(u'São Gabriel Arcanjo')),
            (121, _(u'São Genésio')),
            (145, _(u'São Gens')),
            (177, _(u'São Geraldo')),
            (329, _(u'São Gonçalo')),
            (192, _(u'São Gonçalo de Amarante')),
            (207, _(u'São Gregório')),
            (283, _(u'São Gregório Magno')),
            (99, _(u'São Jerónimo')),
            (89, _(u'São João')),
            (314, _(u'São João Baptista')),
            (131, _(u'São João Baptista e Nossa Senhora da Conceição')),
            (101, _(u'São João Bosco')),
            (275, _(u'São João de Brito')),
            (276, _(u'São João de Deus')),
            (317, _(u'São João Degolado')),
            (429, _(u'São João do Souto ')),
            (420, _(u'São João Evangelista')),
            (17, _(u'São Jorge')),
            (134, _(u'São José')),
            (430, _(u'São José de São Lázaro ')),
            (374, _(u'São José Operário')),
            (391, _(u'São Julião')),
            (312, _(u'São Julião e Santa Bárbara')),
            (426, _(u'São Julião Mártir')),
            (132, _(u'São Justo')),
            (119, _(u'São Justo e Santa Justa')),
            (27, _(u'São Lázaro')),
            (304, _(u'São Leonardo')),
            (84, _(u'São Lourenço')),
            (318, _(u'São Lucas')),
            (68, _(u'São Luís')),
            (1, _(u'São Luís, Bispo')),
            (140, _(u'São Mamede')),
            (165, _(u'São Manços')),
            (55, _(u'São Marcos')),
            (93, _(u'São Martinho')),
            (389, _(u'São Martinho de Tours')),
            (138, _(u'São Martinho e Santa Maria de Alcáçova')),
            (90, _(u'São Mateus')),
            (58, _(u'São Matias')),
            (261, _(u'São Maximiliano Kolbe')),
            (80, _(u'São Miguel')),
            (413, _(u'São Miguel Arcanjo')),
            (335, _(u'São Nicolau')),
            (234, _(u'São Nicolau de Bari')),
            (256, _(u'São Nicolau e São Julião')),
            (35, _(u'São Paio')),
            (398, _(u'São Pantaleão')),
            (363, _(u'São Paulo')),
            (438, _(u'São Paulo, Apóstolo')),
            (200, _(u'São Pedro')),
            (202, _(u'São Pedro ad Vincula')),
            (396, _(u'São Pedro da Cadeira')),
            (220, _(u'São Pedro de Antioquia')),
            (350, _(u'São Pedro de Fins')),
            (316, _(u'São Pedro de Penaferrim')),
            (416, _(u'São Pedro de Verona')),
            (307, _(u'São Pedro dos Grilhões')),
            (301, _(u'São Pedro e São João')),
            (321, _(u'São Pedro e São Tiago')),
            (56, _(u'São Pedro, Apóstolo')),
            (102, _(u'São Pelágio')),
            (122, _(u'São Romão')),
            (21, _(u'São Roque')),
            (74, _(u'São Salvador')),
            (221, _(u'São Salvador do Mundo')),
            (185, _(u'São Saturnino')),
            (209, _(u'São Sebastião')),
            (435, _(u'São Sebastião, Mártir')),
            (369, _(u'São Silvestre')),
            (409, _(u'São Simão')),
            (96, _(u'São Simão e São Judas Tadeu')),
            (69, _(u'São Teotónio')),
            (217, _(u'São Tiago')),
            (254, _(u'São Tiago e São Martinho')),
            (437, _(u'São Tiago e São Mateus')),
            (231, _(u'São Tiago Maior')),
            (190, _(u'São Tiago Menor')),
            (431, _(u'São Tiago, Apóstolo')),
            (267, _(u'São Tomás de Aquino')),
            (402, _(u'São Tomé')),
            (86, _(u'São Torcato')),
            (343, _(u'São Veríssimo')),
            (76, _(u'São Vicente')),
            (269, _(u'São Vicente de Paulo')),
            (14, _(u'São Vicente Ferreira')),
            (436, _(u'São Vicente, Mártir')),
            (257, _(u'São Vicente, São Tomé e Salvador')),
            (428, _(u'São Vítor ')),
            (26, _(u'Senhor Bom Jesus')),
            (180, _(u'Senhor da Boa Fé')),
            (354, _(u'Senhor da Vera Cruz')),
            (342, _(u'Senhor do Bonfim')),
            (397, _(u'Senhor do Socorro')),
            (355, _(u'Senhor dos Aflitos')),
            (346, _(u'Senhor Jesus')),
            (368, _(u'Senhor Jesus dos Aflitos')),
            (246, _(u'Senhor Jesus dos Milagres')),
            (310, _(u'Senhor Jesus dos Navegantes')),
            (295, _(u'Senhor Jesus e São Pedro')),
            (340, _(u'Senhora da Ajuda')),
            (357, _(u'Senhora da Assunção')),
            (344, _(u'Senhora da Conceição')),
            (325, _(u'Senhora da Expectação')),
            (163, _(u'Senhora da Saúde')),
            (338, _(u'Senhora Do Amparo')),
            (206, _(u'Senhora dos Anjos')),
            (422, _(u'Transfiguração de Nosso Senhor')),
            (216, _(u'Transfiguração de Nosso Senhor Jesus Cristo')),
            (103, _(u'Transfiguração do Senhor')),
            (170, _(u'Vera Cruz')),
        )

    class BaseParoquia(SharedBase):
        nome = models.CharField(_(u'Nome'), max_length=255)
        morada = models.CharField(_(u'Morada'), max_length=255, null=True, blank=True)
        codigo_postal = models.CharField(_(u'Código postal'), max_length=255, null=True, blank=True)
        localidade = models.CharField(_(u'Localidade'), max_length=255, null=True, blank=True)
        telefone = models.CharField(_(u'Telefone'), max_length=255, null=True, blank=True)
        telemovel = models.CharField(_(u'Telemóvel'), max_length=255, null=True, blank=True)
        fax = models.CharField(_(u'Fax'), max_length=255, null=True, blank=True)
        email = models.CharField(_(u'Email'), max_length=255, null=True, blank=True)
        paginaweb = models.CharField(_(u'Página web'), max_length=255, null=True, blank=True)
        arciprestado = models.ForeignKey(basearciprestado, verbose_name=_(u'Arciprestado'), related_name='%(app_label)s_%(class)s_paroquia_arciprestado', null=True, blank=True, on_delete=models.SET_NULL)
        orago = models.PositiveIntegerField(_(u'Orago'), max_length=3, choices=ORAGOS_CHOICES, null=True, blank=True)
        padre1 = models.ForeignKey(basepresbitero, verbose_name=_(u'Padre 1'), related_name='%(app_label)s_%(class)s_paroquia_padre1', null=True, blank=True, on_delete=models.SET_NULL)
        padre2 = models.ForeignKey(basepresbitero, verbose_name=_(u'Padre 2'), related_name='%(app_label)s_%(class)s_paroquia_padre2', null=True, blank=True, on_delete=models.SET_NULL)
        padre3 = models.ForeignKey(basepresbitero, verbose_name=_(u'Padre 3'), related_name='%(app_label)s_%(class)s_paroquia_padre3', null=True, blank=True, on_delete=models.SET_NULL)

        class Meta:
            verbose_name = _(u'Paróquia')
            verbose_name_plural = _(u'Paróquias')
            abstract = True
            ordering = ['nome']

        def __unicode__(self):
            return self.nome
    return BaseParoquia
# Fim Models

# Admin
def getBaseParoquiaForm(mymodel):
    class BaseParoquiaForm(forms.ModelForm):
        class Meta:
            model = mymodel

    return BaseParoquiaForm

def getBaseParoquiaAdmin(mymodel):
    class BaseParoquiaAdmin(getBaseAdmin(mymodel)):
        form = getBaseParoquiaForm(mymodel)
        fieldsets = (
                     (None, {
                             'fields':(
                                       ('nome',),
                                       ('arciprestado',),
                                       ('orago',),
                                       ('morada',),
                                       ('codigo_postal','localidade',),
                                       ('telefone','telemovel',),
                                       ('fax','email',),
                                       ('paginaweb',),
                                       ('padre1',),
                                       ('padre2',),
                                       ('padre3',),
                                       )
                             }),
                     )
        list_display = ('nome', 'alterado', 'id',)
        search_fields = ('nome', 'id', )

    return BaseParoquiaAdmin
# Fim Admin
