#coding: utf-8
from django.db import models
from django.utils.translation import ugettext_lazy as _
from diocesesim.models import getBaseAdmin, SharedBase
from django import forms

try:
    from settings import DIOCESE_NOME
    diocese_nome = DIOCESE_NOME
except Exception, e:
    diocese_nome = ''
    pass

# Models
def getBaseNotaHistorica():
    class BaseNotaHistorica(SharedBase):
        nome = models.CharField(_(u'Nome'), max_length=255)
        sufraganea = models.CharField(_(u'Nota histórica'), max_length=255, null=True, blank=True)
        nota_historica = models.TextField(_(u'Sufragânea'), null=True, blank=True)

        class Meta:
            verbose_name = _(u'Nota Histórica')
            verbose_name_plural = _(u'Notas Históricas')
            abstract = True
            ordering = ['nome']

        def __unicode__(self):
            return self.nome
    return BaseNotaHistorica
# Fim Models

# Admin
def getBaseNotaHistoricaForm(mymodel):
    class BaseNotaHistoricaForm(forms.ModelForm):
        nome = forms.CharField(label=_(u'Nome'), initial=_(u'Nota Histórica de ')+diocese_nome, max_length=255, widget=forms.widgets.TextInput(attrs={'class':'vTextField'}))
        class Meta:
            model = mymodel

    return BaseNotaHistoricaForm

def getBaseNotaHistoricaAdmin(mymodel):
    class BaseNotaHistoricaAdmin(getBaseAdmin(mymodel)):
        form = getBaseNotaHistoricaForm(mymodel)
        fieldsets = (
                     (None, {
                             'fields':(
                                       ('nome',),
                                       ('sufraganea',),
                                       ('nota_historica',),
                                       )
                             }),
                     )
        list_display = ('nome', 'alterado', 'id',)
        search_fields = ('nome', 'id', )

    return BaseNotaHistoricaAdmin
# Fim Admin
