#coding: utf-8
from django.db import models
from django.utils.translation import ugettext_lazy as _
from diocesesim.models import getBaseAdmin, SharedBase
from django import forms


# Models
def getBaseInstitutoReligiosoMasculino(CONGREGACOES_CHOICES):
    if CONGREGACOES_CHOICES == None:
        CONGREGACOES_CHOICES = (
            (31, _(u'Agostinhos – O.S.A.')),
            (2, _(u'Beneditinos – O.S.B.')),
            (11, _(u'Carmelitas – Ordem do Carmo - O. CARM.')),
            (3, _(u'Carmelitas Descalços – O.C.D. ')),
            (4, _(u'Cartuxos – O-Cart')),
            (38, _(u'Consolata – I. M. C.')),
            (7, _(u'Dehonianos – SCJ')),
            (8, _(u'Dominicanos – O.P.')),
            (9, _(u'Dominicanos Irlandeses – O.P.')),
            (10, _(u'Espiritanos – C.S.Sp.')),
            (29, _(u'Filhos da Caridade - F.C.')),
            (30, _(u'Frades Menores Conventuais – O.F.M. Conv.')),
            (19, _(u'Franciscanos – O.F.M.')),
            (1, _(u'Irmãos de Jesus')),
            (14, _(u'Irmãos de La Salle - Lassalistas – F.S.C. ')),
            (12, _(u'Irmãos de S. João de Deus, O.H.')),
            (26, _(u'Irmãozinhos de São Francisco de Assis – FISFA')),
            (34, _(u'Jesuítas – S.J.')),
            (28, _(u'Maristas – F.M.S')),
            (5, _(u'Missionários Claretianos – C.M.F.')),
            (18, _(u'Missionários Combonianos – M.C.C.J')),
            (35, _(u'Missionários de São João Baptista – M.S.J.B.')),
            (20, _(u'Missionários do Verbo Divino ')),
            (33, _(u'Missionários Monfortinos – S.M.M.')),
            (25, _(u'Missionários Redentoristas – C.S.S.R.')),
            (6, _(u'Ordem de Santa Cruz - Padres Crúzios')),
            (17, _(u'Padres Capuchinhos – O.F.M.CAP. ')),
            (39, _(u'Padres de Schoenstatt')),
            (36, _(u'Padres Marianos – M.I.C.')),
            (32, _(u'Padres Palotinos')),
            (37, _(u'Padres Paulistas – SSP')),
            (13, _(u'Padres Vicentinos – C.M.')),
            (27, _(u'Passionistas – CP.')),
            (15, _(u'Preciosíssimo Sangue – C.P.P.S.')),
            (24, _(u'Sagrados Corações – SS.CC.')),
            (16, _(u'Salesianos – SDB')),
            (23, _(u'Scalabrinianos – C.S.')),
            (22, _(u'Shalom (Comunidade) ')),
            (21, _(u'Sociedade Missionária da Boa Nova – SMBN')),
        )

    class BaseInstitutoReligiosoMasculino(SharedBase):
        nome = models.CharField(_(u'Nome'), max_length=255)
        congregacao_id = models.PositiveIntegerField(_(u'Congregação'), max_length=2, choices=CONGREGACOES_CHOICES, null=True, blank=True)
        comunidade = models.CharField(_(u'Casa/comunidade'), max_length=255, null=True, blank=True)
        superior = models.CharField(_(u'Superior'), max_length=255, null=True, blank=True)
        membros = models.TextField(_(u'Membros da Comunidade'), null=True, blank=True)
        morada = models.CharField(_(u'Morada'), max_length=255, null=True, blank=True)
        codigo_postal = models.CharField(_(u'Código postal'), max_length=255, null=True, blank=True)
        localidade = models.CharField(_(u'Localidade'), max_length=255, null=True, blank=True)
        telefone = models.CharField(_(u'Telefone'), max_length=255, null=True, blank=True)
        telemovel = models.CharField(_(u'Telemóvel'), max_length=255, null=True, blank=True)
        fax = models.CharField(_(u'Fax'), max_length=255, null=True, blank=True)
        email = models.CharField(_(u'Email'), max_length=255, null=True, blank=True)
        paginaweb = models.CharField(_(u'Página web'), max_length=255, null=True, blank=True)

        class Meta:
            verbose_name = _(u'Instituto Religioso Masculino')
            verbose_name_plural = _(u'Institutos Religiosos Masculinos')
            abstract = True
            ordering = ['nome']

        def __unicode__(self):
            return self.nome
    return BaseInstitutoReligiosoMasculino
# Fim Models

# Admin
def getBaseInstitutoReligiosoMasculinoForm(mymodel):
    class BaseInstitutoReligiosoMasculinoForm(forms.ModelForm):
        class Meta:
            model = mymodel

    return BaseInstitutoReligiosoMasculinoForm

def getBaseInstitutoReligiosoMasculinoAdmin(mymodel):
    class BaseInstitutoReligiosoMasculinoAdmin(getBaseAdmin(mymodel)):
        form = getBaseInstitutoReligiosoMasculinoForm(mymodel)
        fieldsets = (
                     (None, {
                             'fields':(
                                       ('nome',),
                                       ('congregacao_id',),
                                       ('comunidade',),
                                       ('superior',),
                                       ('membros',),
                                       ('morada',),
                                       ('codigo_postal','localidade',),
                                       ('telefone','telemovel',),
                                       ('fax','email',),
                                       ('paginaweb',),
                                       )
                             }),
                     )
        list_display = ('nome', 'alterado', 'id',)
        search_fields = ('nome', 'id', )

    return BaseInstitutoReligiosoMasculinoAdmin
# Fim Admin
