#coding: utf-8
from django.db import models
from django.utils.translation import ugettext_lazy as _
from diocesesim.models import getBaseAdmin, SharedBase
from django import forms


try:
    from settings import DIOCESE_NOME
    diocese_nome = DIOCESE_NOME
except Exception, e:
    diocese_nome = ''
    pass

# Models
def getBaseColegioArciprestes():
    class BaseColegioArciprestes(SharedBase):
        nome = models.CharField(_(u'Nome'), max_length=255)
        colegio_arciprestes = models.TextField(_(u'Colégio de Arciprestes'), null=True, blank=True)

        class Meta:
            verbose_name = _(u'Colégio de Arciprestes')
            verbose_name_plural = _(u'Colégios de Arciprestes')
            abstract = True
            ordering = ['nome']

        def __unicode__(self):
            return self.nome
    return BaseColegioArciprestes
# Fim Models

# Admin
def getBaseColegioArciprestesForm(mymodel):
    class BaseColegioArciprestesForm(forms.ModelForm):
        nome = forms.CharField(label=(u'Nome'), initial=_(u'Colégio de Arciprestes de ')+diocese_nome, max_length=255, widget=forms.widgets.TextInput(attrs={'class':'vTextField'}))
        class Meta:
            model = mymodel

    return BaseColegioArciprestesForm

def getBaseColegioArciprestesAdmin(mymodel):
    class BaseColegioArciprestesAdmin(getBaseAdmin(mymodel)):
        form = getBaseColegioArciprestesForm(mymodel)
        fieldsets = (
                     (None, {
                             'fields':(
                                       ('nome',),
                                       ('colegio_arciprestes',),
                                       )
                             }),
                     )
        list_display = ('nome', 'alterado', 'id',)
        search_fields = ('nome', 'id', )

    return BaseColegioArciprestesAdmin
# Fim Admin
