#coding: utf-8
from django.db import models
from django.utils.translation import ugettext_lazy as _
from diocesesim.models import getBaseAdmin, SharedBase
from django import forms


try:
    from settings import DIOCESE_NOME
    diocese_nome = DIOCESE_NOME
except Exception, e:
    diocese_nome = ''
    pass

# Models
def getBaseChancelaria():
    class BaseChancelaria(SharedBase):
        nome = models.CharField(_(u'Nome'), max_length=255)
        morada = models.CharField(_(u'Morada'), max_length=255, null=True, blank=True)
        codigo_postal = models.CharField(_(u'Código postal'), max_length=255, null=True, blank=True)
        localidade = models.CharField(_(u'Localidade'), max_length=255, null=True, blank=True)
        telefone = models.CharField(_(u'Telefone'), max_length=255, null=True, blank=True)
        telemovel = models.CharField(_(u'Telemóvel'), max_length=255, null=True, blank=True)
        fax = models.CharField(_(u'Fax'), max_length=255, null=True, blank=True)
        email = models.CharField(_(u'Email'), max_length=255, null=True, blank=True)
        paginaweb = models.CharField(_(u'Página web'), max_length=255, null=True, blank=True)
        chanceler = models.CharField(_(u'Chanceler'), max_length=255, null=True, blank=True)
        vice_chanceler = models.CharField(_(u'Vice-Chanceler'), max_length=255, null=True, blank=True)
        secretariado_deral = models.CharField(_(u'Secretário Geral'), max_length=255, null=True, blank=True)
        consultor_juridico = models.CharField(_(u'Consultor Jurídico'), max_length=255, null=True, blank=True)
        notario = models.CharField(_(u'Notário'), max_length=255, null=True, blank=True)
        servico_del_pios = models.TextField(_(u'Serviço de Legados Pios'), null=True, blank=True)
        associacoes_religiosas = models.TextField(_(u'Associações Religiosas'), null=True, blank=True)
        arquivo_secreto = models.CharField(_(u'Arquivo Secreto'), max_length=255, null=True, blank=True)
        arquivo_historico = models.CharField(_(u'Arquivo Histórico'), max_length=255, null=True, blank=True)

        class Meta:
            verbose_name = _(u'Chancelaria/secretaria geral')
            verbose_name_plural = _(u'Chancelarias/secretarias geral')
            abstract = True
            ordering = ['nome']

        def __unicode__(self):
            return self.nome
    return BaseChancelaria
# Fim Models

# Admin
def getBaseChancelariaForm(mymodel):
    class BaseChancelariaForm(forms.ModelForm):
        nome = forms.CharField(label=(u'Nome'), initial=_(u'Chancelaria/secretaria geral de ')+diocese_nome, max_length=255, widget=forms.widgets.TextInput(attrs={'class':'vTextField'}))
        class Meta:
            model = mymodel

    return BaseChancelariaForm

def getBaseChancelariaAdmin(mymodel):
    class BaseChancelariaAdmin(getBaseAdmin(mymodel)):
        form = getBaseChancelariaForm(mymodel)
        fieldsets = (
                     (None, {
                             'fields':(
                                       ('nome',),
                                       ('morada',),
                                       ('codigo_postal', 'localidade',),
                                       ('telefone', 'telemovel',),
                                       ('fax', 'email',),
                                       ('paginaweb',),
                                       ('chanceler',),
                                       ('vice_chanceler',),
                                       ('secretariado_deral',),
                                       ('consultor_juridico',),
                                       ('notario',),
                                       ('servico_del_pios',),
                                       ('associacoes_religiosas',),
                                       ('arquivo_secreto',),
                                       ('arquivo_historico',),
                                       )
                             }),
                     )
        list_display = ('nome', 'alterado', 'id',)
        search_fields = ('nome', 'id', )

    return BaseChancelariaAdmin
# Fim Admin
