#coding: utf-8
from django.db import models
from django.utils.translation import ugettext_lazy as _
from diocesesim.models import getBaseAdmin, SharedBase
from django import forms


# Models
def getBaseCentroVidaCrista(TIPOS_CHOICES):
    if TIPOS_CHOICES == None:
        TIPOS_CHOICES = (
            (1, _(u'Reitorias/Capelanias')),
            (2, _(u'Santuários')),
        )

    class BaseCentroVidaCrista(SharedBase):
        nome = models.CharField(_(u'Nome'), max_length=255)
        tipo = models.PositiveIntegerField(_(u'Tipo'), max_length=1, choices=TIPOS_CHOICES, default=1)
        director = models.CharField(_(u'Director/Responsável'), max_length=255, null=True, blank=True)
        propriedade = models.CharField(_(u'Propriedade'), max_length=255, null=True, blank=True)
        morada = models.CharField(_(u'Morada'), max_length=255, null=True, blank=True)
        codigo_postal = models.CharField(_(u'Código postal'), max_length=255, null=True, blank=True)
        localidade = models.CharField(_(u'Localidade'), max_length=255, null=True, blank=True)
        telefone = models.CharField(_(u'Telefone'), max_length=255, null=True, blank=True)
        telemovel = models.CharField(_(u'Telemóvel'), max_length=255, null=True, blank=True)
        fax = models.CharField(_(u'Fax'), max_length=255, null=True, blank=True)
        email = models.CharField(_(u'Email'), max_length=255, null=True, blank=True)
        paginaweb = models.CharField(_(u'Página web'), max_length=255, null=True, blank=True)
        obs = models.TextField(_(u'Observações'), null=True, blank=True)

        class Meta:
            verbose_name = _(u'Centro de Vida Cristã')
            verbose_name_plural = _(u'Centros de Vida Cristã')
            abstract = True
            ordering = ['nome']

        def __unicode__(self):
            return self.nome
    return BaseCentroVidaCrista
# Fim Models

# Admin
def getBaseCentroVidaCristaForm(mymodel):
    class BaseCentroVidaCristaForm(forms.ModelForm):
        class Meta:
            model = mymodel

    return BaseCentroVidaCristaForm

def getBaseCentroVidaCristaAdmin(mymodel):
    class BaseCentroVidaCristaAdmin(getBaseAdmin(mymodel)):
        form = getBaseCentroVidaCristaForm(mymodel)
        fieldsets = (
                     (None, {
                             'fields':(
                                       ('nome','tipo',),
                                       ('director',),
                                       ('propriedade',),
                                       ('morada',),
                                       ('codigo_postal','localidade',),
                                       ('telefone','telemovel',),
                                       ('fax','email',),
                                       ('paginaweb',),
                                       ('obs',),
                                       )
                             }),
                     )
        list_display = ('nome', 'alterado', 'id',)
        search_fields = ('nome', 'id', )

    return BaseCentroVidaCristaAdmin
# Fim Admin
